/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferAllocator;
import org.apache.hadoop.hbase.util.ByteBufferArray;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class FileMmapEngine
implements IOEngine {
    static final Log LOG = LogFactory.getLog(FileMmapEngine.class);
    private final String path;
    private long size;
    private ByteBufferArray bufferArray;
    private final FileChannel fileChannel;
    private RandomAccessFile raf = null;

    public FileMmapEngine(String filePath, long capacity) throws IOException {
        this.path = filePath;
        this.size = capacity;
        long fileSize = 0L;
        try {
            this.raf = new RandomAccessFile(filePath, "rw");
            fileSize = this.roundUp(capacity, 0x400000L);
            this.raf.setLength(fileSize);
            this.fileChannel = this.raf.getChannel();
            LOG.info((Object)("Allocating " + StringUtils.byteDesc((long)fileSize) + ", on the path:" + filePath));
        }
        catch (FileNotFoundException fex) {
            LOG.error((Object)("Can't create bucket cache file " + filePath), (Throwable)fex);
            throw fex;
        }
        catch (IOException ioex) {
            LOG.error((Object)("Can't extend bucket cache file; insufficient space for " + StringUtils.byteDesc((long)fileSize)), (Throwable)ioex);
            this.shutdown();
            throw ioex;
        }
        ByteBufferAllocator allocator = new ByteBufferAllocator(){
            int pos = 0;

            public ByteBuffer allocate(long size, boolean directByteBuffer) throws IOException {
                MappedByteBuffer buffer = null;
                if (!directByteBuffer) {
                    throw new IllegalArgumentException("Only Direct Bytebuffers allowed with FileMMap engine");
                }
                buffer = FileMmapEngine.this.fileChannel.map(FileChannel.MapMode.READ_WRITE, (long)this.pos * size, size);
                ++this.pos;
                return buffer;
            }
        };
        this.bufferArray = new ByteBufferArray(fileSize, true, allocator);
    }

    private long roundUp(long n, long to) {
        return (n + to - 1L) / to * to;
    }

    public String toString() {
        return "ioengine=" + this.getClass().getSimpleName() + ", path=" + this.path + ", size=" + String.format("%,d", this.size);
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public Cacheable read(long offset, int length, CacheableDeserializer<Cacheable> deserializer) throws IOException {
        byte[] dst = new byte[length];
        this.bufferArray.getMultiple(offset, length, dst);
        return deserializer.deserialize((ByteBuff)new SingleByteBuff(ByteBuffer.wrap(dst)), true, Cacheable.MemoryType.EXCLUSIVE);
    }

    @Override
    public void write(ByteBuffer srcBuffer, long offset) throws IOException {
        assert (srcBuffer.hasArray());
        this.bufferArray.putMultiple(offset, srcBuffer.remaining(), srcBuffer.array(), srcBuffer.arrayOffset());
    }

    @Override
    public void write(ByteBuff srcBuffer, long offset) throws IOException {
        assert (srcBuffer.hasArray());
        this.bufferArray.putMultiple(offset, srcBuffer.remaining(), srcBuffer.array(), srcBuffer.arrayOffset());
    }

    @Override
    public void sync() throws IOException {
        if (this.fileChannel != null) {
            this.fileChannel.force(true);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.fileChannel.close();
        }
        catch (IOException ex) {
            LOG.error((Object)"Can't shutdown cleanly", (Throwable)ex);
        }
        try {
            this.raf.close();
        }
        catch (IOException ex) {
            LOG.error((Object)"Can't shutdown cleanly", (Throwable)ex);
        }
    }
}

