/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.CallRunner;

@InterfaceAudience.Private
public class AdaptiveLifoCoDelCallQueue
implements BlockingQueue<CallRunner> {
    private LinkedBlockingDeque<CallRunner> queue;
    private int maxCapacity;
    private AtomicLong numGeneralCallsDropped;
    private AtomicLong numLifoModeSwitches;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile int codelTargetDelay;
    private volatile int codelInterval;
    private volatile double lifoThreshold;
    private volatile long minDelay;
    private volatile long intervalTime = System.currentTimeMillis();
    private AtomicBoolean resetDelay = new AtomicBoolean(true);
    private volatile boolean isOverloaded;

    public AdaptiveLifoCoDelCallQueue(int capacity, int targetDelay, int interval, double lifoThreshold, AtomicLong numGeneralCallsDropped, AtomicLong numLifoModeSwitches) {
        this.maxCapacity = capacity;
        this.queue = new LinkedBlockingDeque(capacity);
        this.codelTargetDelay = targetDelay;
        this.codelInterval = interval;
        this.lifoThreshold = lifoThreshold;
        this.numGeneralCallsDropped = numGeneralCallsDropped;
        this.numLifoModeSwitches = numLifoModeSwitches;
    }

    public void updateTunables(int newCodelTargetDelay, int newCodelInterval, double newLifoThreshold) {
        this.codelTargetDelay = newCodelTargetDelay;
        this.codelInterval = newCodelInterval;
        this.lifoThreshold = newLifoThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallRunner take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            CallRunner cr;
            while (true) {
                if ((double)this.queue.size() / (double)this.maxCapacity > this.lifoThreshold) {
                    this.numLifoModeSwitches.incrementAndGet();
                    cr = this.queue.takeLast();
                } else {
                    cr = this.queue.takeFirst();
                }
                if (!this.needToDrop(cr)) break;
                this.numGeneralCallsDropped.incrementAndGet();
            }
            CallRunner callRunner = cr;
            return callRunner;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean needToDrop(CallRunner callRunner) {
        long now = System.currentTimeMillis();
        long callDelay = now - callRunner.getCall().timestamp;
        long localMinDelay = this.minDelay;
        if (now > this.intervalTime && !this.resetDelay.getAndSet(true)) {
            this.intervalTime = now + (long)this.codelInterval;
            this.isOverloaded = localMinDelay > (long)this.codelTargetDelay;
        }
        if (this.resetDelay.getAndSet(false)) {
            this.minDelay = callDelay;
            return false;
        }
        if (callDelay < localMinDelay) {
            this.minDelay = callDelay;
        }
        return this.isOverloaded && callDelay > (long)(2 * this.codelTargetDelay);
    }

    @Override
    public boolean offer(CallRunner callRunner) {
        return this.queue.offer(callRunner);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public String toString() {
        return this.queue.toString();
    }

    @Override
    public CallRunner poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public CallRunner poll() {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public CallRunner peek() {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public int drainTo(Collection<? super CallRunner> c) {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public int drainTo(Collection<? super CallRunner> c, int maxElements) {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public Iterator<CallRunner> iterator() {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public boolean add(CallRunner callRunner) {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public CallRunner remove() {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public CallRunner element() {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public boolean addAll(Collection<? extends CallRunner> c) {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public int remainingCapacity() {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public void put(CallRunner callRunner) throws InterruptedException {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }

    @Override
    public boolean offer(CallRunner callRunner, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("This class doesn't support anything, but take() and offer() methods");
    }
}

