/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Reducer;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KeyValueSortReducer
extends Reducer<ImmutableBytesWritable, KeyValue, ImmutableBytesWritable, KeyValue> {
    protected void reduce(ImmutableBytesWritable row, Iterable<KeyValue> kvs, Reducer.Context context) throws IOException, InterruptedException {
        TreeSet<KeyValue> map = new TreeSet<KeyValue>((Comparator<KeyValue>)CellComparator.COMPARATOR);
        for (KeyValue kv : kvs) {
            try {
                map.add(kv.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new IOException(e);
            }
        }
        context.setStatus("Read " + map.getClass());
        int index = 0;
        for (KeyValue kv : map) {
            context.write((Object)row, (Object)kv);
            if (++index % 100 != 0) continue;
            context.setStatus("Wrote " + index);
        }
    }
}

