/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PutSortReducer
extends Reducer<ImmutableBytesWritable, Put, ImmutableBytesWritable, KeyValue> {
    protected void reduce(ImmutableBytesWritable row, Iterable<Put> puts, Reducer.Context context) throws IOException, InterruptedException {
        long threshold = context.getConfiguration().getLong("putsortreducer.row.threshold", 0x40000000L);
        Iterator<Put> iter = puts.iterator();
        while (iter.hasNext()) {
            TreeSet<KeyValue> map = new TreeSet<KeyValue>((Comparator<KeyValue>)CellComparator.COMPARATOR);
            long curSize = 0L;
            while (iter.hasNext() && curSize < threshold) {
                Put p = iter.next();
                for (List cells : p.getFamilyCellMap().values()) {
                    for (Cell cell : cells) {
                        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                        if (!map.add(kv)) continue;
                        curSize += kv.heapSize();
                    }
                }
            }
            context.setStatus("Read " + map.size() + " entries of " + map.getClass() + "(" + StringUtils.humanReadableInt((long)curSize) + ")");
            int index = 0;
            for (KeyValue kv : map) {
                context.write((Object)row, (Object)kv);
                if (++index % 100 != 0) continue;
                context.setStatus("Wrote " + index);
            }
            if (!iter.hasNext()) continue;
            context.write(null, null);
        }
    }
}

