/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.RegionStateListener;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.AssignCallable;
import org.apache.hadoop.hbase.master.AssignmentListener;
import org.apache.hadoop.hbase.master.GeneralBulkAssigner;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsAssignmentManager;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStateStore;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.UnAssignCallable;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeLoadBalancer;
import org.apache.hadoop.hbase.master.handler.DisableTableHandler;
import org.apache.hadoop.hbase.master.handler.EnableTableHandler;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class AssignmentManager {
    private static final Log LOG = LogFactory.getLog(AssignmentManager.class);
    protected final MasterServices server;
    private ServerManager serverManager;
    private boolean shouldAssignRegionsWithFavoredNodes;
    private LoadBalancer balancer;
    private final MetricsAssignmentManager metricsAssignmentManager;
    private final TableLockManager tableLockManager;
    private AtomicInteger numRegionsOpened = new AtomicInteger(0);
    private final KeyLocker<String> locker = new KeyLocker();
    Set<HRegionInfo> replicasToClose = Collections.synchronizedSet(new HashSet());
    private final Map<String, HRegionInfo> regionsToReopen;
    private final int maximumAttempts;
    private final long sleepTimeBeforeRetryingMetaAssignment;
    final NavigableMap<String, RegionPlan> regionPlans = new TreeMap<String, RegionPlan>();
    private final TableStateManager tableStateManager;
    private final org.apache.hadoop.hbase.executor.ExecutorService executorService;
    private ExecutorService threadPoolExecutorService;
    private final RegionStates regionStates;
    private final int bulkAssignThresholdRegions;
    private final int bulkAssignThresholdServers;
    private final int bulkPerRegionOpenTimeGuesstimate;
    private final boolean bulkAssignWaitTillAllAssigned;
    protected final AtomicBoolean failoverCleanupDone = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, AtomicInteger> failedOpenTracker = new ConcurrentHashMap();
    private final RegionStateStore regionStateStore;
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean TEST_SKIP_SPLIT_HANDLING = false;
    private List<AssignmentListener> listeners = new CopyOnWriteArrayList<AssignmentListener>();
    private RegionStateListener regionStateListener;

    public AssignmentManager(MasterServices server, ServerManager serverManager, LoadBalancer balancer, org.apache.hadoop.hbase.executor.ExecutorService service, MetricsMaster metricsMaster, TableLockManager tableLockManager, TableStateManager tableStateManager) throws IOException {
        this.server = server;
        this.serverManager = serverManager;
        this.executorService = service;
        this.regionStateStore = new RegionStateStore(server);
        this.regionsToReopen = Collections.synchronizedMap(new HashMap());
        Configuration conf = server.getConfiguration();
        this.shouldAssignRegionsWithFavoredNodes = conf.getClass("hbase.master.loadbalancer.class", Object.class).equals(FavoredNodeLoadBalancer.class);
        this.tableStateManager = tableStateManager;
        this.maximumAttempts = Math.max(1, this.server.getConfiguration().getInt("hbase.assignment.maximum.attempts", 10));
        this.sleepTimeBeforeRetryingMetaAssignment = this.server.getConfiguration().getLong("hbase.meta.assignment.retry.sleeptime", 1000L);
        this.balancer = balancer;
        int maxThreads = conf.getInt("hbase.assignment.threads.max", 30);
        this.threadPoolExecutorService = Threads.getBoundedCachedThreadPool((int)maxThreads, (long)60L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)Threads.newDaemonThreadFactory((String)"AM."));
        this.regionStates = new RegionStates(server, tableStateManager, serverManager, this.regionStateStore);
        this.bulkAssignWaitTillAllAssigned = conf.getBoolean("hbase.bulk.assignment.waittillallassigned", false);
        this.bulkAssignThresholdRegions = conf.getInt("hbase.bulk.assignment.threshold.regions", 7);
        this.bulkAssignThresholdServers = conf.getInt("hbase.bulk.assignment.threshold.servers", 3);
        this.bulkPerRegionOpenTimeGuesstimate = conf.getInt("hbase.bulk.assignment.perregion.open.time", 10000);
        this.metricsAssignmentManager = new MetricsAssignmentManager();
        this.tableLockManager = tableLockManager;
    }

    public void registerListener(AssignmentListener listener) {
        this.listeners.add(listener);
    }

    public boolean unregisterListener(AssignmentListener listener) {
        return this.listeners.remove(listener);
    }

    public TableStateManager getTableStateManager() {
        return this.tableStateManager;
    }

    public RegionStates getRegionStates() {
        return this.regionStates;
    }

    @VisibleForTesting
    RegionStateStore getRegionStateStore() {
        return this.regionStateStore;
    }

    public RegionPlan getRegionReopenPlan(HRegionInfo hri) {
        return new RegionPlan(hri, null, this.regionStates.getRegionServerOfRegion(hri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlan(String encodedName, RegionPlan plan) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.put(encodedName, plan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlans(Map<String, RegionPlan> plans) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.putAll(plans);
        }
    }

    public void setRegionsToReopen(List<HRegionInfo> regions) {
        for (HRegionInfo hri : regions) {
            this.regionsToReopen.put(hri.getEncodedName(), hri);
        }
    }

    public Pair<Integer, Integer> getReopenStatus(TableName tableName) throws IOException {
        List hris = TableName.META_TABLE_NAME.equals((Object)tableName) ? new MetaTableLocator().getMetaRegions(this.server.getZooKeeper()) : MetaTableAccessor.getTableRegions((Connection)this.server.getConnection(), (TableName)tableName, (boolean)true);
        Integer pending = 0;
        for (HRegionInfo hri : hris) {
            String name = hri.getEncodedName();
            if (!this.regionsToReopen.containsKey(name) && !this.regionStates.isRegionInTransition(name)) continue;
            Integer n = pending;
            Integer n2 = pending = Integer.valueOf(pending + 1);
        }
        return new Pair((Object)pending, (Object)hris.size());
    }

    public boolean isFailoverCleanupDone() {
        return this.failoverCleanupDone.get();
    }

    public Lock acquireRegionLock(String encodedName) {
        return this.locker.acquireLock((Object)encodedName);
    }

    void failoverCleanupDone() {
        this.failoverCleanupDone.set(true);
        this.serverManager.processQueuedDeadServers();
    }

    void joinCluster() throws IOException, KeeperException, InterruptedException, CoordinatedStateException {
        long startTime = System.currentTimeMillis();
        Set<ServerName> deadServers = this.rebuildUserRegions();
        boolean failover = this.processDeadServersAndRegionsInTransition(deadServers);
        this.recoverTableInDisablingState();
        this.recoverTableInEnablingState();
        LOG.info((Object)("Joined the cluster in " + (System.currentTimeMillis() - startTime) + "ms, failover=" + failover));
    }

    boolean processDeadServersAndRegionsInTransition(Set<ServerName> deadServers) throws KeeperException, IOException, InterruptedException, CoordinatedStateException {
        Set<ServerName> queuedDeadServers;
        Map<String, RegionState> regionsInTransition;
        boolean failover;
        boolean bl = failover = !this.serverManager.getDeadServers().isEmpty();
        if (failover) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found dead servers out on cluster " + this.serverManager.getDeadServers()));
            }
            failover = false;
            for (ServerName serverName : this.serverManager.getDeadServers().copyServerNames()) {
                if (!this.regionStates.getRegionAssignments().values().contains(serverName)) continue;
                LOG.debug((Object)("Found regions on dead server: " + serverName));
                failover = true;
                break;
            }
        }
        Set<ServerName> onlineServers = this.serverManager.getOnlineServers().keySet();
        if (!failover) {
            for (Map.Entry<HRegionInfo, ServerName> en : this.regionStates.getRegionAssignments().entrySet()) {
                HRegionInfo hri = en.getKey();
                if (hri.isMetaTable() || !onlineServers.contains(en.getValue())) continue;
                LOG.debug((Object)("Found region " + hri + " out on cluster"));
                failover = true;
                break;
            }
        }
        if (!failover && !(regionsInTransition = this.regionStates.getRegionsInTransition()).isEmpty()) {
            for (RegionState regionState : regionsInTransition.values()) {
                ServerName serverName = regionState.getServerName();
                if (regionState.getRegion().isMetaRegion() || serverName == null || !onlineServers.contains(serverName)) continue;
                LOG.debug((Object)("Found " + regionState + " for region " + regionState.getRegion().getRegionNameAsString() + " for server " + serverName + "in RITs"));
                failover = true;
                break;
            }
        }
        if (!failover && !(queuedDeadServers = this.serverManager.getRequeuedDeadServers().keySet()).isEmpty()) {
            Configuration conf = this.server.getConfiguration();
            Path rootdir = FSUtils.getRootDir(conf);
            FileSystem fs = rootdir.getFileSystem(conf);
            for (ServerName serverName : queuedDeadServers) {
                Path logDir = new Path(rootdir, DefaultWALProvider.getWALDirectoryName(serverName.toString()));
                Path splitDir = logDir.suffix("-splitting");
                if (!this.checkWals(fs, logDir) && !this.checkWals(fs, splitDir)) continue;
                LOG.debug((Object)("Found queued dead server " + serverName));
                failover = true;
                break;
            }
            if (!failover) {
                LOG.info((Object)("AM figured that it's not a failover and cleaned up " + queuedDeadServers.size() + " queued dead servers"));
                this.serverManager.removeRequeuedDeadServers();
            }
        }
        Set<TableName> disabledOrDisablingOrEnabling = null;
        Map<HRegionInfo, ServerName> allRegions = null;
        if (!failover) {
            disabledOrDisablingOrEnabling = this.tableStateManager.getTablesInStates(TableState.State.DISABLED, TableState.State.DISABLING, TableState.State.ENABLING);
            allRegions = this.regionStates.closeAllUserRegions(disabledOrDisablingOrEnabling);
        }
        this.regionStateStore.start();
        if (failover) {
            if (deadServers != null && !deadServers.isEmpty()) {
                for (ServerName serverName : deadServers) {
                    if (this.serverManager.isServerDead(serverName)) continue;
                    this.serverManager.expireServer(serverName);
                }
            }
            this.processRegionsInTransition(this.regionStates.getRegionsInTransition().values());
        }
        this.failoverCleanupDone();
        if (!failover) {
            LOG.info((Object)"Clean cluster startup. Don't reassign user regions");
            this.assignAllUserRegions(allRegions);
        } else {
            LOG.info((Object)"Failover! Reassign user regions");
        }
        for (HRegionInfo h : this.replicasToClose) {
            this.unassign(h);
        }
        this.replicasToClose.clear();
        return failover;
    }

    private boolean checkWals(FileSystem fs, Path dir) throws IOException {
        if (!fs.exists(dir)) {
            LOG.debug((Object)(dir + " doesn't exist"));
            return false;
        }
        if (!fs.getFileStatus(dir).isDirectory()) {
            LOG.warn((Object)(dir + " is not a directory"));
            return false;
        }
        FileStatus[] files = FSUtils.listStatus(fs, dir);
        if (files == null || files.length == 0) {
            LOG.debug((Object)(dir + " has no files"));
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile() && files[i].getLen() > 0L) {
                LOG.debug((Object)(dir + " has a non-empty file: " + files[i].getPath()));
                return true;
            }
            if (!files[i].isDirectory() || !this.checkWals(fs, dir)) continue;
            LOG.debug((Object)(dir + " is a directory and has a non-empty file: " + files[i].getPath()));
            return true;
        }
        LOG.debug((Object)("Found 0 non-empty wal files for :" + dir));
        return false;
    }

    public void removeClosedRegion(HRegionInfo hri) {
        if (this.regionsToReopen.remove(hri.getEncodedName()) != null) {
            LOG.debug((Object)"Removed region from reopening regions because it was closed");
        }
    }

    void processFavoredNodes(List<HRegionInfo> regions) throws IOException {
        if (!this.shouldAssignRegionsWithFavoredNodes) {
            return;
        }
        HashMap<HRegionInfo, List<ServerName>> regionToFavoredNodes = new HashMap<HRegionInfo, List<ServerName>>();
        for (HRegionInfo region : regions) {
            regionToFavoredNodes.put(region, ((FavoredNodeLoadBalancer)this.balancer).getFavoredNodes(region));
        }
        FavoredNodeAssignmentHelper.updateMetaWithFavoredNodesInfo(regionToFavoredNodes, this.server.getConnection());
    }

    void regionOnline(HRegionInfo regionInfo, ServerName sn) {
        this.regionOnline(regionInfo, sn, -1L);
    }

    void regionOnline(HRegionInfo regionInfo, ServerName sn, long openSeqNum) {
        this.numRegionsOpened.incrementAndGet();
        this.regionStates.regionOnline(regionInfo, sn, openSeqNum);
        this.clearRegionPlan(regionInfo);
        this.balancer.regionOnline(regionInfo, sn);
        this.sendRegionOpenedNotification(regionInfo, sn);
    }

    public void regionOffline(HRegionInfo regionInfo) {
        this.regionOffline(regionInfo, null);
    }

    public void offlineDisabledRegion(HRegionInfo regionInfo) {
        this.replicasToClose.remove(regionInfo);
        this.regionOffline(regionInfo);
    }

    public void assign(HRegionInfo region) {
        this.assign(region, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(HRegionInfo region, boolean forceNewPlan) {
        if (this.isDisabledorDisablingRegionInRIT(region)) {
            return;
        }
        String encodedName = region.getEncodedName();
        ReentrantLock lock = this.locker.acquireLock((Object)encodedName);
        try {
            RegionState state = this.forceRegionStateToOffline(region, forceNewPlan);
            if (state != null) {
                if (this.regionStates.wasRegionOnDeadServer(encodedName)) {
                    LOG.info((Object)("Skip assigning " + region.getRegionNameAsString() + ", it's host " + this.regionStates.getLastRegionServerOfRegion(encodedName) + " is dead but not processed yet"));
                    return;
                }
                this.assign(state, forceNewPlan);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    boolean assign(ServerName destination, List<HRegionInfo> regions) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void unassign(HRegionInfo region, ServerName server, ServerName dest) {
        for (int i = 1; i <= this.maximumAttempts; ++i) {
            if (this.server.isStopped() || this.server.isAborted()) {
                LOG.debug((Object)("Server stopped/aborted; skipping unassign of " + region));
                return;
            }
            if (!this.serverManager.isServerOnline(server)) {
                LOG.debug((Object)("Offline " + region.getRegionNameAsString() + ", no need to unassign since it's on a dead server: " + server));
                this.regionStates.updateRegionState(region, RegionState.State.OFFLINE);
                return;
            }
            try {
                if (this.serverManager.sendRegionClose(server, region, dest)) {
                    LOG.debug((Object)("Sent CLOSE to " + server + " for region " + region.getRegionNameAsString()));
                    return;
                }
                LOG.warn((Object)("Server " + server + " region CLOSE RPC returned false for " + region.getRegionNameAsString()));
                continue;
            }
            catch (Throwable t2) {
                IOException t2;
                long sleepTime = 0L;
                Configuration conf = this.server.getConfiguration();
                if (t2 instanceof RemoteException) {
                    t2 = ((RemoteException)t2).unwrapRemoteException();
                }
                if (t2 instanceof RegionServerAbortedException || t2 instanceof RegionServerStoppedException || t2 instanceof ServerNotRunningYetException) {
                    sleepTime = 1 + conf.getInt("hbase.ipc.client.failed.servers.expiry", 2000);
                } else {
                    if (t2 instanceof NotServingRegionException) {
                        LOG.debug((Object)("Offline " + region.getRegionNameAsString() + ", it's not any more on " + server), (Throwable)t2);
                        this.regionStates.updateRegionState(region, RegionState.State.OFFLINE);
                        return;
                    }
                    if (t2 instanceof FailedServerException && i < this.maximumAttempts) {
                        sleepTime = 1 + conf.getInt("hbase.ipc.client.failed.servers.expiry", 2000);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(server + " is on failed server list; waiting " + sleepTime + "ms"), (Throwable)t2);
                        }
                    }
                }
                try {
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)("Interrupted unassign " + region.getRegionNameAsString()), (Throwable)ie);
                    Thread.currentThread().interrupt();
                    this.regionStates.updateRegionState(region, RegionState.State.FAILED_CLOSE);
                    return;
                }
                LOG.info((Object)("Server " + server + " returned " + t2 + " for " + region.getRegionNameAsString() + ", try=" + i + " of " + this.maximumAttempts), (Throwable)t2);
            }
        }
        this.regionStates.updateRegionState(region, RegionState.State.FAILED_CLOSE);
    }

    private RegionState forceRegionStateToOffline(HRegionInfo region, boolean forceNewPlan) {
        RegionState state = this.regionStates.getRegionState(region);
        if (state == null) {
            LOG.warn((Object)("Assigning but not in region states: " + region));
            state = this.regionStates.createRegionState(region);
        }
        if (forceNewPlan && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Force region state offline " + state));
        }
        switch (state.getState()) {
            case OPEN: 
            case OPENING: 
            case PENDING_OPEN: 
            case CLOSING: 
            case PENDING_CLOSE: {
                if (!forceNewPlan) {
                    LOG.debug((Object)("Skip assigning " + region + ", it is already " + state));
                    return null;
                }
            }
            case FAILED_CLOSE: 
            case FAILED_OPEN: {
                this.regionStates.updateRegionState(region, RegionState.State.PENDING_CLOSE);
                this.unassign(region, state.getServerName(), null);
                state = this.regionStates.getRegionState(region);
                if (!state.isOffline() && !state.isClosed()) {
                    return null;
                }
            }
            case OFFLINE: 
            case CLOSED: {
                break;
            }
            default: {
                LOG.error((Object)("Trying to assign region " + region + ", which is " + state));
                return null;
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void assign(RegionState state, boolean forceNewPlan) {
        block38: {
            startTime = EnvironmentEdgeManager.currentTime();
            try {
                conf = this.server.getConfiguration();
                plan = null;
                maxWaitTime = -1L;
                region = state.getRegion();
                previousException = null;
                for (i = 1; i <= this.maximumAttempts; ++i) {
                    if (this.server.isStopped() || this.server.isAborted()) {
                        AssignmentManager.LOG.info((Object)("Skip assigning " + region.getRegionNameAsString() + ", the server is stopped/aborted"));
                        return;
                    }
                    if (plan == null) {
                        try {
                            plan = this.getRegionPlan(region, forceNewPlan);
                        }
                        catch (HBaseIOException e) {
                            AssignmentManager.LOG.warn((Object)"Failed to get region plan", (Throwable)e);
                        }
                    }
                    if (plan == null) {
                        AssignmentManager.LOG.warn((Object)("Unable to determine a plan to assign " + region));
                        if (region.isMetaRegion()) {
                            if (i == this.maximumAttempts) {
                                i = 0;
                                AssignmentManager.LOG.warn((Object)("Unable to determine a plan to assign a hbase:meta region " + region + " after maximumAttempts (" + this.maximumAttempts + "). Reset attempts count and continue retrying."));
                            }
                            this.waitForRetryingMetaAssignment();
                            continue;
                        }
                        this.regionStates.updateRegionState(region, RegionState.State.FAILED_OPEN);
                        return;
                    }
                    AssignmentManager.LOG.info((Object)("Assigning " + region.getRegionNameAsString() + " to " + plan.getDestination()));
                    this.regionStates.updateRegionState(region, RegionState.State.PENDING_OPEN, plan.getDestination());
                    needNewPlan = false;
                    assignMsg = "Failed assignment of " + region.getRegionNameAsString() + " to " + plan.getDestination();
                    try {
                        favoredNodes = ServerName.EMPTY_SERVER_LIST;
                        if (this.shouldAssignRegionsWithFavoredNodes) {
                            favoredNodes = ((FavoredNodeLoadBalancer)this.balancer).getFavoredNodes(region);
                        }
                        this.serverManager.sendRegionOpen(plan.getDestination(), region, favoredNodes);
                        return;
                    }
                    catch (Throwable t) {
                        block37: {
                            block36: {
                                if (t instanceof RemoteException) {
                                    t = ((RemoteException)t).unwrapRemoteException();
                                }
                                previousException = t;
                                hold = t instanceof ServerNotRunningYetException;
                                v0 = retry = hold == false && t instanceof SocketTimeoutException != false && this.serverManager.isServerOnline(plan.getDestination()) != false;
                                if (!hold) break block36;
                                AssignmentManager.LOG.warn((Object)(assignMsg + ", waiting a little before trying on the same region server " + "try=" + i + " of " + this.maximumAttempts), (Throwable)t);
                                if (maxWaitTime < 0L) {
                                    maxWaitTime = EnvironmentEdgeManager.currentTime() + this.server.getConfiguration().getLong("hbase.regionserver.rpc.startup.waittime", 60000L);
                                }
                                try {
                                    now = EnvironmentEdgeManager.currentTime();
                                    if (now < maxWaitTime) {
                                        if (AssignmentManager.LOG.isDebugEnabled()) {
                                            AssignmentManager.LOG.debug((Object)("Server is not yet up; waiting up to " + (maxWaitTime - now) + "ms"), (Throwable)t);
                                        }
                                        Thread.sleep(100L);
                                        --i;
                                    } else {
                                        AssignmentManager.LOG.debug((Object)"Server is not up for a while; try a new one", (Throwable)t);
                                        needNewPlan = true;
                                    }
                                    ** GOTO lbl79
                                }
                                catch (InterruptedException ie) {
                                    AssignmentManager.LOG.warn((Object)("Failed to assign " + region.getRegionNameAsString() + " since interrupted"), (Throwable)ie);
                                    this.regionStates.updateRegionState(region, RegionState.State.FAILED_OPEN);
                                    Thread.currentThread().interrupt();
                                    this.metricsAssignmentManager.updateAssignmentTime(EnvironmentEdgeManager.currentTime() - startTime);
                                    return;
                                }
                            }
                            if (retry) {
                                --i;
                                if (AssignmentManager.LOG.isDebugEnabled()) {
                                    AssignmentManager.LOG.debug((Object)(assignMsg + ", trying to assign to the same region server due "), (Throwable)t);
                                }
                            } else {
                                needNewPlan = true;
                                AssignmentManager.LOG.warn((Object)(assignMsg + ", trying to assign elsewhere instead;" + " try=" + i + " of " + this.maximumAttempts), (Throwable)t);
                            }
lbl79:
                            // 4 sources

                            if (i == this.maximumAttempts) {
                                if (!region.isMetaRegion()) continue;
                                i = 0;
                                AssignmentManager.LOG.warn((Object)(assignMsg + ", trying to assign a hbase:meta region reached to maximumAttempts (" + this.maximumAttempts + ").  Reset attempt counts and continue retrying."));
                                this.waitForRetryingMetaAssignment();
                            }
                            if (!needNewPlan) continue;
                            newPlan = null;
                            try {
                                newPlan = this.getRegionPlan(region, true);
                            }
                            catch (HBaseIOException e) {
                                AssignmentManager.LOG.warn((Object)"Failed to get region plan", (Throwable)e);
                            }
                            if (newPlan != null) break block37;
                            this.regionStates.updateRegionState(region, RegionState.State.FAILED_OPEN);
                            AssignmentManager.LOG.warn((Object)("Unable to find a viable location to assign region " + region.getRegionNameAsString()));
                            this.metricsAssignmentManager.updateAssignmentTime(EnvironmentEdgeManager.currentTime() - startTime);
                            return;
                        }
                        if (plan != newPlan && !plan.getDestination().equals((Object)newPlan.getDestination())) {
                            this.regionStates.updateRegionState(region, RegionState.State.OFFLINE);
                            plan = newPlan;
                            continue;
                        }
                        if (!plan.getDestination().equals((Object)newPlan.getDestination()) || !(previousException instanceof FailedServerException)) continue;
                        try {
                            AssignmentManager.LOG.info((Object)("Trying to re-assign " + region.getRegionNameAsString() + " to the same failed server."));
                            Thread.sleep(1 + conf.getInt("hbase.ipc.client.failed.servers.expiry", 2000));
                            continue;
                        }
                        catch (InterruptedException ie) {
                            AssignmentManager.LOG.warn((Object)("Failed to assign " + region.getRegionNameAsString() + " since interrupted"), (Throwable)ie);
                            this.regionStates.updateRegionState(region, RegionState.State.FAILED_OPEN);
                            Thread.currentThread().interrupt();
                            this.metricsAssignmentManager.updateAssignmentTime(EnvironmentEdgeManager.currentTime() - startTime);
                            return;
                        }
                    }
                }
                this.regionStates.updateRegionState(region, RegionState.State.FAILED_OPEN);
                break block38;
                {
                    catch (Throwable var19_21) {
                        throw var19_21;
                    }
                }
            }
            finally {
                this.metricsAssignmentManager.updateAssignmentTime(EnvironmentEdgeManager.currentTime() - startTime);
            }
        }
    }

    private boolean isDisabledorDisablingRegionInRIT(HRegionInfo region) {
        if (this.tableStateManager.isTableState(region.getTable(), TableState.State.DISABLED, TableState.State.DISABLING) || this.replicasToClose.contains(region)) {
            LOG.info((Object)("Table " + region.getTable() + " is disabled or disabling;" + " skipping assign of " + region.getRegionNameAsString()));
            this.offlineDisabledRegion(region);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionPlan getRegionPlan(HRegionInfo region, boolean forceNewPlan) throws HBaseIOException {
        RegionPlan existingPlan;
        String encodedName = region.getEncodedName();
        List<ServerName> destServers = this.serverManager.createDestinationServersList();
        if (destServers.isEmpty()) {
            LOG.warn((Object)("Can't move " + encodedName + ", there is no destination server available."));
            return null;
        }
        RegionPlan randomPlan = null;
        boolean newPlan = false;
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            existingPlan = (RegionPlan)this.regionPlans.get(encodedName);
            if (existingPlan != null && existingPlan.getDestination() != null) {
                LOG.debug((Object)("Found an existing plan for " + region.getRegionNameAsString() + " destination server is " + existingPlan.getDestination() + " accepted as a dest server = " + destServers.contains(existingPlan.getDestination())));
            }
            if (forceNewPlan || existingPlan == null || existingPlan.getDestination() == null || !destServers.contains(existingPlan.getDestination())) {
                newPlan = true;
                try {
                    randomPlan = new RegionPlan(region, null, this.balancer.randomAssignment(region, destServers));
                }
                catch (IOException ex) {
                    LOG.warn((Object)"Failed to create new plan.", (Throwable)ex);
                    return null;
                }
                if (!region.isMetaTable() && this.shouldAssignRegionsWithFavoredNodes) {
                    ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(1);
                    regions.add(region);
                    try {
                        this.processFavoredNodes(regions);
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("Ignoring exception in processFavoredNodes " + ie));
                    }
                }
                this.regionPlans.put(encodedName, randomPlan);
            }
        }
        if (newPlan) {
            if (randomPlan.getDestination() == null) {
                LOG.warn((Object)("Can't find a destination for " + encodedName));
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No previous transition plan found (or ignoring an existing plan) for " + region.getRegionNameAsString() + "; generated random plan=" + randomPlan + "; " + destServers.size() + " (online=" + this.serverManager.getOnlineServers().size() + ") available servers, forceNewPlan=" + forceNewPlan));
            }
            return randomPlan;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using pre-existing plan for " + region.getRegionNameAsString() + "; plan=" + existingPlan));
        }
        return existingPlan;
    }

    private void waitForRetryingMetaAssignment() {
        try {
            Thread.sleep(this.sleepTimeBeforeRetryingMetaAssignment);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Got exception while waiting for hbase:meta assignment");
            Thread.currentThread().interrupt();
        }
    }

    public void unassign(HRegionInfo region) {
        this.unassign(region, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void unassign(HRegionInfo region, ServerName dest) {
        block14: {
            block15: {
                block12: {
                    block13: {
                        AssignmentManager.LOG.debug((Object)("Starting unassign of " + region.getRegionNameAsString() + " (offlining), current state: " + this.regionStates.getRegionState(region)));
                        encodedName = region.getEncodedName();
                        lock = this.locker.acquireLock((Object)encodedName);
                        state = this.regionStates.getRegionTransitionState(encodedName);
                        try {
                            if (state != null && !state.isFailedClose()) ** GOTO lbl33
                            if (state != null) break block12;
                            state = this.regionStates.getRegionState(encodedName);
                            if (state == null || !state.isUnassignable()) break block13;
                            AssignmentManager.LOG.info((Object)("Attempting to unassign " + state + ", ignored"));
                            lock.unlock();
                        }
                        catch (Throwable var6_6) {
                            lock.unlock();
                            if (!this.replicasToClose.contains(region) && this.regionStates.isRegionInState(region, new RegionState.State[]{RegionState.State.OFFLINE})) {
                                this.assign(region);
                            }
                            throw var6_6;
                        }
                        if (!this.replicasToClose.contains(region) && this.regionStates.isRegionInState(region, new RegionState.State[]{RegionState.State.OFFLINE})) {
                            this.assign(region);
                        }
                        return;
                    }
                    if (state != null && state.getServerName() != null) break block12;
                    AssignmentManager.LOG.warn((Object)("Attempting to unassign a region not in RegionStates " + region.getRegionNameAsString() + ", offlined"));
                    this.regionOffline(region);
                    lock.unlock();
                    if (!this.replicasToClose.contains(region) && this.regionStates.isRegionInState(region, new RegionState.State[]{RegionState.State.OFFLINE})) {
                        this.assign(region);
                    }
                    return;
                }
                state = this.regionStates.updateRegionState(region, RegionState.State.PENDING_CLOSE);
                break block14;
lbl33:
                // 1 sources

                if (!state.isFailedOpen()) break block15;
                this.regionOffline(region);
                lock.unlock();
                if (!this.replicasToClose.contains(region) && this.regionStates.isRegionInState(region, new RegionState.State[]{RegionState.State.OFFLINE})) {
                    this.assign(region);
                }
                return;
            }
            AssignmentManager.LOG.debug((Object)("Attempting to unassign " + region.getRegionNameAsString() + " but it is " + "already in transition (" + state.getState()));
            lock.unlock();
            if (!this.replicasToClose.contains(region) && this.regionStates.isRegionInState(region, new RegionState.State[]{RegionState.State.OFFLINE})) {
                this.assign(region);
            }
            return;
        }
        this.unassign(region, state.getServerName(), dest);
        lock.unlock();
        if (!this.replicasToClose.contains(region) && this.regionStates.isRegionInState(region, new RegionState.State[]{RegionState.State.OFFLINE})) {
            this.assign(region);
        }
    }

    public int getNumRegionsOpened() {
        return this.numRegionsOpened.get();
    }

    public boolean waitForAssignment(HRegionInfo regionInfo) throws InterruptedException {
        ArrayList<HRegionInfo> regionSet = new ArrayList<HRegionInfo>(1);
        regionSet.add(regionInfo);
        return this.waitForAssignment(regionSet, true, Long.MAX_VALUE);
    }

    protected boolean waitForAssignment(Collection<HRegionInfo> regionSet, boolean waitTillAllAssigned, int reassigningRegions, long minEndTime) throws InterruptedException {
        long deadline = minEndTime + (long)(this.bulkPerRegionOpenTimeGuesstimate * (reassigningRegions + 1));
        return this.waitForAssignment(regionSet, waitTillAllAssigned, deadline);
    }

    protected boolean waitForAssignment(Collection<HRegionInfo> regionSet, boolean waitTillAllAssigned, long deadline) throws InterruptedException {
        while (!regionSet.isEmpty() && !this.server.isStopped() && deadline > System.currentTimeMillis()) {
            int failedOpenCount = 0;
            Iterator<HRegionInfo> regionInfoIterator = regionSet.iterator();
            while (regionInfoIterator.hasNext()) {
                HRegionInfo hri = regionInfoIterator.next();
                if (this.regionStates.isRegionOnline(hri) || this.regionStates.isRegionInState(hri, RegionState.State.SPLITTING, RegionState.State.SPLIT, RegionState.State.MERGING, RegionState.State.MERGED)) {
                    regionInfoIterator.remove();
                    continue;
                }
                if (!this.regionStates.isRegionInState(hri, RegionState.State.FAILED_OPEN)) continue;
                ++failedOpenCount;
            }
            if (!waitTillAllAssigned) break;
            if (regionSet.isEmpty()) continue;
            if (failedOpenCount == regionSet.size()) break;
            this.regionStates.waitForUpdate(100L);
        }
        return regionSet.isEmpty();
    }

    public void assignMeta(HRegionInfo hri) throws KeeperException {
        this.regionStates.updateRegionState(hri, RegionState.State.OFFLINE);
        this.assign(hri);
    }

    public void assign(Map<HRegionInfo, ServerName> regions) throws IOException, InterruptedException {
        if (regions == null || regions.isEmpty()) {
            return;
        }
        List<ServerName> servers = this.serverManager.createDestinationServersList();
        if (servers == null || servers.isEmpty()) {
            throw new IOException("Found no destination server to assign region(s)");
        }
        Map<ServerName, List<HRegionInfo>> bulkPlan = this.balancer.retainAssignment(regions, servers);
        if (bulkPlan == null) {
            throw new IOException("Unable to determine a plan to assign region(s)");
        }
        this.processBogusAssignments(bulkPlan);
        this.assign(regions.size(), servers.size(), "retainAssignment=true", bulkPlan);
    }

    public void assign(List<HRegionInfo> regions) throws IOException, InterruptedException {
        if (regions == null || regions.isEmpty()) {
            return;
        }
        List<ServerName> servers = this.serverManager.createDestinationServersList();
        if (servers == null || servers.isEmpty()) {
            throw new IOException("Found no destination server to assign region(s)");
        }
        Map<ServerName, List<HRegionInfo>> bulkPlan = this.balancer.roundRobinAssignment(regions, servers);
        if (bulkPlan == null) {
            throw new IOException("Unable to determine a plan to assign region(s)");
        }
        this.processBogusAssignments(bulkPlan);
        this.processFavoredNodes(regions);
        this.assign(regions.size(), servers.size(), "round-robin=true", bulkPlan);
    }

    private void assign(int regions, int totalServers, String message, Map<ServerName, List<HRegionInfo>> bulkPlan) throws InterruptedException, IOException {
        int servers = bulkPlan.size();
        if (servers == 1 || regions < this.bulkAssignThresholdRegions && servers < this.bulkAssignThresholdServers) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Not using bulk assignment since we are assigning only " + regions + " region(s) to " + servers + " server(s)"));
            }
            ArrayList<HRegionInfo> userRegionSet = new ArrayList<HRegionInfo>(regions);
            for (Map.Entry<ServerName, List<HRegionInfo>> plan : bulkPlan.entrySet()) {
                if (this.assign(plan.getKey(), plan.getValue()) || this.server.isStopped()) continue;
                for (HRegionInfo region : plan.getValue()) {
                    if (this.regionStates.isRegionOnline(region)) continue;
                    this.invokeAssign(region);
                    if (region.getTable().isSystemTable()) continue;
                    userRegionSet.add(region);
                }
            }
            if (!this.waitForAssignment(userRegionSet, true, userRegionSet.size(), System.currentTimeMillis())) {
                LOG.debug((Object)("some user regions are still in transition: " + userRegionSet));
            }
        } else {
            LOG.info((Object)("Bulk assigning " + regions + " region(s) across " + totalServers + " server(s), " + message));
            GeneralBulkAssigner ba = new GeneralBulkAssigner(this.server, bulkPlan, this, this.bulkAssignWaitTillAllAssigned);
            ba.bulkAssign();
            LOG.info((Object)"Bulk assigning done");
        }
    }

    private void assignAllUserRegions(Map<HRegionInfo, ServerName> allRegions) throws IOException, InterruptedException {
        if (allRegions == null || allRegions.isEmpty()) {
            return;
        }
        boolean retainAssignment = this.server.getConfiguration().getBoolean("hbase.master.startup.retainassign", true);
        Set<HRegionInfo> regionsFromMetaScan = allRegions.keySet();
        if (retainAssignment) {
            this.assign(allRegions);
        } else {
            ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(regionsFromMetaScan);
            this.assign(regions);
        }
        for (HRegionInfo hri : regionsFromMetaScan) {
            TableName tableName = hri.getTable();
            if (this.tableStateManager.isTableState(tableName, TableState.State.ENABLED)) continue;
            this.setEnabledTable(tableName);
        }
        this.assign(AssignmentManager.replicaRegionsNotRecordedInMeta(regionsFromMetaScan, this.server));
    }

    public static List<HRegionInfo> replicaRegionsNotRecordedInMeta(Set<HRegionInfo> regionsRecordedInMeta, MasterServices master) throws IOException {
        ArrayList<HRegionInfo> regionsNotRecordedInMeta = new ArrayList<HRegionInfo>();
        for (HRegionInfo hri : regionsRecordedInMeta) {
            TableName table = hri.getTable();
            HTableDescriptor htd = master.getTableDescriptors().get(table);
            int desiredRegionReplication = htd.getRegionReplication();
            for (int i = 0; i < desiredRegionReplication; ++i) {
                HRegionInfo replica = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)hri, (int)i);
                if (regionsRecordedInMeta.contains(replica)) continue;
                regionsNotRecordedInMeta.add(replica);
            }
        }
        return regionsNotRecordedInMeta;
    }

    Set<ServerName> rebuildUserRegions() throws IOException, KeeperException {
        Set<TableName> disabledOrEnablingTables = this.tableStateManager.getTablesInStates(TableState.State.DISABLED, TableState.State.ENABLING);
        Set<TableName> disabledOrDisablingOrEnabling = this.tableStateManager.getTablesInStates(TableState.State.DISABLED, TableState.State.DISABLING, TableState.State.ENABLING);
        List results = MetaTableAccessor.fullScanRegions((Connection)this.server.getConnection());
        Set<ServerName> onlineServers = this.serverManager.getOnlineServers().keySet();
        HashSet<ServerName> offlineServers = new HashSet<ServerName>();
        for (Result result : results) {
            HRegionLocation[] locations;
            RegionLocations rl;
            if (result == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)"null result from meta - ignoring but this is strange.");
                continue;
            }
            PairOfSameType p = MetaTableAccessor.getMergeRegions((Result)result);
            if (p.getFirst() != null && p.getSecond() != null) {
                int numReplicas = this.server.getTableDescriptors().get(((HRegionInfo)p.getFirst()).getTable()).getRegionReplication();
                for (HRegionInfo merge : p) {
                    for (int i = 1; i < numReplicas; ++i) {
                        this.replicasToClose.add(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)merge, (int)i));
                    }
                }
            }
            if ((rl = MetaTableAccessor.getRegionLocations((Result)result)) == null || (locations = rl.getRegionLocations()) == null) continue;
            for (HRegionLocation hrl : locations) {
                HRegionInfo regionInfo;
                if (hrl == null || (regionInfo = hrl.getRegionInfo()) == null) continue;
                int replicaId = regionInfo.getReplicaId();
                RegionState.State state = RegionStateStore.getRegionState(result, replicaId);
                if (replicaId == 0 && state.equals((Object)RegionState.State.SPLIT)) {
                    for (HRegionLocation h : locations) {
                        this.replicasToClose.add(h.getRegionInfo());
                    }
                }
                ServerName lastHost = hrl.getServerName();
                ServerName regionLocation = RegionStateStore.getRegionServer(result, replicaId);
                this.regionStates.createRegionState(regionInfo, state, regionLocation, lastHost);
                if (!this.regionStates.isRegionInState(regionInfo, RegionState.State.OPEN)) continue;
                TableName tableName = regionInfo.getTable();
                if (!onlineServers.contains(regionLocation)) {
                    offlineServers.add(regionLocation);
                } else if (!disabledOrEnablingTables.contains(tableName)) {
                    this.regionStates.regionOnline(regionInfo, regionLocation);
                    this.balancer.regionOnline(regionInfo, regionLocation);
                }
                if (disabledOrDisablingOrEnabling.contains(tableName) || this.getTableStateManager().isTableState(tableName, TableState.State.ENABLED)) continue;
                this.setEnabledTable(tableName);
            }
        }
        return offlineServers;
    }

    private void recoverTableInDisablingState() throws KeeperException, IOException {
        Set<TableName> disablingTables = this.tableStateManager.getTablesInStates(TableState.State.DISABLING);
        if (disablingTables.size() != 0) {
            for (TableName tableName : disablingTables) {
                LOG.info((Object)("The table " + tableName + " is in DISABLING state.  Hence recovering by moving the table" + " to DISABLED state."));
                new DisableTableHandler(this.server, tableName, this, this.tableLockManager, true).prepare().process();
            }
        }
    }

    private void recoverTableInEnablingState() throws KeeperException, IOException {
        Set<TableName> enablingTables = this.tableStateManager.getTablesInStates(TableState.State.ENABLING);
        if (enablingTables.size() != 0) {
            for (TableName tableName : enablingTables) {
                LOG.info((Object)("The table " + tableName + " is in ENABLING state.  Hence recovering by moving the table" + " to ENABLED state."));
                EnableTableHandler eth = new EnableTableHandler(this.server, tableName, this, this.tableLockManager, true);
                try {
                    eth.prepare();
                }
                catch (TableNotFoundException e) {
                    LOG.warn((Object)("Table " + tableName + " not found in hbase:meta to recover."));
                    continue;
                }
                eth.process();
            }
        }
    }

    void processRegionsInTransition(Collection<RegionState> regionsInTransition) {
        for (RegionState regionState : regionsInTransition) {
            LOG.info((Object)("Processing " + regionState));
            ServerName serverName = regionState.getServerName();
            if (serverName != null && !this.serverManager.getOnlineServers().containsKey(serverName)) {
                LOG.info((Object)("Server " + serverName + " isn't online. SSH will handle this"));
                continue;
            }
            HRegionInfo regionInfo = regionState.getRegion();
            RegionState.State state = regionState.getState();
            switch (state) {
                case CLOSED: {
                    this.invokeAssign(regionState.getRegion());
                    break;
                }
                case PENDING_OPEN: {
                    this.retrySendRegionOpen(regionState);
                    break;
                }
                case PENDING_CLOSE: {
                    this.retrySendRegionClose(regionState);
                    break;
                }
                case FAILED_CLOSE: 
                case FAILED_OPEN: {
                    this.invokeUnAssign(regionInfo);
                    break;
                }
            }
        }
    }

    private void retrySendRegionOpen(final RegionState regionState) {
        this.executorService.submit(new EventHandler(this.server, EventType.M_MASTER_RECOVERY){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void process() throws IOException {
                hri = regionState.getRegion();
                serverName = regionState.getServerName();
                lock = AssignmentManager.access$000(AssignmentManager.this).acquireLock((Object)hri.getEncodedName());
                i = 1;
                if (i > AssignmentManager.access$100(AssignmentManager.this)) ** GOTO lbl-1000
                if (!AssignmentManager.access$200(AssignmentManager.this).isServerOnline(serverName) || this.server.isStopped() || this.server.isAborted()) {
                    lock.unlock();
                    return;
                }
                if (!regionState.equals((Object)AssignmentManager.access$300(AssignmentManager.this).getRegionState(hri))) {
                    lock.unlock();
                    return;
                }
                favoredNodes = ServerName.EMPTY_SERVER_LIST;
                if (AssignmentManager.access$400(AssignmentManager.this)) {
                    favoredNodes = ((FavoredNodeLoadBalancer)AssignmentManager.access$500(AssignmentManager.this)).getFavoredNodes(hri);
                }
                AssignmentManager.access$200(AssignmentManager.this).sendRegionOpen(serverName, hri, favoredNodes);
                lock.unlock();
                return;
                {
                    catch (Throwable var9_10) {
                        lock.unlock();
                        throw var9_10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        AssignmentManager.access$300(AssignmentManager.this).updateRegionState(hri, RegionState.State.FAILED_OPEN);
                        lock.unlock();
                        return;
                    }
                }
            }
        });
    }

    private void retrySendRegionClose(final RegionState regionState) {
        this.executorService.submit(new EventHandler(this.server, EventType.M_MASTER_RECOVERY){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void process() throws IOException {
                hri = regionState.getRegion();
                serverName = regionState.getServerName();
                lock = AssignmentManager.access$000(AssignmentManager.this).acquireLock((Object)hri.getEncodedName());
                i = 1;
                if (i > AssignmentManager.access$100(AssignmentManager.this)) ** GOTO lbl-1000
                if (!AssignmentManager.access$200(AssignmentManager.this).isServerOnline(serverName) || this.server.isStopped() || this.server.isAborted()) {
                    lock.unlock();
                    return;
                }
                if (!regionState.equals((Object)AssignmentManager.access$300(AssignmentManager.this).getRegionState(hri))) {
                    lock.unlock();
                    return;
                }
                AssignmentManager.access$200(AssignmentManager.this).sendRegionClose(serverName, hri, null);
                lock.unlock();
                return;
                {
                    catch (Throwable var9_10) {
                        lock.unlock();
                        throw var9_10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        AssignmentManager.access$300(AssignmentManager.this).updateRegionState(hri, RegionState.State.FAILED_CLOSE);
                        lock.unlock();
                        return;
                    }
                }
            }
        });
    }

    public void updateRegionsInTransitionMetrics() {
        long currentTime = System.currentTimeMillis();
        int totalRITs = 0;
        int totalRITsOverThreshold = 0;
        long oldestRITTime = 0L;
        int ritThreshold = this.server.getConfiguration().getInt("hbase.metrics.rit.stuck.warning.threshold", 60000);
        for (RegionState state : this.regionStates.getRegionsInTransition().values()) {
            ++totalRITs;
            long ritTime = currentTime - state.getStamp();
            if (ritTime > (long)ritThreshold) {
                ++totalRITsOverThreshold;
            }
            if (oldestRITTime >= ritTime) continue;
            oldestRITTime = ritTime;
        }
        if (this.metricsAssignmentManager != null) {
            this.metricsAssignmentManager.updateRITOldestAge(oldestRITTime);
            this.metricsAssignmentManager.updateRITCount(totalRITs);
            this.metricsAssignmentManager.updateRITCountOverThreshold(totalRITsOverThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRegionPlan(HRegionInfo region) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.remove(region.getEncodedName());
        }
    }

    public void waitOnRegionToClearRegionsInTransition(HRegionInfo hri) throws IOException, InterruptedException {
        this.waitOnRegionToClearRegionsInTransition(hri, -1L);
    }

    public boolean waitOnRegionToClearRegionsInTransition(HRegionInfo hri, long timeOut) throws InterruptedException {
        if (!this.regionStates.isRegionInTransition(hri)) {
            return true;
        }
        long end = timeOut <= 0L ? Long.MAX_VALUE : EnvironmentEdgeManager.currentTime() + timeOut;
        LOG.info((Object)("Waiting for " + hri.getEncodedName() + " to leave regions-in-transition, timeOut=" + timeOut + " ms."));
        while (!this.server.isStopped() && this.regionStates.isRegionInTransition(hri)) {
            this.regionStates.waitForUpdate(100L);
            if (EnvironmentEdgeManager.currentTime() <= end) continue;
            LOG.info((Object)("Timed out on waiting for " + hri.getEncodedName() + " to be assigned."));
            return false;
        }
        if (this.server.isStopped()) {
            LOG.info((Object)"Giving up wait on regions in transition because stoppable.isStopped is set");
            return false;
        }
        return true;
    }

    void invokeAssign(HRegionInfo regionInfo) {
        this.threadPoolExecutorService.submit(new AssignCallable(this, regionInfo));
    }

    void invokeUnAssign(HRegionInfo regionInfo) {
        this.threadPoolExecutorService.submit(new UnAssignCallable(this, regionInfo));
    }

    public boolean isCarryingMeta(ServerName serverName) {
        return this.isCarryingRegion(serverName, HRegionInfo.FIRST_META_REGIONINFO);
    }

    public boolean isCarryingMetaReplica(ServerName serverName, int replicaId) {
        return this.isCarryingRegion(serverName, RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (int)replicaId));
    }

    public boolean isCarryingMetaReplica(ServerName serverName, HRegionInfo metaHri) {
        return this.isCarryingRegion(serverName, metaHri);
    }

    private boolean isCarryingRegion(ServerName serverName, HRegionInfo hri) {
        ServerName transitionAddr;
        RegionState regionState = this.regionStates.getRegionTransitionState(hri);
        ServerName serverName2 = transitionAddr = regionState != null ? regionState.getServerName() : null;
        if (transitionAddr != null) {
            boolean matchTransitionAddr = transitionAddr.equals((Object)serverName);
            LOG.debug((Object)("Checking region=" + hri.getRegionNameAsString() + ", transitioning on server=" + matchTransitionAddr + " server being checked: " + serverName + ", matches=" + matchTransitionAddr));
            return matchTransitionAddr;
        }
        ServerName assignedAddr = this.regionStates.getRegionServerOfRegion(hri);
        boolean matchAssignedAddr = serverName.equals((Object)assignedAddr);
        LOG.debug((Object)("based on AM, current region=" + hri.getRegionNameAsString() + " is on server=" + assignedAddr + ", server being checked: " + serverName));
        return matchAssignedAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegionInfo> cleanOutCrashedServerReferences(ServerName sn) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            Iterator i = this.regionPlans.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                ServerName otherSn = ((RegionPlan)e.getValue()).getDestination();
                if (otherSn == null || !otherSn.equals((Object)sn)) continue;
                i.remove();
            }
        }
        List<HRegionInfo> rits = this.regionStates.serverOffline(sn);
        Iterator<HRegionInfo> it = rits.iterator();
        while (it.hasNext()) {
            HRegionInfo hri = it.next();
            String encodedName = hri.getEncodedName();
            ReentrantLock lock = this.locker.acquireLock((Object)encodedName);
            try {
                RegionState regionState = this.regionStates.getRegionTransitionState(encodedName);
                if (regionState == null || regionState.getServerName() != null && !regionState.isOnServer(sn) || !RegionStates.isOneOfStates(regionState, RegionState.State.PENDING_OPEN, RegionState.State.OPENING, RegionState.State.FAILED_OPEN, RegionState.State.FAILED_CLOSE, RegionState.State.OFFLINE)) {
                    LOG.info((Object)("Skip " + regionState + " since it is not opening/failed_close" + " on the dead server any more: " + sn));
                    it.remove();
                    continue;
                }
                if (this.tableStateManager.isTableState(hri.getTable(), TableState.State.DISABLED, TableState.State.DISABLING)) {
                    this.regionStates.regionOffline(hri);
                    it.remove();
                    continue;
                }
                this.regionStates.updateRegionState(hri, RegionState.State.OFFLINE);
            }
            finally {
                lock.unlock();
            }
        }
        return rits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void balance(RegionPlan plan) {
        HRegionInfo hri = plan.getRegionInfo();
        TableName tableName = hri.getTable();
        if (this.tableStateManager.isTableState(tableName, TableState.State.DISABLED, TableState.State.DISABLING)) {
            LOG.info((Object)("Ignored moving region of disabling/disabled table " + tableName));
            return;
        }
        String encodedName = hri.getEncodedName();
        ReentrantLock lock = this.locker.acquireLock((Object)encodedName);
        try {
            if (!this.regionStates.isRegionOnline(hri)) {
                RegionState state = this.regionStates.getRegionState(encodedName);
                LOG.info((Object)("Ignored moving region not assigned: " + hri + ", " + (state == null ? "not in region states" : state)));
                return;
            }
            NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
            synchronized (navigableMap) {
                this.regionPlans.put(plan.getRegionName(), plan);
            }
            this.unassign(hri, plan.getDestination());
        }
        finally {
            lock.unlock();
        }
    }

    public void stop() {
        this.threadPoolExecutorService.shutdownNow();
        this.regionStateStore.stop();
    }

    protected void setEnabledTable(TableName tableName) {
        try {
            this.tableStateManager.setTableState(tableName, TableState.State.ENABLED);
        }
        catch (IOException e) {
            String errorMsg = "Unable to ensure that the table " + tableName + " will be" + " enabled because of a ZooKeeper issue";
            LOG.error((Object)errorMsg);
            this.server.abort(errorMsg, e);
        }
    }

    @SuppressWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="Worth fixing but not the end of the world.")
    private String onRegionFailedOpen(RegionState current, HRegionInfo hri, ServerName serverName) {
        if (current == null || !current.isOpeningOrFailedOpenOnServer(serverName)) {
            return hri.getShortNameToLog() + " is not opening on " + serverName;
        }
        if (current.isFailedOpen()) {
            return null;
        }
        String encodedName = hri.getEncodedName();
        AtomicInteger failedOpenCount = this.failedOpenTracker.get(encodedName);
        if (failedOpenCount == null) {
            failedOpenCount = new AtomicInteger();
            this.failedOpenTracker.put(encodedName, failedOpenCount);
        }
        if (failedOpenCount.incrementAndGet() >= this.maximumAttempts && !hri.isMetaRegion()) {
            this.regionStates.updateRegionState(hri, RegionState.State.FAILED_OPEN);
            this.failedOpenTracker.remove(encodedName);
        } else {
            RegionState regionState;
            if (hri.isMetaRegion() && failedOpenCount.get() >= this.maximumAttempts) {
                LOG.warn((Object)("Failed to open the hbase:meta region " + hri.getRegionNameAsString() + " after" + failedOpenCount.get() + " retries. Continue retrying."));
            }
            if ((regionState = this.regionStates.updateRegionState(hri, RegionState.State.CLOSED)) != null) {
                if (this.getTableStateManager().isTableState(hri.getTable(), TableState.State.DISABLED, TableState.State.DISABLING) || this.replicasToClose.contains(hri)) {
                    this.offlineDisabledRegion(hri);
                    return null;
                }
                this.regionStates.updateRegionState(hri, RegionState.State.CLOSED);
                this.removeClosedRegion(hri);
                try {
                    this.getRegionPlan(hri, true);
                }
                catch (HBaseIOException e) {
                    LOG.warn((Object)"Failed to get region plan", (Throwable)e);
                }
                this.invokeAssign(hri);
            }
        }
        return null;
    }

    private String onRegionOpen(RegionState current, HRegionInfo hri, ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        long openSeqNum;
        if (current == null || !current.isOpeningOrOpenedOnServer(serverName)) {
            return hri.getShortNameToLog() + " is not opening on " + serverName;
        }
        if (current.isOpened()) {
            return null;
        }
        long l = openSeqNum = transition.hasOpenSeqNum() ? transition.getOpenSeqNum() : -1L;
        if (openSeqNum < 0L) {
            return "Newly opened region has invalid open seq num " + openSeqNum;
        }
        this.regionOnline(hri, serverName, openSeqNum);
        this.failedOpenTracker.remove(hri.getEncodedName());
        if (this.getTableStateManager().isTableState(hri.getTable(), TableState.State.DISABLED, TableState.State.DISABLING)) {
            this.invokeUnAssign(hri);
        }
        return null;
    }

    private String onRegionClosed(RegionState current, HRegionInfo hri, ServerName serverName) {
        if (current == null || !current.isClosingOrClosedOnServer(serverName)) {
            return hri.getShortNameToLog() + " is not closing on " + serverName;
        }
        if (current.isClosed()) {
            return null;
        }
        if (this.getTableStateManager().isTableState(hri.getTable(), TableState.State.DISABLED, TableState.State.DISABLING) || this.replicasToClose.contains(hri)) {
            this.offlineDisabledRegion(hri);
            return null;
        }
        this.regionStates.updateRegionState(hri, RegionState.State.CLOSED);
        this.sendRegionClosedNotification(hri);
        this.removeClosedRegion(hri);
        this.invokeAssign(hri);
        return null;
    }

    private String onRegionReadyToSplit(RegionState current, HRegionInfo hri, ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        if (current == null || !current.isSplittingOrOpenedOnServer(serverName)) {
            return hri.getShortNameToLog() + " is not opening on " + serverName;
        }
        if (!((HMaster)this.server).getSplitOrMergeTracker().isSplitOrMergeEnabled(Admin.MasterSwitchType.SPLIT)) {
            return "split switch is off!";
        }
        if (current.isSplitting()) {
            return null;
        }
        HRegionInfo a = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1));
        HRegionInfo b = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2));
        RegionState rs_a = this.regionStates.getRegionState(a);
        RegionState rs_b = this.regionStates.getRegionState(b);
        if (rs_a != null || rs_b != null) {
            return "Some daughter is already existing. a=" + rs_a + ", b=" + rs_b;
        }
        this.regionStates.updateRegionState(hri, RegionState.State.SPLITTING);
        this.regionStates.createRegionState(a, RegionState.State.SPLITTING_NEW, serverName, null);
        this.regionStates.createRegionState(b, RegionState.State.SPLITTING_NEW, serverName, null);
        return null;
    }

    private String onRegionSplitPONR(RegionState current, HRegionInfo hri, ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        if (current == null || !current.isSplittingOnServer(serverName)) {
            return hri.getShortNameToLog() + " is not splitting on " + serverName;
        }
        HRegionInfo a = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1));
        HRegionInfo b = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2));
        RegionState rs_a = this.regionStates.getRegionState(a);
        RegionState rs_b = this.regionStates.getRegionState(b);
        if (rs_a == null && rs_b == null) {
            rs_a = this.regionStates.createRegionState(a, RegionState.State.SPLITTING_NEW, serverName, null);
            rs_b = this.regionStates.createRegionState(b, RegionState.State.SPLITTING_NEW, serverName, null);
        }
        if (rs_a == null || !rs_a.isSplittingNewOnServer(serverName) || rs_b == null || !rs_b.isSplittingNewOnServer(serverName)) {
            return "Some daughter is not known to be splitting on " + serverName + ", a=" + rs_a + ", b=" + rs_b;
        }
        if (!this.regionStates.isRegionOnServer(hri, serverName)) {
            return null;
        }
        try {
            this.regionStates.splitRegion(hri, a, b, serverName);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Failed to record split region " + hri.getShortNameToLog()));
            return "Failed to record the splitting in meta";
        }
        return null;
    }

    private String onRegionSplit(RegionState current, final HRegionInfo hri, ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        if (current == null || !current.isSplittingOrSplitOnServer(serverName)) {
            return hri.getShortNameToLog() + " is not splitting on " + serverName;
        }
        if (current.isSplit()) {
            return null;
        }
        final HRegionInfo a = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1));
        final HRegionInfo b = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2));
        RegionState rs_a = this.regionStates.getRegionState(a);
        RegionState rs_b = this.regionStates.getRegionState(b);
        if (rs_a == null || !rs_a.isSplittingNewOnServer(serverName) || rs_b == null || !rs_b.isSplittingNewOnServer(serverName)) {
            return "Some daughter is not known to be splitting on " + serverName + ", a=" + rs_a + ", b=" + rs_b;
        }
        if (TEST_SKIP_SPLIT_HANDLING) {
            return "Skipping split message, TEST_SKIP_SPLIT_HANDLING is set";
        }
        this.regionOffline(hri, RegionState.State.SPLIT);
        this.regionOnline(a, serverName, 1L);
        this.regionOnline(b, serverName, 1L);
        if (this.getTableStateManager().isTableState(hri.getTable(), TableState.State.DISABLED, TableState.State.DISABLING)) {
            this.invokeUnAssign(a);
            this.invokeUnAssign(b);
        } else {
            Callable<Object> splitReplicasCallable = new Callable<Object>(){

                @Override
                public Object call() {
                    AssignmentManager.this.doSplittingOfReplicas(hri, a, b);
                    return null;
                }
            };
            this.threadPoolExecutorService.submit(splitReplicasCallable);
        }
        return null;
    }

    private String onRegionSplitReverted(RegionState current, HRegionInfo hri, ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        if (current == null || !current.isSplittingOrOpenedOnServer(serverName)) {
            return hri.getShortNameToLog() + " is not splitting on " + serverName;
        }
        if (current.isOpened()) {
            return null;
        }
        HRegionInfo a = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1));
        HRegionInfo b = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2));
        RegionState rs_a = this.regionStates.getRegionState(a);
        RegionState rs_b = this.regionStates.getRegionState(b);
        if (rs_a == null || !rs_a.isSplittingNewOnServer(serverName) || rs_b == null || !rs_b.isSplittingNewOnServer(serverName)) {
            return "Some daughter is not known to be splitting on " + serverName + ", a=" + rs_a + ", b=" + rs_b;
        }
        this.regionOnline(hri, serverName);
        this.regionOffline(a);
        this.regionOffline(b);
        if (this.getTableStateManager().isTableState(hri.getTable(), TableState.State.DISABLED, TableState.State.DISABLING)) {
            this.invokeUnAssign(hri);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String onRegionReadyToMerge(RegionState current, HRegionInfo hri, ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        if (current != null && !current.isMergingNewOnServer(serverName)) {
            return "Merging daughter region already exists, p=" + current;
        }
        if (!((HMaster)this.server).getSplitOrMergeTracker().isSplitOrMergeEnabled(Admin.MasterSwitchType.MERGE)) {
            return "merge switch is off!";
        }
        if (current != null) {
            return null;
        }
        HRegionInfo a = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1));
        HRegionInfo b = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2));
        HashSet<String> encodedNames = new HashSet<String>(2);
        encodedNames.add(a.getEncodedName());
        encodedNames.add(b.getEncodedName());
        Map locks = this.locker.acquireLocks(encodedNames);
        try {
            RegionState rs_a = this.regionStates.getRegionState(a);
            RegionState rs_b = this.regionStates.getRegionState(b);
            if (rs_a == null || !rs_a.isOpenedOnServer(serverName) || rs_b == null || !rs_b.isOpenedOnServer(serverName)) {
                String string = "Some daughter is not in a state to merge on " + serverName + ", a=" + rs_a + ", b=" + rs_b;
                return string;
            }
            this.regionStates.updateRegionState(a, RegionState.State.MERGING);
            this.regionStates.updateRegionState(b, RegionState.State.MERGING);
            this.regionStates.createRegionState(hri, RegionState.State.MERGING_NEW, serverName, null);
            String string = null;
            return string;
        }
        finally {
            for (Lock lock : locks.values()) {
                lock.unlock();
            }
        }
    }

    private String onRegionMergePONR(RegionState current, HRegionInfo hri, ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        if (current != null && !current.isMergingNewOnServer(serverName)) {
            return hri.getShortNameToLog() + " is not merging on " + serverName;
        }
        HRegionInfo a = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1));
        HRegionInfo b = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2));
        RegionState rs_a = this.regionStates.getRegionState(a);
        RegionState rs_b = this.regionStates.getRegionState(b);
        if (rs_a == null || !rs_a.isMergingOnServer(serverName) || rs_b == null || !rs_b.isMergingOnServer(serverName)) {
            return "Some daughter is not known to be merging on " + serverName + ", a=" + rs_a + ", b=" + rs_b;
        }
        if (current == null) {
            this.regionStates.createRegionState(hri, RegionState.State.MERGING_NEW, serverName, null);
        }
        if (this.regionStates.isRegionOnServer(hri, serverName)) {
            return null;
        }
        try {
            this.regionStates.mergeRegions(hri, a, b, serverName);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Failed to record merged region " + hri.getShortNameToLog()));
            return "Failed to record the merging in meta";
        }
        return null;
    }

    private String onRegionMerged(RegionState current, final HRegionInfo hri, ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        if (current == null || !current.isMergingNewOrOpenedOnServer(serverName)) {
            return hri.getShortNameToLog() + " is not merging on " + serverName;
        }
        if (current.isOpened()) {
            return null;
        }
        final HRegionInfo a = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1));
        final HRegionInfo b = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2));
        RegionState rs_a = this.regionStates.getRegionState(a);
        RegionState rs_b = this.regionStates.getRegionState(b);
        if (rs_a == null || !rs_a.isMergingOnServer(serverName) || rs_b == null || !rs_b.isMergingOnServer(serverName)) {
            return "Some daughter is not known to be merging on " + serverName + ", a=" + rs_a + ", b=" + rs_b;
        }
        this.regionOffline(a, RegionState.State.MERGED);
        this.regionOffline(b, RegionState.State.MERGED);
        this.regionOnline(hri, serverName, 1L);
        if (this.getTableStateManager().isTableState(hri.getTable(), TableState.State.DISABLED, TableState.State.DISABLING)) {
            this.invokeUnAssign(hri);
        } else {
            Callable<Object> mergeReplicasCallable = new Callable<Object>(){

                @Override
                public Object call() {
                    AssignmentManager.this.doMergingOfReplicas(hri, a, b);
                    return null;
                }
            };
            this.threadPoolExecutorService.submit(mergeReplicasCallable);
        }
        return null;
    }

    private String onRegionMergeReverted(RegionState current, HRegionInfo hri, ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        if (current == null || !current.isMergingNewOrOfflineOnServer(serverName)) {
            return hri.getShortNameToLog() + " is not merging on " + serverName;
        }
        if (current.isOffline()) {
            return null;
        }
        HRegionInfo a = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1));
        HRegionInfo b = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2));
        RegionState rs_a = this.regionStates.getRegionState(a);
        RegionState rs_b = this.regionStates.getRegionState(b);
        if (rs_a == null || !rs_a.isMergingOnServer(serverName) || rs_b == null || !rs_b.isMergingOnServer(serverName)) {
            return "Some daughter is not known to be merging on " + serverName + ", a=" + rs_a + ", b=" + rs_b;
        }
        this.regionOnline(a, serverName);
        this.regionOnline(b, serverName);
        this.regionOffline(hri);
        if (this.getTableStateManager().isTableState(hri.getTable(), TableState.State.DISABLED, TableState.State.DISABLING)) {
            this.invokeUnAssign(a);
            this.invokeUnAssign(b);
        }
        return null;
    }

    private void doMergingOfReplicas(HRegionInfo mergedHri, HRegionInfo hri_a, HRegionInfo hri_b) {
        ArrayList<HRegionInfo> unmergedRegions = new ArrayList<HRegionInfo>();
        unmergedRegions.add(hri_a);
        unmergedRegions.add(hri_b);
        Map<ServerName, List<HRegionInfo>> map = this.regionStates.getRegionAssignments(unmergedRegions);
        Collection<List<HRegionInfo>> c = map.values();
        for (List<HRegionInfo> l : c) {
            for (HRegionInfo h : l) {
                if (RegionReplicaUtil.isDefaultReplica((HRegionInfo)h)) continue;
                LOG.debug((Object)("Unassigning un-merged replica " + h));
                this.unassign(h);
            }
        }
        int numReplicas = 1;
        try {
            numReplicas = this.server.getTableDescriptors().get(mergedHri.getTable()).getRegionReplication();
        }
        catch (IOException e) {
            LOG.warn((Object)("Couldn't get the replication attribute of the table " + mergedHri.getTable() + " due to " + e.getMessage() + ". The assignment of replicas for the merged region " + "will not be done"));
        }
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        for (int i = 1; i < numReplicas; ++i) {
            regions.add(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)mergedHri, (int)i));
        }
        try {
            this.assign(regions);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Couldn't assign all replica(s) of region " + mergedHri + " because of " + ioe.getMessage()));
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)("Couldn't assign all replica(s) of region " + mergedHri + " because of " + ie.getMessage()));
        }
    }

    private void doSplittingOfReplicas(HRegionInfo parentHri, HRegionInfo hri_a, HRegionInfo hri_b) {
        int numReplicas = 1;
        try {
            numReplicas = this.server.getTableDescriptors().get(parentHri.getTable()).getRegionReplication();
        }
        catch (IOException e) {
            LOG.warn((Object)("Couldn't get the replication attribute of the table " + parentHri.getTable() + " due to " + e.getMessage() + ". The assignment of daughter replicas " + "replicas will not be done"));
        }
        ArrayList<HRegionInfo> parentRegion = new ArrayList<HRegionInfo>();
        parentRegion.add(parentHri);
        Map<ServerName, List<HRegionInfo>> currentAssign = this.regionStates.getRegionAssignments(parentRegion);
        Collection<List<HRegionInfo>> c = currentAssign.values();
        for (List<HRegionInfo> l : c) {
            for (HRegionInfo h : l) {
                if (RegionReplicaUtil.isDefaultReplica((HRegionInfo)h)) continue;
                LOG.debug((Object)("Unassigning parent's replica " + h));
                this.unassign(h);
            }
        }
        HashMap<HRegionInfo, ServerName> map = new HashMap<HRegionInfo, ServerName>();
        for (int i = 1; i < numReplicas; ++i) {
            this.prepareDaughterReplicaForAssignment(hri_a, parentHri, i, map);
            this.prepareDaughterReplicaForAssignment(hri_b, parentHri, i, map);
        }
        try {
            this.assign(map);
        }
        catch (IOException e) {
            LOG.warn((Object)("Caught exception " + e + " while trying to assign replica(s) of daughter(s)"));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Caught exception " + e + " while trying to assign replica(s) of daughter(s)"));
        }
    }

    private void prepareDaughterReplicaForAssignment(HRegionInfo daughterHri, HRegionInfo parentHri, int replicaId, Map<HRegionInfo, ServerName> map) {
        HRegionInfo parentReplica = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)parentHri, (int)replicaId);
        HRegionInfo daughterReplica = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)daughterHri, (int)replicaId);
        LOG.debug((Object)("Created replica region for daughter " + daughterReplica));
        ServerName sn = this.regionStates.getRegionServerOfRegion(parentReplica);
        if (sn != null) {
            map.put(daughterReplica, sn);
        } else {
            List<ServerName> servers = this.serverManager.getOnlineServersList();
            sn = servers.get(new Random(System.currentTimeMillis()).nextInt(servers.size()));
            map.put(daughterReplica, sn);
        }
    }

    public Set<HRegionInfo> getReplicasToClose() {
        return this.replicasToClose;
    }

    private void regionOffline(HRegionInfo regionInfo, RegionState.State state) {
        block3: {
            block2: {
                this.regionStates.regionOffline(regionInfo, state);
                this.removeClosedRegion(regionInfo);
                this.clearRegionPlan(regionInfo);
                this.balancer.regionOffline(regionInfo);
                this.sendRegionClosedNotification(regionInfo);
                if (state == null || !state.equals((Object)RegionState.State.SPLIT)) break block2;
                ArrayList<HRegionInfo> c = new ArrayList<HRegionInfo>(1);
                c.add(regionInfo);
                Map<ServerName, List<HRegionInfo>> map = this.regionStates.getRegionAssignments(c);
                Collection<List<HRegionInfo>> allReplicas = map.values();
                for (List<HRegionInfo> list : allReplicas) {
                    this.replicasToClose.addAll(list);
                }
                break block3;
            }
            if (state == null || !state.equals((Object)RegionState.State.MERGED)) break block3;
            ArrayList<HRegionInfo> c = new ArrayList<HRegionInfo>(1);
            c.add(regionInfo);
            Map<ServerName, List<HRegionInfo>> map = this.regionStates.getRegionAssignments(c);
            Collection<List<HRegionInfo>> allReplicas = map.values();
            for (List<HRegionInfo> list : allReplicas) {
                this.replicasToClose.addAll(list);
            }
        }
    }

    private void sendRegionOpenedNotification(HRegionInfo regionInfo, ServerName serverName) {
        if (!this.listeners.isEmpty()) {
            for (AssignmentListener listener : this.listeners) {
                listener.regionOpened(regionInfo, serverName);
            }
        }
    }

    private void sendRegionClosedNotification(HRegionInfo regionInfo) {
        if (!this.listeners.isEmpty()) {
            for (AssignmentListener listener : this.listeners) {
                listener.regionClosed(regionInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String onRegionTransition(ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        RegionServerStatusProtos.RegionStateTransition.TransitionCode code = transition.getTransitionCode();
        HRegionInfo hri = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(0));
        ReentrantLock lock = this.locker.acquireLock((Object)hri.getEncodedName());
        try {
            RegionState current = this.regionStates.getRegionState(hri);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Got transition " + code + " for " + (current != null ? current.toString() : hri.getShortNameToLog()) + " from " + serverName));
            }
            String errorMsg = null;
            switch (code) {
                case OPENED: {
                    errorMsg = this.onRegionOpen(current, hri, serverName, transition);
                    break;
                }
                case FAILED_OPEN: {
                    errorMsg = this.onRegionFailedOpen(current, hri, serverName);
                    break;
                }
                case CLOSED: {
                    errorMsg = this.onRegionClosed(current, hri, serverName);
                    break;
                }
                case READY_TO_SPLIT: {
                    try {
                        this.regionStateListener.onRegionSplit(hri);
                        errorMsg = this.onRegionReadyToSplit(current, hri, serverName, transition);
                    }
                    catch (IOException exp) {
                        if (exp instanceof QuotaExceededException) {
                            this.server.getRegionNormalizer().planSkipped(hri, NormalizationPlan.PlanType.SPLIT);
                        }
                        errorMsg = org.apache.hadoop.util.StringUtils.stringifyException((Throwable)exp);
                    }
                    break;
                }
                case SPLIT_PONR: {
                    errorMsg = this.onRegionSplitPONR(current, hri, serverName, transition);
                    break;
                }
                case SPLIT: {
                    errorMsg = this.onRegionSplit(current, hri, serverName, transition);
                    break;
                }
                case SPLIT_REVERTED: {
                    errorMsg = this.onRegionSplitReverted(current, hri, serverName, transition);
                    if (!StringUtils.isEmpty((String)errorMsg)) break;
                    try {
                        this.regionStateListener.onRegionSplitReverted(hri);
                    }
                    catch (IOException exp) {
                        LOG.warn((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)exp));
                    }
                    break;
                }
                case READY_TO_MERGE: {
                    errorMsg = this.onRegionReadyToMerge(current, hri, serverName, transition);
                    break;
                }
                case MERGE_PONR: {
                    errorMsg = this.onRegionMergePONR(current, hri, serverName, transition);
                    break;
                }
                case MERGED: {
                    try {
                        errorMsg = this.onRegionMerged(current, hri, serverName, transition);
                        this.regionStateListener.onRegionMerged(hri);
                    }
                    catch (IOException exp) {
                        errorMsg = org.apache.hadoop.util.StringUtils.stringifyException((Throwable)exp);
                    }
                    break;
                }
                case MERGE_REVERTED: {
                    errorMsg = this.onRegionMergeReverted(current, hri, serverName, transition);
                    break;
                }
                default: {
                    errorMsg = "Unexpected transition code " + code;
                }
            }
            if (errorMsg != null) {
                LOG.info((Object)("Could not transition region from " + current + " on " + code + " by " + serverName + ": " + errorMsg));
            }
            String string = errorMsg;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private void processBogusAssignments(Map<ServerName, List<HRegionInfo>> bulkPlan) {
        if (bulkPlan.containsKey(LoadBalancer.BOGUS_SERVER_NAME)) {
            for (HRegionInfo hri : bulkPlan.get(LoadBalancer.BOGUS_SERVER_NAME)) {
                this.regionStates.updateRegionState(hri, RegionState.State.FAILED_OPEN);
            }
            bulkPlan.remove(LoadBalancer.BOGUS_SERVER_NAME);
        }
    }

    public LoadBalancer getBalancer() {
        return this.balancer;
    }

    public Map<ServerName, List<HRegionInfo>> getSnapShotOfAssignment(Collection<HRegionInfo> infos) {
        return this.getRegionStates().getRegionAssignments(infos);
    }

    void setRegionStateListener(RegionStateListener listener) {
        this.regionStateListener = listener;
    }

    static /* synthetic */ KeyLocker access$000(AssignmentManager x0) {
        return x0.locker;
    }

    static /* synthetic */ int access$100(AssignmentManager x0) {
        return x0.maximumAttempts;
    }

    static /* synthetic */ ServerManager access$200(AssignmentManager x0) {
        return x0.serverManager;
    }

    static /* synthetic */ RegionStates access$300(AssignmentManager x0) {
        return x0.regionStates;
    }

    static /* synthetic */ boolean access$400(AssignmentManager x0) {
        return x0.shouldAssignRegionsWithFavoredNodes;
    }

    static /* synthetic */ LoadBalancer access$500(AssignmentManager x0) {
        return x0.balancer;
    }

    static /* synthetic */ Log access$600() {
        return LOG;
    }
}

