/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ServiceNotRunningException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.ClusterSchemaService;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.procedure.CreateNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ModifyNamespaceProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;

@InterfaceAudience.Private
class ClusterSchemaServiceImpl
implements ClusterSchemaService {
    private boolean running = false;
    private final TableNamespaceManager tableNamespaceManager;
    private final MasterServices masterServices;
    private static final List<NamespaceDescriptor> EMPTY_NAMESPACE_LIST = Collections.unmodifiableList(new ArrayList(0));

    ClusterSchemaServiceImpl(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.tableNamespaceManager = new TableNamespaceManager(masterServices);
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private synchronized void checkIsRunning() throws ServiceNotRunningException {
        if (!this.isRunning()) {
            throw new ServiceNotRunningException();
        }
    }

    public synchronized void startAndWait() throws IOException {
        if (this.isRunning()) {
            throw new IllegalStateException("Already running; cannot double-start.");
        }
        this.running = true;
        this.tableNamespaceManager.start();
    }

    public synchronized void stopAndWait() throws IOException {
        this.checkIsRunning();
        this.running = false;
    }

    @Override
    public TableNamespaceManager getTableNamespaceManager() {
        return this.tableNamespaceManager;
    }

    private long submitProcedure(Procedure<?> procedure, long nonceGroup, long nonce) throws ServiceNotRunningException {
        this.checkIsRunning();
        ProcedureExecutor<MasterProcedureEnv> pe = this.masterServices.getMasterProcedureExecutor();
        return pe.submitProcedure(procedure, nonceGroup, nonce);
    }

    @Override
    public long createNamespace(NamespaceDescriptor namespaceDescriptor, long nonceGroup, long nonce) throws IOException {
        return this.submitProcedure((Procedure<?>)new CreateNamespaceProcedure((MasterProcedureEnv)this.masterServices.getMasterProcedureExecutor().getEnvironment(), namespaceDescriptor), nonceGroup, nonce);
    }

    @Override
    public long modifyNamespace(NamespaceDescriptor namespaceDescriptor, long nonceGroup, long nonce) throws IOException {
        return this.submitProcedure((Procedure<?>)new ModifyNamespaceProcedure((MasterProcedureEnv)this.masterServices.getMasterProcedureExecutor().getEnvironment(), namespaceDescriptor), nonceGroup, nonce);
    }

    @Override
    public long deleteNamespace(String name, long nonceGroup, long nonce) throws IOException {
        return this.submitProcedure((Procedure<?>)new DeleteNamespaceProcedure((MasterProcedureEnv)this.masterServices.getMasterProcedureExecutor().getEnvironment(), name), nonceGroup, nonce);
    }

    @Override
    public NamespaceDescriptor getNamespace(String name) throws IOException {
        NamespaceDescriptor nsd = this.getTableNamespaceManager().get(name);
        if (nsd == null) {
            throw new NamespaceNotFoundException(name);
        }
        return nsd;
    }

    @Override
    public List<NamespaceDescriptor> getNamespaces() throws IOException {
        this.checkIsRunning();
        NavigableSet<NamespaceDescriptor> set = this.getTableNamespaceManager().list();
        if (set == null || set.isEmpty()) {
            return EMPTY_NAMESPACE_LIST;
        }
        ArrayList<NamespaceDescriptor> list = new ArrayList<NamespaceDescriptor>(set.size());
        list.addAll(set);
        return Collections.unmodifiableList(list);
    }
}

