/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.Service;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.ClusterSchema;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
public interface MasterServices
extends Server {
    public ClusterSchema getClusterSchema();

    public AssignmentManager getAssignmentManager();

    public MasterFileSystem getMasterFileSystem();

    public ServerManager getServerManager();

    public ExecutorService getExecutorService();

    public TableLockManager getTableLockManager();

    public TableStateManager getTableStateManager();

    public MasterCoprocessorHost getMasterCoprocessorHost();

    public MasterQuotaManager getMasterQuotaManager();

    public RegionNormalizer getRegionNormalizer();

    public ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor();

    public void checkTableModifiable(TableName var1) throws IOException, TableNotFoundException, TableNotDisabledException;

    public long createTable(HTableDescriptor var1, byte[][] var2, long var3, long var5) throws IOException;

    public long deleteTable(TableName var1, long var2, long var4) throws IOException;

    public long truncateTable(TableName var1, boolean var2, long var3, long var5) throws IOException;

    public long modifyTable(TableName var1, HTableDescriptor var2, long var3, long var5) throws IOException;

    public long enableTable(TableName var1, long var2, long var4) throws IOException;

    public long disableTable(TableName var1, long var2, long var4) throws IOException;

    public long addColumn(TableName var1, HColumnDescriptor var2, long var3, long var5) throws IOException;

    public long modifyColumn(TableName var1, HColumnDescriptor var2, long var3, long var5) throws IOException;

    public long deleteColumn(TableName var1, byte[] var2, long var3, long var5) throws IOException;

    public TableDescriptors getTableDescriptors();

    public boolean isServerCrashProcessingEnabled();

    public boolean registerService(Service var1);

    public void dispatchMergingRegions(HRegionInfo var1, HRegionInfo var2, boolean var3, User var4) throws IOException;

    public boolean isInitialized();

    public boolean abortProcedure(long var1, boolean var3) throws IOException;

    public List<ProcedureInfo> listProcedures() throws IOException;

    public List<HTableDescriptor> listTableDescriptorsByNamespace(String var1) throws IOException;

    public List<TableName> listTableNamesByNamespace(String var1) throws IOException;

    public long getLastMajorCompactionTimestamp(TableName var1) throws IOException;

    public long getLastMajorCompactionTimestampForRegion(byte[] var1) throws IOException;

    public LoadBalancer getLoadBalancer();
}

