/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;

@InterfaceAudience.Private
public class CreateTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(CreateTableHandler.class);
    protected final MasterFileSystem fileSystemManager;
    protected final HTableDescriptor hTableDescriptor;
    protected final Configuration conf;
    private final AssignmentManager assignmentManager;
    private final TableLockManager tableLockManager;
    private final HRegionInfo[] newRegions;
    private final MasterServices masterServices;
    private final TableLockManager.TableLock tableLock;
    private User activeUser;

    public CreateTableHandler(Server server, MasterFileSystem fileSystemManager, HTableDescriptor hTableDescriptor, Configuration conf, HRegionInfo[] newRegions, MasterServices masterServices) {
        super(server, EventType.C_M_CREATE_TABLE);
        this.fileSystemManager = fileSystemManager;
        this.hTableDescriptor = hTableDescriptor;
        this.conf = conf;
        this.newRegions = newRegions;
        this.masterServices = masterServices;
        this.assignmentManager = masterServices.getAssignmentManager();
        this.tableLockManager = masterServices.getTableLockManager();
        this.tableLock = this.tableLockManager.writeLock(this.hTableDescriptor.getTableName(), EventType.C_M_CREATE_TABLE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTableHandler prepare() throws NotAllMetaRegionsOnlineException, TableExistsException, IOException {
        int timeout = this.conf.getInt("hbase.client.catalog.timeout", 10000);
        try {
            if (this.server.getMetaTableLocator().waitMetaRegionLocation(this.server.getZooKeeper(), (long)timeout) == null) {
                throw new NotAllMetaRegionsOnlineException();
            }
            this.activeUser = RpcServer.getRequestUser();
            if (this.activeUser == null) {
                this.activeUser = UserProvider.instantiate((Configuration)this.conf).getCurrent();
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted waiting for meta availability", (Throwable)e);
            InterruptedIOException ie = new InterruptedIOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        this.tableLock.acquire();
        boolean success = false;
        try {
            TableName tableName = this.hTableDescriptor.getTableName();
            if (MetaTableAccessor.tableExists((Connection)this.server.getConnection(), (TableName)tableName)) {
                throw new TableExistsException(tableName);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.releaseTableLock();
            }
        }
        return this;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.hTableDescriptor.getTableName();
    }

    @Override
    public void process() {
        TableName tableName = this.hTableDescriptor.getTableName();
        LOG.info((Object)("Create table " + tableName));
        HMaster master = (HMaster)this.server;
        try {
            final MasterCoprocessorHost cpHost = master.getMasterCoprocessorHost();
            if (cpHost != null) {
                cpHost.preCreateTableHandler(this.hTableDescriptor, this.newRegions);
            }
            this.handleCreateTable(tableName);
            this.completed(null);
            if (cpHost != null) {
                this.activeUser.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        cpHost.postCreateTableHandler(CreateTableHandler.this.hTableDescriptor, CreateTableHandler.this.newRegions);
                        return null;
                    }
                });
            }
        }
        catch (Throwable e) {
            LOG.error((Object)("Error trying to create the table " + tableName), e);
            if (master.isInitialized()) {
                try {
                    ((HMaster)this.server).getMasterQuotaManager().removeTableFromNamespaceQuota(this.hTableDescriptor.getTableName());
                }
                catch (IOException e1) {
                    LOG.error((Object)("Error trying to update namespace quota " + e1));
                }
            }
            this.completed(e);
        }
    }

    protected void completed(Throwable exception) {
        this.releaseTableLock();
        LOG.info((Object)("Table, " + this.hTableDescriptor.getTableName() + ", creation " + (exception == null ? "successful" : "failed. " + exception)));
    }

    private void handleCreateTable(TableName tableName) throws IOException, CoordinatedStateException {
        Path tempdir = this.fileSystemManager.getTempDir();
        FileSystem fs = this.fileSystemManager.getFileSystem();
        TableDescriptor underConstruction = new TableDescriptor(this.hTableDescriptor);
        Path tempTableDir = FSUtils.getTableDir(tempdir, tableName);
        ((FSTableDescriptors)this.masterServices.getTableDescriptors()).createTableDescriptorForTableDirectory(tempTableDir, underConstruction, false);
        Path tableDir = FSUtils.getTableDir(this.fileSystemManager.getRootDir(), tableName);
        List<HRegionInfo> regionInfos = this.handleCreateHdfsRegions(tempdir, tableName);
        if (!fs.rename(tempTableDir, tableDir)) {
            throw new IOException("Unable to move table from temp=" + tempTableDir + " to hbase root=" + tableDir);
        }
        this.masterServices.getTableDescriptors().get(tableName);
        MetaTableAccessor.updateTableState((Connection)this.server.getConnection(), (TableName)this.hTableDescriptor.getTableName(), (TableState.State)TableState.State.ENABLING);
        if (regionInfos != null && regionInfos.size() > 0) {
            this.addRegionsToMeta(regionInfos, this.hTableDescriptor.getRegionReplication());
            regionInfos = this.addReplicas(this.hTableDescriptor, regionInfos);
            if (this.hTableDescriptor.getRegionReplication() > 1) {
                ServerRegionReplicaUtil.setupRegionReplicaReplication(this.conf);
            }
            ModifyRegionUtils.assignRegions(this.assignmentManager, regionInfos);
        }
        this.assignmentManager.getTableStateManager().setTableState(tableName, TableState.State.ENABLED);
        ((HMaster)this.server).getTableDescriptors().get(tableName);
    }

    protected List<HRegionInfo> addReplicas(HTableDescriptor hTableDescriptor, List<HRegionInfo> regions) {
        int numRegionReplicas = hTableDescriptor.getRegionReplication() - 1;
        if (numRegionReplicas <= 0) {
            return regions;
        }
        ArrayList<HRegionInfo> hRegionInfos = new ArrayList<HRegionInfo>((numRegionReplicas + 1) * regions.size());
        for (int i = 0; i < regions.size(); ++i) {
            for (int j = 1; j <= numRegionReplicas; ++j) {
                hRegionInfos.add(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)regions.get(i), (int)j));
            }
        }
        hRegionInfos.addAll(regions);
        return hRegionInfos;
    }

    private void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Could not release the table lock", (Throwable)ex);
            }
        }
    }

    protected List<HRegionInfo> handleCreateHdfsRegions(Path tableRootDir, TableName tableName) throws IOException {
        return ModifyRegionUtils.createRegions(this.conf, tableRootDir, this.hTableDescriptor, this.newRegions, null);
    }

    protected void addRegionsToMeta(List<HRegionInfo> regionInfos, int regionReplication) throws IOException {
        MetaTableAccessor.addRegionsToMeta((Connection)this.server.getConnection(), regionInfos, (int)regionReplication);
    }
}

