/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MobCompactionStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class DefaultMobStoreCompactor
extends DefaultCompactor {
    private static final Log LOG = LogFactory.getLog(DefaultMobStoreCompactor.class);
    private long mobSizeThreshold;
    private HMobStore mobStore;

    public DefaultMobStoreCompactor(Configuration conf, Store store) {
        super(conf, store);
        if (!(store instanceof HMobStore)) {
            throw new IllegalArgumentException("The store " + store + " is not a HMobStore");
        }
        this.mobStore = (HMobStore)store;
        this.mobSizeThreshold = store.getFamily().getMobThreshold();
    }

    @Override
    protected StoreFile.Writer createTmpWriter(Compactor.FileDetails fd, boolean shouldDropBehind) throws IOException {
        StoreFile.Writer writer = this.store.createWriterInTmp(fd.maxKeyCount, this.compactionCompression, true, true, true, shouldDropBehind);
        return writer;
    }

    @Override
    protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(store.getFamily().getMaxVersions());
        if (scanType == ScanType.COMPACT_DROP_DELETES) {
            scanType = ScanType.COMPACT_RETAIN_DELETES;
            return new MobCompactionStoreScanner(store, store.getScanInfo(), scan, scanners, scanType, smallestReadPoint, earliestPutTs, true);
        }
        return new MobCompactionStoreScanner(store, store.getScanInfo(), scan, scanners, scanType, smallestReadPoint, earliestPutTs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean performCompaction(Compactor.FileDetails fd, InternalScanner scanner, Compactor.CellSink writer, long smallestReadPoint, boolean cleanSeqId, ThroughputController throughputController, boolean major) throws IOException {
        if (!(scanner instanceof MobCompactionStoreScanner)) {
            throw new IllegalArgumentException("The scanner should be an instance of MobCompactionStoreScanner");
        }
        MobCompactionStoreScanner compactionScanner = (MobCompactionStoreScanner)scanner;
        int bytesWritten = 0;
        ArrayList<Cell> cells = new ArrayList<Cell>();
        int closeCheckInterval = HStore.getCloseCheckInterval();
        Path path = MobUtils.getMobFamilyPath(this.conf, this.store.getTableName(), this.store.getColumnFamilyName());
        byte[] fileName = null;
        StoreFile.Writer mobFileWriter = null;
        StoreFile.Writer delFileWriter = null;
        long mobCells = 0L;
        long deleteMarkersCount = 0L;
        ArrayBackedTag tableNameTag = new ArrayBackedTag(6, this.store.getTableName().getName());
        long cellsCountCompactedToMob = 0L;
        long cellsCountCompactedFromMob = 0L;
        long cellsSizeCompactedToMob = 0L;
        long cellsSizeCompactedFromMob = 0L;
        try {
            boolean hasMore;
            try {
                mobFileWriter = this.mobStore.createWriterInTmp(new Date(fd.latestPutTs), fd.maxKeyCount, this.store.getFamily().getCompression(), this.store.getRegionInfo().getStartKey());
                fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to create mob writer, we will continue the compaction by writing MOB cells directly in store files", (Throwable)e);
            }
            delFileWriter = this.mobStore.createDelFileWriterInTmp(new Date(fd.latestPutTs), fd.maxKeyCount, this.store.getFamily().getCompression(), this.store.getRegionInfo().getStartKey());
            ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
            do {
                hasMore = compactionScanner.next(cells, scannerContext);
                for (Cell c : cells) {
                    if (compactionScanner.isOutputDeleteMarkers() && CellUtil.isDelete((Cell)c)) {
                        delFileWriter.append(c);
                        ++deleteMarkersCount;
                    } else if (mobFileWriter == null || c.getTypeByte() != KeyValue.Type.Put.getCode()) {
                        writer.append(c);
                    } else if (MobUtils.isMobReferenceCell(c)) {
                        if (MobUtils.hasValidMobRefCellValue(c)) {
                            int size = MobUtils.getMobValueLength(c);
                            if ((long)size > this.mobSizeThreshold) {
                                writer.append(c);
                            } else {
                                Cell mobCell = this.mobStore.resolve(c, false);
                                if (mobCell.getValueLength() != 0) {
                                    CellUtil.setSequenceId((Cell)mobCell, (long)c.getSequenceId());
                                    writer.append(mobCell);
                                    ++cellsCountCompactedFromMob;
                                    cellsSizeCompactedFromMob += (long)mobCell.getValueLength();
                                } else {
                                    writer.append(c);
                                }
                            }
                        } else {
                            LOG.warn((Object)("The value format of the KeyValue " + c + " is wrong, its length is less than " + 4));
                            writer.append(c);
                        }
                    } else if ((long)c.getValueLength() <= this.mobSizeThreshold) {
                        writer.append(c);
                    } else {
                        ++mobCells;
                        mobFileWriter.append(c);
                        KeyValue reference = MobUtils.createMobRefKeyValue(c, fileName, (Tag)tableNameTag);
                        writer.append((Cell)reference);
                        ++cellsCountCompactedToMob;
                        cellsSizeCompactedToMob += (long)c.getValueLength();
                    }
                    ++this.progress.currentCompactedKVs;
                    if (closeCheckInterval <= 0 || (bytesWritten += KeyValueUtil.length((Cell)c)) <= closeCheckInterval) continue;
                    bytesWritten = 0;
                    if (this.store.areWritesEnabled()) continue;
                    this.progress.cancel();
                    boolean bl = false;
                    return bl;
                }
                cells.clear();
            } while (hasMore);
        }
        finally {
            if (mobFileWriter != null) {
                mobFileWriter.appendMetadata(fd.maxSeqId, major, mobCells);
                mobFileWriter.close();
            }
            if (delFileWriter != null) {
                delFileWriter.appendMetadata(fd.maxSeqId, major, deleteMarkersCount);
                delFileWriter.close();
            }
        }
        if (mobFileWriter != null) {
            if (mobCells > 0L) {
                this.mobStore.commitFile(mobFileWriter.getPath(), path);
            } else {
                try {
                    this.store.getFileSystem().delete(mobFileWriter.getPath(), true);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to delete the temp mob file", (Throwable)e);
                }
            }
        }
        if (delFileWriter != null) {
            if (deleteMarkersCount > 0L) {
                this.mobStore.commitFile(delFileWriter.getPath(), path);
            } else {
                try {
                    this.store.getFileSystem().delete(delFileWriter.getPath(), true);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to delete the temp del file", (Throwable)e);
                }
            }
        }
        this.mobStore.updateCellsCountCompactedFromMob(cellsCountCompactedFromMob);
        this.mobStore.updateCellsCountCompactedToMob(cellsCountCompactedToMob);
        this.mobStore.updateCellsSizeCompactedFromMob(cellsSizeCompactedFromMob);
        this.mobStore.updateCellsSizeCompactedToMob(cellsSizeCompactedToMob);
        this.progress.complete();
        return true;
    }
}

