/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.MD5Hash;

@InterfaceAudience.Private
public final class MobFileName {
    private final String date;
    private final String startKey;
    private final String uuid;
    private final String fileName;

    private MobFileName(byte[] startKey, String date, String uuid) {
        this.startKey = MD5Hash.getMD5AsHex((byte[])startKey, (int)0, (int)startKey.length);
        this.uuid = uuid;
        this.date = date;
        this.fileName = this.startKey + date + uuid;
    }

    private MobFileName(String startKey, String date, String uuid) {
        this.startKey = startKey;
        this.uuid = uuid;
        this.date = date;
        this.fileName = this.startKey + date + uuid;
    }

    public static MobFileName create(byte[] startKey, String date, String uuid) {
        return new MobFileName(startKey, date, uuid);
    }

    public static MobFileName create(String startKey, String date, String uuid) {
        return new MobFileName(startKey, date, uuid);
    }

    public static MobFileName create(String fileName) {
        String startKey = fileName.substring(0, 32);
        String date = fileName.substring(32, 40);
        String uuid = fileName.substring(40);
        return new MobFileName(startKey, date, uuid);
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getDate() {
        return this.date;
    }

    public int hashCode() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.startKey);
        builder.append(this.date);
        builder.append(this.uuid);
        return builder.toString().hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof MobFileName) {
            MobFileName another = (MobFileName)anObject;
            if (this.startKey.equals(another.startKey) && this.date.equals(another.date) && this.uuid.equals(another.uuid)) {
                return true;
            }
        }
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }
}

