/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namespace;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.namespace.NamespaceTableAndRegionInfo;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
class NamespaceStateManager {
    private static final Log LOG = LogFactory.getLog(NamespaceStateManager.class);
    private ConcurrentMap<String, NamespaceTableAndRegionInfo> nsStateCache = new ConcurrentHashMap<String, NamespaceTableAndRegionInfo>();
    private MasterServices master;
    private volatile boolean initialized = false;

    public NamespaceStateManager(MasterServices masterServices) {
        this.master = masterServices;
    }

    public void start() throws IOException {
        LOG.info((Object)"Namespace State Manager started.");
        this.initialize();
    }

    public NamespaceTableAndRegionInfo getState(String name) {
        return (NamespaceTableAndRegionInfo)this.nsStateCache.get(name);
    }

    synchronized boolean checkAndUpdateNamespaceRegionCount(TableName name, byte[] regionName, int incr) throws IOException {
        String namespace = name.getNamespaceAsString();
        NamespaceDescriptor nspdesc = this.getNamespaceDescriptor(namespace);
        if (nspdesc != null) {
            NamespaceTableAndRegionInfo currentStatus = this.getState(namespace);
            if (incr > 0 && (long)currentStatus.getRegionCount() >= TableNamespaceManager.getMaxRegions(nspdesc)) {
                LOG.warn((Object)("The region " + Bytes.toStringBinary((byte[])regionName) + " cannot be created. The region count  will exceed quota on the namespace. " + "This may be transient, please retry later if there are any ongoing split" + " operations in the namespace."));
                return false;
            }
            NamespaceTableAndRegionInfo nsInfo = (NamespaceTableAndRegionInfo)this.nsStateCache.get(namespace);
            if (nsInfo != null) {
                nsInfo.incRegionCountForTable(name, incr);
            } else {
                LOG.warn((Object)("Namespace state found null for namespace : " + namespace));
            }
        }
        return true;
    }

    synchronized void checkAndUpdateNamespaceRegionCount(TableName name, int incr) throws IOException {
        String namespace = name.getNamespaceAsString();
        NamespaceDescriptor nspdesc = this.getNamespaceDescriptor(namespace);
        if (nspdesc != null) {
            NamespaceTableAndRegionInfo currentStatus = this.getState(namespace);
            int regionCountOfTable = currentStatus.getRegionCountOfTable(name);
            if ((long)(currentStatus.getRegionCount() - regionCountOfTable + incr) > TableNamespaceManager.getMaxRegions(nspdesc)) {
                throw new QuotaExceededException("The table " + name.getNameAsString() + " region count cannot be updated as it would exceed maximum number " + "of regions allowed in the namespace.  The total number of regions permitted is " + TableNamespaceManager.getMaxRegions(nspdesc));
            }
            currentStatus.removeTable(name);
            currentStatus.addTable(name, incr);
        }
    }

    private NamespaceDescriptor getNamespaceDescriptor(String namespaceAsString) {
        try {
            return this.master.getClusterSchema().getNamespace(namespaceAsString);
        }
        catch (IOException e) {
            LOG.error((Object)("Error while fetching namespace descriptor for namespace : " + namespaceAsString));
            return null;
        }
    }

    synchronized void checkAndUpdateNamespaceTableCount(TableName table, int numRegions) throws IOException {
        String namespace = table.getNamespaceAsString();
        NamespaceDescriptor nspdesc = this.getNamespaceDescriptor(namespace);
        if (nspdesc != null) {
            NamespaceTableAndRegionInfo currentStatus = this.getState(nspdesc.getName());
            if ((long)currentStatus.getTables().size() >= TableNamespaceManager.getMaxTables(nspdesc)) {
                throw new QuotaExceededException("The table " + table.getNameAsString() + "cannot be created as it would exceed maximum number of tables allowed " + " in the namespace.  The total number of tables permitted is " + TableNamespaceManager.getMaxTables(nspdesc));
            }
            if ((long)(currentStatus.getRegionCount() + numRegions) > TableNamespaceManager.getMaxRegions(nspdesc)) {
                throw new QuotaExceededException("The table " + table.getNameAsString() + " is not allowed to have " + numRegions + " regions. The total number of regions permitted is only " + TableNamespaceManager.getMaxRegions(nspdesc) + ", while current region count is " + currentStatus.getRegionCount() + ". This may be transient, please retry later if there are any" + " ongoing split operations in the namespace.");
            }
        } else {
            throw new IOException("Namespace Descriptor found null for " + namespace + " This is unexpected.");
        }
        this.addTable(table, numRegions);
    }

    NamespaceTableAndRegionInfo addNamespace(String namespace) {
        if (!this.nsStateCache.containsKey(namespace)) {
            NamespaceTableAndRegionInfo a1 = new NamespaceTableAndRegionInfo(namespace);
            this.nsStateCache.put(namespace, a1);
        }
        return (NamespaceTableAndRegionInfo)this.nsStateCache.get(namespace);
    }

    void deleteNamespace(String namespace) {
        this.nsStateCache.remove(namespace);
    }

    private void addTable(TableName tableName, int regionCount) throws IOException {
        NamespaceTableAndRegionInfo info = (NamespaceTableAndRegionInfo)this.nsStateCache.get(tableName.getNamespaceAsString());
        if (info == null) {
            throw new IOException("Bad state : Namespace quota information not found for namespace : " + tableName.getNamespaceAsString());
        }
        info.addTable(tableName, regionCount);
    }

    synchronized void removeTable(TableName tableName) {
        NamespaceTableAndRegionInfo info = (NamespaceTableAndRegionInfo)this.nsStateCache.get(tableName.getNamespaceAsString());
        if (info != null) {
            info.removeTable(tableName);
        }
    }

    private void initialize() throws IOException {
        List<NamespaceDescriptor> namespaces = this.master.getClusterSchema().getNamespaces();
        for (NamespaceDescriptor namespace : namespaces) {
            this.addNamespace(namespace.getName());
            List<TableName> tables = this.master.listTableNamesByNamespace(namespace.getName());
            for (TableName table : tables) {
                if (table.isSystemTable()) continue;
                List regions = MetaTableAccessor.getTableRegions((Connection)this.master.getConnection(), (TableName)table, (boolean)true);
                this.addTable(table, regions.size());
            }
        }
        LOG.info((Object)("Finished updating state of " + this.nsStateCache.size() + " namespaces. "));
        this.initialized = true;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void removeRegionFromTable(HRegionInfo hri) throws IOException {
        String namespace = hri.getTable().getNamespaceAsString();
        NamespaceTableAndRegionInfo nsInfo = (NamespaceTableAndRegionInfo)this.nsStateCache.get(namespace);
        if (nsInfo == null) {
            throw new IOException("Namespace state found null for namespace : " + namespace);
        }
        nsInfo.decrementRegionCountForTable(hri.getTable(), 1);
    }
}

