/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaState;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.UserQuotaState;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class QuotaCache
implements Stoppable {
    private static final Log LOG = LogFactory.getLog(QuotaCache.class);
    public static final String REFRESH_CONF_KEY = "hbase.quota.refresh.period";
    private static final int REFRESH_DEFAULT_PERIOD = 300000;
    private static final int EVICT_PERIOD_FACTOR = 5;
    static boolean TEST_FORCE_REFRESH = false;
    private final ConcurrentHashMap<String, QuotaState> namespaceQuotaCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<TableName, QuotaState> tableQuotaCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, UserQuotaState> userQuotaCache = new ConcurrentHashMap();
    private final RegionServerServices rsServices;
    private QuotaRefresherChore refreshChore;
    private boolean stopped = true;

    public QuotaCache(RegionServerServices rsServices) {
        this.rsServices = rsServices;
    }

    public void start() throws IOException {
        this.stopped = false;
        Configuration conf = this.rsServices.getConfiguration();
        int period = conf.getInt(REFRESH_CONF_KEY, 300000);
        this.refreshChore = new QuotaRefresherChore(period, this);
        this.rsServices.getChoreService().scheduleChore((ScheduledChore)this.refreshChore);
    }

    public void stop(String why) {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public QuotaLimiter getUserLimiter(UserGroupInformation ugi, TableName table) {
        if (table.isSystemTable()) {
            return NoopQuotaLimiter.get();
        }
        return this.getUserQuotaState(ugi).getTableLimiter(table);
    }

    public UserQuotaState getUserQuotaState(UserGroupInformation ugi) {
        String key = ugi.getShortUserName();
        UserQuotaState quotaInfo = this.userQuotaCache.get(key);
        if (quotaInfo == null && this.userQuotaCache.putIfAbsent(key, quotaInfo = new UserQuotaState()) == null) {
            this.triggerCacheRefresh();
        }
        return quotaInfo;
    }

    public QuotaLimiter getTableLimiter(TableName table) {
        return this.getQuotaState(this.tableQuotaCache, table).getGlobalLimiter();
    }

    public QuotaLimiter getNamespaceLimiter(String namespace) {
        return this.getQuotaState(this.namespaceQuotaCache, namespace).getGlobalLimiter();
    }

    private <K> QuotaState getQuotaState(ConcurrentHashMap<K, QuotaState> quotasMap, K key) {
        QuotaState quotaInfo = quotasMap.get(key);
        if (quotaInfo == null && quotasMap.putIfAbsent(key, quotaInfo = new QuotaState()) == null) {
            this.triggerCacheRefresh();
        }
        return quotaInfo;
    }

    private Configuration getConfiguration() {
        return this.rsServices.getConfiguration();
    }

    @VisibleForTesting
    void triggerCacheRefresh() {
        this.refreshChore.triggerNow();
    }

    @VisibleForTesting
    long getLastUpdate() {
        return this.refreshChore.lastUpdate;
    }

    @VisibleForTesting
    Map<String, QuotaState> getNamespaceQuotaCache() {
        return this.namespaceQuotaCache;
    }

    @VisibleForTesting
    Map<TableName, QuotaState> getTableQuotaCache() {
        return this.tableQuotaCache;
    }

    @VisibleForTesting
    Map<String, UserQuotaState> getUserQuotaCache() {
        return this.userQuotaCache;
    }

    static interface Fetcher<Key, Value> {
        public Get makeGet(Map.Entry<Key, Value> var1);

        public Map<Key, Value> fetchEntries(List<Get> var1) throws IOException;
    }

    private class QuotaRefresherChore
    extends ScheduledChore {
        private long lastUpdate;

        public QuotaRefresherChore(int period, Stoppable stoppable) {
            super("QuotaRefresherChore", stoppable, period);
            this.lastUpdate = 0L;
        }

        @SuppressWarnings(value={"GC_UNRELATED_TYPES"}, justification="I do not understand why the complaints, it looks good to me -- FIX")
        protected void chore() {
            for (TableName table : QuotaCache.this.rsServices.getOnlineTables()) {
                if (table.isSystemTable()) continue;
                if (!QuotaCache.this.tableQuotaCache.contains(table)) {
                    QuotaCache.this.tableQuotaCache.putIfAbsent(table, new QuotaState());
                }
                String ns = table.getNamespaceAsString();
                if (QuotaCache.this.namespaceQuotaCache.contains(ns)) continue;
                QuotaCache.this.namespaceQuotaCache.putIfAbsent(ns, new QuotaState());
            }
            this.fetchNamespaceQuotaState();
            this.fetchTableQuotaState();
            this.fetchUserQuotaState();
            this.lastUpdate = EnvironmentEdgeManager.currentTime();
        }

        private void fetchNamespaceQuotaState() {
            this.fetch("namespace", QuotaCache.this.namespaceQuotaCache, new Fetcher<String, QuotaState>(){

                @Override
                public Get makeGet(Map.Entry<String, QuotaState> entry) {
                    return QuotaUtil.makeGetForNamespaceQuotas((String)entry.getKey());
                }

                @Override
                public Map<String, QuotaState> fetchEntries(List<Get> gets) throws IOException {
                    return QuotaUtil.fetchNamespaceQuotas(QuotaCache.this.rsServices.getConnection(), gets);
                }
            });
        }

        private void fetchTableQuotaState() {
            this.fetch("table", QuotaCache.this.tableQuotaCache, new Fetcher<TableName, QuotaState>(){

                @Override
                public Get makeGet(Map.Entry<TableName, QuotaState> entry) {
                    return QuotaUtil.makeGetForTableQuotas((TableName)entry.getKey());
                }

                @Override
                public Map<TableName, QuotaState> fetchEntries(List<Get> gets) throws IOException {
                    return QuotaUtil.fetchTableQuotas(QuotaCache.this.rsServices.getConnection(), gets);
                }
            });
        }

        private void fetchUserQuotaState() {
            final Set namespaces = QuotaCache.this.namespaceQuotaCache.keySet();
            final Set tables = QuotaCache.this.tableQuotaCache.keySet();
            this.fetch("user", QuotaCache.this.userQuotaCache, new Fetcher<String, UserQuotaState>(){

                @Override
                public Get makeGet(Map.Entry<String, UserQuotaState> entry) {
                    return QuotaUtil.makeGetForUserQuotas((String)entry.getKey(), (Iterable)tables, (Iterable)namespaces);
                }

                @Override
                public Map<String, UserQuotaState> fetchEntries(List<Get> gets) throws IOException {
                    return QuotaUtil.fetchUserQuotas(QuotaCache.this.rsServices.getConnection(), gets);
                }
            });
        }

        private <K, V extends QuotaState> void fetch(String type, ConcurrentHashMap<K, V> quotasMap, Fetcher<K, V> fetcher) {
            long now = EnvironmentEdgeManager.currentTime();
            long refreshPeriod = this.getPeriod();
            long evictPeriod = refreshPeriod * 5L;
            ArrayList<Get> gets = new ArrayList<Get>();
            ArrayList<K> toRemove = new ArrayList<K>();
            for (Map.Entry<K, V> entry : quotasMap.entrySet()) {
                long lastUpdate = ((QuotaState)entry.getValue()).getLastUpdate();
                long lastQuery = ((QuotaState)entry.getValue()).getLastQuery();
                if (lastQuery > 0L && now - lastQuery >= evictPeriod) {
                    toRemove.add(entry.getKey());
                    continue;
                }
                if (!TEST_FORCE_REFRESH && now - lastUpdate < refreshPeriod) continue;
                gets.add(fetcher.makeGet(entry));
            }
            for (Map.Entry<K, V> key : toRemove) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("evict " + type + " key=" + key));
                }
                quotasMap.remove(key);
            }
            if (!gets.isEmpty()) {
                try {
                    for (Map.Entry<K, V> entry : fetcher.fetchEntries(gets).entrySet()) {
                        QuotaState quotaInfo = (QuotaState)quotasMap.putIfAbsent(entry.getKey(), entry.getValue());
                        if (quotaInfo != null) {
                            quotaInfo.update((QuotaState)entry.getValue());
                        }
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace((Object)("refresh " + type + " key=" + entry.getKey() + " quotas=" + quotaInfo));
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Unable to read " + type + " from quota table"), (Throwable)e);
                }
            }
        }
    }
}

