/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.regionserver.SegmentScanner;
import org.apache.hadoop.hbase.regionserver.UnexpectedStateException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public abstract class AbstractMemStore
implements MemStore {
    private static final long NO_SNAPSHOT_ID = -1L;
    private final Configuration conf;
    private final CellComparator comparator;
    private volatile MutableSegment active;
    private volatile ImmutableSegment snapshot;
    protected volatile long snapshotId;
    private volatile long timeOfOldestEdit;
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 4 * ClassSize.REFERENCE + 16));
    public static final long DEEP_OVERHEAD = ClassSize.align((long)(FIXED_OVERHEAD + (long)(2 * (ClassSize.ATOMIC_LONG + ClassSize.TIMERANGE_TRACKER + ClassSize.CELL_SKIPLIST_SET + ClassSize.CONCURRENT_SKIPLISTMAP))));

    protected AbstractMemStore(Configuration conf, CellComparator c) {
        this.conf = conf;
        this.comparator = c;
        this.resetCellSet();
        this.snapshot = SegmentFactory.instance().createImmutableSegment(conf, c, 0L);
        this.snapshotId = -1L;
    }

    protected void resetCellSet() {
        this.active = SegmentFactory.instance().createMutableSegment(this.conf, this.comparator, DEEP_OVERHEAD);
        this.timeOfOldestEdit = Long.MAX_VALUE;
    }

    static long heapSizeChange(Cell cell, boolean notPresent) {
        return notPresent ? ClassSize.align((long)((long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + CellUtil.estimatedHeapSizeOf((Cell)cell))) : 0L;
    }

    public abstract void updateLowestUnflushedSequenceIdInWal(boolean var1);

    @Override
    public long add(Cell cell) {
        Cell toAdd = this.maybeCloneWithAllocator(cell);
        return this.internalAdd(toAdd);
    }

    @Override
    public long upsert(Iterable<Cell> cells, long readpoint) {
        long size = 0L;
        for (Cell cell : cells) {
            size += this.upsert(cell, readpoint);
        }
        return size;
    }

    @Override
    public long timeOfOldestEdit() {
        return this.timeOfOldestEdit;
    }

    @Override
    public long delete(Cell deleteCell) {
        Cell toAdd = this.maybeCloneWithAllocator(deleteCell);
        long s = this.internalAdd(toAdd);
        return s;
    }

    @Override
    public MemStoreSnapshot snapshot() {
        return this.snapshot(0L);
    }

    @Override
    public void clearSnapshot(long id) throws UnexpectedStateException {
        if (this.snapshotId != id) {
            throw new UnexpectedStateException("Current snapshot id is " + this.snapshotId + ",passed " + id);
        }
        ImmutableSegment oldSnapshot = this.snapshot;
        if (!this.snapshot.isEmpty()) {
            this.snapshot = SegmentFactory.instance().createImmutableSegment(this.getComparator(), 0L);
        }
        this.snapshotId = -1L;
        oldSnapshot.close();
    }

    public long heapSize() {
        return this.getActive().getSize();
    }

    @Override
    public long getFlushableSize() {
        long snapshotSize = this.getSnapshot().getSize();
        return snapshotSize > 0L ? snapshotSize : this.keySize();
    }

    @Override
    public List<KeyValueScanner> getScanners(long readPt) throws IOException {
        return Collections.singletonList(new MemStoreScanner(this, readPt));
    }

    @Override
    public long getSnapshotSize() {
        return this.getSnapshot().getSize();
    }

    @Override
    public void rollback(Cell cell) {
        long sz = this.active.rollback(cell);
        if (sz != 0L) {
            this.setOldestEditTimeToNow();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 1;
        try {
            for (Segment segment : this.getListOfSegments()) {
                buf.append("Segment (" + i + ") " + segment.toString() + "; ");
                ++i;
            }
        }
        catch (IOException e) {
            return e.toString();
        }
        return buf.toString();
    }

    protected Configuration getConfiguration() {
        return this.conf;
    }

    protected void dump(Log log) {
        this.active.dump(log);
        this.snapshot.dump(log);
    }

    private long upsert(Cell cell, long readpoint) {
        long addedSize = this.internalAdd(cell);
        KeyValue firstCell = KeyValueUtil.createFirstOnRow((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength(), (byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
        SortedSet<Cell> ss = this.active.tailSet((Cell)firstCell);
        Iterator it = ss.iterator();
        int versionsVisible = 0;
        while (it.hasNext()) {
            Cell cur = (Cell)it.next();
            if (cell == cur) continue;
            if (!CellUtil.matchingRow((Cell)cell, (Cell)cur) || !CellUtil.matchingQualifier((Cell)cell, (Cell)cur)) break;
            if (cur.getTypeByte() != KeyValue.Type.Put.getCode() || cur.getSequenceId() > readpoint) continue;
            if (versionsVisible >= 1) {
                long delta = AbstractMemStore.heapSizeChange(cur, true);
                addedSize -= delta;
                this.active.incSize(-delta);
                it.remove();
                this.setOldestEditTimeToNow();
                continue;
            }
            ++versionsVisible;
        }
        return addedSize;
    }

    protected Cell getLowest(Cell a, Cell b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return this.comparator.compareRows(a, b) <= 0 ? a : b;
    }

    protected Cell getNextRow(Cell key, NavigableSet<Cell> set) {
        Cell result = null;
        NavigableSet<Cell> tail = key == null ? set : set.tailSet(key);
        for (Cell cell : tail) {
            if (this.comparator.compareRows(cell, key) <= 0) continue;
            result = cell;
            break;
        }
        return result;
    }

    @Override
    @VisibleForTesting
    public long updateColumnValue(byte[] row, byte[] family, byte[] qualifier, long newValue, long now) {
        Cell cell;
        KeyValue firstCell = KeyValueUtil.createFirstOnRow((byte[])row, (byte[])family, (byte[])qualifier);
        Cell snc = this.snapshot.getFirstAfter((Cell)firstCell);
        if (snc != null && CellUtil.matchingRow((Cell)snc, (Cell)firstCell) && CellUtil.matchingQualifier((Cell)snc, (Cell)firstCell) && snc.getTimestamp() == now) {
            ++now;
        }
        SortedSet<Cell> ss = this.getActive().tailSet((Cell)firstCell);
        Iterator i$ = ss.iterator();
        while (i$.hasNext() && CellUtil.matchingColumn((Cell)(cell = (Cell)i$.next()), (byte[])family, (byte[])qualifier) && CellUtil.matchingRow((Cell)cell, (Cell)firstCell)) {
            if (cell.getTypeByte() != KeyValue.Type.Put.getCode() || cell.getTimestamp() <= now || !CellUtil.matchingQualifier((Cell)firstCell, (Cell)cell)) continue;
            now = cell.getTimestamp();
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(1);
        cells.add((Cell)new KeyValue(row, family, qualifier, now, Bytes.toBytes((long)newValue)));
        return this.upsert(cells, 1L);
    }

    private Cell maybeCloneWithAllocator(Cell cell) {
        return this.active.maybeCloneWithAllocator(cell);
    }

    private long internalAdd(Cell toAdd) {
        long s = this.active.add(toAdd);
        this.setOldestEditTimeToNow();
        this.checkActiveSize();
        return s;
    }

    private void setOldestEditTimeToNow() {
        if (this.timeOfOldestEdit == Long.MAX_VALUE) {
            this.timeOfOldestEdit = EnvironmentEdgeManager.currentTime();
        }
    }

    protected long keySize() {
        return this.heapSize() - DEEP_OVERHEAD;
    }

    protected CellComparator getComparator() {
        return this.comparator;
    }

    protected MutableSegment getActive() {
        return this.active;
    }

    protected ImmutableSegment getSnapshot() {
        return this.snapshot;
    }

    protected AbstractMemStore setSnapshot(ImmutableSegment snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    protected void setSnapshotSize(long snapshotSize) {
        this.getSnapshot().setSize(snapshotSize);
    }

    protected abstract void checkActiveSize();

    protected abstract List<SegmentScanner> getListOfScanners(long var1) throws IOException;

    protected abstract List<Segment> getListOfSegments() throws IOException;

    public long getActiveSize() {
        return this.getActive().getSize();
    }
}

