/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.regionserver.SegmentScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class DefaultMemStore
extends AbstractMemStore {
    private static final Log LOG = LogFactory.getLog(DefaultMemStore.class);

    public DefaultMemStore() {
        this(HBaseConfiguration.create(), CellComparator.COMPARATOR);
    }

    public DefaultMemStore(Configuration conf, CellComparator c) {
        super(conf, c);
    }

    void dump() {
        super.dump(LOG);
    }

    @Override
    public MemStoreSnapshot snapshot(long flushOpSeqId) {
        if (!this.getSnapshot().isEmpty()) {
            LOG.warn((Object)"Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
        } else {
            this.snapshotId = EnvironmentEdgeManager.currentTime();
            if (!this.getActive().isEmpty()) {
                ImmutableSegment immutableSegment = SegmentFactory.instance().createImmutableSegment(this.getConfiguration(), this.getActive());
                this.setSnapshot(immutableSegment);
                this.setSnapshotSize(this.keySize());
                this.resetCellSet();
            }
        }
        return new MemStoreSnapshot(this.snapshotId, this.getSnapshot());
    }

    @Override
    protected List<SegmentScanner> getListOfScanners(long readPt) throws IOException {
        ArrayList<SegmentScanner> list = new ArrayList<SegmentScanner>(2);
        list.add(0, this.getActive().getSegmentScanner(readPt));
        list.add(1, this.getSnapshot().getSegmentScanner(readPt));
        return list;
    }

    @Override
    protected List<Segment> getListOfSegments() throws IOException {
        ArrayList<Segment> list = new ArrayList<Segment>(2);
        list.add(0, this.getActive());
        list.add(1, this.getSnapshot());
        return list;
    }

    Cell getNextRow(Cell cell) {
        return this.getLowest(this.getNextRow(cell, this.getActive().getCellSet()), this.getNextRow(cell, this.getSnapshot().getCellSet()));
    }

    @Override
    public void updateLowestUnflushedSequenceIdInWal(boolean onlyIfMoreRecent) {
    }

    @Override
    public long size() {
        return this.heapSize();
    }

    @Override
    protected void checkActiveSize() {
    }

    @Override
    public void finalizeFlush() {
    }

    public static void main(String[] args) {
        int i;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
        LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        DefaultMemStore memstore1 = new DefaultMemStore();
        long size = 0L;
        int count = 10000;
        byte[] fam = Bytes.toBytes((String)"col");
        byte[] qf = Bytes.toBytes((String)"umn");
        byte[] empty = new byte[]{};
        for (i = 0; i < 10000; ++i) {
            size += memstore1.add((Cell)new KeyValue(Bytes.toBytes((int)i), fam, qf, (long)i, empty));
        }
        LOG.info((Object)("memstore1 estimated size=" + size));
        for (i = 0; i < 10000; ++i) {
            size += memstore1.add((Cell)new KeyValue(Bytes.toBytes((int)i), fam, qf, (long)i, empty));
        }
        LOG.info((Object)("memstore1 estimated size (2nd loading of same data)=" + size));
        DefaultMemStore memstore2 = new DefaultMemStore();
        for (int i2 = 0; i2 < 10000; ++i2) {
            size += memstore2.add((Cell)new KeyValue(Bytes.toBytes((int)i2), fam, qf, (long)i2, new byte[i2]));
        }
        LOG.info((Object)("memstore2 estimated size=" + size));
        int seconds = 30;
        LOG.info((Object)"Waiting 30 seconds while heap dump is taken");
        LOG.info((Object)"Exiting.");
    }
}

