/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.FlushPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class FlushLargeStoresPolicy
extends FlushPolicy {
    private static final Log LOG = LogFactory.getLog(FlushLargeStoresPolicy.class);
    public static final String HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND = "hbase.hregion.percolumnfamilyflush.size.lower.bound";
    public static final String HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN = "hbase.hregion.percolumnfamilyflush.size.lower.bound.min";
    private static final long DEFAULT_HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN = 0x1000000L;
    private long flushSizeLowerBound = -1L;

    @Override
    protected void configureForRegion(HRegion region) {
        String flushedSizeLowerBoundString;
        super.configureForRegion(region);
        int familyNumber = region.getTableDesc().getFamilies().size();
        if (familyNumber <= 1) {
            return;
        }
        long flushSizeLowerBound = region.getMemstoreFlushSize() / (long)familyNumber;
        long minimumLowerBound = this.getConf().getLong(HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN, 0x1000000L);
        if (minimumLowerBound > flushSizeLowerBound) {
            flushSizeLowerBound = minimumLowerBound;
        }
        if ((flushedSizeLowerBoundString = region.getTableDesc().getValue(HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No hbase.hregion.percolumnfamilyflush.size.lower.bound set in description of table " + region.getTableDesc().getTableName() + ", use config (" + flushSizeLowerBound + ") instead"));
            }
        } else {
            try {
                flushSizeLowerBound = Long.parseLong(flushedSizeLowerBoundString);
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)("Number format exception when parsing hbase.hregion.percolumnfamilyflush.size.lower.bound for table " + region.getTableDesc().getTableName() + ":" + flushedSizeLowerBoundString + ". " + nfe + ", use config (" + flushSizeLowerBound + ") instead"));
            }
        }
        this.flushSizeLowerBound = flushSizeLowerBound;
    }

    private boolean shouldFlush(Store store) {
        if (store.getMemStoreSize() > this.flushSizeLowerBound) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Flush Column Family " + store.getColumnFamilyName() + " of " + this.region.getRegionInfo().getEncodedName() + " because memstoreSize=" + store.getMemStoreSize() + " > lower bound=" + this.flushSizeLowerBound));
            }
            return true;
        }
        return this.region.shouldFlushStore(store);
    }

    @Override
    public Collection<Store> selectStoresToFlush() {
        if (this.region.getTableDesc().getFamilies().size() == 1) {
            return this.region.stores.values();
        }
        Collection<Store> stores = this.region.stores.values();
        HashSet<Store> specificStoresToFlush = new HashSet<Store>();
        for (Store store : stores) {
            if (!this.shouldFlush(store)) continue;
            specificStoresToFlush.add(store);
        }
        if (specificStoresToFlush.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Since none of the CFs were above the size, flushing all.");
            }
            return stores;
        }
        return specificStoresToFlush;
    }
}

