/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.mob.MobCacheConfig;
import org.apache.hadoop.hbase.mob.MobFile;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobStoreEngine;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MobReferenceOnlyFilter;
import org.apache.hadoop.hbase.regionserver.MobStoreScanner;
import org.apache.hadoop.hbase.regionserver.ReversedMobStoreScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.IdLock;

@InterfaceAudience.Private
public class HMobStore
extends HStore {
    private static final Log LOG = LogFactory.getLog(HMobStore.class);
    private MobCacheConfig mobCacheConfig;
    private Path homePath;
    private Path mobFamilyPath;
    private volatile long cellsCountCompactedToMob = 0L;
    private volatile long cellsCountCompactedFromMob = 0L;
    private volatile long cellsSizeCompactedToMob = 0L;
    private volatile long cellsSizeCompactedFromMob = 0L;
    private volatile long mobFlushCount = 0L;
    private volatile long mobFlushedCellsCount = 0L;
    private volatile long mobFlushedCellsSize = 0L;
    private volatile long mobScanCellsCount = 0L;
    private volatile long mobScanCellsSize = 0L;
    private HColumnDescriptor family;
    private TableLockManager tableLockManager;
    private TableName tableLockName;
    private Map<String, List<Path>> map = new ConcurrentHashMap<String, List<Path>>();
    private final IdLock keyLock = new IdLock();

    public HMobStore(HRegion region, HColumnDescriptor family, Configuration confParam) throws IOException {
        super(region, family, confParam);
        this.family = family;
        this.mobCacheConfig = (MobCacheConfig)this.cacheConf;
        this.homePath = MobUtils.getMobHome(this.conf);
        this.mobFamilyPath = MobUtils.getMobFamilyPath(this.conf, this.getTableName(), family.getNameAsString());
        ArrayList<Path> locations = new ArrayList<Path>(2);
        locations.add(this.mobFamilyPath);
        TableName tn = region.getTableDesc().getTableName();
        locations.add(HFileArchiveUtil.getStoreArchivePath(this.conf, tn, MobUtils.getMobRegionInfo(tn).getEncodedName(), family.getNameAsString()));
        this.map.put(Bytes.toString((byte[])tn.getName()), locations);
        if (region.getRegionServerServices() != null) {
            this.tableLockManager = region.getRegionServerServices().getTableLockManager();
            this.tableLockName = MobUtils.getTableLockName(this.getTableName());
        }
    }

    @Override
    protected void createCacheConf(HColumnDescriptor family) {
        this.cacheConf = new MobCacheConfig(this.conf, family);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    protected KeyValueScanner createScanner(Scan scan, NavigableSet<byte[]> targetCols, long readPt, KeyValueScanner scanner) throws IOException {
        if (scanner == null) {
            if (MobUtils.isRefOnlyScan(scan)) {
                MobReferenceOnlyFilter refOnlyFilter = new MobReferenceOnlyFilter();
                Filter filter = scan.getFilter();
                if (filter != null) {
                    scan.setFilter((Filter)new FilterList(new Filter[]{filter, refOnlyFilter}));
                } else {
                    scan.setFilter((Filter)refOnlyFilter);
                }
            }
            scanner = scan.isReversed() ? new ReversedMobStoreScanner(this, this.getScanInfo(), scan, targetCols, readPt) : new MobStoreScanner(this, this.getScanInfo(), scan, targetCols, readPt);
        }
        return scanner;
    }

    @Override
    protected StoreEngine<?, ?, ?, ?> createStoreEngine(Store store, Configuration conf, CellComparator cellComparator) throws IOException {
        MobStoreEngine engine = new MobStoreEngine();
        engine.createComponents(conf, store, cellComparator);
        return engine;
    }

    private Path getTempDir() {
        return new Path(this.homePath, ".tmp");
    }

    public StoreFile.Writer createWriterInTmp(Date date, long maxKeyCount, Compression.Algorithm compression, byte[] startKey) throws IOException {
        if (startKey == null) {
            startKey = HConstants.EMPTY_START_ROW;
        }
        Path path = this.getTempDir();
        return this.createWriterInTmp(MobUtils.formatDate(date), path, maxKeyCount, compression, startKey);
    }

    public StoreFile.Writer createDelFileWriterInTmp(Date date, long maxKeyCount, Compression.Algorithm compression, byte[] startKey) throws IOException {
        if (startKey == null) {
            startKey = HConstants.EMPTY_START_ROW;
        }
        Path path = this.getTempDir();
        String suffix = UUID.randomUUID().toString().replaceAll("-", "") + "_del";
        MobFileName mobFileName = MobFileName.create(startKey, MobUtils.formatDate(date), suffix);
        return this.createWriterInTmp(mobFileName, path, maxKeyCount, compression);
    }

    public StoreFile.Writer createWriterInTmp(String date, Path basePath, long maxKeyCount, Compression.Algorithm compression, byte[] startKey) throws IOException {
        MobFileName mobFileName = MobFileName.create(startKey, date, UUID.randomUUID().toString().replaceAll("-", ""));
        return this.createWriterInTmp(mobFileName, basePath, maxKeyCount, compression);
    }

    public StoreFile.Writer createWriterInTmp(MobFileName mobFileName, Path basePath, long maxKeyCount, Compression.Algorithm compression) throws IOException {
        MobCacheConfig writerCacheConf = this.mobCacheConfig;
        HFileContext hFileContext = new HFileContextBuilder().withCompression(compression).withIncludesMvcc(true).withIncludesTags(true).withCompressTags(this.family.isCompressTags()).withChecksumType(this.checksumType).withBytesPerCheckSum(this.bytesPerChecksum).withBlockSize(this.blocksize).withHBaseCheckSum(true).withDataBlockEncoding(this.getFamily().getDataBlockEncoding()).withEncryptionContext(this.cryptoContext).withCreateTime(EnvironmentEdgeManager.currentTime()).build();
        StoreFile.Writer w = new StoreFile.WriterBuilder(this.conf, writerCacheConf, this.region.getFilesystem()).withFilePath(new Path(basePath, mobFileName.getFileName())).withComparator(CellComparator.COMPARATOR).withBloomType(BloomType.NONE).withMaxKeyCount(maxKeyCount).withFileContext(hFileContext).build();
        return w;
    }

    public void commitFile(Path sourceFile, Path targetPath) throws IOException {
        if (sourceFile == null) {
            return;
        }
        Path dstPath = new Path(targetPath, sourceFile.getName());
        this.validateMobFile(sourceFile);
        String msg = "Renaming flushed file from " + sourceFile + " to " + dstPath;
        LOG.info((Object)msg);
        Path parent = dstPath.getParent();
        if (!this.region.getFilesystem().exists(parent)) {
            this.region.getFilesystem().mkdirs(parent);
        }
        if (!this.region.getFilesystem().rename(sourceFile, dstPath)) {
            throw new IOException("Failed rename of " + sourceFile + " to " + dstPath);
        }
    }

    private void validateMobFile(Path path) throws IOException {
        StoreFile storeFile = null;
        try {
            storeFile = new StoreFile(this.region.getFilesystem(), path, this.conf, (CacheConfig)this.mobCacheConfig, BloomType.NONE);
            storeFile.createReader();
        }
        catch (IOException e) {
            LOG.error((Object)("Fail to open mob file[" + path + "], keep it in temp directory."), (Throwable)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeReader(false);
            }
        }
    }

    public Cell resolve(Cell reference, boolean cacheBlocks) throws IOException {
        return this.resolve(reference, cacheBlocks, -1L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell resolve(Cell reference, boolean cacheBlocks, long readPt, boolean readEmptyValueOnMobCellMiss) throws IOException {
        Cell result = null;
        if (MobUtils.hasValidMobRefCellValue(reference)) {
            String fileName = MobUtils.getMobFileName(reference);
            Tag tableNameTag = MobUtils.getTableNameTag(reference);
            if (tableNameTag != null) {
                String tableNameString = TagUtil.getValueAsString((Tag)tableNameTag);
                List<Path> locations = this.map.get(tableNameString);
                if (locations == null) {
                    IdLock.Entry lockEntry = this.keyLock.getLockEntry(tableNameString.hashCode());
                    try {
                        locations = this.map.get(tableNameString);
                        if (locations == null) {
                            locations = new ArrayList<Path>(2);
                            TableName tn = TableName.valueOf((String)tableNameString);
                            locations.add(MobUtils.getMobFamilyPath(this.conf, tn, this.family.getNameAsString()));
                            locations.add(HFileArchiveUtil.getStoreArchivePath(this.conf, tn, MobUtils.getMobRegionInfo(tn).getEncodedName(), this.family.getNameAsString()));
                            this.map.put(tableNameString, locations);
                        }
                    }
                    finally {
                        this.keyLock.releaseLockEntry(lockEntry);
                    }
                }
                result = this.readCell(locations, fileName, reference, cacheBlocks, readPt, readEmptyValueOnMobCellMiss);
            }
        }
        if (result == null) {
            LOG.warn((Object)"The KeyValue result is null, assemble a new KeyValue with the same row,family,qualifier,timestamp,type and tags but with an empty value to return.");
            result = new KeyValue(reference.getRowArray(), reference.getRowOffset(), (int)reference.getRowLength(), reference.getFamilyArray(), reference.getFamilyOffset(), (int)reference.getFamilyLength(), reference.getQualifierArray(), reference.getQualifierOffset(), reference.getQualifierLength(), reference.getTimestamp(), KeyValue.Type.codeToType((byte)reference.getTypeByte()), HConstants.EMPTY_BYTE_ARRAY, 0, 0, reference.getTagsArray(), reference.getTagsOffset(), reference.getTagsLength());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cell readCell(List<Path> locations, String fileName, Cell search, boolean cacheMobBlocks, long readPt, boolean readEmptyValueOnMobCellMiss) throws IOException {
        FileSystem fs = this.getFileSystem();
        Object throwable = null;
        for (Path location : locations) {
            MobFile file = null;
            Path path = new Path(location, fileName);
            try {
                file = this.mobCacheConfig.getMobFileCache().openFile(fs, path, this.mobCacheConfig);
                Cell cell = readPt != -1L ? file.readCell(search, cacheMobBlocks, readPt) : file.readCell(search, cacheMobBlocks);
                return cell;
            }
            catch (IOException e) {
                this.mobCacheConfig.getMobFileCache().evictFile(fileName);
                throwable = e;
                if (e instanceof FileNotFoundException || e.getCause() instanceof FileNotFoundException) {
                    LOG.warn((Object)("Fail to read the cell, the mob file " + path + " doesn't exist"), (Throwable)e);
                    continue;
                }
                if (e instanceof CorruptHFileException) {
                    LOG.error((Object)("The mob file " + path + " is corrupt"), (Throwable)e);
                    break;
                }
                throw e;
            }
            catch (NullPointerException e) {
                this.mobCacheConfig.getMobFileCache().evictFile(fileName);
                LOG.warn((Object)"Fail to read the cell", (Throwable)e);
                throwable = e;
            }
            catch (AssertionError e) {
                this.mobCacheConfig.getMobFileCache().evictFile(fileName);
                LOG.warn((Object)"Fail to read the cell", (Throwable)((Object)e));
                throwable = e;
            }
            finally {
                if (file == null) continue;
                this.mobCacheConfig.getMobFileCache().closeFile(file);
            }
        }
        LOG.error((Object)("The mob file " + fileName + " could not be found in the locations " + locations + " or it is corrupt"));
        if (readEmptyValueOnMobCellMiss) {
            return null;
        }
        if (throwable instanceof IOException) {
            throw throwable;
        }
        throw new IOException((Throwable)throwable);
    }

    public Path getPath() {
        return this.mobFamilyPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoreFile> compact(CompactionContext compaction, ThroughputController throughputController) throws IOException {
        if (compaction.getRequest().isAllFiles()) {
            TableLockManager.TableLock lock = null;
            if (this.tableLockManager != null) {
                lock = this.tableLockManager.readLock(this.tableLockName, "Major compaction in HMobStore");
            }
            boolean tableLocked = false;
            String tableName = this.getTableName().getNameAsString();
            if (lock != null) {
                try {
                    LOG.info((Object)("Start to acquire a read lock for the table[" + tableName + "], ready to perform the major compaction"));
                    lock.acquire();
                    tableLocked = true;
                }
                catch (Exception e) {
                    LOG.error((Object)("Fail to lock the table " + tableName), (Throwable)e);
                }
            } else {
                tableLocked = true;
            }
            try {
                if (!tableLocked) {
                    LOG.warn((Object)("Cannot obtain the table lock, maybe a sweep tool is running on this table[" + tableName + "], forcing the delete markers to be retained"));
                    compaction.getRequest().forceRetainDeleteMarkers();
                }
                List<StoreFile> list = super.compact(compaction, throughputController);
                return list;
            }
            finally {
                if (tableLocked && lock != null) {
                    try {
                        lock.release();
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Fail to release the table lock " + tableName), (Throwable)e);
                    }
                }
            }
        }
        return super.compact(compaction, throughputController);
    }

    @Override
    public void finalizeFlush() {
    }

    public void updateCellsCountCompactedToMob(long count) {
        this.cellsCountCompactedToMob += count;
    }

    public long getCellsCountCompactedToMob() {
        return this.cellsCountCompactedToMob;
    }

    public void updateCellsCountCompactedFromMob(long count) {
        this.cellsCountCompactedFromMob += count;
    }

    public long getCellsCountCompactedFromMob() {
        return this.cellsCountCompactedFromMob;
    }

    public void updateCellsSizeCompactedToMob(long size) {
        this.cellsSizeCompactedToMob += size;
    }

    public long getCellsSizeCompactedToMob() {
        return this.cellsSizeCompactedToMob;
    }

    public void updateCellsSizeCompactedFromMob(long size) {
        this.cellsSizeCompactedFromMob += size;
    }

    public long getCellsSizeCompactedFromMob() {
        return this.cellsSizeCompactedFromMob;
    }

    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public void updateMobFlushCount() {
        ++this.mobFlushCount;
    }

    public long getMobFlushCount() {
        return this.mobFlushCount;
    }

    public void updateMobFlushedCellsCount(long count) {
        this.mobFlushedCellsCount += count;
    }

    public long getMobFlushedCellsCount() {
        return this.mobFlushedCellsCount;
    }

    public void updateMobFlushedCellsSize(long size) {
        this.mobFlushedCellsSize += size;
    }

    public long getMobFlushedCellsSize() {
        return this.mobFlushedCellsSize;
    }

    public void updateMobScanCellsCount(long count) {
        this.mobScanCellsCount += count;
    }

    public long getMobScanCellsCount() {
        return this.mobScanCellsCount;
    }

    public void updateMobScanCellsSize(long size) {
        this.mobScanCellsSize += size;
    }

    public long getMobScanCellsSize() {
        return this.mobScanCellsSize;
    }
}

