/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ReversedKeyValueHeap;
import org.apache.hadoop.hbase.regionserver.SegmentScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.htrace.Trace;

@InterfaceAudience.Private
public class MemStoreScanner
extends NonLazyKeyValueScanner {
    private KeyValueHeap forwardHeap;
    private ReversedKeyValueHeap backwardHeap;
    private Type type = Type.UNDEFINED;
    private long readPoint;
    List<SegmentScanner> scanners;
    private AbstractMemStore backwardReferenceToMemStore;

    public MemStoreScanner(AbstractMemStore ms, long readPoint, Type type) throws IOException {
        this(ms, ms.getListOfScanners(readPoint), readPoint, type);
    }

    public MemStoreScanner(AbstractMemStore ms, long readPt) throws IOException {
        this(ms, readPt, Type.UNDEFINED);
    }

    public MemStoreScanner(AbstractMemStore ms, List<SegmentScanner> scanners, long readPoint, Type type) throws IOException {
        this.readPoint = readPoint;
        this.type = type;
        switch (type) {
            case UNDEFINED: 
            case USER_SCAN_FORWARD: 
            case COMPACT_FORWARD: {
                this.forwardHeap = new KeyValueHeap(scanners, ms.getComparator());
                break;
            }
            case USER_SCAN_BACKWARD: {
                this.backwardHeap = new ReversedKeyValueHeap(scanners, ms.getComparator());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown scanner type in MemStoreScanner");
            }
        }
        this.backwardReferenceToMemStore = ms;
        this.scanners = scanners;
        if (Trace.isTracing() && Trace.currentSpan() != null) {
            Trace.currentSpan().addTimelineAnnotation("Creating MemStoreScanner");
        }
    }

    @Override
    public synchronized Cell peek() {
        if (this.type == Type.USER_SCAN_BACKWARD) {
            return this.backwardHeap.peek();
        }
        return this.forwardHeap.peek();
    }

    @Override
    public synchronized Cell next() throws IOException {
        KeyValueHeap heap = Type.USER_SCAN_BACKWARD == this.type ? this.backwardHeap : this.forwardHeap;
        Cell currentCell = heap.next();
        if (currentCell != null) {
            return currentCell;
        }
        return null;
    }

    @Override
    public synchronized boolean seek(Cell cell) throws IOException {
        this.assertForward();
        if (cell == null) {
            this.close();
            return false;
        }
        return this.forwardHeap.seek(cell);
    }

    @Override
    public synchronized boolean reseek(Cell cell) throws IOException {
        this.assertForward();
        return this.forwardHeap.reseek(cell);
    }

    @Override
    public synchronized long getSequenceID() {
        return Long.MAX_VALUE;
    }

    @Override
    public synchronized void close() {
        if (this.forwardHeap != null) {
            assert (this.type == Type.USER_SCAN_FORWARD || this.type == Type.COMPACT_FORWARD || this.type == Type.UNDEFINED);
            this.forwardHeap.close();
            this.forwardHeap = null;
            if (this.backwardHeap != null) {
                this.backwardHeap.close();
                this.backwardHeap = null;
            }
        } else if (this.backwardHeap != null) {
            assert (this.type == Type.USER_SCAN_BACKWARD);
            this.backwardHeap.close();
            this.backwardHeap = null;
        }
    }

    @Override
    public synchronized boolean backwardSeek(Cell cell) throws IOException {
        this.initBackwardHeapIfNeeded(cell, false);
        return this.backwardHeap.backwardSeek(cell);
    }

    @Override
    public synchronized boolean seekToPreviousRow(Cell cell) throws IOException {
        this.initBackwardHeapIfNeeded(cell, false);
        if (this.backwardHeap.peek() == null) {
            this.restartBackwardHeap(cell);
        }
        return this.backwardHeap.seekToPreviousRow(cell);
    }

    @Override
    public synchronized boolean seekToLastRow() throws IOException {
        return this.initBackwardHeapIfNeeded((Cell)KeyValue.LOWESTKEY, true);
    }

    @Override
    public synchronized boolean shouldUseScanner(Scan scan, Store store, long oldestUnexpiredTS) {
        if (this.type == Type.COMPACT_FORWARD) {
            return true;
        }
        for (SegmentScanner sc : this.scanners) {
            if (!sc.shouldSeek(scan, oldestUnexpiredTS)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 1;
        for (SegmentScanner scanner : this.scanners) {
            buf.append("scanner (" + i + ") " + scanner.toString() + " ||| ");
            ++i;
        }
        return buf.toString();
    }

    private boolean restartBackwardHeap(Cell cell) throws IOException {
        boolean res = false;
        for (SegmentScanner scan : this.scanners) {
            res |= scan.seekToPreviousRow(cell);
        }
        this.backwardHeap = new ReversedKeyValueHeap(this.scanners, this.backwardReferenceToMemStore.getComparator());
        return res;
    }

    private boolean initBackwardHeapIfNeeded(Cell cell, boolean toLast) throws IOException {
        boolean res = false;
        if (toLast && this.type != Type.UNDEFINED) {
            throw new IllegalStateException("Wrong usage of initBackwardHeapIfNeeded in parameters. The type is:" + this.type.toString());
        }
        if (this.type == Type.UNDEFINED && this.backwardHeap == null && this.forwardHeap != null) {
            this.forwardHeap.close();
            this.forwardHeap = null;
            for (SegmentScanner scan : this.scanners) {
                if (toLast) {
                    res |= scan.seekToLastRow();
                    continue;
                }
                res |= scan.backwardSeek(cell);
            }
            this.backwardHeap = new ReversedKeyValueHeap(this.scanners, this.backwardReferenceToMemStore.getComparator());
            this.type = Type.USER_SCAN_BACKWARD;
        }
        if (this.type == Type.USER_SCAN_FORWARD) {
            throw new IllegalStateException("Traversing backward with forward scan");
        }
        return res;
    }

    private void assertForward() throws IllegalStateException {
        if (this.type == Type.UNDEFINED) {
            this.type = Type.USER_SCAN_FORWARD;
        }
        if (this.type == Type.USER_SCAN_BACKWARD) {
            throw new IllegalStateException("Traversing forward with backward scan");
        }
    }

    public static enum Type {
        UNDEFINED,
        COMPACT_FORWARD,
        USER_SCAN_FORWARD,
        USER_SCAN_BACKWARD;

    }
}

