/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;

@InterfaceAudience.Private
public class MemStoreSnapshot {
    private final long id;
    private final int cellsCount;
    private final long size;
    private final TimeRangeTracker timeRangeTracker;
    private final KeyValueScanner scanner;
    private final boolean tagsPresent;

    public MemStoreSnapshot(long id, ImmutableSegment snapshot) {
        this.id = id;
        this.cellsCount = snapshot.getCellsCount();
        this.size = snapshot.getSize();
        this.timeRangeTracker = snapshot.getTimeRangeTracker();
        this.scanner = snapshot.getKeyValueScanner();
        this.tagsPresent = snapshot.isTagsPresent();
    }

    public long getId() {
        return this.id;
    }

    public int getCellsCount() {
        return this.cellsCount;
    }

    public long getSize() {
        return this.size;
    }

    public TimeRangeTracker getTimeRangeTracker() {
        return this.timeRangeTracker;
    }

    public KeyValueScanner getScanner() {
        return this.scanner;
    }

    public boolean isTagsPresent() {
        return this.tagsPresent;
    }
}

