/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.Segment;

@InterfaceAudience.Private
public class MutableSegment
extends Segment {
    protected MutableSegment(CellSet cellSet, CellComparator comparator, MemStoreLAB memStoreLAB, long size) {
        super(cellSet, comparator, memStoreLAB, size);
    }

    public long add(Cell cell) {
        return this.internalAdd(cell);
    }

    public long rollback(Cell cell) {
        Cell found = this.getCellSet().get(cell);
        if (found != null && found.getSequenceId() == cell.getSequenceId()) {
            long sz = AbstractMemStore.heapSizeChange(cell, true);
            this.getCellSet().remove(cell);
            this.incSize(-sz);
            return sz;
        }
        return 0L;
    }

    Cell first() {
        return this.getCellSet().first();
    }
}

