/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransaction;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitTransactionImpl;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class RegionMergeTransactionImpl
implements RegionMergeTransaction {
    private static final Log LOG = LogFactory.getLog(RegionMergeTransactionImpl.class);
    private HRegionInfo mergedRegionInfo;
    private final HRegion region_a;
    private final HRegion region_b;
    private final Path mergesdir;
    private final boolean forcible;
    private final long masterSystemTime;
    private RegionMergeTransaction.RegionMergeTransactionPhase currentPhase = RegionMergeTransaction.RegionMergeTransactionPhase.STARTED;
    private Server server;
    private RegionServerServices rsServices;
    private final List<RegionMergeTransaction.JournalEntry> journal = new ArrayList<RegionMergeTransaction.JournalEntry>();
    private final ArrayList<RegionMergeTransaction.TransactionListener> listeners = new ArrayList();
    private static IOException closedByOtherException = new IOException("Failed to close region: already closed by another thread");
    private RegionServerCoprocessorHost rsCoprocessorHost = null;

    public RegionMergeTransactionImpl(Region a, Region b, boolean forcible) {
        this(a, b, forcible, EnvironmentEdgeManager.currentTime());
    }

    public RegionMergeTransactionImpl(Region a, Region b, boolean forcible, long masterSystemTime) {
        if (a.getRegionInfo().compareTo(b.getRegionInfo()) <= 0) {
            this.region_a = (HRegion)a;
            this.region_b = (HRegion)b;
        } else {
            this.region_a = (HRegion)b;
            this.region_b = (HRegion)a;
        }
        this.forcible = forcible;
        this.masterSystemTime = masterSystemTime;
        this.mergesdir = this.region_a.getRegionFileSystem().getMergesDir();
    }

    private void transition(RegionMergeTransaction.RegionMergeTransactionPhase nextPhase) throws IOException {
        this.transition(nextPhase, false);
    }

    private void transition(RegionMergeTransaction.RegionMergeTransactionPhase nextPhase, boolean isRollback) throws IOException {
        if (!isRollback) {
            this.journal.add(new JournalEntryImpl(nextPhase));
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            RegionMergeTransaction.TransactionListener listener = this.listeners.get(i);
            if (!isRollback) {
                listener.transition(this, this.currentPhase, nextPhase);
                continue;
            }
            listener.rollback(this, this.currentPhase, nextPhase);
        }
        this.currentPhase = nextPhase;
    }

    @Override
    public boolean prepare(RegionServerServices services) throws IOException {
        if (!this.region_a.getTableDesc().getTableName().equals((Object)this.region_b.getTableDesc().getTableName())) {
            LOG.info((Object)("Can't merge regions " + this.region_a + "," + this.region_b + " because they do not belong to the same table"));
            return false;
        }
        if (this.region_a.getRegionInfo().equals((Object)this.region_b.getRegionInfo())) {
            LOG.info((Object)("Can't merge the same region " + this.region_a));
            return false;
        }
        if (!this.forcible && !HRegionInfo.areAdjacent((HRegionInfo)this.region_a.getRegionInfo(), (HRegionInfo)this.region_b.getRegionInfo())) {
            String msg = "Skip merging " + this.region_a.getRegionInfo().getRegionNameAsString() + " and " + this.region_b.getRegionInfo().getRegionNameAsString() + ", because they are not adjacent.";
            LOG.info((Object)msg);
            return false;
        }
        if (!this.region_a.isMergeable() || !this.region_b.isMergeable()) {
            return false;
        }
        try {
            boolean regionAHasMergeQualifier = this.hasMergeQualifierInMeta(services, this.region_a.getRegionInfo().getRegionName());
            if (regionAHasMergeQualifier || this.hasMergeQualifierInMeta(services, this.region_b.getRegionInfo().getRegionName())) {
                LOG.debug((Object)("Region " + (regionAHasMergeQualifier ? this.region_a.getRegionInfo().getRegionNameAsString() : this.region_b.getRegionInfo().getRegionNameAsString()) + " is not mergeable because it has merge qualifier in META"));
                return false;
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed judging whether merge transaction is available for " + this.region_a.getRegionInfo().getRegionNameAsString() + " and " + this.region_b.getRegionInfo().getRegionNameAsString()), (Throwable)e);
            return false;
        }
        this.mergedRegionInfo = RegionMergeTransactionImpl.getMergedRegionInfo(this.region_a.getRegionInfo(), this.region_b.getRegionInfo());
        this.transition(RegionMergeTransaction.RegionMergeTransactionPhase.PREPARED);
        return true;
    }

    @Override
    public Region execute(Server server, RegionServerServices services) throws IOException {
        if (User.isHBaseSecurityEnabled((Configuration)this.region_a.getBaseConf())) {
            LOG.warn((Object)"Should use execute(Server, RegionServerServices, User)");
        }
        return this.execute(server, services, null);
    }

    @Override
    public Region execute(Server server, RegionServerServices services, User user) throws IOException {
        this.server = server;
        this.rsServices = services;
        if (this.rsCoprocessorHost == null) {
            this.rsCoprocessorHost = server != null ? ((HRegionServer)server).getRegionServerCoprocessorHost() : null;
        }
        final HRegion mergedRegion = this.createMergedRegion(server, services, user);
        if (this.rsCoprocessorHost != null) {
            if (user == null) {
                this.rsCoprocessorHost.postMergeCommit(this.region_a, this.region_b, mergedRegion);
            } else {
                try {
                    user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            RegionMergeTransactionImpl.this.rsCoprocessorHost.postMergeCommit(RegionMergeTransactionImpl.this.region_a, RegionMergeTransactionImpl.this.region_b, mergedRegion);
                            return null;
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
        }
        this.stepsAfterPONR(server, services, mergedRegion, user);
        this.transition(RegionMergeTransaction.RegionMergeTransactionPhase.COMPLETED);
        return mergedRegion;
    }

    @VisibleForTesting
    public void stepsAfterPONR(Server server, RegionServerServices services, final HRegion mergedRegion, User user) throws IOException {
        this.openMergedRegion(server, services, mergedRegion);
        if (this.rsCoprocessorHost != null) {
            if (user == null) {
                this.rsCoprocessorHost.postMerge(this.region_a, this.region_b, mergedRegion);
            } else {
                try {
                    user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            RegionMergeTransactionImpl.this.rsCoprocessorHost.postMerge(RegionMergeTransactionImpl.this.region_a, RegionMergeTransactionImpl.this.region_b, mergedRegion);
                            return null;
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
        }
    }

    private HRegion createMergedRegion(Server server, RegionServerServices services, User user) throws IOException {
        LOG.info((Object)("Starting merge of " + this.region_a + " and " + this.region_b.getRegionInfo().getRegionNameAsString() + ", forcible=" + this.forcible));
        if (server != null && server.isStopped() || services != null && services.isStopping()) {
            throw new IOException("Server is stopped or stopping");
        }
        if (this.rsCoprocessorHost != null) {
            boolean ret = false;
            if (user == null) {
                ret = this.rsCoprocessorHost.preMerge(this.region_a, this.region_b);
            } else {
                try {
                    ret = (Boolean)user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws Exception {
                            return RegionMergeTransactionImpl.this.rsCoprocessorHost.preMerge(RegionMergeTransactionImpl.this.region_a, RegionMergeTransactionImpl.this.region_b);
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
            if (ret) {
                throw new IOException("Coprocessor bypassing regions " + this.region_a + " " + this.region_b + " merge.");
            }
        }
        boolean testing = server == null ? true : server.getConfiguration().getBoolean("hbase.testing.nocluster", false);
        HRegion mergedRegion = this.stepsBeforePONR(server, services, testing);
        final ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
        if (this.rsCoprocessorHost != null) {
            boolean ret = false;
            if (user == null) {
                ret = this.rsCoprocessorHost.preMergeCommit(this.region_a, this.region_b, metaEntries);
            } else {
                try {
                    ret = (Boolean)user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws Exception {
                            return RegionMergeTransactionImpl.this.rsCoprocessorHost.preMergeCommit(RegionMergeTransactionImpl.this.region_a, RegionMergeTransactionImpl.this.region_b, metaEntries);
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
            if (ret) {
                throw new IOException("Coprocessor bypassing regions " + this.region_a + " " + this.region_b + " merge.");
            }
            try {
                for (Mutation p : metaEntries) {
                    HRegionInfo.parseRegionName((byte[])p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Row key of mutation from coprocessor is not parsable as region name.Mutations from coprocessor should only be for hbase:meta table.", (Throwable)e);
                throw e;
            }
        }
        this.transition(RegionMergeTransaction.RegionMergeTransactionPhase.PONR);
        if (services != null && !services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.MERGE_PONR, this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo())) {
            throw new IOException("Failed to notify master that merge passed PONR: " + this.region_a.getRegionInfo().getRegionNameAsString() + " and " + this.region_b.getRegionInfo().getRegionNameAsString());
        }
        return mergedRegion;
    }

    @VisibleForTesting
    public void prepareMutationsForMerge(HRegionInfo mergedRegion, HRegionInfo regionA, HRegionInfo regionB, ServerName serverName, List<Mutation> mutations) throws IOException {
        HRegionInfo copyOfMerged = new HRegionInfo(mergedRegion);
        long time = Math.max(EnvironmentEdgeManager.currentTime(), this.masterSystemTime);
        Put putOfMerged = MetaTableAccessor.makePutFromRegionInfo((HRegionInfo)copyOfMerged, (long)time);
        putOfMerged.addColumn(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER, regionA.toByteArray());
        putOfMerged.addColumn(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER, regionB.toByteArray());
        mutations.add((Mutation)putOfMerged);
        Delete deleteA = MetaTableAccessor.makeDeleteFromRegionInfo((HRegionInfo)regionA, (long)time);
        Delete deleteB = MetaTableAccessor.makeDeleteFromRegionInfo((HRegionInfo)regionB, (long)time);
        mutations.add((Mutation)deleteA);
        mutations.add((Mutation)deleteB);
        this.addLocation(putOfMerged, serverName, 1L);
    }

    @VisibleForTesting
    Put addLocation(Put p, ServerName sn, long openSeqNum) {
        p.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort()));
        p.addColumn(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode()));
        p.addColumn(HConstants.CATALOG_FAMILY, HConstants.SEQNUM_QUALIFIER, Bytes.toBytes((long)openSeqNum));
        return p;
    }

    @VisibleForTesting
    public HRegion stepsBeforePONR(Server server, RegionServerServices services, boolean testing) throws IOException {
        if (services != null && !services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_MERGE, this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo())) {
            throw new IOException("Failed to get ok from master to merge " + this.region_a.getRegionInfo().getRegionNameAsString() + " and " + this.region_b.getRegionInfo().getRegionNameAsString());
        }
        this.transition(RegionMergeTransaction.RegionMergeTransactionPhase.SET_MERGING);
        this.region_a.getRegionFileSystem().createMergesDir();
        this.transition(RegionMergeTransaction.RegionMergeTransactionPhase.CREATED_MERGE_DIR);
        Map<byte[], List<StoreFile>> hstoreFilesOfRegionA = this.closeAndOfflineRegion(services, this.region_a, true, testing);
        Map<byte[], List<StoreFile>> hstoreFilesOfRegionB = this.closeAndOfflineRegion(services, this.region_b, false, testing);
        assert (hstoreFilesOfRegionA != null && hstoreFilesOfRegionB != null);
        this.mergeStoreFiles(hstoreFilesOfRegionA, hstoreFilesOfRegionB);
        this.transition(RegionMergeTransaction.RegionMergeTransactionPhase.STARTED_MERGED_REGION_CREATION);
        HRegion mergedRegion = this.createMergedRegionFromMerges(this.region_a, this.region_b, this.mergedRegionInfo);
        return mergedRegion;
    }

    @VisibleForTesting
    HRegion createMergedRegionFromMerges(HRegion a, HRegion b, HRegionInfo mergedRegion) throws IOException {
        return a.createMergedRegionFromMerges(mergedRegion, b);
    }

    private Map<byte[], List<StoreFile>> closeAndOfflineRegion(RegionServerServices services, HRegion region, boolean isRegionA, boolean testing) throws IOException {
        Map<byte[], List<StoreFile>> hstoreFilesToMerge = null;
        Exception exceptionToThrow = null;
        try {
            hstoreFilesToMerge = region.close(false);
        }
        catch (Exception e) {
            exceptionToThrow = e;
        }
        if (exceptionToThrow == null && hstoreFilesToMerge == null) {
            exceptionToThrow = closedByOtherException;
        }
        if (exceptionToThrow != closedByOtherException) {
            this.transition(isRegionA ? RegionMergeTransaction.RegionMergeTransactionPhase.CLOSED_REGION_A : RegionMergeTransaction.RegionMergeTransactionPhase.CLOSED_REGION_B);
        }
        if (exceptionToThrow != null) {
            if (exceptionToThrow instanceof IOException) {
                throw (IOException)exceptionToThrow;
            }
            throw new IOException(exceptionToThrow);
        }
        if (!testing) {
            services.removeFromOnlineRegions(region, null);
        }
        this.transition(isRegionA ? RegionMergeTransaction.RegionMergeTransactionPhase.OFFLINED_REGION_A : RegionMergeTransaction.RegionMergeTransactionPhase.OFFLINED_REGION_B);
        return hstoreFilesToMerge;
    }

    @VisibleForTesting
    static HRegionInfo getMergedRegionInfo(HRegionInfo a, HRegionInfo b) {
        long rid = EnvironmentEdgeManager.currentTime();
        if (rid < a.getRegionId() || rid < b.getRegionId()) {
            LOG.warn((Object)("Clock skew; merging regions id are " + a.getRegionId() + " and " + b.getRegionId() + ", but current time here is " + rid));
            rid = Math.max(a.getRegionId(), b.getRegionId()) + 1L;
        }
        byte[] startKey = null;
        byte[] endKey = null;
        startKey = a.compareTo(b) <= 0 ? a.getStartKey() : b.getStartKey();
        endKey = Bytes.equals((byte[])a.getEndKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY) || !Bytes.equals((byte[])b.getEndKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY) && Bytes.compareTo((byte[])a.getEndKey(), (byte[])b.getEndKey()) > 0 ? a.getEndKey() : b.getEndKey();
        HRegionInfo mergedRegionInfo = new HRegionInfo(a.getTable(), startKey, endKey, false, rid);
        return mergedRegionInfo;
    }

    @VisibleForTesting
    void openMergedRegion(Server server, RegionServerServices services, HRegion merged) throws IOException {
        boolean stopping;
        boolean stopped = server != null && server.isStopped();
        boolean bl = stopping = services != null && services.isStopping();
        if (stopped || stopping) {
            LOG.info((Object)("Not opening merged region  " + merged.getRegionInfo().getRegionNameAsString() + " because stopping=" + stopping + ", stopped=" + stopped));
            return;
        }
        HRegionInfo hri = merged.getRegionInfo();
        SplitTransactionImpl.LoggingProgressable reporter = server == null ? null : new SplitTransactionImpl.LoggingProgressable(hri, server.getConfiguration().getLong("hbase.regionserver.regionmerge.open.log.interval", 10000L));
        merged.openHRegion(reporter);
        if (services != null) {
            if (!services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.MERGED, this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo())) {
                throw new IOException("Failed to report merged region to master: " + this.mergedRegionInfo.getShortNameToLog());
            }
            services.addToOnlineRegions(merged);
        }
    }

    private void mergeStoreFiles(Map<byte[], List<StoreFile>> hstoreFilesOfRegionA, Map<byte[], List<StoreFile>> hstoreFilesOfRegionB) throws IOException {
        HRegionFileSystem fs_a = this.region_a.getRegionFileSystem();
        for (Map.Entry<byte[], List<StoreFile>> entry : hstoreFilesOfRegionA.entrySet()) {
            String familyName = Bytes.toString((byte[])entry.getKey());
            for (StoreFile storeFile : entry.getValue()) {
                fs_a.mergeStoreFile(this.mergedRegionInfo, familyName, storeFile, this.mergesdir);
            }
        }
        HRegionFileSystem fs_b = this.region_b.getRegionFileSystem();
        for (Map.Entry<byte[], List<StoreFile>> entry : hstoreFilesOfRegionB.entrySet()) {
            String familyName = Bytes.toString((byte[])entry.getKey());
            for (StoreFile storeFile : entry.getValue()) {
                fs_b.mergeStoreFile(this.mergedRegionInfo, familyName, storeFile, this.mergesdir);
            }
        }
    }

    @Override
    public boolean rollback(Server server, RegionServerServices services) throws IOException {
        if (User.isHBaseSecurityEnabled((Configuration)this.region_a.getBaseConf())) {
            LOG.warn((Object)"Should use execute(Server, RegionServerServices, User)");
        }
        return this.rollback(server, services, null);
    }

    @Override
    public boolean rollback(Server server, RegionServerServices services, User user) throws IOException {
        assert (this.mergedRegionInfo != null);
        this.server = server;
        this.rsServices = services;
        if (this.rsCoprocessorHost != null) {
            if (user == null) {
                this.rsCoprocessorHost.preRollBackMerge(this.region_a, this.region_b);
            } else {
                try {
                    user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            RegionMergeTransactionImpl.this.rsCoprocessorHost.preRollBackMerge(RegionMergeTransactionImpl.this.region_a, RegionMergeTransactionImpl.this.region_b);
                            return null;
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
        }
        boolean result = true;
        ListIterator<RegionMergeTransaction.JournalEntry> iterator = this.journal.listIterator(this.journal.size());
        block19: while (iterator.hasPrevious()) {
            RegionMergeTransaction.JournalEntry je = iterator.previous();
            this.transition(je.getPhase(), true);
            switch (je.getPhase()) {
                case SET_MERGING: {
                    if (services == null || services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.MERGE_REVERTED, this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo())) continue block19;
                    return false;
                }
                case CREATED_MERGE_DIR: {
                    this.region_a.writestate.writesEnabled = true;
                    this.region_b.writestate.writesEnabled = true;
                    this.region_a.getRegionFileSystem().cleanupMergesDir();
                    continue block19;
                }
                case CLOSED_REGION_A: {
                    try {
                        this.region_a.initialize();
                        continue block19;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed rollbacking CLOSED_REGION_A of region " + this.region_a.getRegionInfo().getRegionNameAsString()), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                case OFFLINED_REGION_A: {
                    if (services == null) continue block19;
                    services.addToOnlineRegions(this.region_a);
                    continue block19;
                }
                case CLOSED_REGION_B: {
                    try {
                        this.region_b.initialize();
                        continue block19;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed rollbacking CLOSED_REGION_A of region " + this.region_b.getRegionInfo().getRegionNameAsString()), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                case OFFLINED_REGION_B: {
                    if (services == null) continue block19;
                    services.addToOnlineRegions(this.region_b);
                    continue block19;
                }
                case STARTED_MERGED_REGION_CREATION: {
                    this.region_a.getRegionFileSystem().cleanupMergedRegion(this.mergedRegionInfo);
                    continue block19;
                }
                case PONR: {
                    return false;
                }
                case STARTED: 
                case PREPARED: 
                case COMPLETED: {
                    continue block19;
                }
            }
            throw new RuntimeException("Unhandled journal entry: " + je);
        }
        if (this.rsCoprocessorHost != null) {
            if (user == null) {
                this.rsCoprocessorHost.postRollBackMerge(this.region_a, this.region_b);
            } else {
                try {
                    user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            RegionMergeTransactionImpl.this.rsCoprocessorHost.postRollBackMerge(RegionMergeTransactionImpl.this.region_a, RegionMergeTransactionImpl.this.region_b);
                            return null;
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
        }
        return result;
    }

    @Override
    public HRegionInfo getMergedRegionInfo() {
        return this.mergedRegionInfo;
    }

    @VisibleForTesting
    Path getMergesDir() {
        return this.mergesdir;
    }

    @VisibleForTesting
    boolean hasMergeQualifierInMeta(RegionServerServices services, byte[] regionName) throws IOException {
        if (services == null) {
            return false;
        }
        Pair mergeRegions = MetaTableAccessor.getRegionsFromMergeQualifier((Connection)services.getConnection(), (byte[])regionName);
        return mergeRegions != null && (mergeRegions.getFirst() != null || mergeRegions.getSecond() != null);
    }

    @Override
    public List<RegionMergeTransaction.JournalEntry> getJournal() {
        return this.journal;
    }

    @Override
    public RegionMergeTransaction registerTransactionListener(RegionMergeTransaction.TransactionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public RegionServerServices getRegionServerServices() {
        return this.rsServices;
    }

    public static class JournalEntryImpl
    implements RegionMergeTransaction.JournalEntry {
        private RegionMergeTransaction.RegionMergeTransactionPhase type;
        private long timestamp;

        public JournalEntryImpl(RegionMergeTransaction.RegionMergeTransactionPhase type) {
            this(type, EnvironmentEdgeManager.currentTime());
        }

        public JournalEntryImpl(RegionMergeTransaction.RegionMergeTransactionPhase type, long timestamp) {
            this.type = type;
            this.timestamp = timestamp;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.type);
            sb.append(" at ");
            sb.append(this.timestamp);
            return sb.toString();
        }

        @Override
        public RegionMergeTransaction.RegionMergeTransactionPhase getPhase() {
            return this.type;
        }

        @Override
        public long getTimeStamp() {
            return this.timestamp;
        }
    }
}

