/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ScanDeleteTracker
implements DeleteTracker {
    protected boolean hasFamilyStamp = false;
    protected long familyStamp = 0L;
    protected SortedSet<Long> familyVersionStamps = new TreeSet<Long>();
    protected byte[] deleteBuffer = null;
    protected int deleteOffset = 0;
    protected int deleteLength = 0;
    protected byte deleteType = 0;
    protected long deleteTimestamp = 0L;

    @Override
    public void add(Cell cell) {
        long timestamp = cell.getTimestamp();
        byte type = cell.getTypeByte();
        if (!this.hasFamilyStamp || timestamp > this.familyStamp) {
            if (type == KeyValue.Type.DeleteFamily.getCode()) {
                this.hasFamilyStamp = true;
                this.familyStamp = timestamp;
                return;
            }
            if (type == KeyValue.Type.DeleteFamilyVersion.getCode()) {
                this.familyVersionStamps.add(timestamp);
                return;
            }
            if (this.deleteBuffer != null && type < this.deleteType && CellUtil.matchingQualifier((Cell)cell, (byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength)) {
                return;
            }
            this.deleteBuffer = cell.getQualifierArray();
            this.deleteOffset = cell.getQualifierOffset();
            this.deleteLength = cell.getQualifierLength();
            this.deleteType = type;
            this.deleteTimestamp = timestamp;
        }
    }

    @Override
    public DeleteTracker.DeleteResult isDeleted(Cell cell) {
        long timestamp = cell.getTimestamp();
        if (this.hasFamilyStamp && timestamp <= this.familyStamp) {
            return DeleteTracker.DeleteResult.FAMILY_DELETED;
        }
        if (this.familyVersionStamps.contains(timestamp)) {
            return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
        }
        if (this.deleteBuffer != null) {
            int ret = -CellComparator.compareQualifiers((Cell)cell, (byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength);
            if (ret == 0) {
                if (this.deleteType == KeyValue.Type.DeleteColumn.getCode()) {
                    return DeleteTracker.DeleteResult.COLUMN_DELETED;
                }
                if (timestamp == this.deleteTimestamp) {
                    return DeleteTracker.DeleteResult.VERSION_DELETED;
                }
                assert (timestamp < this.deleteTimestamp);
                this.deleteBuffer = null;
            } else if (ret < 0) {
                this.deleteBuffer = null;
            } else {
                throw new IllegalStateException("isDelete failed: deleteBuffer=" + Bytes.toStringBinary((byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength) + ", qualifier=" + Bytes.toStringBinary((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()) + ", timestamp=" + timestamp + ", comparison result: " + ret);
            }
        }
        return DeleteTracker.DeleteResult.NOT_DELETED;
    }

    @Override
    public boolean isEmpty() {
        return this.deleteBuffer == null && !this.hasFamilyStamp && this.familyVersionStamps.isEmpty();
    }

    @Override
    public void reset() {
        this.hasFamilyStamp = false;
        this.familyStamp = 0L;
        this.familyVersionStamps.clear();
        this.deleteBuffer = null;
    }

    @Override
    public void update() {
        this.reset();
    }
}

