/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.SegmentScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.ByteRange;

@InterfaceAudience.Private
public abstract class Segment {
    private volatile CellSet cellSet;
    private final CellComparator comparator;
    private volatile MemStoreLAB memStoreLAB;
    private final AtomicLong size;
    private final TimeRangeTracker timeRangeTracker;
    protected volatile boolean tagsPresent;

    protected Segment(CellSet cellSet, CellComparator comparator, MemStoreLAB memStoreLAB, long size) {
        this.cellSet = cellSet;
        this.comparator = comparator;
        this.memStoreLAB = memStoreLAB;
        this.size = new AtomicLong(size);
        this.timeRangeTracker = new TimeRangeTracker();
        this.tagsPresent = false;
    }

    protected Segment(Segment segment) {
        this.cellSet = segment.getCellSet();
        this.comparator = segment.getComparator();
        this.memStoreLAB = segment.getMemStoreLAB();
        this.size = new AtomicLong(segment.getSize());
        this.timeRangeTracker = segment.getTimeRangeTracker();
        this.tagsPresent = segment.isTagsPresent();
    }

    public SegmentScanner getSegmentScanner(long readPoint) {
        return new SegmentScanner(this, readPoint);
    }

    public boolean isEmpty() {
        return this.getCellSet().isEmpty();
    }

    public int getCellsCount() {
        return this.getCellSet().size();
    }

    public Cell getFirstAfter(Cell cell) {
        SortedSet<Cell> snTailSet = this.tailSet(cell);
        if (!snTailSet.isEmpty()) {
            return snTailSet.first();
        }
        return null;
    }

    public void close() {
        MemStoreLAB mslab = this.getMemStoreLAB();
        if (mslab != null) {
            mslab.close();
        }
    }

    public Cell maybeCloneWithAllocator(Cell cell) {
        if (this.getMemStoreLAB() == null) {
            return cell;
        }
        int len = KeyValueUtil.length((Cell)cell);
        ByteRange alloc = this.getMemStoreLAB().allocateBytes(len);
        if (alloc == null) {
            return cell;
        }
        assert (alloc.getBytes() != null);
        KeyValueUtil.appendToByteArray((Cell)cell, (byte[])alloc.getBytes(), (int)alloc.getOffset());
        KeyValue newKv = new KeyValue(alloc.getBytes(), alloc.getOffset(), len);
        newKv.setSequenceId(cell.getSequenceId());
        return newKv;
    }

    public boolean shouldSeek(Scan scan, long oldestUnexpiredTS) {
        return this.getTimeRangeTracker().includesTimeRange(scan.getTimeRange()) && this.getTimeRangeTracker().getMaximumTimestamp() >= oldestUnexpiredTS;
    }

    public long getMinTimestamp() {
        return this.getTimeRangeTracker().getMinimumTimestamp();
    }

    public boolean isTagsPresent() {
        return this.tagsPresent;
    }

    public void incScannerCount() {
        if (this.getMemStoreLAB() != null) {
            this.getMemStoreLAB().incScannerCount();
        }
    }

    public void decScannerCount() {
        if (this.getMemStoreLAB() != null) {
            this.getMemStoreLAB().decScannerCount();
        }
    }

    public Segment setSize(long size) {
        this.size.set(size);
        return this;
    }

    public long getSize() {
        return this.size.get();
    }

    public void incSize(long delta) {
        this.size.addAndGet(delta);
    }

    public TimeRangeTracker getTimeRangeTracker() {
        return this.timeRangeTracker;
    }

    public Cell last() {
        return this.getCellSet().last();
    }

    public Iterator<Cell> iterator() {
        return this.getCellSet().iterator();
    }

    public SortedSet<Cell> headSet(Cell firstKeyOnRow) {
        return this.getCellSet().headSet(firstKeyOnRow);
    }

    public int compare(Cell left, Cell right) {
        return this.getComparator().compare(left, right);
    }

    public int compareRows(Cell left, Cell right) {
        return this.getComparator().compareRows(left, right);
    }

    protected CellSet getCellSet() {
        return this.cellSet;
    }

    protected CellComparator getComparator() {
        return this.comparator;
    }

    protected long internalAdd(Cell cell) {
        boolean succ = this.getCellSet().add(cell);
        long s = AbstractMemStore.heapSizeChange(cell, succ);
        this.updateMetaInfo(cell, s);
        return s;
    }

    protected void updateMetaInfo(Cell toAdd, long s) {
        this.getTimeRangeTracker().includeTimestamp(toAdd);
        this.size.addAndGet(s);
        if (toAdd.getTagsLength() > 0) {
            this.tagsPresent = true;
        }
    }

    protected SortedSet<Cell> tailSet(Cell firstCell) {
        return this.getCellSet().tailSet(firstCell);
    }

    private MemStoreLAB getMemStoreLAB() {
        return this.memStoreLAB;
    }

    void dump(Log log) {
        for (Cell cell : this.getCellSet()) {
            log.debug((Object)cell);
        }
    }

    public String toString() {
        String res = "Store segment of type " + this.getClass().getName() + "; ";
        res = res + "isEmpty " + (this.isEmpty() ? "yes" : "no") + "; ";
        res = res + "cellCount " + this.getCellsCount() + "; ";
        res = res + "size " + this.getSize() + "; ";
        res = res + "Min ts " + this.getMinTimestamp() + "; ";
        return res;
    }
}

