/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.HeapMemStoreLAB;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.Private
public final class SegmentFactory {
    static final String USEMSLAB_KEY = "hbase.hregion.memstore.mslab.enabled";
    static final boolean USEMSLAB_DEFAULT = true;
    static final String MSLAB_CLASS_NAME = "hbase.regionserver.mslab.class";
    private static SegmentFactory instance = new SegmentFactory();

    private SegmentFactory() {
    }

    public static SegmentFactory instance() {
        return instance;
    }

    public ImmutableSegment createImmutableSegment(Configuration conf, CellComparator comparator, long size) {
        MemStoreLAB memStoreLAB = this.getMemStoreLAB(conf);
        MutableSegment segment = this.generateMutableSegment(conf, comparator, memStoreLAB, size);
        return this.createImmutableSegment(conf, segment);
    }

    public ImmutableSegment createImmutableSegment(CellComparator comparator, long size) {
        MutableSegment segment = this.generateMutableSegment(null, comparator, null, size);
        return this.createImmutableSegment(null, segment);
    }

    public ImmutableSegment createImmutableSegment(Configuration conf, MutableSegment segment) {
        return new ImmutableSegment(segment);
    }

    public MutableSegment createMutableSegment(Configuration conf, CellComparator comparator, long size) {
        MemStoreLAB memStoreLAB = this.getMemStoreLAB(conf);
        return this.generateMutableSegment(conf, comparator, memStoreLAB, size);
    }

    private MutableSegment generateMutableSegment(Configuration conf, CellComparator comparator, MemStoreLAB memStoreLAB, long size) {
        CellSet set = new CellSet(comparator);
        return new MutableSegment(set, comparator, memStoreLAB, size);
    }

    private MemStoreLAB getMemStoreLAB(Configuration conf) {
        MemStoreLAB memStoreLAB = null;
        if (conf.getBoolean(USEMSLAB_KEY, true)) {
            String className = conf.get(MSLAB_CLASS_NAME, HeapMemStoreLAB.class.getName());
            memStoreLAB = (MemStoreLAB)ReflectionUtils.instantiateWithCustomCtor((String)className, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{conf});
        }
        return memStoreLAB;
    }
}

