/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.Store;

@InterfaceAudience.Private
public class SegmentScanner
implements KeyValueScanner {
    private long sequenceID = Long.MAX_VALUE;
    private final Segment segment;
    private long readPoint;
    private Iterator<Cell> iter;
    private Cell current = null;
    private boolean stopSkippingKVsIfNextRow = false;
    private Cell last = null;

    protected SegmentScanner(Segment segment, long readPoint) {
        this.segment = segment;
        this.readPoint = readPoint;
        this.iter = segment.iterator();
        this.current = this.getNext();
        this.segment.incScannerCount();
    }

    @Override
    public Cell peek() {
        if (this.current != null && this.current.getSequenceId() > this.readPoint) {
            throw new RuntimeException("current is invalid: read point is " + this.readPoint + ", " + "while current sequence id is " + this.current.getSequenceId());
        }
        return this.current;
    }

    @Override
    public Cell next() throws IOException {
        Cell oldCurrent = this.current;
        this.current = this.getNext();
        return oldCurrent;
    }

    @Override
    public boolean seek(Cell cell) throws IOException {
        if (cell == null) {
            this.close();
            return false;
        }
        this.iter = this.segment.tailSet(cell).iterator();
        this.last = null;
        this.current = this.getNext();
        return this.current != null;
    }

    @Override
    public boolean reseek(Cell cell) throws IOException {
        this.iter = this.segment.tailSet(this.getHighest(cell, this.last)).iterator();
        this.current = this.getNext();
        return this.current != null;
    }

    @Override
    public boolean backwardSeek(Cell key) throws IOException {
        this.seek(key);
        if (this.peek() == null || this.segment.compareRows(this.peek(), key) > 0) {
            return this.seekToPreviousRow(key);
        }
        return true;
    }

    @Override
    public boolean seekToPreviousRow(Cell cell) throws IOException {
        boolean keepSeeking = false;
        Cell key = cell;
        do {
            Cell firstKeyOnRow;
            SortedSet<Cell> cellHead;
            Cell lastCellBeforeRow;
            Cell cell2 = lastCellBeforeRow = (cellHead = this.segment.headSet(firstKeyOnRow = CellUtil.createFirstOnRow((Cell)key))).isEmpty() ? null : cellHead.last();
            if (lastCellBeforeRow == null) {
                this.current = null;
                return false;
            }
            Cell firstKeyOnPreviousRow = CellUtil.createFirstOnRow((Cell)lastCellBeforeRow);
            this.stopSkippingKVsIfNextRow = true;
            this.seek(firstKeyOnPreviousRow);
            this.stopSkippingKVsIfNextRow = false;
            if (this.peek() == null || this.segment.getComparator().compareRows(this.peek(), firstKeyOnPreviousRow) > 0) {
                keepSeeking = true;
                key = firstKeyOnPreviousRow;
                continue;
            }
            keepSeeking = false;
        } while (keepSeeking);
        return true;
    }

    @Override
    public boolean seekToLastRow() throws IOException {
        Cell higherCell;
        Cell cell = higherCell = this.segment.isEmpty() ? null : this.segment.last();
        if (higherCell == null) {
            return false;
        }
        Cell firstCellOnLastRow = CellUtil.createFirstOnRow((Cell)higherCell);
        if (this.seek(firstCellOnLastRow)) {
            return true;
        }
        return this.seekToPreviousRow(higherCell);
    }

    @Override
    public long getSequenceID() {
        return this.sequenceID;
    }

    @Override
    public void close() {
        this.getSegment().decScannerCount();
    }

    @Override
    public boolean shouldUseScanner(Scan scan, Store store, long oldestUnexpiredTS) {
        return true;
    }

    @Override
    public boolean requestSeek(Cell c, boolean forward, boolean useBloom) throws IOException {
        throw new IllegalStateException("requestSeek cannot be called on MutableCellSetSegmentScanner");
    }

    @Override
    public boolean realSeekDone() {
        return true;
    }

    @Override
    public void enforceSeek() throws IOException {
        throw new IllegalStateException("enforceSeek cannot be called on MutableCellSetSegmentScanner");
    }

    @Override
    public boolean isFileScanner() {
        return false;
    }

    @Override
    public Cell getNextIndexedKey() {
        return null;
    }

    @Override
    public void shipped() throws IOException {
    }

    public void setSequenceID(long x) {
        this.sequenceID = x;
    }

    public boolean shouldSeek(Scan scan, long oldestUnexpiredTS) {
        return this.getSegment().shouldSeek(scan, oldestUnexpiredTS);
    }

    protected Segment getSegment() {
        return this.segment;
    }

    public String toString() {
        String res = "Store segment scanner of type " + this.getClass().getName() + "; ";
        res = res + "sequence id " + this.getSequenceID() + "; ";
        res = res + this.getSegment().toString();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cell getNext() {
        Cell startKV = this.current;
        Cell next = null;
        try {
            while (this.iter.hasNext()) {
                next = this.iter.next();
                if (next.getSequenceId() <= this.readPoint) {
                    Cell cell = next;
                    return cell;
                }
                if (!this.stopSkippingKVsIfNextRow || startKV == null || this.segment.compareRows(next, startKV) <= 0) continue;
                Cell cell = null;
                return cell;
            }
            Cell cell = null;
            return cell;
        }
        finally {
            if (next != null) {
                this.last = next;
            }
        }
    }

    private Cell getHighest(Cell first, Cell second) {
        if (first == null && second == null) {
            return null;
        }
        if (first != null && second != null) {
            int compare = this.segment.compare(first, second);
            return compare > 0 ? first : second;
        }
        return first != null ? first : second;
    }
}

