/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.SplitTransactionImpl;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
class SplitRequest
implements Runnable {
    private static final Log LOG = LogFactory.getLog(SplitRequest.class);
    private final HRegion parent;
    private final byte[] midKey;
    private final HRegionServer server;
    private final User user;
    private TableLockManager.TableLock tableLock;

    SplitRequest(Region region, byte[] midKey, HRegionServer hrs, User user) {
        Preconditions.checkNotNull((Object)hrs);
        this.parent = (HRegion)region;
        this.midKey = midKey;
        this.server = hrs;
        this.user = user;
    }

    public String toString() {
        return "regionName=" + this.parent + ", midKey=" + Bytes.toStringBinary((byte[])this.midKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSplitting(User user) {
        success = false;
        this.server.metricsRegionServer.incrSplitRequest();
        startTime = EnvironmentEdgeManager.currentTime();
        st = new SplitTransactionImpl(this.parent, this.midKey);
        this.tableLock = this.server.getTableLockManager().readLock(this.parent.getTableDesc().getTableName(), "SPLIT_REGION:" + this.parent.getRegionInfo().getRegionNameAsString());
        try {
            this.tableLock.acquire();
        }
        catch (IOException ex) {
            this.tableLock = null;
            throw ex;
        }
        if (st.prepare()) ** GOTO lbl57
        if (this.parent.getCoprocessorHost() == null) ** GOTO lbl47
        ** GOTO lbl42
        {
            catch (IOException ex) {
                block47: {
                    block48: {
                        block51: {
                            block49: {
                                try {
                                    ex = ex instanceof RemoteException != false ? ((RemoteException)ex).unwrapRemoteException() : ex;
                                    SplitRequest.LOG.error((Object)("Split failed " + this), (Throwable)ex);
                                    this.server.checkFileSystem();
                                    if (this.parent.getCoprocessorHost() != null) {
                                    }
                                    break block47;
                                }
                                catch (Throwable var9_24) {
                                    if (this.parent.getCoprocessorHost() != null) {
                                        try {
                                            this.parent.getCoprocessorHost().postCompleteSplit();
                                        }
                                        catch (IOException io) {
                                            SplitRequest.LOG.error((Object)("Split failed " + this), (Throwable)(io instanceof RemoteException != false ? ((RemoteException)io).unwrapRemoteException() : io));
                                        }
                                    }
                                    if (this.parent.shouldForceSplit()) {
                                        this.parent.clearSplit();
                                    }
                                    this.releaseTableLock();
                                    endTime = EnvironmentEdgeManager.currentTime();
                                    this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                                    if (success) {
                                        this.server.metricsRegionServer.incrSplitSuccess();
                                        SplitRequest.LOG.info((Object)("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime)));
                                    }
                                    SplitRequest.LOG.info((Object)("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal())));
                                    throw var9_24;
                                }
lbl42:
                                // 1 sources

                                try {
                                    this.parent.getCoprocessorHost().postCompleteSplit();
                                }
                                catch (IOException io) {
                                    SplitRequest.LOG.error((Object)("Split failed " + this), (Throwable)(io instanceof RemoteException != false ? ((RemoteException)io).unwrapRemoteException() : io));
                                }
lbl47:
                                // 3 sources

                                if (this.parent.shouldForceSplit()) {
                                    this.parent.clearSplit();
                                }
                                this.releaseTableLock();
                                endTime = EnvironmentEdgeManager.currentTime();
                                this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                                if (success) {
                                    this.server.metricsRegionServer.incrSplitSuccess();
                                    SplitRequest.LOG.info((Object)("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime)));
                                }
                                SplitRequest.LOG.info((Object)("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal())));
                                return;
lbl57:
                                // 1 sources

                                try {
                                    st.execute(this.server, this.server, user);
                                    success = true;
                                    break block48;
                                }
                                catch (Exception e) {}
                                if (!this.server.isStopping() && !this.server.isStopped()) ** GOTO lbl-1000
                                SplitRequest.LOG.info((Object)("Skip rollback/cleanup of failed split of " + this.parent.getRegionInfo().getRegionNameAsString() + " because server is" + (this.server.isStopping() != false ? " stopping" : " stopped")), (Throwable)e);
                                if (this.parent.getCoprocessorHost() != null) {
                                    try {
                                        this.parent.getCoprocessorHost().postCompleteSplit();
                                    }
                                    catch (IOException io) {
                                        SplitRequest.LOG.error((Object)("Split failed " + this), (Throwable)(io instanceof RemoteException != false ? ((RemoteException)io).unwrapRemoteException() : io));
                                    }
                                }
                                if (this.parent.shouldForceSplit()) {
                                    this.parent.clearSplit();
                                }
                                this.releaseTableLock();
                                endTime = EnvironmentEdgeManager.currentTime();
                                this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                                if (success) {
                                    this.server.metricsRegionServer.incrSplitSuccess();
                                    SplitRequest.LOG.info((Object)("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime)));
                                }
                                SplitRequest.LOG.info((Object)("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal())));
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    if (!(e instanceof DroppedSnapshotException)) ** GOTO lbl-1000
                                    this.server.abort("Replay of WAL required. Forcing server shutdown", e);
                                    if (this.parent.getCoprocessorHost() == null) break block49;
                                }
                                try {
                                    this.parent.getCoprocessorHost().postCompleteSplit();
                                }
                                catch (IOException io) {
                                    SplitRequest.LOG.error((Object)("Split failed " + this), (Throwable)(io instanceof RemoteException != false ? ((RemoteException)io).unwrapRemoteException() : io));
                                }
                            }
                            if (this.parent.shouldForceSplit()) {
                                this.parent.clearSplit();
                            }
                            this.releaseTableLock();
                            endTime = EnvironmentEdgeManager.currentTime();
                            this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                            if (success) {
                                this.server.metricsRegionServer.incrSplitSuccess();
                                SplitRequest.LOG.info((Object)("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime)));
                            }
                            SplitRequest.LOG.info((Object)("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal())));
                            return;
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    SplitRequest.LOG.info((Object)("Running rollback/cleanup of failed split of " + this.parent.getRegionInfo().getRegionNameAsString() + "; " + e.getMessage()), (Throwable)e);
                                    if (st.rollback(this.server, this.server)) {
                                        SplitRequest.LOG.info((Object)("Successful rollback of failed split of " + this.parent.getRegionInfo().getRegionNameAsString()));
                                    } else {
                                        this.server.abort("Abort; we got an error after point-of-no-return");
                                    }
                                }
                                catch (RuntimeException ee) {
                                    msg = "Failed rollback of failed split of " + this.parent.getRegionInfo().getRegionNameAsString() + " -- aborting server";
                                    SplitRequest.LOG.info((Object)msg, (Throwable)ee);
                                    this.server.abort(msg + " -- Cause: " + ee.getMessage());
                                }
                                if (this.parent.getCoprocessorHost() == null) break block51;
                            }
                            try {
                                this.parent.getCoprocessorHost().postCompleteSplit();
                            }
                            catch (IOException io) {
                                SplitRequest.LOG.error((Object)("Split failed " + this), (Throwable)(io instanceof RemoteException != false ? ((RemoteException)io).unwrapRemoteException() : io));
                            }
                        }
                        if (this.parent.shouldForceSplit()) {
                            this.parent.clearSplit();
                        }
                        this.releaseTableLock();
                        endTime = EnvironmentEdgeManager.currentTime();
                        this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                        if (success) {
                            this.server.metricsRegionServer.incrSplitSuccess();
                            SplitRequest.LOG.info((Object)("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime)));
                        }
                        SplitRequest.LOG.info((Object)("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal())));
                        return;
                    }
                    if (this.parent.getCoprocessorHost() != null) {
                        try {
                            this.parent.getCoprocessorHost().postCompleteSplit();
                        }
                        catch (IOException io) {
                            SplitRequest.LOG.error((Object)("Split failed " + this), (Throwable)(io instanceof RemoteException != false ? ((RemoteException)io).unwrapRemoteException() : io));
                        }
                    }
                    if (this.parent.shouldForceSplit()) {
                        this.parent.clearSplit();
                    }
                    this.releaseTableLock();
                    endTime = EnvironmentEdgeManager.currentTime();
                    this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                    if (success) {
                        this.server.metricsRegionServer.incrSplitSuccess();
                        SplitRequest.LOG.info((Object)("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime)));
                    }
                    SplitRequest.LOG.info((Object)("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal())));
                    return;
                    try {
                        this.parent.getCoprocessorHost().postCompleteSplit();
                    }
                    catch (IOException io) {
                        SplitRequest.LOG.error((Object)("Split failed " + this), (Throwable)(io instanceof RemoteException != false ? ((RemoteException)io).unwrapRemoteException() : io));
                    }
                }
                if (this.parent.shouldForceSplit()) {
                    this.parent.clearSplit();
                }
                this.releaseTableLock();
                endTime = EnvironmentEdgeManager.currentTime();
                this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                if (success) {
                    this.server.metricsRegionServer.incrSplitSuccess();
                    SplitRequest.LOG.info((Object)("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime)));
                }
                SplitRequest.LOG.info((Object)("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal())));
                return;
            }
        }
    }

    @Override
    public void run() {
        if (this.server.isStopping() || this.server.isStopped()) {
            LOG.debug((Object)("Skipping split because server is stopping=" + this.server.isStopping() + " or stopped=" + this.server.isStopped()));
            return;
        }
        this.doSplitting(this.user);
    }

    protected void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.error((Object)"Could not release the table lock (something is really wrong). Aborting this server to avoid holding the lock forever.");
                this.server.abort("Abort; we got an error when releasing the table lock on " + this.parent.getRegionInfo().getRegionNameAsString());
            }
        }
    }
}

