/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.LimitedPrivate(value={"Coprocessor"})
public class StoreFile {
    private static final Log LOG = LogFactory.getLog((String)StoreFile.class.getName());
    public static final byte[] MAX_SEQ_ID_KEY = Bytes.toBytes((String)"MAX_SEQ_ID_KEY");
    public static final byte[] MAJOR_COMPACTION_KEY = Bytes.toBytes((String)"MAJOR_COMPACTION_KEY");
    public static final byte[] EXCLUDE_FROM_MINOR_COMPACTION_KEY = Bytes.toBytes((String)"EXCLUDE_FROM_MINOR_COMPACTION");
    public static final byte[] BLOOM_FILTER_TYPE_KEY = Bytes.toBytes((String)"BLOOM_FILTER_TYPE");
    public static final byte[] DELETE_FAMILY_COUNT = Bytes.toBytes((String)"DELETE_FAMILY_COUNT");
    private static final byte[] LAST_BLOOM_KEY = Bytes.toBytes((String)"LAST_BLOOM_KEY");
    public static final byte[] TIMERANGE_KEY = Bytes.toBytes((String)"TIMERANGE");
    public static final byte[] EARLIEST_PUT_TS = Bytes.toBytes((String)"EARLIEST_PUT_TS");
    public static final byte[] MOB_CELLS_COUNT = Bytes.toBytes((String)"MOB_CELLS_COUNT");
    private final StoreFileInfo fileInfo;
    private final FileSystem fs;
    private final CacheConfig cacheConf;
    private long sequenceid = -1L;
    private long maxMemstoreTS = -1L;
    private Cell firstKey;
    private Cell lastKey;
    private Comparator comparator;
    private AtomicBoolean majorCompaction = null;
    private boolean excludeFromMinorCompaction = false;
    public static final byte[] BULKLOAD_TASK_KEY = Bytes.toBytes((String)"BULKLOAD_SOURCE_TASK");
    public static final byte[] BULKLOAD_TIME_KEY = Bytes.toBytes((String)"BULKLOAD_TIMESTAMP");
    private Map<byte[], byte[]> metadataMap;
    private volatile Reader reader;
    private final BloomType cfBloomType;
    public static final byte[] SKIP_RESET_SEQ_ID = Bytes.toBytes((String)"SKIP_RESET_SEQ_ID");

    CacheConfig getCacheConf() {
        return this.cacheConf;
    }

    public Cell getFirstKey() {
        return this.firstKey;
    }

    public Cell getLastKey() {
        return this.lastKey;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public long getMaxMemstoreTS() {
        return this.maxMemstoreTS;
    }

    public void setMaxMemstoreTS(long maxMemstoreTS) {
        this.maxMemstoreTS = maxMemstoreTS;
    }

    public StoreFile(FileSystem fs, Path p, Configuration conf, CacheConfig cacheConf, BloomType cfBloomType) throws IOException {
        this(fs, new StoreFileInfo(conf, fs, p), conf, cacheConf, cfBloomType);
    }

    public StoreFile(FileSystem fs, StoreFileInfo fileInfo, Configuration conf, CacheConfig cacheConf, BloomType cfBloomType) throws IOException {
        this.fs = fs;
        this.fileInfo = fileInfo;
        this.cacheConf = cacheConf;
        if (BloomFilterFactory.isGeneralBloomEnabled(conf)) {
            this.cfBloomType = cfBloomType;
        } else {
            LOG.info((Object)("Ignoring bloom filter check for file " + this.getPath() + ": " + "cfBloomType=" + cfBloomType + " (disabled in config)"));
            this.cfBloomType = BloomType.NONE;
        }
    }

    public StoreFile(StoreFile other) {
        this.fs = other.fs;
        this.fileInfo = other.fileInfo;
        this.cacheConf = other.cacheConf;
        this.cfBloomType = other.cfBloomType;
    }

    public StoreFileInfo getFileInfo() {
        return this.fileInfo;
    }

    public Path getPath() {
        return this.fileInfo.getPath();
    }

    public Path getQualifiedPath() {
        return this.fileInfo.getPath().makeQualified(this.fs);
    }

    public boolean isReference() {
        return this.fileInfo.isReference();
    }

    public boolean isHFile() {
        return StoreFileInfo.isHFile(this.fileInfo.getPath());
    }

    public boolean isMajorCompaction() {
        if (this.majorCompaction == null) {
            throw new NullPointerException("This has not been set yet");
        }
        return this.majorCompaction.get();
    }

    public boolean excludeFromMinorCompaction() {
        return this.excludeFromMinorCompaction;
    }

    public long getMaxSequenceId() {
        return this.sequenceid;
    }

    public long getModificationTimeStamp() throws IOException {
        return this.fileInfo == null ? 0L : this.fileInfo.getModificationTime();
    }

    public byte[] getMetadataValue(byte[] key) {
        return this.metadataMap.get(key);
    }

    public static long getMaxMemstoreTSInList(Collection<StoreFile> sfs) {
        long max = 0L;
        for (StoreFile sf : sfs) {
            if (sf.isBulkLoadResult()) continue;
            max = Math.max(max, sf.getMaxMemstoreTS());
        }
        return max;
    }

    public static long getMaxSequenceIdInList(Collection<StoreFile> sfs) {
        long max = 0L;
        for (StoreFile sf : sfs) {
            max = Math.max(max, sf.getMaxSequenceId());
        }
        return max;
    }

    boolean isBulkLoadResult() {
        boolean bulkLoadedHFile = false;
        String fileName = this.getPath().getName();
        int startPos = fileName.indexOf("SeqId_");
        if (startPos != -1) {
            bulkLoadedHFile = true;
        }
        return bulkLoadedHFile || this.metadataMap.containsKey(BULKLOAD_TIME_KEY);
    }

    @VisibleForTesting
    public boolean isCompactedAway() {
        if (this.reader != null) {
            return this.reader.isCompactedAway();
        }
        return true;
    }

    @VisibleForTesting
    public int getRefCount() {
        return this.reader.refCount.get();
    }

    public long getBulkLoadTimestamp() {
        byte[] bulkLoadTimestamp = this.metadataMap.get(BULKLOAD_TIME_KEY);
        return bulkLoadTimestamp == null ? 0L : Bytes.toLong((byte[])bulkLoadTimestamp);
    }

    public HDFSBlocksDistribution getHDFSBlockDistribution() {
        return this.fileInfo.getHDFSBlockDistribution();
    }

    private Reader open(boolean canUseDropBehind) throws IOException {
        if (this.reader != null) {
            throw new IllegalAccessError("Already open");
        }
        this.reader = this.fileInfo.open(this.fs, this.cacheConf, canUseDropBehind);
        this.metadataMap = Collections.unmodifiableMap(this.reader.loadFileInfo());
        byte[] b = this.metadataMap.get(MAX_SEQ_ID_KEY);
        if (b != null) {
            this.sequenceid = Bytes.toLong((byte[])b);
            if (this.fileInfo.isTopReference()) {
                ++this.sequenceid;
            }
        }
        if (this.isBulkLoadResult()) {
            String fileName = this.getPath().getName();
            int startPos = fileName.lastIndexOf("SeqId_");
            if (startPos != -1) {
                this.sequenceid = Long.parseLong(fileName.substring(startPos + 6, fileName.indexOf(95, startPos + 6)));
                if (this.fileInfo.isTopReference()) {
                    ++this.sequenceid;
                }
            }
            this.reader.setSkipResetSeqId(this.isSkipResetSeqId(this.metadataMap.get(SKIP_RESET_SEQ_ID)));
            this.reader.setBulkLoaded(true);
        }
        this.reader.setSequenceID(this.sequenceid);
        b = this.metadataMap.get(HFile.Writer.MAX_MEMSTORE_TS_KEY);
        if (b != null) {
            this.maxMemstoreTS = Bytes.toLong((byte[])b);
        }
        if ((b = this.metadataMap.get(MAJOR_COMPACTION_KEY)) != null) {
            boolean mc = Bytes.toBoolean((byte[])b);
            if (this.majorCompaction == null) {
                this.majorCompaction = new AtomicBoolean(mc);
            } else {
                this.majorCompaction.set(mc);
            }
        } else {
            this.majorCompaction = new AtomicBoolean(false);
        }
        b = this.metadataMap.get(EXCLUDE_FROM_MINOR_COMPACTION_KEY);
        this.excludeFromMinorCompaction = b != null && Bytes.toBoolean((byte[])b);
        BloomType hfileBloomType = this.reader.getBloomFilterType();
        if (this.cfBloomType != BloomType.NONE) {
            this.reader.loadBloomfilter(BlockType.GENERAL_BLOOM_META);
            if (hfileBloomType != this.cfBloomType) {
                LOG.info((Object)("HFile Bloom filter type for " + this.reader.getHFileReader().getName() + ": " + hfileBloomType + ", but " + this.cfBloomType + " specified in column family " + "configuration"));
            }
        } else if (hfileBloomType != BloomType.NONE) {
            LOG.info((Object)("Bloom filter turned off by CF config for " + this.reader.getHFileReader().getName()));
        }
        this.reader.loadBloomfilter(BlockType.DELETE_FAMILY_BLOOM_META);
        try {
            byte[] timerangeBytes = this.metadataMap.get(TIMERANGE_KEY);
            if (timerangeBytes != null) {
                this.reader.timeRangeTracker = new TimeRangeTracker();
                Writables.copyWritable((byte[])timerangeBytes, (Writable)this.reader.timeRangeTracker);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Error reading timestamp range data from meta -- proceeding without", (Throwable)e);
            this.reader.timeRangeTracker = null;
        }
        this.firstKey = this.reader.getFirstKey();
        this.lastKey = this.reader.getLastKey();
        this.comparator = this.reader.getComparator();
        return this.reader;
    }

    public Reader createReader() throws IOException {
        return this.createReader(false);
    }

    public Reader createReader(boolean canUseDropBehind) throws IOException {
        if (this.reader == null) {
            try {
                this.reader = this.open(canUseDropBehind);
            }
            catch (IOException e) {
                try {
                    boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
                    this.closeReader(evictOnClose);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
        }
        return this.reader;
    }

    public Reader getReader() {
        return this.reader;
    }

    public synchronized void closeReader(boolean evictOnClose) throws IOException {
        if (this.reader != null) {
            this.reader.close(evictOnClose);
            this.reader = null;
        }
    }

    public void markCompactedAway() {
        if (this.reader != null) {
            this.reader.markCompactedAway();
        }
    }

    public void deleteReader() throws IOException {
        boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
        this.closeReader(evictOnClose);
        this.fs.delete(this.getPath(), true);
    }

    public String toString() {
        return this.fileInfo.toString();
    }

    public String toStringDetailed() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPath().toString());
        sb.append(", isReference=").append(this.isReference());
        sb.append(", isBulkLoadResult=").append(this.isBulkLoadResult());
        if (this.isBulkLoadResult()) {
            sb.append(", bulkLoadTS=").append(this.getBulkLoadTimestamp());
        } else {
            sb.append(", seqid=").append(this.getMaxSequenceId());
        }
        sb.append(", majorCompaction=").append(this.isMajorCompaction());
        return sb.toString();
    }

    private boolean isSkipResetSeqId(byte[] skipResetSeqId) {
        if (skipResetSeqId != null && skipResetSeqId.length == 1) {
            return Bytes.toBoolean((byte[])skipResetSeqId);
        }
        return false;
    }

    public static Path getUniqueFile(FileSystem fs, Path dir) throws IOException {
        if (!fs.getFileStatus(dir).isDirectory()) {
            throw new IOException("Expecting " + dir.toString() + " to be a directory");
        }
        return new Path(dir, UUID.randomUUID().toString().replaceAll("-", ""));
    }

    public Long getMinimumTimestamp() {
        return this.getReader().timeRangeTracker == null ? null : Long.valueOf(this.getReader().timeRangeTracker.getMinimumTimestamp());
    }

    public Long getMaximumTimestamp() {
        return this.getReader().timeRangeTracker == null ? null : Long.valueOf(this.getReader().timeRangeTracker.getMaximumTimestamp());
    }

    byte[] getFileSplitPoint(CellComparator comparator) throws IOException {
        if (this.reader == null) {
            LOG.warn((Object)("Storefile " + this + " Reader is null; cannot get split point"));
            return null;
        }
        Cell midkey = this.reader.midkey();
        if (midkey != null) {
            Cell firstKey = this.reader.getFirstKey();
            Cell lastKey = this.reader.getLastKey();
            if (comparator.compareRows(midkey, firstKey) == 0 || comparator.compareRows(midkey, lastKey) == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"cannot split because midkey is the same as first or last row");
                }
                return null;
            }
            return CellUtil.cloneRow((Cell)midkey);
        }
        return null;
    }

    public static abstract class Comparators {
        public static final Comparator<StoreFile> SEQ_ID = Ordering.compound((Iterable)ImmutableList.of((Object)Ordering.natural().onResultOf((Function)new GetSeqId()), (Object)Ordering.natural().onResultOf((Function)new GetFileSize()).reverse(), (Object)Ordering.natural().onResultOf((Function)new GetBulkTime()), (Object)Ordering.natural().onResultOf((Function)new GetPathName())));

        private static class GetPathName
        implements Function<StoreFile, String> {
            private GetPathName() {
            }

            public String apply(StoreFile sf) {
                return sf.getPath().getName();
            }
        }

        private static class GetBulkTime
        implements Function<StoreFile, Long> {
            private GetBulkTime() {
            }

            public Long apply(StoreFile sf) {
                if (!sf.isBulkLoadResult()) {
                    return Long.MAX_VALUE;
                }
                return sf.getBulkLoadTimestamp();
            }
        }

        private static class GetFileSize
        implements Function<StoreFile, Long> {
            private GetFileSize() {
            }

            public Long apply(StoreFile sf) {
                if (sf.getReader() != null) {
                    return sf.getReader().length();
                }
                return -1L;
            }
        }

        private static class GetSeqId
        implements Function<StoreFile, Long> {
            private GetSeqId() {
            }

            public Long apply(StoreFile sf) {
                return sf.getMaxSequenceId();
            }
        }
    }

    public static class Reader {
        private static final Log LOG = LogFactory.getLog((String)Reader.class.getName());
        protected BloomFilter generalBloomFilter = null;
        protected BloomFilter deleteFamilyBloomFilter = null;
        protected BloomType bloomFilterType;
        private final HFile.Reader reader;
        protected TimeRangeTracker timeRangeTracker = null;
        protected long sequenceID = -1L;
        private byte[] lastBloomKey;
        private long deleteFamilyCnt = -1L;
        private boolean bulkLoadResult = false;
        private KeyValue.KeyOnlyKeyValue lastBloomKeyOnlyKV = null;
        private boolean skipResetSeqId = true;
        private AtomicInteger refCount = new AtomicInteger(0);
        private volatile boolean compactedAway = false;

        public Reader(FileSystem fs, Path path, CacheConfig cacheConf, Configuration conf) throws IOException {
            this.reader = HFile.createReader(fs, path, cacheConf, conf);
            this.bloomFilterType = BloomType.NONE;
        }

        void markCompactedAway() {
            this.compactedAway = true;
        }

        public Reader(FileSystem fs, Path path, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Configuration conf) throws IOException {
            this.reader = HFile.createReader(fs, path, in, size, cacheConf, conf);
            this.bloomFilterType = BloomType.NONE;
        }

        public void setReplicaStoreFile(boolean isPrimaryReplicaStoreFile) {
            this.reader.setPrimaryReplicaReader(isPrimaryReplicaStoreFile);
        }

        public boolean isPrimaryReplicaReader() {
            return this.reader.isPrimaryReplicaReader();
        }

        Reader() {
            this.reader = null;
        }

        public CellComparator getComparator() {
            return this.reader.getComparator();
        }

        public StoreFileScanner getStoreFileScanner(boolean cacheBlocks, boolean pread) {
            return this.getStoreFileScanner(cacheBlocks, pread, false, 0L);
        }

        public StoreFileScanner getStoreFileScanner(boolean cacheBlocks, boolean pread, boolean isCompaction, long readPt) {
            this.refCount.incrementAndGet();
            return new StoreFileScanner(this, this.getScanner(cacheBlocks, pread, isCompaction), !isCompaction, this.reader.hasMVCCInfo(), readPt);
        }

        void decrementRefCount() {
            this.refCount.decrementAndGet();
        }

        public boolean isReferencedInReads() {
            return this.refCount.get() != 0;
        }

        public boolean isCompactedAway() {
            return this.compactedAway;
        }

        @Deprecated
        public HFileScanner getScanner(boolean cacheBlocks, boolean pread) {
            return this.getScanner(cacheBlocks, pread, false);
        }

        @Deprecated
        public HFileScanner getScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
            return this.reader.getScanner(cacheBlocks, pread, isCompaction);
        }

        public void close(boolean evictOnClose) throws IOException {
            this.reader.close(evictOnClose);
        }

        boolean passesTimerangeFilter(TimeRange timeRange, long oldestUnexpiredTS) {
            if (this.timeRangeTracker == null) {
                return true;
            }
            return this.timeRangeTracker.includesTimeRange(timeRange) && this.timeRangeTracker.getMaximumTimestamp() >= oldestUnexpiredTS;
        }

        boolean passesBloomFilter(Scan scan, SortedSet<byte[]> columns) {
            if (!scan.isGetScan()) {
                return true;
            }
            byte[] row = scan.getStartRow();
            switch (this.bloomFilterType) {
                case ROW: {
                    return this.passesGeneralRowBloomFilter(row, 0, row.length);
                }
                case ROWCOL: {
                    if (columns != null && columns.size() == 1) {
                        byte[] column = columns.first();
                        KeyValue kvKey = KeyValueUtil.createFirstOnRow((byte[])row, (int)0, (int)row.length, (byte[])HConstants.EMPTY_BYTE_ARRAY, (int)0, (int)0, (byte[])column, (int)0, (int)column.length);
                        return this.passesGeneralRowColBloomFilter((Cell)kvKey);
                    }
                    return true;
                }
            }
            return true;
        }

        public boolean passesDeleteFamilyBloomFilter(byte[] row, int rowOffset, int rowLen) {
            BloomFilter bloomFilter = this.deleteFamilyBloomFilter;
            if (this.reader.getTrailer().getEntryCount() == 0L || this.deleteFamilyCnt == 0L) {
                return false;
            }
            if (bloomFilter == null) {
                return true;
            }
            try {
                if (!bloomFilter.supportsAutoLoading()) {
                    return true;
                }
                return bloomFilter.contains(row, rowOffset, rowLen, null);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Bad Delete Family bloom filter data -- proceeding without", (Throwable)e);
                this.setDeleteFamilyBloomFilterFaulty();
                return true;
            }
        }

        public boolean passesGeneralRowBloomFilter(byte[] row, int rowOffset, int rowLen) {
            BloomFilter bloomFilter = this.generalBloomFilter;
            if (bloomFilter == null) {
                return true;
            }
            byte[] key = null;
            if (rowOffset != 0 || rowLen != row.length) {
                throw new AssertionError((Object)"For row-only Bloom filters the row must occupy the whole array");
            }
            key = row;
            return this.checkGeneralBloomFilter(key, null, bloomFilter);
        }

        public boolean passesGeneralRowColBloomFilter(Cell cell) {
            BloomFilter bloomFilter = this.generalBloomFilter;
            if (bloomFilter == null) {
                return true;
            }
            Cell kvKey = null;
            kvKey = cell.getTypeByte() == KeyValue.Type.Maximum.getCode() && cell.getFamilyLength() == 0 ? cell : CellUtil.createFirstOnRowCol((Cell)cell);
            return this.checkGeneralBloomFilter(null, kvKey, bloomFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean checkGeneralBloomFilter(byte[] key, Cell kvKey, BloomFilter bloomFilter) {
            HFileBlock bloomBlock;
            block14: {
                boolean bl;
                if (this.reader.getTrailer().getEntryCount() == 0L) {
                    return false;
                }
                bloomBlock = null;
                try {
                    boolean exists;
                    boolean keyIsAfterLast;
                    boolean shouldCheckBloom;
                    ByteBuff bloom;
                    if (bloomFilter.supportsAutoLoading()) {
                        bloom = null;
                        shouldCheckBloom = true;
                    } else {
                        bloomBlock = this.reader.getMetaBlock("BLOOM_FILTER_DATA", true);
                        bloom = bloomBlock.getBufferWithoutHeader();
                        boolean bl2 = shouldCheckBloom = bloom != null;
                    }
                    if (!shouldCheckBloom) break block14;
                    boolean bl3 = keyIsAfterLast = this.lastBloomKey != null;
                    if (keyIsAfterLast) {
                        if (this.bloomFilterType == BloomType.ROW) {
                            keyIsAfterLast = Bytes.BYTES_RAWCOMPARATOR.compare((Object)key, (Object)this.lastBloomKey) > 0;
                        } else {
                            boolean bl4 = keyIsAfterLast = CellComparator.COMPARATOR.compare(kvKey, (Cell)this.lastBloomKeyOnlyKV) > 0;
                        }
                    }
                    if (this.bloomFilterType == BloomType.ROWCOL) {
                        Cell rowBloomKey = CellUtil.createFirstOnRow((Cell)kvKey);
                        exists = keyIsAfterLast && CellComparator.COMPARATOR.compare(rowBloomKey, (Cell)this.lastBloomKeyOnlyKV) > 0 ? false : bloomFilter.contains(kvKey, bloom) || bloomFilter.contains(rowBloomKey, bloom);
                    } else {
                        exists = !keyIsAfterLast && bloomFilter.contains(key, 0, key.length, bloom);
                    }
                    bl = exists;
                }
                catch (IOException e) {
                    LOG.error((Object)"Error reading bloom filter data -- proceeding without", (Throwable)e);
                    this.setGeneralBloomFilterFaulty();
                    this.reader.returnBlock(bloomBlock);
                }
                catch (IllegalArgumentException e2) {
                    LOG.error((Object)"Bad bloom filter data -- proceeding without", (Throwable)e2);
                    this.setGeneralBloomFilterFaulty();
                    {
                        catch (Throwable throwable) {
                            this.reader.returnBlock(bloomBlock);
                            throw throwable;
                        }
                    }
                    this.reader.returnBlock(bloomBlock);
                }
                this.reader.returnBlock(bloomBlock);
                return bl;
            }
            this.reader.returnBlock(bloomBlock);
            return true;
        }

        public boolean passesKeyRangeFilter(Scan scan) {
            if (this.getFirstKey() == null || this.getLastKey() == null) {
                return false;
            }
            if (Bytes.equals((byte[])scan.getStartRow(), (byte[])HConstants.EMPTY_START_ROW) && Bytes.equals((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW)) {
                return true;
            }
            byte[] smallestScanRow = scan.isReversed() ? scan.getStopRow() : scan.getStartRow();
            byte[] largestScanRow = scan.isReversed() ? scan.getStartRow() : scan.getStopRow();
            Cell firstKeyKV = this.getFirstKey();
            Cell lastKeyKV = this.getLastKey();
            boolean nonOverLapping = this.getComparator().compareRows(firstKeyKV, largestScanRow, 0, largestScanRow.length) > 0 && !Bytes.equals((byte[])(scan.isReversed() ? scan.getStartRow() : scan.getStopRow()), (byte[])HConstants.EMPTY_END_ROW) || this.getComparator().compareRows(lastKeyKV, smallestScanRow, 0, smallestScanRow.length) < 0;
            return !nonOverLapping;
        }

        public Map<byte[], byte[]> loadFileInfo() throws IOException {
            byte[] cnt;
            Map<byte[], byte[]> fi = this.reader.loadFileInfo();
            byte[] b = fi.get(BLOOM_FILTER_TYPE_KEY);
            if (b != null) {
                this.bloomFilterType = BloomType.valueOf((String)Bytes.toString((byte[])b));
            }
            this.lastBloomKey = fi.get(LAST_BLOOM_KEY);
            if (this.bloomFilterType == BloomType.ROWCOL) {
                this.lastBloomKeyOnlyKV = new KeyValue.KeyOnlyKeyValue(this.lastBloomKey, 0, this.lastBloomKey.length);
            }
            if ((cnt = fi.get(DELETE_FAMILY_COUNT)) != null) {
                this.deleteFamilyCnt = Bytes.toLong((byte[])cnt);
            }
            return fi;
        }

        public void loadBloomfilter() {
            this.loadBloomfilter(BlockType.GENERAL_BLOOM_META);
            this.loadBloomfilter(BlockType.DELETE_FAMILY_BLOOM_META);
        }

        private void loadBloomfilter(BlockType blockType) {
            block11: {
                try {
                    if (blockType == BlockType.GENERAL_BLOOM_META) {
                        if (this.generalBloomFilter != null) {
                            return;
                        }
                        DataInput bloomMeta = this.reader.getGeneralBloomFilterMetadata();
                        if (bloomMeta != null) {
                            if (this.bloomFilterType == BloomType.NONE) {
                                throw new IOException("valid bloom filter type not found in FileInfo");
                            }
                            this.generalBloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, this.reader);
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)("Loaded " + this.bloomFilterType.toString() + " " + this.generalBloomFilter.getClass().getSimpleName() + " metadata for " + this.reader.getName()));
                            }
                        }
                        break block11;
                    }
                    if (blockType == BlockType.DELETE_FAMILY_BLOOM_META) {
                        if (this.deleteFamilyBloomFilter != null) {
                            return;
                        }
                        DataInput bloomMeta = this.reader.getDeleteBloomFilterMetadata();
                        if (bloomMeta != null) {
                            this.deleteFamilyBloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, this.reader);
                            LOG.info((Object)("Loaded Delete Family Bloom (" + this.deleteFamilyBloomFilter.getClass().getSimpleName() + ") metadata for " + this.reader.getName()));
                        }
                        break block11;
                    }
                    throw new RuntimeException("Block Type: " + blockType.toString() + "is not supported for Bloom filter");
                }
                catch (IOException e) {
                    LOG.error((Object)("Error reading bloom filter meta for " + blockType + " -- proceeding without"), (Throwable)e);
                    this.setBloomFilterFaulty(blockType);
                }
                catch (IllegalArgumentException e) {
                    LOG.error((Object)("Bad bloom filter meta " + blockType + " -- proceeding without"), (Throwable)e);
                    this.setBloomFilterFaulty(blockType);
                }
            }
        }

        private void setBloomFilterFaulty(BlockType blockType) {
            if (blockType == BlockType.GENERAL_BLOOM_META) {
                this.setGeneralBloomFilterFaulty();
            } else if (blockType == BlockType.DELETE_FAMILY_BLOOM_META) {
                this.setDeleteFamilyBloomFilterFaulty();
            }
        }

        public long getFilterEntries() {
            return this.generalBloomFilter != null ? this.generalBloomFilter.getKeyCount() : this.reader.getEntries();
        }

        public void setGeneralBloomFilterFaulty() {
            this.generalBloomFilter = null;
        }

        public void setDeleteFamilyBloomFilterFaulty() {
            this.deleteFamilyBloomFilter = null;
        }

        public Cell getLastKey() {
            return this.reader.getLastKey();
        }

        public byte[] getLastRowKey() {
            return this.reader.getLastRowKey();
        }

        public Cell midkey() throws IOException {
            return this.reader.midkey();
        }

        public long length() {
            return this.reader.length();
        }

        public long getTotalUncompressedBytes() {
            return this.reader.getTrailer().getTotalUncompressedBytes();
        }

        public long getEntries() {
            return this.reader.getEntries();
        }

        public long getDeleteFamilyCnt() {
            return this.deleteFamilyCnt;
        }

        public Cell getFirstKey() {
            return this.reader.getFirstKey();
        }

        public long indexSize() {
            return this.reader.indexSize();
        }

        public BloomType getBloomFilterType() {
            return this.bloomFilterType;
        }

        public long getSequenceID() {
            return this.sequenceID;
        }

        public void setSequenceID(long sequenceID) {
            this.sequenceID = sequenceID;
        }

        public void setBulkLoaded(boolean bulkLoadResult) {
            this.bulkLoadResult = bulkLoadResult;
        }

        public boolean isBulkLoaded() {
            return this.bulkLoadResult;
        }

        BloomFilter getGeneralBloomFilter() {
            return this.generalBloomFilter;
        }

        long getUncompressedDataIndexSize() {
            return this.reader.getTrailer().getUncompressedDataIndexSize();
        }

        public long getTotalBloomSize() {
            if (this.generalBloomFilter == null) {
                return 0L;
            }
            return this.generalBloomFilter.getByteSize();
        }

        public int getHFileVersion() {
            return this.reader.getTrailer().getMajorVersion();
        }

        public int getHFileMinorVersion() {
            return this.reader.getTrailer().getMinorVersion();
        }

        public HFile.Reader getHFileReader() {
            return this.reader;
        }

        void disableBloomFilterForTesting() {
            this.generalBloomFilter = null;
            this.deleteFamilyBloomFilter = null;
        }

        public long getMaxTimestamp() {
            return this.timeRangeTracker == null ? Long.MAX_VALUE : this.timeRangeTracker.getMaximumTimestamp();
        }

        boolean isSkipResetSeqId() {
            return this.skipResetSeqId;
        }

        void setSkipResetSeqId(boolean skipResetSeqId) {
            this.skipResetSeqId = skipResetSeqId;
        }
    }

    public static class Writer
    implements Compactor.CellSink {
        private final BloomFilterWriter generalBloomFilterWriter;
        private final BloomFilterWriter deleteFamilyBloomFilterWriter;
        private final BloomType bloomType;
        private byte[] lastBloomKey;
        private int lastBloomKeyOffset;
        private int lastBloomKeyLen;
        private Cell lastCell = null;
        private long earliestPutTs = Long.MAX_VALUE;
        private Cell lastDeleteFamilyCell = null;
        private long deleteFamilyCnt = 0L;
        TimeRangeTracker timeRangeTracker = new TimeRangeTracker();
        boolean isTimeRangeTrackerSet = false;
        protected HFile.Writer writer;
        private KeyValue.KeyOnlyKeyValue lastBloomKeyOnlyKV = null;

        private Writer(FileSystem fs, Path path, Configuration conf, CacheConfig cacheConf, CellComparator comparator, BloomType bloomType, long maxKeys, InetSocketAddress[] favoredNodes, HFileContext fileContext) throws IOException {
            this.writer = HFile.getWriterFactory(conf, cacheConf).withPath(fs, path).withComparator(comparator).withFavoredNodes(favoredNodes).withFileContext(fileContext).create();
            this.generalBloomFilterWriter = BloomFilterFactory.createGeneralBloomAtWrite(conf, cacheConf, bloomType, (int)Math.min(maxKeys, Integer.MAX_VALUE), this.writer);
            if (this.generalBloomFilterWriter != null) {
                this.bloomType = bloomType;
                if (this.bloomType == BloomType.ROWCOL) {
                    this.lastBloomKeyOnlyKV = new KeyValue.KeyOnlyKeyValue();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Bloom filter type for " + path + ": " + this.bloomType + ", " + this.generalBloomFilterWriter.getClass().getSimpleName()));
                }
            } else {
                this.bloomType = BloomType.NONE;
            }
            this.deleteFamilyBloomFilterWriter = this.bloomType != BloomType.ROWCOL ? BloomFilterFactory.createDeleteBloomAtWrite(conf, cacheConf, (int)Math.min(maxKeys, Integer.MAX_VALUE), this.writer) : null;
            if (this.deleteFamilyBloomFilterWriter != null && LOG.isTraceEnabled()) {
                LOG.trace((Object)("Delete Family Bloom filter type for " + path + ": " + this.deleteFamilyBloomFilterWriter.getClass().getSimpleName()));
            }
        }

        public void appendMetadata(long maxSequenceId, boolean majorCompaction) throws IOException {
            this.writer.appendFileInfo(MAX_SEQ_ID_KEY, Bytes.toBytes((long)maxSequenceId));
            this.writer.appendFileInfo(MAJOR_COMPACTION_KEY, Bytes.toBytes((boolean)majorCompaction));
            this.appendTrackedTimestampsToMetadata();
        }

        public void appendMetadata(long maxSequenceId, boolean majorCompaction, long mobCellsCount) throws IOException {
            this.writer.appendFileInfo(MAX_SEQ_ID_KEY, Bytes.toBytes((long)maxSequenceId));
            this.writer.appendFileInfo(MAJOR_COMPACTION_KEY, Bytes.toBytes((boolean)majorCompaction));
            this.writer.appendFileInfo(MOB_CELLS_COUNT, Bytes.toBytes((long)mobCellsCount));
            this.appendTrackedTimestampsToMetadata();
        }

        public void appendTrackedTimestampsToMetadata() throws IOException {
            this.appendFileInfo(TIMERANGE_KEY, WritableUtils.toByteArray((Writable[])new Writable[]{this.timeRangeTracker}));
            this.appendFileInfo(EARLIEST_PUT_TS, Bytes.toBytes((long)this.earliestPutTs));
        }

        public void setTimeRangeTracker(TimeRangeTracker trt) {
            this.timeRangeTracker = trt;
            this.isTimeRangeTrackerSet = true;
        }

        public void trackTimestamps(Cell cell) {
            if (KeyValue.Type.Put.getCode() == cell.getTypeByte()) {
                this.earliestPutTs = Math.min(this.earliestPutTs, cell.getTimestamp());
            }
            if (!this.isTimeRangeTrackerSet) {
                this.timeRangeTracker.includeTimestamp(cell);
            }
        }

        private void appendGeneralBloomfilter(Cell cell) throws IOException {
            if (this.generalBloomFilterWriter != null) {
                boolean newKey = true;
                if (this.lastCell != null) {
                    switch (this.bloomType) {
                        case ROW: {
                            newKey = !CellUtil.matchingRows((Cell)cell, (Cell)this.lastCell);
                            break;
                        }
                        case ROWCOL: {
                            newKey = !CellUtil.matchingRowColumn((Cell)cell, (Cell)this.lastCell);
                            break;
                        }
                        case NONE: {
                            newKey = false;
                            break;
                        }
                        default: {
                            throw new IOException("Invalid Bloom filter type: " + this.bloomType + " (ROW or ROWCOL expected)");
                        }
                    }
                }
                if (newKey) {
                    int bloomKeyLen;
                    int bloomKeyOffset;
                    byte[] bloomKey = null;
                    KeyValue bloomKeyKV = null;
                    switch (this.bloomType) {
                        case ROW: {
                            bloomKey = cell.getRowArray();
                            bloomKeyOffset = cell.getRowOffset();
                            bloomKeyLen = cell.getRowLength();
                            break;
                        }
                        case ROWCOL: {
                            bloomKeyKV = KeyValueUtil.createFirstOnRow((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength(), (byte[])HConstants.EMPTY_BYTE_ARRAY, (int)0, (int)0, (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                            bloomKey = bloomKeyKV.getBuffer();
                            bloomKeyOffset = bloomKeyKV.getKeyOffset();
                            bloomKeyLen = bloomKeyKV.getKeyLength();
                            break;
                        }
                        default: {
                            throw new IOException("Invalid Bloom filter type: " + this.bloomType + " (ROW or ROWCOL expected)");
                        }
                    }
                    this.generalBloomFilterWriter.add(bloomKey, bloomKeyOffset, bloomKeyLen);
                    if (this.lastBloomKey != null) {
                        int res = 0;
                        res = this.bloomType == BloomType.ROW ? Bytes.BYTES_RAWCOMPARATOR.compare(bloomKey, bloomKeyOffset, bloomKeyLen, this.lastBloomKey, this.lastBloomKeyOffset, this.lastBloomKeyLen) : CellComparator.COMPARATOR.compare((Cell)bloomKeyKV, (Cell)this.lastBloomKeyOnlyKV);
                        if (res <= 0) {
                            throw new IOException("Non-increasing Bloom keys: " + Bytes.toStringBinary((byte[])bloomKey, (int)bloomKeyOffset, (int)bloomKeyLen) + " after " + Bytes.toStringBinary((byte[])this.lastBloomKey, (int)this.lastBloomKeyOffset, (int)this.lastBloomKeyLen));
                        }
                    }
                    this.lastBloomKey = bloomKey;
                    this.lastBloomKeyOffset = bloomKeyOffset;
                    this.lastBloomKeyLen = bloomKeyLen;
                    if (this.bloomType == BloomType.ROWCOL) {
                        this.lastBloomKeyOnlyKV.setKey(bloomKey, bloomKeyOffset, bloomKeyLen);
                    }
                    this.lastCell = cell;
                }
            }
        }

        private void appendDeleteFamilyBloomFilter(Cell cell) throws IOException {
            if (!CellUtil.isDeleteFamily((Cell)cell) && !CellUtil.isDeleteFamilyVersion((Cell)cell)) {
                return;
            }
            ++this.deleteFamilyCnt;
            if (null != this.deleteFamilyBloomFilterWriter) {
                boolean newKey = true;
                if (this.lastDeleteFamilyCell != null) {
                    boolean bl = newKey = !CellUtil.matchingRows((Cell)cell, (Cell)this.lastDeleteFamilyCell);
                }
                if (newKey) {
                    this.deleteFamilyBloomFilterWriter.add(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
                    this.lastDeleteFamilyCell = cell;
                }
            }
        }

        @Override
        public void append(Cell cell) throws IOException {
            this.appendGeneralBloomfilter(cell);
            this.appendDeleteFamilyBloomFilter(cell);
            this.writer.append(cell);
            this.trackTimestamps(cell);
        }

        public Path getPath() {
            return this.writer.getPath();
        }

        public boolean hasGeneralBloom() {
            return this.generalBloomFilterWriter != null;
        }

        BloomFilterWriter getGeneralBloomWriter() {
            return this.generalBloomFilterWriter;
        }

        private boolean closeBloomFilter(BloomFilterWriter bfw) throws IOException {
            boolean haveBloom;
            boolean bl = haveBloom = bfw != null && bfw.getKeyCount() > 0L;
            if (haveBloom) {
                bfw.compactBloom();
            }
            return haveBloom;
        }

        private boolean closeGeneralBloomFilter() throws IOException {
            boolean hasGeneralBloom = this.closeBloomFilter(this.generalBloomFilterWriter);
            if (hasGeneralBloom) {
                this.writer.addGeneralBloomFilter(this.generalBloomFilterWriter);
                this.writer.appendFileInfo(BLOOM_FILTER_TYPE_KEY, Bytes.toBytes((String)this.bloomType.toString()));
                if (this.lastBloomKey != null) {
                    this.writer.appendFileInfo(LAST_BLOOM_KEY, Arrays.copyOfRange(this.lastBloomKey, this.lastBloomKeyOffset, this.lastBloomKeyOffset + this.lastBloomKeyLen));
                }
            }
            return hasGeneralBloom;
        }

        private boolean closeDeleteFamilyBloomFilter() throws IOException {
            boolean hasDeleteFamilyBloom = this.closeBloomFilter(this.deleteFamilyBloomFilterWriter);
            if (hasDeleteFamilyBloom) {
                this.writer.addDeleteFamilyBloomFilter(this.deleteFamilyBloomFilterWriter);
            }
            this.writer.appendFileInfo(DELETE_FAMILY_COUNT, Bytes.toBytes((long)this.deleteFamilyCnt));
            return hasDeleteFamilyBloom;
        }

        public void close() throws IOException {
            boolean hasGeneralBloom = this.closeGeneralBloomFilter();
            boolean hasDeleteFamilyBloom = this.closeDeleteFamilyBloomFilter();
            this.writer.close();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)((hasGeneralBloom ? "" : "NO ") + "General Bloom and " + (hasDeleteFamilyBloom ? "" : "NO ") + "DeleteFamily" + " was added to HFile " + this.getPath()));
            }
        }

        public void appendFileInfo(byte[] key, byte[] value) throws IOException {
            this.writer.appendFileInfo(key, value);
        }

        HFile.Writer getHFileWriter() {
            return this.writer;
        }
    }

    @SuppressWarnings(value={"ICAST_INTEGER_MULTIPLY_CAST_TO_LONG"}, justification="Will not overflow")
    public static class WriterBuilder {
        private final Configuration conf;
        private final CacheConfig cacheConf;
        private final FileSystem fs;
        private CellComparator comparator = CellComparator.COMPARATOR;
        private BloomType bloomType = BloomType.NONE;
        private long maxKeyCount = 0L;
        private Path dir;
        private Path filePath;
        private InetSocketAddress[] favoredNodes;
        private HFileContext fileContext;

        public WriterBuilder(Configuration conf, CacheConfig cacheConf, FileSystem fs) {
            this.conf = conf;
            this.cacheConf = cacheConf;
            this.fs = fs;
        }

        public WriterBuilder withOutputDir(Path dir) {
            Preconditions.checkNotNull((Object)dir);
            this.dir = dir;
            return this;
        }

        public WriterBuilder withFilePath(Path filePath) {
            Preconditions.checkNotNull((Object)filePath);
            this.filePath = filePath;
            return this;
        }

        public WriterBuilder withFavoredNodes(InetSocketAddress[] favoredNodes) {
            this.favoredNodes = favoredNodes;
            return this;
        }

        public WriterBuilder withComparator(CellComparator comparator) {
            Preconditions.checkNotNull((Object)comparator);
            this.comparator = comparator;
            return this;
        }

        public WriterBuilder withBloomType(BloomType bloomType) {
            Preconditions.checkNotNull((Object)bloomType);
            this.bloomType = bloomType;
            return this;
        }

        public WriterBuilder withMaxKeyCount(long maxKeyCount) {
            this.maxKeyCount = maxKeyCount;
            return this;
        }

        public WriterBuilder withFileContext(HFileContext fileContext) {
            this.fileContext = fileContext;
            return this;
        }

        public WriterBuilder withShouldDropCacheBehind(boolean shouldDropCacheBehind) {
            return this;
        }

        public Writer build() throws IOException {
            if ((this.dir == null ? 0 : 1) + (this.filePath == null ? 0 : 1) != 1) {
                throw new IllegalArgumentException("Either specify parent directory or file path");
            }
            if (this.dir == null) {
                this.dir = this.filePath.getParent();
            }
            if (!this.fs.exists(this.dir)) {
                this.fs.mkdirs(this.dir);
            }
            if (this.filePath == null) {
                this.filePath = StoreFile.getUniqueFile(this.fs, this.dir);
                if (!BloomFilterFactory.isGeneralBloomEnabled(this.conf)) {
                    this.bloomType = BloomType.NONE;
                }
            }
            if (this.comparator == null) {
                this.comparator = CellComparator.COMPARATOR;
            }
            return new Writer(this.fs, this.filePath, this.conf, this.cacheConf, this.comparator, this.bloomType, this.maxKeyCount, this.favoredNodes, this.fileContext);
        }
    }
}

