/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class DateTieredCompactionPolicy
extends RatioBasedCompactionPolicy {
    private static final Log LOG = LogFactory.getLog(DateTieredCompactionPolicy.class);
    private RatioBasedCompactionPolicy compactionPolicyPerWindow;

    public DateTieredCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) throws IOException {
        super(conf, storeConfigInfo);
        try {
            this.compactionPolicyPerWindow = (RatioBasedCompactionPolicy)ReflectionUtils.instantiateWithCustomCtor((String)this.comConf.getCompactionPolicyForTieredWindow(), (Class[])new Class[]{Configuration.class, StoreConfigInformation.class}, (Object[])new Object[]{conf, storeConfigInfo});
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured compaction policy '" + this.comConf.getCompactionPolicyForTieredWindow() + "'", e);
        }
    }

    @Override
    public boolean isMajorCompaction(Collection<StoreFile> filesToCompact) throws IOException {
        return false;
    }

    @Override
    public boolean needsCompaction(Collection<StoreFile> storeFiles, List<StoreFile> filesCompacting) {
        return this.needsCompaction(storeFiles, filesCompacting, EnvironmentEdgeManager.currentTime());
    }

    @VisibleForTesting
    public boolean needsCompaction(Collection<StoreFile> storeFiles, List<StoreFile> filesCompacting, long now) {
        if (!super.needsCompaction(storeFiles, filesCompacting)) {
            return false;
        }
        ArrayList<StoreFile> candidates = new ArrayList<StoreFile>(storeFiles);
        candidates = this.filterBulk(candidates);
        candidates = this.skipLargeFiles(candidates, true);
        try {
            candidates = this.applyCompactionPolicy(candidates, true, false, now);
        }
        catch (Exception e) {
            LOG.error((Object)"Can not check for compaction: ", (Throwable)e);
            return false;
        }
        return candidates != null && candidates.size() >= this.comConf.getMinFilesToCompact();
    }

    @Override
    public ArrayList<StoreFile> applyCompactionPolicy(ArrayList<StoreFile> candidates, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        return this.applyCompactionPolicy(candidates, mayUseOffPeak, mayBeStuck, EnvironmentEdgeManager.currentTime());
    }

    @VisibleForTesting
    public ArrayList<StoreFile> applyCompactionPolicy(ArrayList<StoreFile> candidates, boolean mayUseOffPeak, boolean mayBeStuck, long now) throws IOException {
        Iterable<StoreFile> candidatesInWindow = DateTieredCompactionPolicy.filterOldStoreFiles(Lists.newArrayList(candidates), this.comConf.getMaxStoreFileAgeMillis(), now);
        List<ArrayList<StoreFile>> buckets = DateTieredCompactionPolicy.partitionFilesToBuckets(candidatesInWindow, this.comConf.getBaseWindowMillis(), this.comConf.getWindowsPerTier(), now);
        LOG.debug((Object)("Compaction buckets are: " + buckets));
        if ((long)buckets.size() >= this.storeConfigInfo.getBlockingFileCount()) {
            LOG.warn((Object)("Number of compaction buckets:" + buckets.size() + ", exceeds blocking file count setting: " + this.storeConfigInfo.getBlockingFileCount() + ", either increase hbase.hstore.blockingStoreFiles or " + "reduce the number of tiered compaction windows"));
        }
        return this.newestBucket(buckets, this.comConf.getIncomingWindowMin(), now, this.comConf.getBaseWindowMillis(), mayUseOffPeak);
    }

    private ArrayList<StoreFile> newestBucket(List<ArrayList<StoreFile>> buckets, int incomingWindowThreshold, long now, long baseWindowMillis, boolean mayUseOffPeak) throws IOException {
        Window incomingWindow = DateTieredCompactionPolicy.getInitialWindow(now, baseWindowMillis);
        for (ArrayList<StoreFile> bucket : buckets) {
            int minThreshold = incomingWindow.compareToTimestamp(bucket.get(0).getMaximumTimestamp()) <= 0 ? this.comConf.getIncomingWindowMin() : this.comConf.getMinFilesToCompact();
            this.compactionPolicyPerWindow.setMinThreshold(minThreshold);
            ArrayList<StoreFile> candidates = this.compactionPolicyPerWindow.applyCompactionPolicy(bucket, mayUseOffPeak, false);
            if (candidates == null || candidates.isEmpty()) continue;
            return candidates;
        }
        return null;
    }

    private static List<ArrayList<StoreFile>> partitionFilesToBuckets(Iterable<StoreFile> storeFiles, long baseWindowSizeMillis, int windowsPerTier, long now) {
        ArrayList buckets = Lists.newArrayList();
        Window window = DateTieredCompactionPolicy.getInitialWindow(now, baseWindowSizeMillis);
        ArrayList storefileMaxTimestampPairs = Lists.newArrayListWithCapacity((int)Iterables.size(storeFiles));
        long maxTimestampSeen = Long.MIN_VALUE;
        for (StoreFile storeFile : storeFiles) {
            maxTimestampSeen = Math.max(maxTimestampSeen, storeFile.getMaximumTimestamp());
            storefileMaxTimestampPairs.add(new Pair((Object)storeFile, (Object)maxTimestampSeen));
        }
        Collections.reverse(storefileMaxTimestampPairs);
        PeekingIterator it = Iterators.peekingIterator(storefileMaxTimestampPairs.iterator());
        while (it.hasNext()) {
            int compResult = window.compareToTimestamp((Long)((Pair)it.peek()).getSecond());
            if (compResult > 0) {
                window = window.nextWindow(windowsPerTier);
                continue;
            }
            ArrayList bucket = Lists.newArrayList();
            while (it.hasNext() && window.compareToTimestamp((Long)((Pair)it.peek()).getSecond()) <= 0) {
                bucket.add(((Pair)it.next()).getFirst());
            }
            if (bucket.isEmpty()) continue;
            buckets.add(bucket);
        }
        return buckets;
    }

    private static Iterable<StoreFile> filterOldStoreFiles(List<StoreFile> storeFiles, long maxAge, long now) {
        if (maxAge == 0L) {
            return ImmutableList.of();
        }
        final long cutoff = now - maxAge;
        return Iterables.filter(storeFiles, (Predicate)new Predicate<StoreFile>(){

            public boolean apply(StoreFile storeFile) {
                if (storeFile == null) {
                    return false;
                }
                return storeFile.getMaximumTimestamp() >= cutoff;
            }
        });
    }

    private static Window getInitialWindow(long now, long timeUnit) {
        return new Window(timeUnit, now / timeUnit);
    }

    private static final class Window {
        private final long windowMillis;
        private final long divPosition;

        private Window(long baseWindowMillis, long divPosition) {
            this.windowMillis = baseWindowMillis;
            this.divPosition = divPosition;
        }

        public int compareToTimestamp(long timestamp) {
            long pos = timestamp / this.windowMillis;
            return this.divPosition == pos ? 0 : (this.divPosition < pos ? -1 : 1);
        }

        public Window nextWindow(int windowsPerTier) {
            if (this.divPosition % (long)windowsPerTier > 0L) {
                return new Window(this.windowMillis, this.divPosition - 1L);
            }
            return new Window(this.windowMillis * (long)windowsPerTier, this.divPosition / (long)windowsPerTier - 1L);
        }
    }
}

