/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;

@InterfaceAudience.Private
class FSWALEntry
extends WAL.Entry {
    private final transient long sequence;
    private final transient boolean inMemstore;
    private final transient HRegionInfo hri;
    private final Set<byte[]> familyNames;

    FSWALEntry(long sequence, WALKey key, WALEdit edit, HRegionInfo hri, boolean inMemstore) {
        super(key, edit);
        this.inMemstore = inMemstore;
        this.hri = hri;
        this.sequence = sequence;
        if (inMemstore) {
            ArrayList<Cell> cells = this.getEdit().getCells();
            if (CollectionUtils.isEmpty(cells)) {
                this.familyNames = Collections.emptySet();
            } else {
                TreeSet familySet = Sets.newTreeSet((Comparator)Bytes.BYTES_COMPARATOR);
                for (Cell cell : cells) {
                    if (CellUtil.matchingFamily((Cell)cell, (byte[])WALEdit.METAFAMILY)) continue;
                    familySet.add(CellUtil.cloneFamily((Cell)cell));
                }
                this.familyNames = Collections.unmodifiableSet(familySet);
            }
        } else {
            this.familyNames = Collections.emptySet();
        }
    }

    @Override
    public String toString() {
        return "sequence=" + this.sequence + ", " + super.toString();
    }

    boolean isInMemstore() {
        return this.inMemstore;
    }

    HRegionInfo getHRegionInfo() {
        return this.hri;
    }

    long getSequence() {
        return this.sequence;
    }

    long stampRegionSequenceId() throws IOException {
        long regionSequenceId = -1L;
        MultiVersionConcurrencyControl mvcc = this.getKey().getMvcc();
        MultiVersionConcurrencyControl.WriteEntry we = null;
        if (mvcc != null) {
            we = mvcc.begin();
            regionSequenceId = we.getWriteNumber();
        }
        if (!this.getEdit().isReplay() && this.inMemstore) {
            for (Cell c : this.getEdit().getCells()) {
                CellUtil.setSequenceId((Cell)c, (long)regionSequenceId);
            }
        }
        this.getKey().setWriteEntry(we);
        return regionSequenceId;
    }

    Set<byte[]> getFamilyNames() {
        return this.familyNames;
    }
}

