/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;

public class TableCfWALEntryFilter
implements WALEntryFilter {
    private static final Log LOG = LogFactory.getLog(TableCfWALEntryFilter.class);
    private final ReplicationPeer peer;

    public TableCfWALEntryFilter(ReplicationPeer peer) {
        this.peer = peer;
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        TableName tabName = entry.getKey().getTablename();
        ArrayList<Cell> cells = entry.getEdit().getCells();
        Map tableCFs = null;
        try {
            tableCFs = this.peer.getTableCFs();
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("should not happen: can't get tableCFs for peer " + this.peer.getId() + ", degenerate as if it's not configured by keeping tableCFs==null"));
        }
        int size = cells.size();
        if (tableCFs == null) {
            return entry;
        }
        if (!tableCFs.containsKey(tabName)) {
            return null;
        }
        List cfs = (List)tableCFs.get(tabName);
        for (int i = size - 1; i >= 0; --i) {
            Cell cell = cells.get(i);
            if (CellUtil.matchingColumn((Cell)cell, (byte[])WALEdit.METAFAMILY, (byte[])WALEdit.BULK_LOAD)) {
                Cell filteredBulkLoadEntryCell = this.filterBulkLoadEntries(cfs, cell);
                if (filteredBulkLoadEntryCell != null) {
                    cells.set(i, filteredBulkLoadEntryCell);
                    continue;
                }
                cells.remove(i);
                continue;
            }
            if (cfs == null || cfs.contains(Bytes.toString((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()))) continue;
            cells.remove(i);
        }
        if (cells.size() < size / 2) {
            cells.trimToSize();
        }
        return entry;
    }

    private Cell filterBulkLoadEntries(List<String> cfs, Cell cell) {
        WALProtos.BulkLoadDescriptor bld = null;
        try {
            bld = WALEdit.getBulkLoadDescriptor(cell);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to get bulk load events information from the WAL file.", (Throwable)e);
            return cell;
        }
        List storesList = bld.getStoresList();
        ArrayList copiedStoresList = new ArrayList(storesList);
        Iterator copiedStoresListIterator = copiedStoresList.iterator();
        boolean anyStoreRemoved = false;
        while (copiedStoresListIterator.hasNext()) {
            WALProtos.StoreDescriptor sd = (WALProtos.StoreDescriptor)copiedStoresListIterator.next();
            byte[] fam = sd.getFamilyName().toByteArray();
            if (cfs == null || cfs.contains(Bytes.toString((byte[])fam))) continue;
            copiedStoresListIterator.remove();
            anyStoreRemoved = true;
        }
        if (!anyStoreRemoved) {
            return cell;
        }
        if (copiedStoresList.isEmpty()) {
            return null;
        }
        WALProtos.BulkLoadDescriptor.Builder newDesc = WALProtos.BulkLoadDescriptor.newBuilder().setTableName(bld.getTableName()).setEncodedRegionName(bld.getEncodedRegionName()).setBulkloadSeqNum(bld.getBulkloadSeqNum());
        newDesc.addAllStores(copiedStoresList);
        WALProtos.BulkLoadDescriptor newBulkLoadDescriptor = newDesc.build();
        return CellUtil.createCell((byte[])CellUtil.cloneRow((Cell)cell), (byte[])WALEdit.METAFAMILY, (byte[])WALEdit.BULK_LOAD, (long)cell.getTimestamp(), (byte)cell.getTypeByte(), (byte[])newBulkLoadDescriptor.toByteArray());
    }
}

