/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Service;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.protobuf.ReplicationProtbufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.replication.HBaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSinkManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class HBaseInterClusterReplicationEndpoint
extends HBaseReplicationEndpoint {
    private static final Log LOG = LogFactory.getLog(HBaseInterClusterReplicationEndpoint.class);
    private HConnection conn;
    private Configuration conf;
    private long sleepForRetries;
    private int maxRetriesMultiplier;
    private int socketTimeoutMultiplier;
    private MetricsSource metrics;
    private ReplicationSinkManager replicationSinkMgr;
    private boolean peersSelected = false;
    private String replicationClusterId = "";
    private ThreadPoolExecutor exec;
    private int maxThreads;
    private Path baseNamespaceDir;
    private Path hfileArchiveDir;
    private boolean replicationBulkLoadDataEnabled;

    @Override
    public void init(ReplicationEndpoint.Context context) throws IOException {
        super.init(context);
        this.conf = HBaseConfiguration.create((Configuration)this.ctx.getConfiguration());
        this.decorateConf();
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.maxretriesmultiplier", 300);
        this.socketTimeoutMultiplier = this.conf.getInt("replication.source.socketTimeoutMultiplier", this.maxRetriesMultiplier);
        this.conn = (HConnection)ConnectionFactory.createConnection((Configuration)this.conf);
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.metrics = context.getMetrics();
        this.replicationSinkMgr = new ReplicationSinkManager(this.conn, this.ctx.getPeerId(), this, this.conf);
        this.maxThreads = this.conf.getInt("hbase.replication.source.maxthreads", 10);
        this.exec = new ThreadPoolExecutor(this.maxThreads, this.maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.exec.allowCoreThreadTimeOut(true);
        this.replicationBulkLoadDataEnabled = this.conf.getBoolean("hbase.replication.bulkload.enabled", false);
        if (this.replicationBulkLoadDataEnabled) {
            this.replicationClusterId = this.conf.get("hbase.replication.cluster.id");
        }
        Path rootDir = FSUtils.getRootDir(this.conf);
        Path baseNSDir = new Path("data");
        this.baseNamespaceDir = new Path(rootDir, baseNSDir);
        this.hfileArchiveDir = new Path(rootDir, new Path("archive", baseNSDir));
    }

    private void decorateConf() {
        String replicationCodec = this.conf.get("hbase.replication.rpc.codec");
        if (StringUtils.isNotEmpty((String)replicationCodec)) {
            this.conf.set("hbase.client.rpc.codec", replicationCodec);
        }
    }

    private void connectToPeers() {
        this.getRegionServers();
        int sleepMultiplier = 1;
        while (this.isRunning() && this.replicationSinkMgr.getNumSinks() == 0) {
            this.replicationSinkMgr.chooseSinks();
            if (!this.isRunning() || this.replicationSinkMgr.getNumSinks() != 0 || !this.sleepForRetries("Waiting for peers", sleepMultiplier)) continue;
            ++sleepMultiplier;
        }
    }

    protected boolean sleepForRetries(String msg, int sleepMultiplier) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(msg + ", sleeping " + this.sleepForRetries + " times " + sleepMultiplier));
            }
            Thread.sleep(this.sleepForRetries * (long)sleepMultiplier);
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Interrupted while sleeping between retries");
        }
        return sleepMultiplier < this.maxRetriesMultiplier;
    }

    @Override
    public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
        int numSinks;
        ExecutorCompletionService<Integer> pool = new ExecutorCompletionService<Integer>(this.exec);
        List<WAL.Entry> entries = replicateContext.getEntries();
        String walGroupId = replicateContext.getWalGroupId();
        int sleepMultiplier = 1;
        int numReplicated = 0;
        if (!this.peersSelected && this.isRunning()) {
            this.connectToPeers();
            this.peersSelected = true;
        }
        if ((numSinks = this.replicationSinkMgr.getNumSinks()) == 0) {
            LOG.warn((Object)"No replication sinks found, returning without replicating. The source should retry with the same set of edits.");
            return false;
        }
        int n = Math.min(Math.min(this.maxThreads, entries.size() / 100 + 1), numSinks);
        ArrayList<List<WAL.Entry>> entryLists = new ArrayList<List<WAL.Entry>>(n);
        if (n == 1) {
            entryLists.add(entries);
        } else {
            for (int i = 0; i < n; ++i) {
                entryLists.add(new ArrayList(entries.size() / n + 1));
            }
            for (WAL.Entry e : entries) {
                ((List)entryLists.get(Math.abs(Bytes.hashCode((byte[])e.getKey().getEncodedRegionName()) % n))).add(e);
            }
        }
        while (this.isRunning()) {
            if (!this.isPeerEnabled()) {
                if (!this.sleepForRetries("Replication is disabled", sleepMultiplier)) continue;
                ++sleepMultiplier;
                continue;
            }
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Replicating " + entries.size() + " entries of total size " + replicateContext.getSize()));
                }
                int futures = 0;
                for (int i = 0; i < entryLists.size(); ++i) {
                    if (((List)entryLists.get(i)).isEmpty()) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Submitting " + ((List)entryLists.get(i)).size() + " entries of total size " + replicateContext.getSize()));
                    }
                    pool.submit(this.createReplicator((List)entryLists.get(i), i));
                    ++futures;
                }
                IOException iox = null;
                for (int i = 0; i < futures; ++i) {
                    try {
                        Future f = pool.take();
                        int index = (Integer)f.get();
                        int batchSize = ((List)entryLists.get(index)).size();
                        entryLists.set(index, Collections.emptyList());
                        numReplicated += batchSize;
                        continue;
                    }
                    catch (InterruptedException ie) {
                        iox = new IOException(ie);
                        continue;
                    }
                    catch (ExecutionException ee) {
                        iox = (IOException)ee.getCause();
                    }
                }
                if (iox != null) {
                    throw iox;
                }
                if (numReplicated != entries.size()) {
                    LOG.warn((Object)"The number of edits replicated is different from the number received, failing for now.");
                    return false;
                }
                this.metrics.setAgeOfLastShippedOp(entries.get(entries.size() - 1).getKey().getWriteTime(), walGroupId);
                return true;
            }
            catch (IOException ioe) {
                this.metrics.refreshAgeOfLastShippedOp(walGroupId);
                if (ioe instanceof RemoteException) {
                    ioe = ((RemoteException)ioe).unwrapRemoteException();
                    LOG.warn((Object)"Can't replicate because of an error on the remote cluster: ", (Throwable)ioe);
                    if (ioe instanceof TableNotFoundException && this.sleepForRetries("A table is missing in the peer cluster. Replication cannot proceed without losing data.", sleepMultiplier)) {
                        ++sleepMultiplier;
                    }
                } else if (ioe instanceof SocketTimeoutException) {
                    this.sleepForRetries("Encountered a SocketTimeoutException. Since the call to the remote cluster timed out, which is usually caused by a machine failure or a massive slowdown", this.socketTimeoutMultiplier);
                } else if (ioe instanceof ConnectException) {
                    LOG.warn((Object)"Peer is unavailable, rechecking all sinks: ", (Throwable)ioe);
                    this.replicationSinkMgr.chooseSinks();
                } else {
                    LOG.warn((Object)"Can't replicate because of a local or network error: ", (Throwable)ioe);
                }
                if (!this.sleepForRetries("Since we are unable to replicate", sleepMultiplier)) continue;
                ++sleepMultiplier;
            }
        }
        return false;
    }

    protected boolean isPeerEnabled() {
        return this.ctx.getReplicationPeer().getPeerState() == ReplicationPeer.PeerState.ENABLED;
    }

    @Override
    protected void doStop() {
        this.disconnect();
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to close the connection");
            }
        }
        this.exec.shutdownNow();
        this.notifyStopped();
    }

    public Service.State stopAndWait() {
        this.doStop();
        return super.stopAndWait();
    }

    @VisibleForTesting
    protected Replicator createReplicator(List<WAL.Entry> entries, int ordinal) {
        return new Replicator(entries, ordinal);
    }

    @VisibleForTesting
    protected class Replicator
    implements Callable<Integer> {
        private List<WAL.Entry> entries;
        private int ordinal;

        public Replicator(List<WAL.Entry> entries, int ordinal) {
            this.entries = entries;
            this.ordinal = ordinal;
        }

        @Override
        public Integer call() throws IOException {
            ReplicationSinkManager.SinkPeer sinkPeer = null;
            try {
                sinkPeer = HBaseInterClusterReplicationEndpoint.this.replicationSinkMgr.getReplicationSink();
                AdminProtos.AdminService.BlockingInterface rrs = sinkPeer.getRegionServer();
                ReplicationProtbufUtil.replicateWALEntry(rrs, this.entries.toArray(new WAL.Entry[this.entries.size()]), HBaseInterClusterReplicationEndpoint.this.replicationClusterId, HBaseInterClusterReplicationEndpoint.this.baseNamespaceDir, HBaseInterClusterReplicationEndpoint.this.hfileArchiveDir);
                HBaseInterClusterReplicationEndpoint.this.replicationSinkMgr.reportSinkSuccess(sinkPeer);
                return this.ordinal;
            }
            catch (IOException ioe) {
                if (sinkPeer != null) {
                    HBaseInterClusterReplicationEndpoint.this.replicationSinkMgr.reportBadSink(sinkPeer);
                }
                throw ioe;
            }
        }
    }
}

