/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public final class SnapshotManifestV1 {
    private static final Log LOG = LogFactory.getLog(SnapshotManifestV1.class);
    public static final int DESCRIPTOR_VERSION = 0;

    private SnapshotManifestV1() {
    }

    static List<SnapshotProtos.SnapshotRegionManifest> loadRegionManifests(final Configuration conf, Executor executor, final FileSystem fs, final Path snapshotDir, HBaseProtos.SnapshotDescription desc) throws IOException {
        FileStatus[] regions = FSUtils.listStatus(fs, snapshotDir, new FSUtils.RegionDirFilter(fs));
        if (regions == null) {
            LOG.info((Object)("No regions under directory:" + snapshotDir));
            return null;
        }
        ExecutorCompletionService<SnapshotProtos.SnapshotRegionManifest> completionService = new ExecutorCompletionService<SnapshotProtos.SnapshotRegionManifest>(executor);
        for (final FileStatus region : regions) {
            completionService.submit(new Callable<SnapshotProtos.SnapshotRegionManifest>(){

                @Override
                public SnapshotProtos.SnapshotRegionManifest call() throws IOException {
                    HRegionInfo hri = HRegionFileSystem.loadRegionInfoFileContent(fs, region.getPath());
                    return SnapshotManifestV1.buildManifestFromDisk(conf, fs, snapshotDir, hri);
                }
            });
        }
        ArrayList<SnapshotProtos.SnapshotRegionManifest> regionsManifest = new ArrayList<SnapshotProtos.SnapshotRegionManifest>(regions.length);
        try {
            for (int i = 0; i < regions.length; ++i) {
                regionsManifest.add((SnapshotProtos.SnapshotRegionManifest)completionService.take().get());
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (ExecutionException e) {
            IOException ex = new IOException();
            ex.initCause(e.getCause());
            throw ex;
        }
        return regionsManifest;
    }

    static void deleteRegionManifest(FileSystem fs, Path snapshotDir, SnapshotProtos.SnapshotRegionManifest manifest) throws IOException {
        String regionName = SnapshotManifest.getRegionNameFromManifest(manifest);
        fs.delete(new Path(snapshotDir, regionName), true);
    }

    static SnapshotProtos.SnapshotRegionManifest buildManifestFromDisk(Configuration conf, FileSystem fs, Path tableDir, HRegionInfo regionInfo) throws IOException {
        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(conf, fs, tableDir, regionInfo, true);
        SnapshotProtos.SnapshotRegionManifest.Builder manifest = SnapshotProtos.SnapshotRegionManifest.newBuilder();
        LOG.debug((Object)"Storing region-info for snapshot.");
        manifest.setRegionInfo(HRegionInfo.convert((HRegionInfo)regionInfo));
        LOG.debug((Object)"Creating references for hfiles");
        Collection<String> familyNames = regionFs.getFamilies();
        if (familyNames != null) {
            for (String familyName : familyNames) {
                Collection<StoreFileInfo> storeFiles = regionFs.getStoreFiles(familyName, false);
                if (storeFiles == null) {
                    LOG.debug((Object)("No files under family: " + familyName));
                    continue;
                }
                SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder family = SnapshotProtos.SnapshotRegionManifest.FamilyFiles.newBuilder();
                family.setFamilyName(ByteStringer.wrap((byte[])Bytes.toBytes((String)familyName)));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding snapshot references for " + storeFiles + " hfiles"));
                }
                int i = 0;
                int sz = storeFiles.size();
                for (StoreFileInfo storeFile : storeFiles) {
                    LOG.debug((Object)("Adding reference for file (" + ++i + "/" + sz + "): " + storeFile.getPath()));
                    SnapshotProtos.SnapshotRegionManifest.StoreFile.Builder sfManifest = SnapshotProtos.SnapshotRegionManifest.StoreFile.newBuilder();
                    sfManifest.setName(storeFile.getPath().getName());
                    family.addStoreFiles(sfManifest.build());
                }
                manifest.addFamilyFiles(family.build());
            }
        }
        return manifest.build();
    }

    static class ManifestBuilder
    implements SnapshotManifest.RegionVisitor<HRegionFileSystem, Path> {
        private final Configuration conf;
        private final Path snapshotDir;
        private final FileSystem fs;

        public ManifestBuilder(Configuration conf, FileSystem fs, Path snapshotDir) {
            this.snapshotDir = snapshotDir;
            this.conf = conf;
            this.fs = fs;
        }

        @Override
        public HRegionFileSystem regionOpen(HRegionInfo regionInfo) throws IOException {
            HRegionFileSystem snapshotRegionFs = HRegionFileSystem.createRegionOnFileSystem(this.conf, this.fs, this.snapshotDir, regionInfo);
            return snapshotRegionFs;
        }

        @Override
        public void regionClose(HRegionFileSystem region) {
        }

        @Override
        public Path familyOpen(HRegionFileSystem snapshotRegionFs, byte[] familyName) {
            Path familyDir = snapshotRegionFs.getStoreDir(Bytes.toString((byte[])familyName));
            return familyDir;
        }

        @Override
        public void familyClose(HRegionFileSystem region, Path family) {
        }

        @Override
        public void storeFile(HRegionFileSystem region, Path familyDir, StoreFileInfo storeFile) throws IOException {
            Path referenceFile = new Path(familyDir, storeFile.getPath().getName());
            boolean success = true;
            if (storeFile.isReference()) {
                storeFile.getReference().write(this.fs, referenceFile);
            } else {
                success = this.fs.createNewFile(referenceFile);
            }
            if (!success) {
                throw new IOException("Failed to create reference file:" + referenceFile);
            }
        }
    }
}

