/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class AssignmentManagerStatusTmplImpl
extends AbstractTemplateImpl
implements AssignmentManagerStatusTmpl.Intf {
    private final AssignmentManager assignmentManager;
    private final int limit;

    protected static AssignmentManagerStatusTmpl.ImplData __jamon_setOptionalArguments(AssignmentManagerStatusTmpl.ImplData p_implData) {
        if (!p_implData.getLimit__IsNotDefault()) {
            p_implData.setLimit(100);
        }
        return p_implData;
    }

    public AssignmentManagerStatusTmplImpl(TemplateManager p_templateManager, AssignmentManagerStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)AssignmentManagerStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.assignmentManager = p_implData.getAssignmentManager();
        this.limit = p_implData.getLimit();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        Map<String, RegionState> rit = this.assignmentManager.getRegionStates().getRegionsInTransitionOrderedByTimestamp();
        if (!rit.isEmpty()) {
            jamonWriter.write("\n");
            ArrayList<String> ritsOverThreshold = new ArrayList<String>();
            ArrayList<String> ritsTwiceThreshold = new ArrayList<String>();
            Configuration conf = HBaseConfiguration.create();
            int ritThreshold = conf.getInt("hbase.metrics.rit.stuck.warning.threshold", 60000);
            int numOfRITOverThreshold = 0;
            long currentTime = System.currentTimeMillis();
            for (Map.Entry<String, RegionState> e : rit.entrySet()) {
                long ritTime = currentTime - e.getValue().getStamp();
                if (ritTime > (long)(ritThreshold * 2)) {
                    ++numOfRITOverThreshold;
                    ritsTwiceThreshold.add(e.getKey());
                    continue;
                }
                if (ritTime <= (long)ritThreshold) continue;
                ++numOfRITOverThreshold;
                ritsOverThreshold.add(e.getKey());
            }
            int numOfRITs = rit.size();
            int ritsPerPage = Math.min(5, numOfRITs);
            int numOfPages = (int)Math.ceil((double)numOfRITs * 1.0 / (double)ritsPerPage);
            jamonWriter.write("<section>\n    <h2>Regions in Transition</h2>\n     <p>");
            Escaping.HTML.write(StandardEmitter.valueOf((int)numOfRITs), jamonWriter);
            jamonWriter.write(" region(s) in transition.  \n     ");
            if (!ritsTwiceThreshold.isEmpty()) {
                jamonWriter.write("\n         <span class=\"label label-danger\" style=\"font-size:100%;font-weight:normal\">\n     ");
            } else if (!ritsOverThreshold.isEmpty()) {
                jamonWriter.write("\n         <span class=\"label label-warning\" style=\"font-size:100%;font-weight:normal\">\n     ");
            } else {
                jamonWriter.write("\n         <span>\n     ");
            }
            jamonWriter.write("\n         ");
            Escaping.HTML.write(StandardEmitter.valueOf((int)numOfRITOverThreshold), jamonWriter);
            jamonWriter.write(" region(s) in transition for \n             more than ");
            Escaping.HTML.write(StandardEmitter.valueOf((int)ritThreshold), jamonWriter);
            jamonWriter.write(" milliseconds.\n         </span>\n     </p>\n     <div class=\"tabbable\">\n         <div class=\"tab-content\">\n         ");
            int recordItr = 0;
            for (Map.Entry<String, RegionState> entry : rit.entrySet()) {
                jamonWriter.write("\n             ");
                if (recordItr % ritsPerPage == 0) {
                    jamonWriter.write("\n                 ");
                    if (recordItr == 0) {
                        jamonWriter.write("\n             <div class=\"tab-pane active\" id=\"tab_rits");
                        Escaping.HTML.write(StandardEmitter.valueOf((int)(recordItr / ritsPerPage + 1)), jamonWriter);
                        jamonWriter.write("\">\n                 ");
                    } else {
                        jamonWriter.write("\n             <div class=\"tab-pane\" id=\"tab_rits");
                        Escaping.HTML.write(StandardEmitter.valueOf((int)(recordItr / ritsPerPage + 1)), jamonWriter);
                        jamonWriter.write("\">\n                 ");
                    }
                    jamonWriter.write("\n                 <table class=\"table table-striped\" style=\"margin-bottom:0px;\"><tr><th>Region</th>\n                     <th>State</th><th>RIT time (ms)</th></tr>\n             ");
                }
                jamonWriter.write("\n \n             ");
                if (ritsOverThreshold.contains(entry.getKey())) {
                    jamonWriter.write("\n                     <tr class=\"alert alert-warning\" role=\"alert\">\n             ");
                } else if (ritsTwiceThreshold.contains(entry.getKey())) {
                    jamonWriter.write("\n                     <tr class=\"alert alert-danger\" role=\"alert\">\n            ");
                } else {
                    jamonWriter.write("\n                    <tr>\n            ");
                }
                jamonWriter.write("\n                         <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)entry.getKey()), jamonWriter);
                jamonWriter.write("</td><td>\n                         ");
                Escaping.HTML.write(StandardEmitter.valueOf((String)HRegionInfo.getDescriptiveNameFromRegionStateForDisplay((RegionState)entry.getValue(), (Configuration)conf)), jamonWriter);
                jamonWriter.write("</td>\n                         <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((long)(currentTime - entry.getValue().getStamp())), jamonWriter);
                jamonWriter.write(" </td>\n                     </tr>\n                     ");
                if (++recordItr % ritsPerPage == 0) {
                    jamonWriter.write("\n                 </table>\n             </div>\n         ");
                }
                jamonWriter.write("\n         ");
            }
            jamonWriter.write("\n  \n         ");
            if (recordItr % ritsPerPage != 0) {
                jamonWriter.write("\n             ");
                while (recordItr % ritsPerPage != 0) {
                    jamonWriter.write("\n             <tr><td colspan=\"3\" style=\"height:61px\"></td></tr>\n             ");
                    ++recordItr;
                }
                jamonWriter.write("\n                   </table>\n             </div>\n         ");
            }
            jamonWriter.write("\n         </div>\n         <nav>\n             <ul class=\"nav nav-pills pagination\">\n             ");
            for (int i = 1; i <= numOfPages; ++i) {
                jamonWriter.write("\n                 ");
                if (i == 1) {
                    jamonWriter.write("\n                 <li class=\"active\">\n                 ");
                } else {
                    jamonWriter.write("\n                 <li>\n                 ");
                }
                jamonWriter.write("\n                 <a href=\"#tab_rits");
                Escaping.HTML.write(StandardEmitter.valueOf((int)i), jamonWriter);
                jamonWriter.write("\">");
                Escaping.HTML.write(StandardEmitter.valueOf((int)i), jamonWriter);
                jamonWriter.write("</a></li>\n             ");
            }
            jamonWriter.write("\n             </ul>\n         </nav>\n     </div>\n   </section>\n ");
        }
        jamonWriter.write("\n\n");
    }
}

