/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemLinkResolver;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.FanOutOneBlockAsyncDFSOutput;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.datatransfer.PipelineAck;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
public class FanOutOneBlockAsyncDFSOutputHelper {
    private static final Log LOG = LogFactory.getLog(FanOutOneBlockAsyncDFSOutputHelper.class);
    private static final ByteBufAllocator ALLOC = PooledByteBufAllocator.DEFAULT;
    public static final long HEART_BEAT_SEQNO = -1L;
    private static final Method CREATE_CHECKSUM;
    private static final PipelineAckStatusGetter PIPELINE_ACK_STATUS_GETTER;
    private static final StorageTypeSetter STORAGE_TYPE_SETTER;
    private static final FileCreater FILE_CREATER;
    private static final LeaseManager LEASE_MANAGER;
    private static final DFSClientAdaptor DFS_CLIENT_ADAPTOR;

    private FanOutOneBlockAsyncDFSOutputHelper() {
    }

    private static DFSClientAdaptor createDFSClientAdaptor() {
        try {
            final Method method = DFSClient.class.getDeclaredMethod("isClientRunning", new Class[0]);
            method.setAccessible(true);
            return new DFSClientAdaptor(){

                @Override
                public boolean isClientRunning(DFSClient client) {
                    try {
                        return (Boolean)method.invoke((Object)client, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    private static LeaseManager createLeaseManager() {
        try {
            final Method beginFileLeaseMethod = DFSClient.class.getDeclaredMethod("beginFileLease", Long.TYPE, DFSOutputStream.class);
            beginFileLeaseMethod.setAccessible(true);
            final Method endFileLeaseMethod = DFSClient.class.getDeclaredMethod("endFileLease", Long.TYPE);
            endFileLeaseMethod.setAccessible(true);
            return new LeaseManager(){

                @Override
                public void begin(DFSClient client, String src, long inodeId) {
                    try {
                        beginFileLeaseMethod.invoke((Object)client, inodeId, null);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void end(DFSClient client, String src, long inodeId) {
                    try {
                        endFileLeaseMethod.invoke((Object)client, inodeId);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            LOG.warn((Object)"No inodeId related lease methods found, should be hadoop 2.4-", (Throwable)e);
            try {
                final Method beginFileLeaseMethod = DFSClient.class.getDeclaredMethod("beginFileLease", String.class, DFSOutputStream.class);
                beginFileLeaseMethod.setAccessible(true);
                final Method endFileLeaseMethod = DFSClient.class.getDeclaredMethod("endFileLease", String.class);
                endFileLeaseMethod.setAccessible(true);
                return new LeaseManager(){

                    @Override
                    public void begin(DFSClient client, String src, long inodeId) {
                        try {
                            beginFileLeaseMethod.invoke((Object)client, src, null);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void end(DFSClient client, String src, long inodeId) {
                        try {
                            endFileLeaseMethod.invoke((Object)client, src);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            catch (NoSuchMethodException e2) {
                throw new Error(e2);
            }
        }
    }

    private static PipelineAckStatusGetter createPipelineAckStatusGetter() {
        try {
            Class<Enum> ecnClass;
            final Method getFlagListMethod = DataTransferProtos.PipelineAckProto.class.getMethod("getFlagList", new Class[0]);
            try {
                ecnClass = Class.forName("org.apache.hadoop.hdfs.protocol.datatransfer.PipelineAck$ECN").asSubclass(Enum.class);
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
            final Enum disabledECN = Enum.valueOf(ecnClass, "DISABLED");
            final Method getReplyMethod = DataTransferProtos.PipelineAckProto.class.getMethod("getReply", Integer.TYPE);
            final Method combineHeaderMethod = PipelineAck.class.getMethod("combineHeader", ecnClass, DataTransferProtos.Status.class);
            final Method getStatusFromHeaderMethod = PipelineAck.class.getMethod("getStatusFromHeader", Integer.TYPE);
            return new PipelineAckStatusGetter(){

                @Override
                public DataTransferProtos.Status get(DataTransferProtos.PipelineAckProto ack) {
                    try {
                        Integer headerFlag;
                        List flagList = (List)getFlagListMethod.invoke((Object)ack, new Object[0]);
                        if (flagList.isEmpty()) {
                            DataTransferProtos.Status reply = (DataTransferProtos.Status)getReplyMethod.invoke((Object)ack, 0);
                            headerFlag = (Integer)combineHeaderMethod.invoke(null, disabledECN, reply);
                        } else {
                            headerFlag = (Integer)flagList.get(0);
                        }
                        return (DataTransferProtos.Status)getStatusFromHeaderMethod.invoke(null, headerFlag);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            LOG.warn((Object)"Can not get expected methods, should be hadoop 2.6-", (Throwable)e);
            try {
                final Method getStatusMethod = DataTransferProtos.PipelineAckProto.class.getMethod("getStatus", Integer.TYPE);
                return new PipelineAckStatusGetter(){

                    @Override
                    public DataTransferProtos.Status get(DataTransferProtos.PipelineAckProto ack) {
                        try {
                            return (DataTransferProtos.Status)getStatusMethod.invoke((Object)ack, 0);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            catch (NoSuchMethodException e2) {
                throw new Error(e2);
            }
        }
    }

    private static StorageTypeSetter createStorageTypeSetter() {
        Method setStorageTypeMethod;
        try {
            setStorageTypeMethod = DataTransferProtos.OpWriteBlockProto.Builder.class.getMethod("setStorageType", HdfsProtos.StorageTypeProto.class);
        }
        catch (NoSuchMethodException e) {
            LOG.warn((Object)"noSetStorageType method found, should be hadoop 2.5-", (Throwable)e);
            return new StorageTypeSetter(){

                @Override
                public DataTransferProtos.OpWriteBlockProto.Builder set(DataTransferProtos.OpWriteBlockProto.Builder builder, Enum<?> storageType) {
                    return builder;
                }
            };
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (HdfsProtos.StorageTypeProto storageTypeProto : HdfsProtos.StorageTypeProto.values()) {
            builder.put((Object)storageTypeProto.name(), (Object)storageTypeProto);
        }
        final ImmutableMap name2ProtoEnum = builder.build();
        return new StorageTypeSetter(){

            @Override
            public DataTransferProtos.OpWriteBlockProto.Builder set(DataTransferProtos.OpWriteBlockProto.Builder builder, Enum<?> storageType) {
                Object protoEnum = name2ProtoEnum.get((Object)storageType.name());
                try {
                    setStorageTypeMethod.invoke((Object)builder, protoEnum);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                return builder;
            }
        };
    }

    private static FileCreater createFileCreater() {
        for (Method method : ClientProtocol.class.getMethods()) {
            if (!method.getName().equals("create")) continue;
            final Method createMethod = method;
            Class<?>[] paramTypes = createMethod.getParameterTypes();
            if (paramTypes[paramTypes.length - 1] == Long.TYPE) {
                return new FileCreater(){

                    @Override
                    public HdfsFileStatus create(ClientProtocol namenode, String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws IOException {
                        try {
                            return (HdfsFileStatus)createMethod.invoke((Object)namenode, src, masked, clientName, flag, createParent, replication, blockSize);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            Throwables.propagateIfPossible((Throwable)e.getTargetException(), IOException.class);
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            try {
                Class<?> cryptoProtocolVersionClass = Class.forName("org.apache.hadoop.crypto.CryptoProtocolVersion");
                Method supportedMethod = cryptoProtocolVersionClass.getMethod("supported", new Class[0]);
                final Object supported = supportedMethod.invoke(null, new Object[0]);
                return new FileCreater(){

                    @Override
                    public HdfsFileStatus create(ClientProtocol namenode, String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws IOException {
                        try {
                            return (HdfsFileStatus)createMethod.invoke((Object)namenode, src, masked, clientName, flag, createParent, replication, blockSize, supported);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            Throwables.propagateIfPossible((Throwable)e.getTargetException(), IOException.class);
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new Error(e);
            }
        }
        throw new Error("No create method found for " + ClientProtocol.class.getName());
    }

    static void beginFileLease(DFSClient client, String src, long inodeId) {
        LEASE_MANAGER.begin(client, src, inodeId);
    }

    static void endFileLease(DFSClient client, String src, long inodeId) {
        LEASE_MANAGER.end(client, src, inodeId);
    }

    static DataChecksum createChecksum(DFSClient client) {
        try {
            return (DataChecksum)CREATE_CHECKSUM.invoke((Object)client.getConf(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static DataTransferProtos.Status getStatus(DataTransferProtos.PipelineAckProto ack) {
        return PIPELINE_ACK_STATUS_GETTER.get(ack);
    }

    private static void processWriteBlockResponse(Channel channel, final DatanodeInfo dnInfo, final Promise<Channel> promise, final int timeoutMs) {
        channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler((long)timeoutMs, 0L, 0L, TimeUnit.MILLISECONDS), new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)DataTransferProtos.BlockOpResponseProto.getDefaultInstance()), new SimpleChannelInboundHandler<DataTransferProtos.BlockOpResponseProto>(){

            protected void channelRead0(ChannelHandlerContext ctx, DataTransferProtos.BlockOpResponseProto resp) throws Exception {
                DataTransferProtos.Status pipelineStatus = resp.getStatus();
                if (PipelineAck.isRestartOOBStatus((DataTransferProtos.Status)pipelineStatus)) {
                    throw new IOException("datanode " + dnInfo + " is restarting");
                }
                String logInfo = "ack with firstBadLink as " + resp.getFirstBadLink();
                if (resp.getStatus() != DataTransferProtos.Status.SUCCESS) {
                    if (resp.getStatus() == DataTransferProtos.Status.ERROR_ACCESS_TOKEN) {
                        throw new InvalidBlockTokenException("Got access token error, status message " + resp.getMessage() + ", " + logInfo);
                    }
                    throw new IOException("Got error, status=" + resp.getStatus().name() + ", status message " + resp.getMessage() + ", " + logInfo);
                }
                ChannelPipeline p = ctx.pipeline();
                while (p.first() != null) {
                    p.removeFirst();
                }
                ctx.channel().config().setAutoRead(false);
                promise.trySuccess((Object)ctx.channel());
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                promise.tryFailure((Throwable)new IOException("connection to " + dnInfo + " is closed"));
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
                    promise.tryFailure((Throwable)new IOException("Timeout(" + timeoutMs + "ms) waiting for response"));
                } else {
                    super.userEventTriggered(ctx, evt);
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                promise.tryFailure(cause);
            }
        }});
    }

    private static void requestWriteBlock(Channel channel, Enum<?> storageType, DataTransferProtos.OpWriteBlockProto.Builder writeBlockProtoBuilder) throws IOException {
        DataTransferProtos.OpWriteBlockProto proto = STORAGE_TYPE_SETTER.set(writeBlockProtoBuilder, storageType).build();
        int protoLen = proto.getSerializedSize();
        ByteBuf buffer = channel.alloc().buffer(3 + CodedOutputStream.computeRawVarint32Size((int)protoLen) + protoLen);
        buffer.writeShort(28);
        buffer.writeByte((int)Op.WRITE_BLOCK.code);
        proto.writeDelimitedTo((OutputStream)new ByteBufOutputStream(buffer));
        channel.writeAndFlush((Object)buffer);
    }

    private static List<Future<Channel>> connectToDataNodes(Configuration conf, String clientName, LocatedBlock locatedBlock, long maxBytesRcvd, long latestGS, BlockConstructionStage stage, DataChecksum summer, EventLoop eventLoop) {
        StorageType[] storageTypes = locatedBlock.getStorageTypes();
        DatanodeInfo[] datanodeInfos = locatedBlock.getLocations();
        boolean connectToDnViaHostname = conf.getBoolean("dfs.client.use.datanode.hostname", false);
        final int timeoutMs = conf.getInt("dfs.client.socket-timeout", 60000);
        ExtendedBlock blockCopy = new ExtendedBlock(locatedBlock.getBlock());
        blockCopy.setNumBytes(locatedBlock.getBlockSize());
        DataTransferProtos.ClientOperationHeaderProto header = DataTransferProtos.ClientOperationHeaderProto.newBuilder().setBaseHeader(DataTransferProtos.BaseHeaderProto.newBuilder().setBlock(PBHelper.convert((ExtendedBlock)blockCopy)).setToken(PBHelper.convert((Token)locatedBlock.getBlockToken()))).setClientName(clientName).build();
        DataTransferProtos.ChecksumProto checksumProto = DataTransferProtoUtil.toProto((DataChecksum)summer);
        DataTransferProtos.OpWriteBlockProto.Builder writeBlockProtoBuilder = DataTransferProtos.OpWriteBlockProto.newBuilder().setHeader(header).setStage(DataTransferProtos.OpWriteBlockProto.BlockConstructionStage.valueOf((String)stage.name())).setPipelineSize(1).setMinBytesRcvd(locatedBlock.getBlock().getNumBytes()).setMaxBytesRcvd(maxBytesRcvd).setLatestGenerationStamp(latestGS).setRequestedChecksum(checksumProto).setCachingStrategy(DataTransferProtos.CachingStrategyProto.newBuilder().setDropBehind(true).build());
        ArrayList<Future<Channel>> futureList = new ArrayList<Future<Channel>>(datanodeInfos.length);
        for (int i = 0; i < datanodeInfos.length; ++i) {
            final DatanodeInfo dnInfo = datanodeInfos[i];
            StorageType storageType = storageTypes[i];
            final Promise promise = eventLoop.newPromise();
            futureList.add((Future<Channel>)promise);
            String dnAddr = dnInfo.getXferAddr(connectToDnViaHostname);
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoop)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutMs)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    FanOutOneBlockAsyncDFSOutputHelper.processWriteBlockResponse(ch, dnInfo, (Promise<Channel>)promise, timeoutMs);
                }
            })).connect((SocketAddress)NetUtils.createSocketAddr((String)dnAddr)).addListener((GenericFutureListener)new ChannelFutureListener((Enum)storageType, writeBlockProtoBuilder, promise){
                final /* synthetic */ Enum val$storageType;
                final /* synthetic */ DataTransferProtos.OpWriteBlockProto.Builder val$writeBlockProtoBuilder;
                final /* synthetic */ Promise val$promise;
                {
                    this.val$storageType = enum_;
                    this.val$writeBlockProtoBuilder = builder;
                    this.val$promise = promise;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        FanOutOneBlockAsyncDFSOutputHelper.requestWriteBlock(future.channel(), this.val$storageType, this.val$writeBlockProtoBuilder);
                    } else {
                        this.val$promise.tryFailure(future.cause());
                    }
                }
            });
        }
        return futureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FanOutOneBlockAsyncDFSOutput createOutput(DistributedFileSystem dfs, String src, boolean overwrite, boolean createParent, short replication, long blockSize, EventLoop eventLoop) throws IOException {
        Configuration conf = dfs.getConf();
        FSUtils fsUtils = FSUtils.getInstance((FileSystem)dfs, conf);
        DFSClient client = dfs.getClient();
        String clientName = client.getClientName();
        ClientProtocol namenode = client.getNamenode();
        HdfsFileStatus stat = FILE_CREATER.create(namenode, src, FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)conf)), clientName, (EnumSetWritable<CreateFlag>)new EnumSetWritable(overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE)), createParent, replication, blockSize);
        FanOutOneBlockAsyncDFSOutputHelper.beginFileLease(client, src, stat.getFileId());
        boolean succ = false;
        LocatedBlock locatedBlock = null;
        ArrayList<Channel> datanodeList = new ArrayList<Channel>();
        try {
            DataChecksum summer = FanOutOneBlockAsyncDFSOutputHelper.createChecksum(client);
            locatedBlock = namenode.addBlock(src, client.getClientName(), null, null, stat.getFileId(), null);
            for (Future<Channel> future : FanOutOneBlockAsyncDFSOutputHelper.connectToDataNodes(conf, clientName, locatedBlock, 0L, 0L, BlockConstructionStage.PIPELINE_SETUP_CREATE, summer, eventLoop)) {
                datanodeList.add((Channel)future.syncUninterruptibly().getNow());
            }
            succ = true;
            FanOutOneBlockAsyncDFSOutput fanOutOneBlockAsyncDFSOutput = new FanOutOneBlockAsyncDFSOutput(conf, fsUtils, dfs, client, namenode, clientName, src, stat.getFileId(), locatedBlock, eventLoop, datanodeList, summer, ALLOC);
            return fanOutOneBlockAsyncDFSOutput;
        }
        finally {
            if (!succ) {
                for (Channel c : datanodeList) {
                    c.close();
                }
                FanOutOneBlockAsyncDFSOutputHelper.endFileLease(client, src, stat.getFileId());
                fsUtils.recoverFileLease((FileSystem)dfs, new Path(src), conf, new CancelOnClose(client));
            }
        }
    }

    public static FanOutOneBlockAsyncDFSOutput createOutput(final DistributedFileSystem dfs, Path f, final boolean overwrite, final boolean createParent, final short replication, final long blockSize, final EventLoop eventLoop) throws IOException {
        return (FanOutOneBlockAsyncDFSOutput)new FileSystemLinkResolver<FanOutOneBlockAsyncDFSOutput>(){

            public FanOutOneBlockAsyncDFSOutput doCall(Path p) throws IOException, UnresolvedLinkException {
                return FanOutOneBlockAsyncDFSOutputHelper.createOutput(dfs, p.toUri().getPath(), overwrite, createParent, replication, blockSize, eventLoop);
            }

            public FanOutOneBlockAsyncDFSOutput next(FileSystem fs, Path p) throws IOException {
                throw new UnsupportedOperationException();
            }
        }.resolve((FileSystem)dfs, f);
    }

    static void completeFile(DFSClient client, ClientProtocol namenode, String src, String clientName, ExtendedBlock block, long fileId) {
        int retry = 0;
        while (true) {
            try {
                if (namenode.complete(src, clientName, block, fileId)) {
                    FanOutOneBlockAsyncDFSOutputHelper.endFileLease(client, src, fileId);
                    return;
                }
                LOG.warn((Object)("complete file " + src + " not finished, retry = " + retry));
            }
            catch (LeaseExpiredException e) {
                LOG.warn((Object)("lease for file " + src + " is expired, give up"), (Throwable)e);
                return;
            }
            catch (Exception e) {
                LOG.warn((Object)("complete file " + src + " failed, retry = " + retry), (Throwable)e);
            }
            FanOutOneBlockAsyncDFSOutputHelper.sleepIgnoreInterrupt(retry);
            ++retry;
        }
    }

    static void sleepIgnoreInterrupt(int retry) {
        try {
            Thread.sleep(ConnectionUtils.getPauseTime((long)100L, (int)retry));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        try {
            CREATE_CHECKSUM = DFSClient.Conf.class.getDeclaredMethod("createChecksum", new Class[0]);
            CREATE_CHECKSUM.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        PIPELINE_ACK_STATUS_GETTER = FanOutOneBlockAsyncDFSOutputHelper.createPipelineAckStatusGetter();
        STORAGE_TYPE_SETTER = FanOutOneBlockAsyncDFSOutputHelper.createStorageTypeSetter();
        FILE_CREATER = FanOutOneBlockAsyncDFSOutputHelper.createFileCreater();
        LEASE_MANAGER = FanOutOneBlockAsyncDFSOutputHelper.createLeaseManager();
        DFS_CLIENT_ADAPTOR = FanOutOneBlockAsyncDFSOutputHelper.createDFSClientAdaptor();
    }

    static final class CancelOnClose
    implements CancelableProgressable {
        private final DFSClient client;

        public CancelOnClose(DFSClient client) {
            this.client = client;
        }

        @Override
        public boolean progress() {
            return DFS_CLIENT_ADAPTOR.isClientRunning(this.client);
        }
    }

    private static interface DFSClientAdaptor {
        public boolean isClientRunning(DFSClient var1);
    }

    private static interface LeaseManager {
        public void begin(DFSClient var1, String var2, long var3);

        public void end(DFSClient var1, String var2, long var3);
    }

    private static interface FileCreater {
        public HdfsFileStatus create(ClientProtocol var1, String var2, FsPermission var3, String var4, EnumSetWritable<CreateFlag> var5, boolean var6, short var7, long var8) throws IOException;
    }

    private static interface StorageTypeSetter {
        public DataTransferProtos.OpWriteBlockProto.Builder set(DataTransferProtos.OpWriteBlockProto.Builder var1, Enum<?> var2);
    }

    private static interface PipelineAckStatusGetter {
        public DataTransferProtos.Status get(DataTransferProtos.PipelineAckProto var1);
    }
}

