/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.io.MultipleIOException;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class OfflineMetaRepair {
    private static final Log LOG = LogFactory.getLog((String)OfflineMetaRepair.class.getName());

    protected static void printUsageAndExit() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: OfflineMetaRepair [opts]\n").append(" where [opts] are:\n").append("   -details               Display full report of all regions.\n").append("   -base <hdfs://>        Base Hbase Data directory.\n").append("   -sidelineDir <hdfs://> HDFS path to backup existing meta and root.\n").append("   -fix                   Auto fix as many problems as possible.\n").append("   -fixHoles              Auto fix as region holes.");
        System.err.println(sb.toString());
        Runtime.getRuntime().exit(-2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FSUtils.setFsDefault(conf, FSUtils.getRootDir(conf));
        HBaseFsck fsck = new HBaseFsck(conf);
        boolean fixHoles = false;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.equals("-details")) {
                HBaseFsck.setDisplayFullReport();
                continue;
            }
            if (cmd.equals("-base")) {
                if (i == args.length - 1) {
                    System.err.println("OfflineMetaRepair: -base needs an HDFS path.");
                    OfflineMetaRepair.printUsageAndExit();
                }
                FSUtils.setRootDir(conf, new Path(args[++i]));
                FSUtils.setFsDefault(conf, FSUtils.getRootDir(conf));
                continue;
            }
            if (cmd.equals("-sidelineDir")) {
                if (i == args.length - 1) {
                    System.err.println("OfflineMetaRepair: -sidelineDir needs an HDFS path.");
                    OfflineMetaRepair.printUsageAndExit();
                }
                fsck.setSidelineDir(args[++i]);
                continue;
            }
            if (cmd.equals("-fixHoles")) {
                fixHoles = true;
                continue;
            }
            if (cmd.equals("-fix")) {
                fixHoles = true;
                continue;
            }
            String str = "Unknown command line option : " + cmd;
            LOG.info((Object)str);
            System.out.println(str);
            OfflineMetaRepair.printUsageAndExit();
        }
        System.out.println("OfflineMetaRepair command line options: " + StringUtils.join((Object[])args, (String)" "));
        boolean success = false;
        try {
            success = fsck.rebuildMeta(fixHoles);
            System.exit(success ? 0 : 1);
        }
        catch (MultipleIOException mioes) {
            for (IOException ioe : mioes.getExceptions()) {
                LOG.error((Object)"Bailed out due to:", (Throwable)ioe);
            }
            System.exit(success ? 0 : 1);
        }
        catch (Exception e) {
            LOG.error((Object)"Bailed out due to: ", (Throwable)e);
            System.exit(success ? 0 : 1);
            {
                catch (Throwable throwable) {
                    System.exit(success ? 0 : 1);
                    throw throwable;
                }
            }
        }
    }
}

