/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.BoundedGroupingStrategy;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.NamespaceGroupingStrategy;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;

@InterfaceAudience.Private
class RegionGroupingProvider
implements WALProvider {
    private static final Log LOG = LogFactory.getLog(RegionGroupingProvider.class);
    public static final String REGION_GROUPING_STRATEGY = "hbase.wal.regiongrouping.strategy";
    public static final String DEFAULT_REGION_GROUPING_STRATEGY = Strategies.defaultStrategy.name();
    private static final String META_WAL_GROUP_NAME = "meta";
    protected final Map<String, FSHLog> cached = new HashMap<String, FSHLog>();
    private final Set<FSHLog> logs = Collections.synchronizedSet(new HashSet());
    final Object walCacheLock = new Object();
    protected RegionGroupingStrategy strategy = null;
    private List<WALActionsListener> listeners = null;
    private String providerId = null;
    private Configuration conf = null;

    RegionGroupingProvider() {
    }

    RegionGroupingStrategy getStrategy(Configuration conf, String key, String defaultValue) throws IOException {
        Class clazz;
        try {
            clazz = Strategies.valueOf((String)conf.get((String)key, (String)defaultValue)).clazz;
        }
        catch (IllegalArgumentException exception) {
            clazz = conf.getClass(key, IdentityGroupingStrategy.class, RegionGroupingStrategy.class);
        }
        LOG.info((Object)("Instantiating RegionGroupingStrategy of type " + clazz));
        try {
            RegionGroupingStrategy result = (RegionGroupingStrategy)clazz.newInstance();
            result.init(conf, this.providerId);
            return result;
        }
        catch (InstantiationException exception) {
            LOG.error((Object)"couldn't set up region grouping strategy, check config key hbase.wal.regiongrouping.strategy");
            LOG.debug((Object)"Exception details for failure to load region grouping strategy.", (Throwable)exception);
            throw new IOException("couldn't set up region grouping strategy", exception);
        }
        catch (IllegalAccessException exception) {
            LOG.error((Object)"couldn't set up region grouping strategy, check config key hbase.wal.regiongrouping.strategy");
            LOG.debug((Object)"Exception details for failure to load region grouping strategy.", (Throwable)exception);
            throw new IOException("couldn't set up region grouping strategy", exception);
        }
    }

    @Override
    public void init(WALFactory factory, Configuration conf, List<WALActionsListener> listeners, String providerId) throws IOException {
        if (null != this.strategy) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        this.listeners = null == listeners ? null : Collections.unmodifiableList(listeners);
        StringBuilder sb = new StringBuilder().append(factory.factoryId);
        if (providerId != null) {
            if (providerId.startsWith(".")) {
                sb.append(providerId);
            } else {
                sb.append(".").append(providerId);
            }
        }
        this.providerId = sb.toString();
        this.strategy = this.getStrategy(conf, REGION_GROUPING_STRATEGY, DEFAULT_REGION_GROUPING_STRATEGY);
        this.conf = conf;
    }

    FSHLog populateCache(String groupName) throws IOException {
        List<WALActionsListener> listeners;
        String hlogPrefix;
        boolean isMeta = ".meta".equals(this.providerId);
        if (isMeta) {
            hlogPrefix = this.providerId;
            listeners = Collections.singletonList(new MetricsWAL());
        } else {
            hlogPrefix = groupName;
            listeners = this.listeners;
        }
        FSHLog log = new FSHLog(FileSystem.get((Configuration)this.conf), FSUtils.getRootDir(this.conf), DefaultWALProvider.getWALDirectoryName(this.providerId), "oldWALs", this.conf, listeners, true, hlogPrefix, isMeta ? ".meta" : null);
        this.cached.put(groupName, log);
        this.logs.add(log);
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WAL getWAL(String group) throws IOException {
        WAL log = this.cached.get(group);
        if (null == log) {
            Object object = this.walCacheLock;
            synchronized (object) {
                log = this.cached.get(group);
                if (null == log) {
                    log = this.populateCache(group);
                }
            }
        }
        return log;
    }

    @Override
    public WAL getWAL(byte[] identifier, byte[] namespace) throws IOException {
        String group = ".meta".equals(this.providerId) ? META_WAL_GROUP_NAME : this.strategy.group(identifier, namespace);
        return this.getWAL(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws IOException {
        IOException failure = null;
        Set<FSHLog> set = this.logs;
        synchronized (set) {
            for (FSHLog wal : this.logs) {
                try {
                    wal.shutdown();
                }
                catch (IOException exception) {
                    LOG.error((Object)("Problem shutting down log '" + wal + "': " + exception.getMessage()));
                    LOG.debug((Object)("Details of problem shutting down log '" + wal + "'"), (Throwable)exception);
                    failure = exception;
                }
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        IOException failure = null;
        Set<FSHLog> set = this.logs;
        synchronized (set) {
            for (FSHLog wal : this.logs) {
                try {
                    wal.close();
                }
                catch (IOException exception) {
                    LOG.error((Object)("Problem closing log '" + wal + "': " + exception.getMessage()));
                    LOG.debug((Object)("Details of problem closing wal '" + wal + "'"), (Throwable)exception);
                    failure = exception;
                }
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumLogFiles() {
        long numLogFiles = 0L;
        Set<FSHLog> set = this.logs;
        synchronized (set) {
            for (FSHLog wal : this.logs) {
                numLogFiles += (long)wal.getNumLogFiles();
            }
        }
        return numLogFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLogFileSize() {
        long logFileSize = 0L;
        Set<FSHLog> set = this.logs;
        synchronized (set) {
            for (FSHLog wal : this.logs) {
                logFileSize += wal.getLogFileSize();
            }
        }
        return logFileSize;
    }

    static class IdentityGroupingStrategy
    implements RegionGroupingStrategy {
        IdentityGroupingStrategy() {
        }

        @Override
        public void init(Configuration config, String providerId) {
        }

        @Override
        public String group(byte[] identifier, byte[] namespace) {
            return Bytes.toString((byte[])identifier);
        }
    }

    static enum Strategies {
        defaultStrategy(BoundedGroupingStrategy.class),
        identity(IdentityGroupingStrategy.class),
        bounded(BoundedGroupingStrategy.class),
        namespace(NamespaceGroupingStrategy.class);

        final Class<? extends RegionGroupingStrategy> clazz;

        private Strategies(Class<? extends RegionGroupingStrategy> clazz) {
            this.clazz = clazz;
        }
    }

    public static interface RegionGroupingStrategy {
        public static final String GROUP_NAME_DELIMITER = ".";

        public String group(byte[] var1, byte[] var2);

        public void init(Configuration var1, String var2);
    }
}

