/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.AcidHouseKeeperService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestTxnCommands {
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    private static final String TEST_WAREHOUSE_DIR = TEST_DATA_DIR + "/warehouse";
    private static int BUCKET_COUNT = 2;
    @Rule
    public TestName testName = new TestName();
    private HiveConf hiveConf;
    private Driver d;

    @Before
    public void setUp() throws Exception {
        this.tearDown();
        this.hiveConf = new HiveConf(this.getClass());
        this.hiveConf.set(HiveConf.ConfVars.PREEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.POSTEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname, "false");
        this.hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, TEST_WAREHOUSE_DIR);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
        TxnDbUtil.setConfValues((HiveConf)this.hiveConf);
        TxnDbUtil.prepDb();
        File f = new File(TEST_WAREHOUSE_DIR);
        if (f.exists()) {
            FileUtil.fullyDelete((File)f);
        }
        if (!new File(TEST_WAREHOUSE_DIR).mkdirs()) {
            throw new RuntimeException("Could not create " + TEST_WAREHOUSE_DIR);
        }
        SessionState.start((SessionState)new SessionState(this.hiveConf));
        this.d = new Driver(this.hiveConf);
        this.dropTables();
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBL) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL2) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create temporary  table " + (Object)((Object)Table.ACIDTBL2) + "(a int, b int, c int) clustered by (c) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
    }

    private void dropTables() throws Exception {
        for (Table t : Table.values()) {
            this.runStatementOnDriver("drop table if exists " + (Object)((Object)t));
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.d != null) {
                this.runStatementOnDriver("set autocommit true");
                this.dropTables();
                this.d.destroy();
                this.d.close();
                this.d = null;
            }
        }
        finally {
            TxnDbUtil.cleanDb();
            FileUtils.deleteDirectory((File)new File(TEST_DATA_DIR));
        }
    }

    @Test
    public void testInsertOverwrite() throws Exception {
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)Table.NONACIDORCTBL) + " select a,b from " + (Object)((Object)Table.NONACIDORCTBL2));
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL2) + "3(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
    }

    @Ignore(value="not needed but useful for testing")
    @Test
    public void testNonAcidInsert() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(2,3)");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
    }

    private void dumpBucketData(Table table, long txnId, int stmtId, int bucketNum) throws Exception {
    }

    private void dumpTableData(Table table, long txnId, int stmtId) throws Exception {
        for (int bucketNum = 0; bucketNum < BUCKET_COUNT; ++bucketNum) {
            this.dumpBucketData(table, txnId, stmtId, bucketNum);
        }
    }

    @Test
    public void testSimpleAcidInsert() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> allData = this.stringifyValues(rows1);
        allData.addAll(this.stringifyValues(rows2));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Data didn't match inside tx (rs0)", allData, rs0);
        this.runStatementOnDriver("COMMIT WORK");
        this.dumpTableData(Table.ACIDTBL, 1L, 0);
        this.dumpTableData(Table.ACIDTBL, 2L, 0);
        this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        this.runStatementOnDriver("COMMIT");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Data didn't match inside tx (rs0)", allData, rs1);
    }

    @Test
    public void testErrors() throws Exception {
        this.runStatementOnDriver("set autocommit true");
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("start transaction");
        Assert.assertEquals((String)("Error didn't match: " + cpr), (long)ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT.getErrorCode(), (long)cpr.getErrorCode());
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("start transaction");
        CommandProcessorResponse cpr2 = this.runStatementOnDriverNegative("create table foo(x int, y int)");
        Assert.assertEquals((String)"Expected DDL to fail in an open txn", (long)ErrorMsg.OP_NOT_ALLOWED_IN_TXN.getErrorCode(), (long)cpr2.getErrorCode());
        this.runStatementOnDriver("set autocommit true");
        CommandProcessorResponse cpr3 = this.runStatementOnDriverNegative("update " + (Object)((Object)Table.ACIDTBL) + " set a = 1 where b != 1");
        Assert.assertEquals((String)"Expected update of bucket column to fail", (Object)"FAILED: SemanticException [Error 10302]: Updating values of bucketing columns is not supported.  Column a.", (Object)cpr3.getErrorMessage());
        cpr3 = this.runStatementOnDriverNegative("commit work");
        Assert.assertEquals((String)("Error didn't match: " + cpr3), (long)ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT.getErrorCode(), (long)cpr.getErrorCode());
        cpr3 = this.runStatementOnDriverNegative("rollback work");
        Assert.assertEquals((String)("Error didn't match: " + cpr3), (long)ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT.getErrorCode(), (long)cpr.getErrorCode());
        this.runStatementOnDriver("set autocommit false");
        cpr3 = this.runStatementOnDriverNegative("commit");
        Assert.assertEquals((String)("Error didn't match: " + cpr3), (long)ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT.getErrorCode(), (long)cpr.getErrorCode());
        cpr3 = this.runStatementOnDriverNegative("rollback");
        Assert.assertEquals((String)("Error didn't match: " + cpr3), (long)ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT.getErrorCode(), (long)cpr.getErrorCode());
        this.runStatementOnDriver("start transaction");
        cpr3 = this.runStatementOnDriverNegative("start transaction");
        Assert.assertEquals((String)"Expected start transaction to fail", (long)ErrorMsg.OP_NOT_ALLOWED_IN_TXN.getErrorCode(), (long)cpr3.getErrorCode());
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        this.runStatementOnDriver("set autocommit true");
        rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
    }

    @Test
    public void testReadMyOwnInsert() throws Exception {
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        List<String> rs = this.runStatementOnDriver("select * from " + (Object)((Object)Table.ACIDTBL));
        Assert.assertEquals((String)("Expected empty " + (Object)((Object)Table.ACIDTBL)), (long)0L, (long)rs.size());
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("START TRANSACTION");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        this.runStatementOnDriver("rollback work");
        Assert.assertEquals((String)"Can't see write after commit", (long)1L, (long)rs1.size());
    }

    @Test
    public void testImplicitRollback() throws Exception {
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("select * from no_such_table");
        Assert.assertEquals((String)"Txn didn't fail?", (Object)"FAILED: SemanticException [Error 10001]: Line 1:14 Table not found 'no_such_table'", (Object)cpr.getErrorMessage());
        this.runStatementOnDriver("start transaction");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        this.runStatementOnDriver("commit");
        Assert.assertEquals((String)"Didn't rollback as expected", (long)0L, (long)rs1.size());
    }

    @Test
    public void testExplicitRollback() throws Exception {
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        this.runStatementOnDriver("ROLLBACK");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Rollback didn't rollback", (long)0L, (long)rs.size());
    }

    @Test
    public void testMultipleInserts() throws Exception {
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> allData = this.stringifyValues(rows1);
        allData.addAll(this.stringifyValues(rows2));
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match before commit rs", allData, rs);
        this.runStatementOnDriver("commit");
        this.dumpTableData(Table.ACIDTBL, 1L, 0);
        this.dumpTableData(Table.ACIDTBL, 1L, 1);
        this.runStatementOnDriver("set autocommit true");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match after commit rs1", allData, rs1);
    }

    @Test
    public void testDelete() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", this.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where b = 4");
        int[][] updatedData2 = new int[][]{{1, 2}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", this.stringifyValues(updatedData2), rs3);
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", this.stringifyValues(updatedData2), rs4);
    }

    @Test
    public void testUpdateOfInserts() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", this.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        List<String> allData = this.stringifyValues(rows1);
        allData.addAll(this.stringifyValues(rows2));
        Assert.assertEquals((String)"Content didn't match rs1", allData, rs1);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set b = 1 where b != 1");
        int[][] updatedData = new int[][]{{1, 1}, {3, 1}, {5, 1}, {7, 1}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after update", this.stringifyValues(updatedData), rs2);
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", this.stringifyValues(updatedData), rs4);
    }

    @Test
    public void testUpdateDeleteOfInserts() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", this.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        List<String> allData = this.stringifyValues(rows1);
        allData.addAll(this.stringifyValues(rows2));
        Assert.assertEquals((String)"Content didn't match rs1", allData, rs1);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set b = 1 where b != 1");
        int[][] updatedData = new int[][]{{1, 1}, {3, 1}, {5, 1}, {7, 1}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after update", this.stringifyValues(updatedData), rs2);
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a = 7 and b = 1");
        this.dumpTableData(Table.ACIDTBL, 1L, 0);
        this.dumpTableData(Table.ACIDTBL, 2L, 0);
        this.dumpTableData(Table.ACIDTBL, 2L, 2);
        this.dumpTableData(Table.ACIDTBL, 2L, 4);
        int[][] updatedData2 = new int[][]{{1, 1}, {3, 1}, {5, 1}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", this.stringifyValues(updatedData2), rs3);
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", this.stringifyValues(updatedData2), rs4);
    }

    @Test
    public void testMultipleDelete() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", this.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where b = 8");
        int[][] updatedData2 = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", this.stringifyValues(updatedData2), rs2);
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where b = 4");
        int[][] updatedData3 = new int[][]{{1, 2}, {5, 6}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete2", this.stringifyValues(updatedData3), rs3);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set b=3");
        this.dumpTableData(Table.ACIDTBL, 1L, 0);
        this.dumpTableData(Table.ACIDTBL, 2L, 0);
        this.dumpTableData(Table.ACIDTBL, 2L, 2);
        this.dumpTableData(Table.ACIDTBL, 2L, 4);
        List<String> rs5 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData4 = new int[][]{{1, 3}, {5, 3}};
        Assert.assertEquals((String)"Wrong data after delete", this.stringifyValues(updatedData4), rs5);
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", this.stringifyValues(updatedData4), rs4);
    }

    @Test
    public void testDeleteIn() throws Exception {
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a IN (SELECT A.a from " + (Object)((Object)Table.ACIDTBL) + "  A)");
        int[][] tableData = new int[][]{{1, 2}, {3, 2}, {5, 2}, {1, 3}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL2) + "(a,b,c) values(1,7,17),(3,7,17)");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a in(select a from " + (Object)((Object)Table.ACIDTBL2) + ")");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) select a,b from " + (Object)((Object)Table.ACIDTBL2));
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 7}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update failed", this.stringifyValues(updatedData), rs);
    }

    @Test
    public void testTimeOutReaper() throws Exception {
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a = 5");
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_TIMEDOUT_TXN_REAPER_START, 0L, TimeUnit.SECONDS);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_TXN_TIMEOUT, 2L, TimeUnit.MILLISECONDS);
        AcidHouseKeeperService houseKeeperService = new AcidHouseKeeperService();
        houseKeeperService.start(this.hiveConf);
        while (houseKeeperService.getIsAliveCounter() <= Integer.MIN_VALUE) {
            Thread.sleep(100L);
        }
        houseKeeperService.stop();
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("delete from " + (Object)((Object)Table.ACIDTBL) + " where a = 5");
        Assert.assertTrue((String)("Actual: " + cpr.getErrorMessage()), (boolean)cpr.getErrorMessage().contains("Transaction manager has aborted the transaction txnid:1"));
    }

    private List<String> stringifyValues(int[][] rowsIn) {
        assert (rowsIn.length > 0);
        int[][] rows = (int[][])rowsIn.clone();
        Arrays.sort(rows, new RowComp());
        ArrayList<String> rs = new ArrayList<String>();
        for (int[] row : rows) {
            assert (row.length > 0);
            StringBuilder sb = new StringBuilder();
            for (int value : row) {
                sb.append(value).append("\t");
            }
            sb.setLength(sb.length() - 1);
            rs.add(sb.toString());
        }
        return rs;
    }

    private String makeValuesClause(int[][] rows) {
        assert (rows.length > 0);
        StringBuilder sb = new StringBuilder("values");
        for (int[] row : rows) {
            assert (row.length > 0);
            if (row.length > 1) {
                sb.append("(");
            }
            for (int value : row) {
                sb.append(value).append(",");
            }
            sb.setLength(sb.length() - 1);
            if (row.length > 1) {
                sb.append(")");
            }
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private List<String> runStatementOnDriver(String stmt) throws Exception {
        CommandProcessorResponse cpr = this.d.run(stmt);
        if (cpr.getResponseCode() != 0) {
            throw new RuntimeException(stmt + " failed: " + cpr);
        }
        ArrayList<String> rs = new ArrayList<String>();
        this.d.getResults(rs);
        return rs;
    }

    private CommandProcessorResponse runStatementOnDriverNegative(String stmt) throws Exception {
        CommandProcessorResponse cpr = this.d.run(stmt);
        if (cpr.getResponseCode() != 0) {
            return cpr;
        }
        throw new RuntimeException("Didn't get expected failure!");
    }

    @Test
    public void exchangePartition() throws Exception {
        this.runStatementOnDriver("create database ex1");
        this.runStatementOnDriver("create database ex2");
        this.runStatementOnDriver("CREATE TABLE ex1.exchange_part_test1 (f1 string) PARTITIONED BY (ds STRING)");
        this.runStatementOnDriver("CREATE TABLE ex2.exchange_part_test2 (f1 string) PARTITIONED BY (ds STRING)");
        this.runStatementOnDriver("ALTER TABLE ex2.exchange_part_test2 ADD PARTITION (ds='2013-04-05')");
        this.runStatementOnDriver("ALTER TABLE ex1.exchange_part_test1 EXCHANGE PARTITION (ds='2013-04-05') WITH TABLE ex2.exchange_part_test2");
    }

    private static final class RowComp
    implements Comparator<int[]> {
        private RowComp() {
        }

        @Override
        public int compare(int[] row1, int[] row2) {
            assert (row1 != null && row2 != null && row1.length == row2.length);
            for (int i = 0; i < row1.length; ++i) {
                int comp = Integer.compare(row1[i], row2[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    private static enum Table {
        ACIDTBL("acidTbl"),
        ACIDTBL2("acidTbl2"),
        NONACIDORCTBL("nonAcidOrcTbl"),
        NONACIDORCTBL2("nonAcidOrcTbl2");

        private final String name;

        public String toString() {
            return this.name;
        }

        private Table(String name) {
            this.name = name;
        }
    }
}

