/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddScalarCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffScalarCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateSubColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateSubColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateSubScalarCol;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorGenericDateExpressions {
    private int size = 200;
    private Random random = new Random();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private List<VectorExpression.Type> dateTimestampStringTypes = Arrays.asList(VectorExpression.Type.DATE, VectorExpression.Type.TIMESTAMP, VectorExpression.Type.STRING);

    private long newRandom(int i) {
        return this.random.nextInt(i);
    }

    private LongColumnVector newRandomLongColumnVector(int range, int size) {
        LongColumnVector vector = new LongColumnVector(size);
        for (int i = 0; i < size; ++i) {
            vector.vector[i] = this.random.nextInt(range);
        }
        return vector;
    }

    private LongColumnVector toTimestamp(LongColumnVector date) {
        LongColumnVector vector = new LongColumnVector(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (date.isNull[i]) {
                vector.isNull[i] = true;
                vector.noNulls = false;
                continue;
            }
            vector.vector[i] = this.toTimestamp(date.vector[i]);
        }
        return vector;
    }

    private long toTimestamp(long date) {
        return DateWritable.daysToMillis((int)((int)date)) * 1000000L;
    }

    private BytesColumnVector toString(LongColumnVector date) {
        BytesColumnVector bcv = new BytesColumnVector(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (date.isNull[i]) {
                bcv.isNull[i] = true;
                bcv.noNulls = false;
                continue;
            }
            bcv.vector[i] = this.toString(date.vector[i]);
            bcv.start[i] = 0;
            bcv.length[i] = bcv.vector[i].length;
        }
        return bcv;
    }

    private byte[] toString(long date) {
        try {
            String formatted = this.formatter.format(new Date(DateWritable.daysToMillis((int)((int)date))));
            return formatted.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void validateDateAdd(VectorizedRowBatch batch, VectorExpression.Type colType1, long scalar2, boolean isPositive, LongColumnVector date1) {
        Object udf = isPositive ? new VectorUDFDateAddColScalar(0, scalar2, 1) : new VectorUDFDateSubColScalar(0, scalar2, 1);
        udf.setInputTypes(new VectorExpression.Type[]{colType1, VectorExpression.Type.OTHER});
        udf.evaluate(batch);
        BytesColumnVector output = (BytesColumnVector)batch.cols[1];
        try {
            for (int i = 0; i < this.size; ++i) {
                String expected = isPositive ? new String(this.toString(date1.vector[i] + scalar2), "UTF-8") : new String(this.toString(date1.vector[i] - scalar2), "UTF-8");
                if (date1.isNull[i]) {
                    Assert.assertTrue((boolean)output.isNull[i]);
                    continue;
                }
                String actual = new String(output.vector[i], output.start[i], output.start[i] + output.length[i], "UTF-8");
                Assert.assertEquals((String)("expectedLen:" + expected.length() + " actualLen:" + actual.length()), (Object)expected, (Object)actual);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ColumnVector castTo(LongColumnVector date, VectorExpression.Type type) {
        switch (type) {
            case DATE: {
                return date;
            }
            case TIMESTAMP: {
                return this.toTimestamp(date);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return this.toString(date);
            }
        }
        throw new Error("Unsupported input type " + type.name());
    }

    private void testDateAddColScalar(VectorExpression.Type colType1, boolean isPositive) {
        LongColumnVector date1 = this.newRandomLongColumnVector(10000, this.size);
        ColumnVector col1 = this.castTo(date1, colType1);
        long scalar2 = this.newRandom(1000);
        BytesColumnVector output = new BytesColumnVector(this.size);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
        batch.cols[0] = col1;
        batch.cols[1] = output;
        this.validateDateAdd(batch, colType1, scalar2, isPositive, date1);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.validateDateAdd(batch, colType1, scalar2, isPositive, date1);
    }

    @Test
    public void testDateAddColScalar() {
        for (VectorExpression.Type colType1 : this.dateTimestampStringTypes) {
            this.testDateAddColScalar(colType1, true);
        }
        VectorUDFDateAddColScalar udf = new VectorUDFDateAddColScalar(0, 0L, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING, VectorExpression.Type.TIMESTAMP});
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new BytesColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        byte[] bytes = new byte[]{};
        try {
            bytes = "error".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    @Test
    public void testDateSubColScalar() {
        for (VectorExpression.Type colType1 : this.dateTimestampStringTypes) {
            this.testDateAddColScalar(colType1, false);
        }
        VectorUDFDateSubColScalar udf = new VectorUDFDateSubColScalar(0, 0L, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING, VectorExpression.Type.TIMESTAMP});
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new BytesColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        byte[] bytes = new byte[]{};
        try {
            bytes = "error".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    private void validateDateAdd(VectorizedRowBatch batch, long scalar1, LongColumnVector date2, VectorExpression.Type colType1, boolean isPositive) {
        VectorUDFDateAddScalarCol udf;
        block15: {
            block14: {
                udf = null;
                if (!isPositive) break block14;
                switch (colType1) {
                    case DATE: {
                        udf = new VectorUDFDateAddScalarCol((Object)scalar1, 0, 1);
                        break block15;
                    }
                    case TIMESTAMP: {
                        udf = new VectorUDFDateAddScalarCol((Object)this.toTimestamp(scalar1), 0, 1);
                        break block15;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        udf = new VectorUDFDateAddScalarCol((Object)this.toString(scalar1), 0, 1);
                        break block15;
                    }
                    default: {
                        throw new Error("Invalid input type: " + colType1.name());
                    }
                }
            }
            switch (colType1) {
                case DATE: {
                    udf = new VectorUDFDateSubScalarCol((Object)scalar1, 0, 1);
                    break;
                }
                case TIMESTAMP: {
                    udf = new VectorUDFDateSubScalarCol((Object)this.toTimestamp(scalar1), 0, 1);
                    break;
                }
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    udf = new VectorUDFDateSubScalarCol((Object)this.toString(scalar1), 0, 1);
                    break;
                }
                default: {
                    throw new Error("Invalid input type: " + colType1.name());
                }
            }
        }
        udf.setInputTypes(new VectorExpression.Type[]{colType1, VectorExpression.Type.OTHER});
        udf.evaluate(batch);
        BytesColumnVector output = (BytesColumnVector)batch.cols[1];
        try {
            for (int i = 0; i < date2.vector.length; ++i) {
                String expected = isPositive ? new String(this.toString(scalar1 + date2.vector[i]), "UTF-8") : new String(this.toString(scalar1 - date2.vector[i]), "UTF-8");
                if (date2.isNull[i]) {
                    Assert.assertTrue((boolean)output.isNull[i]);
                    continue;
                }
                Assert.assertEquals((Object)expected, (Object)new String(output.vector[i], output.start[i], output.start[i] + output.length[i], "UTF-8"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void testDateAddScalarCol(VectorExpression.Type colType1, boolean isPositive) {
        LongColumnVector date2 = this.newRandomLongColumnVector(10000, this.size);
        long scalar1 = this.newRandom(1000);
        BytesColumnVector output = new BytesColumnVector(this.size);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
        batch.cols[0] = date2;
        batch.cols[1] = output;
        this.validateDateAdd(batch, scalar1, date2, colType1, isPositive);
        TestVectorizedRowBatch.addRandomNulls((ColumnVector)date2);
        batch.cols[0] = date2;
        this.validateDateAdd(batch, scalar1, date2, colType1, isPositive);
    }

    @Test
    public void testDateAddScalarCol() {
        for (VectorExpression.Type scalarType1 : this.dateTimestampStringTypes) {
            this.testDateAddScalarCol(scalarType1, true);
        }
        VectorUDFDateAddScalarCol udf = null;
        try {
            udf = new VectorUDFDateAddScalarCol((Object)"error".getBytes("UTF-8"), 0, 1);
        }
        catch (UnsupportedEncodingException scalarType1) {
            // empty catch block
        }
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING, VectorExpression.Type.TIMESTAMP});
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new LongColumnVector(1);
        batch.cols[1] = new BytesColumnVector(1);
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    @Test
    public void testDateSubScalarCol() {
        for (VectorExpression.Type scalarType1 : this.dateTimestampStringTypes) {
            this.testDateAddScalarCol(scalarType1, false);
        }
        VectorUDFDateSubScalarCol udf = null;
        try {
            udf = new VectorUDFDateSubScalarCol((Object)"error".getBytes("UTF-8"), 0, 1);
        }
        catch (UnsupportedEncodingException scalarType1) {
            // empty catch block
        }
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING, VectorExpression.Type.TIMESTAMP});
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new LongColumnVector(1);
        batch.cols[1] = new BytesColumnVector(1);
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    private void validateDateAdd(VectorizedRowBatch batch, LongColumnVector date1, LongColumnVector date2, VectorExpression.Type colType1, boolean isPositive) {
        Object udf = isPositive ? new VectorUDFDateAddColCol(0, 1, 2) : new VectorUDFDateSubColCol(0, 1, 2);
        udf.setInputTypes(new VectorExpression.Type[]{colType1, VectorExpression.Type.OTHER});
        udf.evaluate(batch);
        BytesColumnVector output = (BytesColumnVector)batch.cols[2];
        try {
            for (int i = 0; i < date2.vector.length; ++i) {
                String expected = isPositive ? new String(this.toString(date1.vector[i] + date2.vector[i]), "UTF-8") : new String(this.toString(date1.vector[i] - date2.vector[i]), "UTF-8");
                if (date1.isNull[i] || date2.isNull[i]) {
                    Assert.assertTrue((boolean)output.isNull[i]);
                    continue;
                }
                Assert.assertEquals((Object)expected, (Object)new String(output.vector[i], output.start[i], output.start[i] + output.length[i], "UTF-8"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void testDateAddColCol(VectorExpression.Type colType1, boolean isPositive) {
        LongColumnVector date1 = this.newRandomLongColumnVector(10000, this.size);
        LongColumnVector days2 = this.newRandomLongColumnVector(1000, this.size);
        ColumnVector col1 = this.castTo(date1, colType1);
        BytesColumnVector output = new BytesColumnVector(this.size);
        VectorizedRowBatch batch = new VectorizedRowBatch(3, this.size);
        batch.cols[0] = col1;
        batch.cols[1] = days2;
        batch.cols[2] = output;
        this.validateDateAdd(batch, date1, days2, colType1, isPositive);
        TestVectorizedRowBatch.addRandomNulls((ColumnVector)date1);
        batch.cols[0] = this.castTo(date1, colType1);
        this.validateDateAdd(batch, date1, days2, colType1, isPositive);
        TestVectorizedRowBatch.addRandomNulls((ColumnVector)days2);
        batch.cols[1] = days2;
        this.validateDateAdd(batch, date1, days2, colType1, isPositive);
    }

    @Test
    public void testDateAddColCol() {
        for (VectorExpression.Type colType1 : this.dateTimestampStringTypes) {
            this.testDateAddColCol(colType1, true);
        }
        VectorUDFDateAddColCol udf = new VectorUDFDateAddColCol(0, 1, 2);
        VectorizedRowBatch batch = new VectorizedRowBatch(3, 1);
        byte[] bytes = new byte[]{};
        try {
            bytes = "error".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING, VectorExpression.Type.TIMESTAMP});
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        batch.cols[2] = new BytesColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[2].isNull[0], (Object)true);
    }

    @Test
    public void testDateSubColCol() {
        for (VectorExpression.Type colType1 : this.dateTimestampStringTypes) {
            this.testDateAddColCol(colType1, false);
        }
        VectorUDFDateSubColCol udf = new VectorUDFDateSubColCol(0, 1, 2);
        VectorizedRowBatch batch = new VectorizedRowBatch(3, 1);
        byte[] bytes = new byte[]{};
        try {
            bytes = "error".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING, VectorExpression.Type.TIMESTAMP});
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        batch.cols[2] = new BytesColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[2].isNull[0], (Object)true);
    }

    private void validateDateDiff(VectorizedRowBatch batch, long scalar1, VectorExpression.Type scalarType1, VectorExpression.Type colType2, LongColumnVector date2) {
        VectorUDFDateDiffScalarCol udf = null;
        switch (scalarType1) {
            case DATE: {
                udf = new VectorUDFDateDiffScalarCol((Object)scalar1, 0, 1);
                break;
            }
            case TIMESTAMP: {
                udf = new VectorUDFDateDiffScalarCol((Object)this.toTimestamp(scalar1), 0, 1);
                break;
            }
            case STRING: {
                udf = new VectorUDFDateDiffScalarCol((Object)this.toString(scalar1), 0, 1);
            }
        }
        udf.setInputTypes(new VectorExpression.Type[]{scalarType1, colType2});
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[1];
        for (int i = 0; i < date2.vector.length; ++i) {
            Assert.assertEquals((long)(scalar1 - date2.vector[i]), (long)output.vector[i]);
        }
    }

    @Test
    public void testDateDiffScalarCol() {
        for (VectorExpression.Type scalarType1 : this.dateTimestampStringTypes) {
            for (VectorExpression.Type colType2 : this.dateTimestampStringTypes) {
                LongColumnVector date2 = this.newRandomLongColumnVector(10000, this.size);
                LongColumnVector output = new LongColumnVector(this.size);
                ColumnVector col2 = this.castTo(date2, colType2);
                VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
                batch.cols[0] = col2;
                batch.cols[1] = output;
                long scalar1 = this.newRandom(1000);
                this.validateDateDiff(batch, scalar1, scalarType1, colType2, date2);
                TestVectorizedRowBatch.addRandomNulls((ColumnVector)date2);
                batch.cols[0] = this.castTo(date2, colType2);
                this.validateDateDiff(batch, scalar1, scalarType1, colType2, date2);
            }
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = "error".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        VectorUDFDateDiffScalarCol udf = new VectorUDFDateDiffScalarCol((Object)0, 0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP, VectorExpression.Type.STRING});
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
        udf = new VectorUDFDateDiffScalarCol((Object)bytes, 0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING, VectorExpression.Type.TIMESTAMP});
        batch.cols[0] = new LongColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    private void validateDateDiff(VectorizedRowBatch batch, LongColumnVector date1, long scalar2, VectorExpression.Type colType1, VectorExpression.Type scalarType2) {
        VectorUDFDateDiffColScalar udf = null;
        switch (scalarType2) {
            case DATE: {
                udf = new VectorUDFDateDiffColScalar(0, (Object)scalar2, 1);
                break;
            }
            case TIMESTAMP: {
                udf = new VectorUDFDateDiffColScalar(0, (Object)this.toTimestamp(scalar2), 1);
                break;
            }
            case STRING: {
                udf = new VectorUDFDateDiffColScalar(0, (Object)this.toString(scalar2), 1);
            }
        }
        udf.setInputTypes(new VectorExpression.Type[]{colType1, scalarType2});
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[1];
        for (int i = 0; i < date1.vector.length; ++i) {
            Assert.assertEquals((long)(date1.vector[i] - scalar2), (long)output.vector[i]);
        }
    }

    @Test
    public void testDateDiffColScalar() {
        for (VectorExpression.Type colType1 : this.dateTimestampStringTypes) {
            for (VectorExpression.Type scalarType2 : this.dateTimestampStringTypes) {
                LongColumnVector date1 = this.newRandomLongColumnVector(10000, this.size);
                LongColumnVector output = new LongColumnVector(this.size);
                VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
                batch.cols[0] = this.castTo(date1, colType1);
                batch.cols[1] = output;
                long scalar2 = this.newRandom(1000);
                this.validateDateDiff(batch, date1, scalar2, colType1, scalarType2);
                TestVectorizedRowBatch.addRandomNulls((ColumnVector)date1);
                batch.cols[0] = this.castTo(date1, colType1);
                this.validateDateDiff(batch, date1, scalar2, colType1, scalarType2);
            }
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = "error".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        VectorUDFDateDiffColScalar udf = new VectorUDFDateDiffColScalar(0, (Object)0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP, VectorExpression.Type.STRING});
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
        udf = new VectorUDFDateDiffColScalar(0, (Object)bytes, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP, VectorExpression.Type.STRING});
        batch.cols[0] = new LongColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    private void validateDateDiff(VectorizedRowBatch batch, LongColumnVector date1, LongColumnVector date2, VectorExpression.Type colType1, VectorExpression.Type colType2) {
        VectorUDFDateDiffColCol udf = new VectorUDFDateDiffColCol(0, 1, 2);
        udf.setInputTypes(new VectorExpression.Type[]{colType1, colType2});
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[2];
        for (int i = 0; i < date1.vector.length; ++i) {
            if (date1.isNull[i] || date2.isNull[i]) {
                Assert.assertTrue((boolean)output.isNull[i]);
                continue;
            }
            Assert.assertEquals((long)(date1.vector[i] - date2.vector[i]), (long)output.vector[i]);
        }
    }

    @Test
    public void testDateDiffColCol() {
        for (VectorExpression.Type colType1 : this.dateTimestampStringTypes) {
            for (VectorExpression.Type colType2 : this.dateTimestampStringTypes) {
                LongColumnVector date1 = this.newRandomLongColumnVector(10000, this.size);
                LongColumnVector date2 = this.newRandomLongColumnVector(10000, this.size);
                LongColumnVector output = new LongColumnVector(this.size);
                VectorizedRowBatch batch = new VectorizedRowBatch(3, this.size);
                batch.cols[0] = this.castTo(date1, colType1);
                batch.cols[1] = this.castTo(date2, colType2);
                batch.cols[2] = output;
                this.validateDateDiff(batch, date1, date2, colType1, colType2);
                TestVectorizedRowBatch.addRandomNulls((ColumnVector)date1);
                batch.cols[0] = this.castTo(date1, colType1);
                this.validateDateDiff(batch, date1, date2, colType1, colType2);
                TestVectorizedRowBatch.addRandomNulls((ColumnVector)date2);
                batch.cols[1] = this.castTo(date2, colType2);
                this.validateDateDiff(batch, date1, date2, colType1, colType2);
            }
        }
        VectorUDFDateDiffColCol udf = new VectorUDFDateDiffColCol(0, 1, 2);
        VectorizedRowBatch batch = new VectorizedRowBatch(3, 1);
        byte[] bytes = new byte[]{};
        try {
            bytes = "error".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING, VectorExpression.Type.TIMESTAMP});
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        batch.cols[2] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[2].isNull[0], (Object)true);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP, VectorExpression.Type.STRING});
        batch.cols[0] = new LongColumnVector(1);
        batch.cols[1] = new BytesColumnVector(1);
        batch.cols[2] = new LongColumnVector(1);
        bcv = (BytesColumnVector)batch.cols[1];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[2].isNull[0], (Object)true);
    }

    private void validateDate(VectorizedRowBatch batch, VectorExpression.Type colType, LongColumnVector date) {
        Object udf = colType == VectorExpression.Type.STRING ? new VectorUDFDateString(0, 1) : new VectorUDFDateLong(0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{colType});
        udf.evaluate(batch);
        BytesColumnVector output = (BytesColumnVector)batch.cols[1];
        for (int i = 0; i < this.size; ++i) {
            String actual;
            if (output.isNull[i]) {
                actual = null;
            } else {
                try {
                    actual = new String(output.vector[i], output.start[i], output.length[i], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            if (date.isNull[i]) {
                Assert.assertTrue((boolean)output.isNull[i]);
                continue;
            }
            String expected = this.formatter.format(new Date(DateWritable.daysToMillis((int)((int)date.vector[i]))));
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testDate() {
        for (VectorExpression.Type colType : this.dateTimestampStringTypes) {
            LongColumnVector date = this.newRandomLongColumnVector(10000, this.size);
            BytesColumnVector output = new BytesColumnVector(this.size);
            VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
            batch.cols[0] = this.castTo(date, colType);
            batch.cols[1] = output;
            this.validateDate(batch, colType, date);
            TestVectorizedRowBatch.addRandomNulls((ColumnVector)date);
            batch.cols[0] = this.castTo(date, colType);
            this.validateDate(batch, colType, date);
        }
        VectorUDFDateString udf = new VectorUDFDateString(0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING});
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new BytesColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        byte[] bytes = new byte[]{};
        try {
            bytes = "error".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    private void validateToDate(VectorizedRowBatch batch, VectorExpression.Type colType, LongColumnVector date) {
        Object udf = colType == VectorExpression.Type.STRING || colType == VectorExpression.Type.CHAR || colType == VectorExpression.Type.VARCHAR ? new CastStringToDate(0, 1) : new CastLongToDate(0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{colType});
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[1];
        for (int i = 0; i < this.size; ++i) {
            long actual = output.vector[i];
            if (date.isNull[i]) {
                Assert.assertTrue((boolean)output.isNull[i]);
                continue;
            }
            long expected = date.vector[i];
            Assert.assertEquals((long)expected, (long)actual);
        }
    }

    @Test
    public void testToDate() {
        for (VectorExpression.Type type : Arrays.asList(VectorExpression.Type.TIMESTAMP, VectorExpression.Type.STRING)) {
            LongColumnVector date = this.newRandomLongColumnVector(10000, this.size);
            LongColumnVector output = new LongColumnVector(this.size);
            VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
            batch.cols[0] = this.castTo(date, type);
            batch.cols[1] = output;
            this.validateToDate(batch, type, date);
            TestVectorizedRowBatch.addRandomNulls((ColumnVector)date);
            batch.cols[0] = this.castTo(date, type);
            this.validateToDate(batch, type, date);
        }
        CastStringToDate udf = new CastStringToDate(0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING});
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        byte[] bytes = new byte[]{};
        try {
            bytes = "error".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }
}

