/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import junit.framework.Assert;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfMonthLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfMonthString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFHourLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFHourString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMinuteLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMinuteString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMonthLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMonthString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFSecondLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFSecondString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearString;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class TestVectorTimestampExpressions {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private TimestampWritable toTimestampWritable(long nanos) {
        long ms = nanos / 1000000000L * 1000L;
        long ns = nanos % 1000000000L;
        if (ns < 0L) {
            ms -= 1000L;
            ns += 1000000000L;
        }
        Timestamp ts = new Timestamp(ms);
        ts.setNanos((int)ns);
        return new TimestampWritable(ts);
    }

    private long[] getAllBoundaries() {
        ArrayList<Long> boundaries = new ArrayList<Long>(1);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(0L);
        for (int year = 1902; year <= 2038; ++year) {
            c.set(year, 0, 1, 0, 0, 0);
            long exactly = c.getTimeInMillis() * 1000L * 1000L;
            long before = exactly - 1000000000L;
            long after = exactly + 1000000000L;
            boundaries.add(before);
            boundaries.add(exactly);
            boundaries.add(after);
        }
        Long[] indices = boundaries.toArray(new Long[1]);
        return ArrayUtils.toPrimitive((Long[])indices);
    }

    private VectorizedRowBatch getVectorizedRandomRowBatchLong2(int seed, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        LongColumnVector lcv = new LongColumnVector(size);
        Random rand = new Random(seed);
        for (int i = 0; i < size; ++i) {
            lcv.vector[i] = 1000000000 * rand.nextInt();
        }
        batch.cols[0] = lcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRandomRowBatchStringLong(int seed, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        BytesColumnVector bcv = new BytesColumnVector(size);
        Random rand = new Random(seed);
        for (int i = 0; i < size; ++i) {
            byte[] encoded = this.encodeTime(1000000000 * rand.nextInt());
            bcv.vector[i] = encoded;
            bcv.start[i] = 0;
            bcv.length[i] = encoded.length;
        }
        batch.cols[0] = bcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRandomRowBatch(int seed, int size, TestType testType) {
        switch (testType) {
            case LONG2: {
                return this.getVectorizedRandomRowBatchLong2(seed, size);
            }
            case STRING_LONG: {
                return this.getVectorizedRandomRowBatchStringLong(seed, size);
            }
        }
        throw new IllegalArgumentException();
    }

    private VectorizedRowBatch getVectorizedRowBatchLong2(long[] inputs, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        LongColumnVector lcv = new LongColumnVector(size);
        for (int i = 0; i < size; ++i) {
            lcv.vector[i] = inputs[i % inputs.length];
        }
        batch.cols[0] = lcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRowBatchStringLong(long[] inputs, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        BytesColumnVector bcv = new BytesColumnVector(size);
        for (int i = 0; i < size; ++i) {
            byte[] encoded = this.encodeTime(inputs[i % inputs.length]);
            bcv.vector[i] = encoded;
            bcv.start[i] = 0;
            bcv.length[i] = encoded.length;
        }
        batch.cols[0] = bcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRowBatchStringLong(byte[] vector, int start, int length) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        BytesColumnVector bcv = new BytesColumnVector(1);
        bcv.vector[0] = vector;
        bcv.start[0] = start;
        bcv.length[0] = length;
        batch.cols[0] = bcv;
        batch.cols[1] = new LongColumnVector(1);
        batch.size = 1;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRowBatch(long[] inputs, int size, TestType testType) {
        switch (testType) {
            case LONG2: {
                return this.getVectorizedRowBatchLong2(inputs, size);
            }
            case STRING_LONG: {
                return this.getVectorizedRowBatchStringLong(inputs, size);
            }
        }
        throw new IllegalArgumentException();
    }

    private byte[] encodeTime(long time) {
        ByteBuffer encoded;
        try {
            String formatted = this.dateFormat.format(new Date(time / 1000000L));
            encoded = Text.encode((String)formatted);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        return Arrays.copyOf(encoded.array(), encoded.limit());
    }

    private long decodeTime(byte[] time) {
        try {
            return this.dateFormat.parse(Text.decode((byte[])time)).getTime() * 1000L * 1000L;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long readVectorElementAt(ColumnVector col, int i) {
        if (col instanceof LongColumnVector) {
            return ((LongColumnVector)col).vector[i];
        }
        if (col instanceof BytesColumnVector) {
            byte[] timeBytes = ((BytesColumnVector)col).vector[i];
            return this.decodeTime(timeBytes);
        }
        throw new IllegalArgumentException();
    }

    private void compareToUDFYearLong(long t, int y) {
        UDFYear udf = new UDFYear();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFYear(VectorizedRowBatch batch, TestType testType) {
        VectorUDFYearLong udf = null;
        if (testType == TestType.LONG2) {
            udf = new VectorUDFYearLong(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP});
        } else {
            udf = new VectorUDFYearString(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING});
        }
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFYearLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFYear(TestType testType) {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new long[]{0L}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch, testType);
        long[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFYear(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFYear(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFYear(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFYear(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFYear(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFYear(batch, testType);
    }

    @Test
    public void testVectorUDFYearLong() {
        this.testVectorUDFYear(TestType.LONG2);
    }

    @Test
    public void testVectorUDFYearString() {
        this.testVectorUDFYear(TestType.STRING_LONG);
        VectorizedRowBatch batch = this.getVectorizedRowBatchStringLong(new byte[]{50, 50, 48, 49, 51}, 1, 3);
        VectorUDFYearString udf = new VectorUDFYearString(0, 1);
        udf.evaluate(batch);
        LongColumnVector lcv = (LongColumnVector)batch.cols[1];
        Assert.assertEquals((boolean)false, (boolean)batch.cols[0].isNull[0]);
        Assert.assertEquals((boolean)true, (boolean)lcv.isNull[0]);
    }

    private void compareToUDFDayOfMonthLong(long t, int y) {
        UDFDayOfMonth udf = new UDFDayOfMonth();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFDayOfMonth(VectorizedRowBatch batch, TestType testType) {
        VectorUDFDayOfMonthLong udf = null;
        if (testType == TestType.LONG2) {
            udf = new VectorUDFDayOfMonthLong(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP});
        } else {
            udf = new VectorUDFDayOfMonthString(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING});
        }
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFDayOfMonthLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFDayOfMonth(TestType testType) {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new long[]{0L}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFDayOfMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch, testType);
        long[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFDayOfMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFDayOfMonth(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFDayOfMonth(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFDayOfMonth(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFDayOfMonth(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFDayOfMonth(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFDayOfMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFDayOfMonth(batch, testType);
    }

    @Test
    public void testVectorUDFDayOfMonthLong() {
        this.testVectorUDFDayOfMonth(TestType.LONG2);
    }

    @Test
    public void testVectorUDFDayOfMonthString() {
        this.testVectorUDFDayOfMonth(TestType.STRING_LONG);
    }

    private void compareToUDFHourLong(long t, int y) {
        UDFHour udf = new UDFHour();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFHour(VectorizedRowBatch batch, TestType testType) {
        VectorUDFHourLong udf = null;
        if (testType == TestType.LONG2) {
            udf = new VectorUDFHourLong(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP});
        } else {
            udf = new VectorUDFHourString(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING});
        }
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFHourLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFHour(TestType testType) {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new long[]{0L}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFHour(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFHour(batch, testType);
        long[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFHour(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFHour(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFHour(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFHour(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFHour(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFHour(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFHour(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFHour(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFHour(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFHour(batch, testType);
    }

    @Test
    public void testVectorUDFHourLong() {
        this.testVectorUDFHour(TestType.LONG2);
    }

    @Test
    public void testVectorUDFHourString() {
        this.testVectorUDFHour(TestType.STRING_LONG);
    }

    private void compareToUDFMinuteLong(long t, int y) {
        UDFMinute udf = new UDFMinute();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFMinute(VectorizedRowBatch batch, TestType testType) {
        VectorUDFMinuteLong udf = null;
        if (testType == TestType.LONG2) {
            udf = new VectorUDFMinuteLong(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP});
        } else {
            udf = new VectorUDFMinuteString(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING});
        }
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFMinuteLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFMinute(TestType testType) {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new long[]{0L}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFMinute(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMinute(batch, testType);
        long[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFMinute(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMinute(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMinute(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFMinute(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFMinute(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFMinute(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFMinute(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFMinute(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMinute(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMinute(batch, testType);
    }

    @Test
    public void testVectorUDFMinuteLong() {
        this.testVectorUDFMinute(TestType.LONG2);
    }

    @Test
    public void testVectorUDFMinuteString() {
        this.testVectorUDFMinute(TestType.STRING_LONG);
    }

    private void compareToUDFMonthLong(long t, int y) {
        UDFMonth udf = new UDFMonth();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFMonth(VectorizedRowBatch batch, TestType testType) {
        VectorUDFMonthLong udf;
        if (testType == TestType.LONG2) {
            udf = new VectorUDFMonthLong(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP});
        } else {
            udf = new VectorUDFMonthString(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING});
        }
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFMonthLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFMonth(TestType testType) {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new long[]{0L}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch, testType);
        long[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMonth(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFMonth(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFMonth(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFMonth(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFMonth(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMonth(batch, testType);
    }

    @Test
    public void testVectorUDFMonthLong() {
        this.testVectorUDFMonth(TestType.LONG2);
    }

    @Test
    public void testVectorUDFMonthString() {
        this.testVectorUDFMonth(TestType.STRING_LONG);
    }

    private void compareToUDFSecondLong(long t, int y) {
        UDFSecond udf = new UDFSecond();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFSecond(VectorizedRowBatch batch, TestType testType) {
        VectorUDFSecondLong udf;
        if (testType == TestType.LONG2) {
            udf = new VectorUDFSecondLong(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP});
        } else {
            udf = new VectorUDFSecondString(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING});
        }
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFSecondLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFSecond(TestType testType) {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new long[]{0L}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFSecond(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFSecond(batch, testType);
        long[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFSecond(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFSecond(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFSecond(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFSecond(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFSecond(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFSecond(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFSecond(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFSecond(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFSecond(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFSecond(batch, testType);
    }

    @Test
    public void testVectorUDFSecondLong() {
        this.testVectorUDFSecond(TestType.LONG2);
    }

    @Test
    public void testVectorUDFSecondString() {
        this.testVectorUDFSecond(TestType.STRING_LONG);
    }

    private LongWritable getLongWritable(TimestampWritable i) {
        LongWritable result = new LongWritable();
        if (i == null) {
            return null;
        }
        result.set(i.getSeconds());
        return result;
    }

    private void compareToUDFUnixTimeStampLong(long t, long y) {
        TimestampWritable tsw = this.toTimestampWritable(t);
        LongWritable res = this.getLongWritable(tsw);
        if (res.get() != y) {
            System.out.printf("%d vs %d for %d, %d\n", res.get(), y, t, tsw.getTimestamp().getTime() / 1000L);
        }
        Assert.assertEquals((long)res.get(), (long)y);
    }

    private void verifyUDFUnixTimeStamp(VectorizedRowBatch batch, TestType testType) {
        VectorUDFUnixTimeStampLong udf;
        if (testType == TestType.LONG2) {
            udf = new VectorUDFUnixTimeStampLong(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP});
        } else {
            udf = new VectorUDFUnixTimeStampString(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING});
        }
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[1].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFUnixTimeStampLong(t, y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFUnixTimeStamp(TestType testType) {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new long[]{0L}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFUnixTimeStamp(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch, testType);
        long[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFUnixTimeStamp(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFUnixTimeStamp(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFUnixTimeStamp(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFUnixTimeStamp(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFUnixTimeStamp(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFUnixTimeStamp(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFUnixTimeStamp(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFUnixTimeStamp(batch, testType);
    }

    @Test
    public void testVectorUDFUnixTimeStampLong() {
        this.testVectorUDFUnixTimeStamp(TestType.LONG2);
    }

    @Test
    public void testVectorUDFUnixTimeStampString() {
        this.testVectorUDFUnixTimeStamp(TestType.STRING_LONG);
    }

    private void compareToUDFWeekOfYearLong(long t, int y) {
        UDFWeekOfYear udf = new UDFWeekOfYear();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFWeekOfYear(VectorizedRowBatch batch, TestType testType) {
        VectorUDFWeekOfYearLong udf;
        if (testType == TestType.LONG2) {
            udf = new VectorUDFWeekOfYearLong(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.TIMESTAMP});
        } else {
            udf = new VectorUDFWeekOfYearString(0, 1);
            udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.STRING});
        }
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                long t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFWeekOfYearLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFWeekOfYear(TestType testType) {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new long[]{0L}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFWeekOfYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch, testType);
        long[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFWeekOfYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFWeekOfYear(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFWeekOfYear(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFWeekOfYear(batch, testType);
        batch = this.getVectorizedRowBatch(new long[]{0L}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFWeekOfYear(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFWeekOfYear(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFWeekOfYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFWeekOfYear(batch, testType);
    }

    @Test
    public void testVectorUDFWeekOfYearLong() {
        this.testVectorUDFWeekOfYear(TestType.LONG2);
    }

    @Test
    public void testVectorUDFWeekOfYearString() {
        this.testVectorUDFWeekOfYear(TestType.STRING_LONG);
    }

    public static void main(String[] args) {
        TestVectorTimestampExpressions self = new TestVectorTimestampExpressions();
        self.testVectorUDFYearLong();
        self.testVectorUDFMonthLong();
        self.testVectorUDFDayOfMonthLong();
        self.testVectorUDFHourLong();
        self.testVectorUDFWeekOfYearLong();
        self.testVectorUDFUnixTimeStampLong();
        self.testVectorUDFYearString();
        self.testVectorUDFMonthString();
        self.testVectorUDFDayOfMonthString();
        self.testVectorUDFHourString();
        self.testVectorUDFWeekOfYearString();
        self.testVectorUDFUnixTimeStampString();
    }

    private static enum TestType {
        LONG2,
        STRING_LONG;

    }
}

