/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.RandomByteArrayStream;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.junit.Assert;

public class CommonFastHashTable {
    protected static final float LOAD_FACTOR = 0.75f;
    protected static final int CAPACITY = 8;
    protected static final int WB_SIZE = 128;
    protected static final int MODERATE_WB_SIZE = 8192;
    protected static final int MODERATE_CAPACITY = 512;
    protected static final int LARGE_WB_SIZE = 0x100000;
    protected static final int LARGE_CAPACITY = 0x800000;
    protected static Random random;

    public static int generateLargeCount() {
        int count;
        block13: {
            block12: {
                count = 0;
                if (random.nextInt(100) == 0) break block12;
                switch (random.nextInt(5)) {
                    case 0: {
                        count = 1;
                        break block13;
                    }
                    case 1: {
                        count = 2;
                        break block13;
                    }
                    case 2: {
                        count = 3;
                    }
                    case 3: {
                        count = 4 + random.nextInt(7);
                        break block13;
                    }
                    case 4: {
                        count = 10 + random.nextInt(90);
                        break block13;
                    }
                    default: {
                        throw new Error("Missing case");
                    }
                }
            }
            switch (random.nextInt(3)) {
                case 0: {
                    count = 100 + random.nextInt(900);
                    break;
                }
                case 1: {
                    count = 1000 + random.nextInt(9000);
                    break;
                }
                case 2: {
                    count = 10000 + random.nextInt(90000);
                }
            }
        }
        return count;
    }

    public static void verifyHashMapResult(VectorMapJoinHashMapResult hashMapResult, RandomByteArrayStream randomByteArrayStream) {
        byte[] bytes;
        ArrayList<byte[]> resultBytes = new ArrayList<byte[]>();
        int count = 0;
        if (hashMapResult.hasRows()) {
            WriteBuffers.ByteSegmentRef ref = hashMapResult.first();
            while (ref != null) {
                ++count;
                bytes = ref.getBytes();
                int offset = (int)ref.getOffset();
                int length = ref.getLength();
                resultBytes.add(Arrays.copyOfRange(bytes, offset, offset + length));
                ref = hashMapResult.next();
            }
        } else {
            Assert.assertTrue((boolean)hashMapResult.isEof());
        }
        if (randomByteArrayStream.size() != count) {
            Assert.assertTrue((boolean)false);
        }
        for (int i = 0; i < count; ++i) {
            bytes = (byte[])resultBytes.get(i);
            if (randomByteArrayStream.contains(bytes)) continue;
            Assert.assertTrue((boolean)false);
        }
    }

    public static void verifyHashMapResult(VectorMapJoinHashMapResult hashMapResult, byte[] valueBytes) {
        Assert.assertTrue((boolean)hashMapResult.hasRows());
        WriteBuffers.ByteSegmentRef ref = hashMapResult.first();
        byte[] bytes = ref.getBytes();
        int offset = (int)ref.getOffset();
        int length = ref.getLength();
        Assert.assertTrue((valueBytes.length == length ? 1 : 0) != 0);
        boolean match = true;
        for (int j = 0; j < length; ++j) {
            if (valueBytes[j] == bytes[offset + j]) continue;
            match = false;
            break;
        }
        if (!match) {
            Assert.assertTrue((boolean)false);
        }
    }
}

