/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.LinkedHashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveContextAwareRecordReader;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.IOContext;
import org.apache.hadoop.hive.ql.io.IOContextMap;
import org.apache.hadoop.hive.ql.io.RCFileRecordReader;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestHiveBinarySearchRecordReader
extends TestCase {
    private RCFileRecordReader rcfReader;
    private JobConf conf;
    private TestHiveInputSplit hiveSplit;
    private HiveContextAwareRecordReader hbsReader;
    private IOContext ioContext;

    private void resetIOContext() {
        this.conf.set("iocontext.input.name", "TestHiveBinarySearchRecordReader");
        this.ioContext = IOContextMap.get((Configuration)this.conf);
        this.ioContext.setUseSorted(false);
        this.ioContext.setBinarySearching(false);
        this.ioContext.setEndBinarySearch(false);
        this.ioContext.setComparison(null);
        this.ioContext.setGenericUDFClassName(null);
    }

    private void init() throws IOException {
        this.conf = new JobConf();
        this.resetIOContext();
        this.rcfReader = (RCFileRecordReader)Mockito.mock(RCFileRecordReader.class);
        Mockito.when((Object)this.rcfReader.next((LongWritable)Matchers.anyObject(), (BytesRefArrayWritable)Matchers.anyObject())).thenReturn((Object)true);
        Mockito.when((Object)this.rcfReader.getPos()).thenReturn((Object)50L);
        this.conf.setBoolean("hive.input.format.sorted", true);
        TableDesc tblDesc = Utilities.defaultTd;
        PartitionDesc partDesc = new PartitionDesc(tblDesc, null);
        LinkedHashMap<String, PartitionDesc> pt = new LinkedHashMap<String, PartitionDesc>();
        pt.put("/tmp/testfolder", partDesc);
        MapredWork mrwork = new MapredWork();
        mrwork.getMapWork().setPathToPartitionInfo(pt);
        Utilities.setMapRedWork((Configuration)this.conf, (MapredWork)mrwork, (Path)new Path("/tmp/" + System.getProperty("user.name"), "hive"));
        this.hiveSplit = new TestHiveInputSplit();
        this.hbsReader = new TestHiveRecordReader((RecordReader)this.rcfReader, this.conf);
        this.hbsReader.initIOContext((FileSplit)this.hiveSplit, this.conf, Class.class, (RecordReader)this.rcfReader);
    }

    private boolean executeDoNext(HiveContextAwareRecordReader hbsReader) throws IOException {
        return hbsReader.next(hbsReader.createKey(), hbsReader.createValue());
    }

    public void testNonLinearGreaterThan() throws Exception {
        this.init();
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)Mockito.verify((Object)this.rcfReader)).sync(50L);
        this.ioContext.setComparison(Integer.valueOf(1));
        Mockito.when((Object)this.rcfReader.getPos()).thenReturn((Object)25L);
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)Mockito.verify((Object)this.rcfReader)).sync(25L);
    }

    public void testNonLinearLessThan() throws Exception {
        this.init();
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)Mockito.verify((Object)this.rcfReader)).sync(50L);
        this.ioContext.setComparison(Integer.valueOf(-1));
        Mockito.when((Object)this.rcfReader.getPos()).thenReturn((Object)75L);
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)Mockito.verify((Object)this.rcfReader)).sync(75L);
    }

    public void testNonLinearEqualTo() throws Exception {
        this.init();
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)Mockito.verify((Object)this.rcfReader)).sync(50L);
        this.ioContext.setComparison(Integer.valueOf(0));
        Mockito.when((Object)this.rcfReader.getPos()).thenReturn((Object)25L);
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)Mockito.verify((Object)this.rcfReader)).sync(25L);
    }

    public void testHitLastBlock() throws Exception {
        this.init();
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)Mockito.verify((Object)this.rcfReader)).sync(50L);
        this.ioContext.setComparison(Integer.valueOf(-1));
        Mockito.when((Object)this.rcfReader.getPos()).thenReturn((Object)100L);
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.rcfReader});
        ((RCFileRecordReader)inOrder.verify((Object)this.rcfReader)).sync(75L);
        ((RCFileRecordReader)inOrder.verify((Object)this.rcfReader)).sync(50L);
        Assert.assertFalse((boolean)this.ioContext.isBinarySearching());
    }

    public void testHitSamePositionTwice() throws Exception {
        this.init();
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)Mockito.verify((Object)this.rcfReader)).sync(50L);
        this.ioContext.setComparison(Integer.valueOf(1));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.rcfReader});
        ((RCFileRecordReader)inOrder.verify((Object)this.rcfReader)).sync(25L);
        ((RCFileRecordReader)inOrder.verify((Object)this.rcfReader)).sync(0L);
        Assert.assertFalse((boolean)this.ioContext.isBinarySearching());
    }

    public void testResetRange() throws Exception {
        this.init();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.rcfReader});
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)inOrder.verify((Object)this.rcfReader)).sync(50L);
        this.ioContext.setComparison(Integer.valueOf(-1));
        Mockito.when((Object)this.rcfReader.getPos()).thenReturn((Object)75L);
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)inOrder.verify((Object)this.rcfReader)).sync(75L);
        this.ioContext.setEndBinarySearch(true);
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        ((RCFileRecordReader)inOrder.verify((Object)this.rcfReader)).sync(50L);
        Assert.assertFalse((boolean)this.ioContext.isBinarySearching());
        Assert.assertFalse((boolean)this.ioContext.shouldEndBinarySearch());
    }

    public void testEqualOpClass() throws Exception {
        this.init();
        this.ioContext.setGenericUDFClassName(GenericUDFOPEqual.class.getName());
        Assert.assertTrue((boolean)this.ioContext.isBinarySearching());
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setBinarySearching(false);
        this.ioContext.setComparison(Integer.valueOf(-1));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setComparison(Integer.valueOf(0));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setComparison(Integer.valueOf(1));
        Assert.assertFalse((boolean)this.executeDoNext(this.hbsReader));
    }

    public void testLessThanOpClass() throws Exception {
        this.init();
        this.ioContext.setGenericUDFClassName(GenericUDFOPLessThan.class.getName());
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        Assert.assertFalse((boolean)this.ioContext.isBinarySearching());
        this.ioContext.setComparison(Integer.valueOf(-1));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setComparison(Integer.valueOf(0));
        Assert.assertFalse((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setComparison(Integer.valueOf(1));
        Assert.assertFalse((boolean)this.executeDoNext(this.hbsReader));
    }

    public void testLessThanOrEqualOpClass() throws Exception {
        this.init();
        this.ioContext.setGenericUDFClassName(GenericUDFOPEqualOrLessThan.class.getName());
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        Assert.assertFalse((boolean)this.ioContext.isBinarySearching());
        this.ioContext.setComparison(Integer.valueOf(-1));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setComparison(Integer.valueOf(0));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setComparison(Integer.valueOf(1));
        Assert.assertFalse((boolean)this.executeDoNext(this.hbsReader));
    }

    public void testGreaterThanOpClass() throws Exception {
        this.init();
        this.ioContext.setGenericUDFClassName(GenericUDFOPGreaterThan.class.getName());
        Assert.assertTrue((boolean)this.ioContext.isBinarySearching());
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setBinarySearching(false);
        this.ioContext.setComparison(Integer.valueOf(-1));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setComparison(Integer.valueOf(0));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setComparison(Integer.valueOf(1));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
    }

    public void testGreaterThanOrEqualOpClass() throws Exception {
        this.init();
        this.ioContext.setGenericUDFClassName(GenericUDFOPEqualOrGreaterThan.class.getName());
        Assert.assertTrue((boolean)this.ioContext.isBinarySearching());
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setBinarySearching(false);
        this.ioContext.setComparison(Integer.valueOf(-1));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setComparison(Integer.valueOf(0));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
        this.ioContext.setComparison(Integer.valueOf(1));
        Assert.assertTrue((boolean)this.executeDoNext(this.hbsReader));
    }

    public static void main(String[] args) throws Exception {
        new TestHiveBinarySearchRecordReader().testNonLinearGreaterThan();
        new TestHiveBinarySearchRecordReader().testNonLinearLessThan();
        new TestHiveBinarySearchRecordReader().testNonLinearEqualTo();
        new TestHiveBinarySearchRecordReader().testHitLastBlock();
        new TestHiveBinarySearchRecordReader().testHitSamePositionTwice();
        new TestHiveBinarySearchRecordReader().testResetRange();
        new TestHiveBinarySearchRecordReader().testEqualOpClass();
        new TestHiveBinarySearchRecordReader().testLessThanOpClass();
        new TestHiveBinarySearchRecordReader().testLessThanOrEqualOpClass();
        new TestHiveBinarySearchRecordReader().testGreaterThanOpClass();
        new TestHiveBinarySearchRecordReader().testGreaterThanOrEqualOpClass();
    }

    private static class TestHiveRecordReader<K extends WritableComparable, V extends Writable>
    extends HiveContextAwareRecordReader<K, V> {
        public TestHiveRecordReader(RecordReader recordReader, JobConf conf) throws IOException {
            super(recordReader, conf);
        }

        public K createKey() {
            return null;
        }

        public V createValue() {
            return null;
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public boolean doNext(K key, V value) throws IOException {
            return super.doNext(key, value);
        }

        public void doClose() throws IOException {
        }
    }

    private static class TestHiveInputSplit
    extends HiveInputFormat.HiveInputSplit {
        private TestHiveInputSplit() {
        }

        public long getStart() {
            return 0L;
        }

        public long getLength() {
            return 100L;
        }

        public Path getPath() {
            return new Path("/");
        }
    }
}

