/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestNewIntegerEncoding {
    private OrcFile.EncodingStrategy encodingStrategy;
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    @Rule
    public TestName testCaseName = new TestName();

    public TestNewIntegerEncoding(OrcFile.EncodingStrategy es) {
        this.encodingStrategy = es;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{OrcFile.EncodingStrategy.COMPRESSION}, {OrcFile.EncodingStrategy.SPEED}};
        return Arrays.asList(data);
    }

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicRow() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Row.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            writer.addRow((Object)new Row(111, 1111L));
            writer.addRow((Object)new Row(111, 1111L));
            writer.addRow((Object)new Row(111, 1111L));
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((Object)new IntWritable(111), (Object)((OrcStruct)row).getFieldValue(0));
                Assert.assertEquals((Object)new LongWritable(1111L), (Object)((OrcStruct)row).getFieldValue(1));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicOld() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 1L, 1L, 1L, 1L, 1L, 1L, 10L, 9L, 7L, 6L, 5L, 4L, 3L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 5L, 1L, 3L, 7L, 1L, 9L, 2L, 6L, 3L, 7L, 1L, 9L, 2L, 6L, 3L, 7L, 1L, 9L, 2L, 6L, 3L, 7L, 1L, 9L, 2L, 6L, 3L, 7L, 1L, 9L, 2L, 6L, 2000L, 2L, 1L, 1L, 1L, 1L, 1L, 3L, 7L, 1L, 9L, 2L, 6L, 1L, 1L, 1L, 1L, 1L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).compress(CompressionKind.NONE).version(OrcFile.Version.V_0_11).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicNew() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 1L, 1L, 1L, 1L, 1L, 1L, 10L, 9L, 7L, 6L, 5L, 4L, 3L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 5L, 1L, 3L, 7L, 1L, 9L, 2L, 6L, 3L, 7L, 1L, 9L, 2L, 6L, 3L, 7L, 1L, 9L, 2L, 6L, 3L, 7L, 1L, 9L, 2L, 6L, 3L, 7L, 1L, 9L, 2L, 6L, 2000L, 2L, 1L, 1L, 1L, 1L, 1L, 3L, 7L, 1L, 9L, 2L, 6L, 1L, 1L, 1L, 1L, 1L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicDelta1() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{-500L, -400L, -350L, -325L, -310L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicDelta2() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{-500L, -600L, -650L, -675L, -710L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicDelta3() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{500L, 400L, 350L, 325L, 310L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicDelta4() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{500L, 600L, 650L, 675L, 710L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeltaOverflow() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{4513343538618202719L, 4513343538618202711L, 2911390882471569739L, -9181829309989854913L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeltaOverflow2() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{Long.MAX_VALUE, 4513343538618202711L, 2911390882471569739L, Long.MIN_VALUE};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeltaOverflow3() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{-4513343538618202711L, -2911390882471569739L, -2L, Long.MAX_VALUE};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIntegerMin() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            input.add(Integer.MIN_VALUE);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIntegerMax() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            input.add(Integer.MAX_VALUE);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongMin() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            input.add(Long.MIN_VALUE);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongMax() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            input.add(Long.MAX_VALUE);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomInt() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 100000; ++i) {
                input.add(Long.valueOf(rand.nextInt()));
            }
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomLong() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 100000; ++i) {
                input.add(rand.nextLong());
            }
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseNegativeMin() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{20L, 2L, 3L, 2L, 1L, 3L, 17L, 71L, 35L, 2L, 1L, 139L, 2L, 2L, 3L, 1783L, 475L, 2L, 1L, 1L, 3L, 1L, 3L, 2L, 32L, 1L, 2L, 3L, 1L, 8L, 30L, 1L, 3L, 414L, 1L, 1L, 135L, 3L, 3L, 1L, 414L, 2L, 1L, 2L, 2L, 594L, 2L, 5L, 6L, 4L, 11L, 1L, 2L, 2L, 1L, 1L, 52L, 4L, 1L, 2L, 7L, 1L, 17L, 334L, 1L, 2L, 1L, 2L, 2L, 6L, 1L, 266L, 1L, 2L, 217L, 2L, 6L, 2L, 13L, 2L, 2L, 1L, 2L, 3L, 5L, 1L, 2L, 1L, 7244L, 11813L, 1L, 33L, 2L, -13L, 1L, 2L, 3L, 13L, 1L, 92L, 3L, 13L, 5L, 14L, 9L, 141L, 12L, 6L, 15L, 25L, 1L, 1L, 1L, 46L, 2L, 1L, 1L, 141L, 3L, 1L, 1L, 1L, 1L, 2L, 1L, 4L, 34L, 5L, 78L, 8L, 1L, 2L, 2L, 1L, 9L, 10L, 2L, 1L, 4L, 13L, 1L, 5L, 4L, 4L, 19L, 5L, 1L, 1L, 1L, 68L, 33L, 399L, 1L, 1885L, 25L, 5L, 2L, 4L, 1L, 1L, 2L, 16L, 1L, 2966L, 3L, 1L, 1L, 25501L, 1L, 1L, 1L, 66L, 1L, 3L, 8L, 131L, 14L, 5L, 1L, 2L, 2L, 1L, 1L, 8L, 1L, 1L, 2L, 1L, 5L, 9L, 2L, 3L, 112L, 13L, 2L, 2L, 1L, 5L, 10L, 3L, 1L, 1L, 13L, 2L, 3L, 4L, 1L, 3L, 1L, 1L, 2L, 1L, 1L, 2L, 4L, 2L, 207L, 1L, 1L, 2L, 4L, 3L, 3L, 2L, 2L, 16L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseNegativeMin2() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{20L, 2L, 3L, 2L, 1L, 3L, 17L, 71L, 35L, 2L, 1L, 139L, 2L, 2L, 3L, 1783L, 475L, 2L, 1L, 1L, 3L, 1L, 3L, 2L, 32L, 1L, 2L, 3L, 1L, 8L, 30L, 1L, 3L, 414L, 1L, 1L, 135L, 3L, 3L, 1L, 414L, 2L, 1L, 2L, 2L, 594L, 2L, 5L, 6L, 4L, 11L, 1L, 2L, 2L, 1L, 1L, 52L, 4L, 1L, 2L, 7L, 1L, 17L, 334L, 1L, 2L, 1L, 2L, 2L, 6L, 1L, 266L, 1L, 2L, 217L, 2L, 6L, 2L, 13L, 2L, 2L, 1L, 2L, 3L, 5L, 1L, 2L, 1L, 7244L, 11813L, 1L, 33L, 2L, -1L, 1L, 2L, 3L, 13L, 1L, 92L, 3L, 13L, 5L, 14L, 9L, 141L, 12L, 6L, 15L, 25L, 1L, 1L, 1L, 46L, 2L, 1L, 1L, 141L, 3L, 1L, 1L, 1L, 1L, 2L, 1L, 4L, 34L, 5L, 78L, 8L, 1L, 2L, 2L, 1L, 9L, 10L, 2L, 1L, 4L, 13L, 1L, 5L, 4L, 4L, 19L, 5L, 1L, 1L, 1L, 68L, 33L, 399L, 1L, 1885L, 25L, 5L, 2L, 4L, 1L, 1L, 2L, 16L, 1L, 2966L, 3L, 1L, 1L, 25501L, 1L, 1L, 1L, 66L, 1L, 3L, 8L, 131L, 14L, 5L, 1L, 2L, 2L, 1L, 1L, 8L, 1L, 1L, 2L, 1L, 5L, 9L, 2L, 3L, 112L, 13L, 2L, 2L, 1L, 5L, 10L, 3L, 1L, 1L, 13L, 2L, 3L, 4L, 1L, 3L, 1L, 1L, 2L, 1L, 1L, 2L, 4L, 2L, 207L, 1L, 1L, 2L, 4L, 3L, 3L, 2L, 2L, 16L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseNegativeMin3() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{20L, 2L, 3L, 2L, 1L, 3L, 17L, 71L, 35L, 2L, 1L, 139L, 2L, 2L, 3L, 1783L, 475L, 2L, 1L, 1L, 3L, 1L, 3L, 2L, 32L, 1L, 2L, 3L, 1L, 8L, 30L, 1L, 3L, 414L, 1L, 1L, 135L, 3L, 3L, 1L, 414L, 2L, 1L, 2L, 2L, 594L, 2L, 5L, 6L, 4L, 11L, 1L, 2L, 2L, 1L, 1L, 52L, 4L, 1L, 2L, 7L, 1L, 17L, 334L, 1L, 2L, 1L, 2L, 2L, 6L, 1L, 266L, 1L, 2L, 217L, 2L, 6L, 2L, 13L, 2L, 2L, 1L, 2L, 3L, 5L, 1L, 2L, 1L, 7244L, 11813L, 1L, 33L, 2L, 0L, 1L, 2L, 3L, 13L, 1L, 92L, 3L, 13L, 5L, 14L, 9L, 141L, 12L, 6L, 15L, 25L, 1L, 1L, 1L, 46L, 2L, 1L, 1L, 141L, 3L, 1L, 1L, 1L, 1L, 2L, 1L, 4L, 34L, 5L, 78L, 8L, 1L, 2L, 2L, 1L, 9L, 10L, 2L, 1L, 4L, 13L, 1L, 5L, 4L, 4L, 19L, 5L, 1L, 1L, 1L, 68L, 33L, 399L, 1L, 1885L, 25L, 5L, 2L, 4L, 1L, 1L, 2L, 16L, 1L, 2966L, 3L, 1L, 1L, 25501L, 1L, 1L, 1L, 66L, 1L, 3L, 8L, 131L, 14L, 5L, 1L, 2L, 2L, 1L, 1L, 8L, 1L, 1L, 2L, 1L, 5L, 9L, 2L, 3L, 112L, 13L, 2L, 2L, 1L, 5L, 10L, 3L, 1L, 1L, 13L, 2L, 3L, 4L, 1L, 3L, 1L, 1L, 2L, 1L, 1L, 2L, 4L, 2L, 207L, 1L, 1L, 2L, 4L, 3L, 3L, 2L, 2L, 16L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseNegativeMin4() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{13L, 13L, 11L, 8L, 13L, 10L, 10L, 11L, 11L, 14L, 11L, 7L, 13L, 12L, 12L, 11L, 15L, 12L, 12L, 9L, 8L, 10L, 13L, 11L, 8L, 6L, 5L, 6L, 11L, 7L, 15L, 10L, 7L, 6L, 8L, 7L, 9L, 9L, 11L, 33L, 11L, 3L, 7L, 4L, 6L, 10L, 14L, 12L, 5L, 14L, 7L, 6L};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseAt0() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 5120; ++i) {
                input.add(Long.valueOf(rand.nextInt(100)));
            }
            input.set(0, 20000L);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseAt1() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 5120; ++i) {
                input.add(Long.valueOf(rand.nextInt(100)));
            }
            input.set(1, 20000L);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseAt255() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 5120; ++i) {
                input.add(Long.valueOf(rand.nextInt(100)));
            }
            input.set(255, 20000L);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseAt256() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 5120; ++i) {
                input.add(Long.valueOf(rand.nextInt(100)));
            }
            input.set(256, 20000L);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBase510() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 5120; ++i) {
                input.add(Long.valueOf(rand.nextInt(100)));
            }
            input.set(510, 20000L);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBase511() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 5120; ++i) {
                input.add(Long.valueOf(rand.nextInt(100)));
            }
            input.set(511, 20000L);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseMax1() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 5120; ++i) {
                input.add(Long.valueOf(rand.nextInt(60)));
            }
            input.set(511, Long.MAX_VALUE);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseMax2() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 5120; ++i) {
                input.add(Long.valueOf(rand.nextInt(60)));
            }
            input.set(128, Long.MAX_VALUE);
            input.set(256, Long.MAX_VALUE);
            input.set(511, Long.MAX_VALUE);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseMax3() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            input.add(371946367L);
            input.add(11963367L);
            input.add(68639400007L);
            input.add(100233367L);
            input.add(6367L);
            input.add(10026367L);
            input.add(3670000L);
            input.add(3602367L);
            input.add(4719226367L);
            input.add(7196367L);
            input.add(444442L);
            input.add(210267L);
            input.add(21033L);
            input.add(160267L);
            input.add(400267L);
            input.add(23634347L);
            input.add(16027L);
            input.add(46026367L);
            input.add(Long.MAX_VALUE);
            input.add(33333L);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseMax4() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            for (int i = 0; i < 25; ++i) {
                input.add(371292224226367L);
                input.add(119622332222267L);
                input.add(686329400222007L);
                input.add(100233333222367L);
                input.add(636272333322222L);
                input.add(10202633223267L);
                input.add(36700222022230L);
                input.add(36023226224227L);
                input.add(47192226364427L);
                input.add(71963622222447L);
                input.add(22244444222222L);
                input.add(21220263327442L);
                input.add(21032233332232L);
                input.add(16026322232227L);
                input.add(40022262272212L);
                input.add(23634342227222L);
                input.add(16022222222227L);
                input.add(46026362222227L);
                input.add(46026362222227L);
                input.add(33322222222323L);
            }
            input.add(Long.MAX_VALUE);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatchedBaseTimestamp() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(TSRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            ArrayList tslist = Lists.newArrayList();
            tslist.add(Timestamp.valueOf("2099-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2003-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("1999-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("1995-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2002-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2010-03-02 00:00:00"));
            tslist.add(Timestamp.valueOf("2005-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2006-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2003-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("1996-08-02 00:00:00"));
            tslist.add(Timestamp.valueOf("1998-11-02 00:00:00"));
            tslist.add(Timestamp.valueOf("2008-10-02 00:00:00"));
            tslist.add(Timestamp.valueOf("1993-08-02 00:00:00"));
            tslist.add(Timestamp.valueOf("2008-01-02 00:00:00"));
            tslist.add(Timestamp.valueOf("2007-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2004-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2008-10-02 00:00:00"));
            tslist.add(Timestamp.valueOf("2003-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2004-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2008-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2005-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("1994-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2006-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2004-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2001-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2000-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2000-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2002-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2006-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2011-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2002-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("2005-01-01 00:00:00"));
            tslist.add(Timestamp.valueOf("1974-01-01 00:00:00"));
            for (Timestamp ts : tslist) {
                writer.addRow((Object)new TSRow(ts));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((int)((Timestamp)tslist.get(idx++)).getNanos(), (int)((TimestampWritable)((OrcStruct)row).getFieldValue(0)).getNanos());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectLargeNegatives() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).encodingStrategy(this.encodingStrategy));
            writer.addRow((Object)-7486502418706614742L);
            writer.addRow((Object)0L);
            writer.addRow((Object)1L);
            writer.addRow((Object)1L);
            writer.addRow((Object)-5535739865598783616L);
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            Object row = rows.next(null);
            Assert.assertEquals((long)-7486502418706614742L, (long)((LongWritable)row).get());
            row = rows.next(row);
            Assert.assertEquals((long)0L, (long)((LongWritable)row).get());
            row = rows.next(row);
            Assert.assertEquals((long)1L, (long)((LongWritable)row).get());
            row = rows.next(row);
            Assert.assertEquals((long)1L, (long)((LongWritable)row).get());
            row = rows.next(row);
            Assert.assertEquals((long)-5535739865598783616L, (long)((LongWritable)row).get());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeek() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList input = Lists.newArrayList();
            Random rand = new Random();
            for (int i = 0; i < 100000; ++i) {
                input.add(Long.valueOf(rand.nextInt()));
            }
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).compress(CompressionKind.NONE).stripeSize(100000L).bufferSize(10000).version(OrcFile.Version.V_0_11).encodingStrategy(this.encodingStrategy));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 55555;
            rows.seekToRow((long)idx);
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    public static class Row {
        Integer int1;
        Long long1;

        public Row(int val, long l) {
            this.int1 = val;
            this.long1 = l;
        }
    }

    public static class TSRow {
        Timestamp ts;

        public TSRow(Timestamp ts) {
            this.ts = ts;
        }
    }
}

