/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.File;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestStringDictionary {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    @Rule
    public TestName testCaseName = new TestName();

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTooManyDistinct() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Text.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).compress(CompressionKind.NONE).bufferSize(10000));
            for (int i = 0; i < 20000; ++i) {
                writer.addRow((Object)new Text(String.valueOf(i)));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((Object)new Text(String.valueOf(idx++)), (Object)row);
            }
            for (StripeInformation stripe : reader.getStripes()) {
                OrcProto.StripeFooter footer = ((RecordReaderImpl)rows).readStripeFooter(stripe);
                for (int i = 0; i < footer.getColumnsCount(); ++i) {
                    OrcProto.ColumnEncoding encoding = footer.getColumns(i);
                    Assert.assertEquals((Object)OrcProto.ColumnEncoding.Kind.DIRECT_V2, (Object)encoding.getKind());
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHalfDistinct() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Text.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).compress(CompressionKind.NONE).bufferSize(10000));
            Random rand = new Random(123L);
            int[] input = new int[20000];
            for (i = 0; i < 20000; ++i) {
                input[i] = rand.nextInt(10000);
            }
            for (i = 0; i < 20000; ++i) {
                writer.addRow((Object)new Text(String.valueOf(input[i])));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((Object)new Text(String.valueOf(input[idx++])), (Object)row);
            }
            for (StripeInformation stripe : reader.getStripes()) {
                OrcProto.StripeFooter footer = ((RecordReaderImpl)rows).readStripeFooter(stripe);
                for (int i2 = 0; i2 < footer.getColumnsCount(); ++i2) {
                    OrcProto.ColumnEncoding encoding = footer.getColumns(i2);
                    Assert.assertEquals((Object)OrcProto.ColumnEncoding.Kind.DICTIONARY_V2, (Object)encoding.getKind());
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTooManyDistinctCheckDisabled() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Text.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.conf.setBoolean(HiveConf.ConfVars.HIVE_ORC_ROW_INDEX_STRIDE_DICTIONARY_CHECK.varname, false);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).compress(CompressionKind.NONE).bufferSize(10000));
            for (int i = 0; i < 20000; ++i) {
                writer.addRow((Object)new Text(String.valueOf(i)));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((Object)new Text(String.valueOf(idx++)), (Object)row);
            }
            for (StripeInformation stripe : reader.getStripes()) {
                OrcProto.StripeFooter footer = ((RecordReaderImpl)rows).readStripeFooter(stripe);
                for (int i = 0; i < footer.getColumnsCount(); ++i) {
                    OrcProto.ColumnEncoding encoding = footer.getColumns(i);
                    Assert.assertEquals((Object)OrcProto.ColumnEncoding.Kind.DIRECT_V2, (Object)encoding.getKind());
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHalfDistinctCheckDisabled() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Text.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.conf.setBoolean(HiveConf.ConfVars.HIVE_ORC_ROW_INDEX_STRIDE_DICTIONARY_CHECK.varname, false);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).compress(CompressionKind.NONE).bufferSize(10000));
            Random rand = new Random(123L);
            int[] input = new int[20000];
            for (i = 0; i < 20000; ++i) {
                input[i] = rand.nextInt(10000);
            }
            for (i = 0; i < 20000; ++i) {
                writer.addRow((Object)new Text(String.valueOf(input[i])));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((Object)new Text(String.valueOf(input[idx++])), (Object)row);
            }
            for (StripeInformation stripe : reader.getStripes()) {
                OrcProto.StripeFooter footer = ((RecordReaderImpl)rows).readStripeFooter(stripe);
                for (int i2 = 0; i2 < footer.getColumnsCount(); ++i2) {
                    OrcProto.ColumnEncoding encoding = footer.getColumns(i2);
                    Assert.assertEquals((Object)OrcProto.ColumnEncoding.Kind.DICTIONARY_V2, (Object)encoding.getKind());
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTooManyDistinctV11AlwaysDictionary() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Text.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).compress(CompressionKind.NONE).version(OrcFile.Version.V_0_11).bufferSize(10000));
            for (int i = 0; i < 20000; ++i) {
                writer.addRow((Object)new Text(String.valueOf(i)));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((Object)new Text(String.valueOf(idx++)), (Object)row);
            }
            for (StripeInformation stripe : reader.getStripes()) {
                OrcProto.StripeFooter footer = ((RecordReaderImpl)rows).readStripeFooter(stripe);
                for (int i = 0; i < footer.getColumnsCount(); ++i) {
                    OrcProto.ColumnEncoding encoding = footer.getColumns(i);
                    Assert.assertEquals((Object)OrcProto.ColumnEncoding.Kind.DICTIONARY, (Object)encoding.getKind());
                }
            }
            return;
        }
    }
}

