/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.parquet.AbstractTestParquetDirect;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetRecordReaderWrapper;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestParquetRowGroupFilter
extends AbstractTestParquetDirect {
    JobConf conf;
    String columnNames;
    String columnTypes;

    @Before
    public void initConf() throws Exception {
        this.conf = new JobConf();
    }

    @Test
    public void testRowGroupFilterTakeEffect() throws Exception {
        this.columnNames = "intCol";
        this.columnTypes = "int";
        ArrayWritableObjectInspector inspector = this.getObjectInspector(this.columnNames, this.columnTypes);
        MessageType fileSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {\n  optional int32 intCol;\n}\n");
        this.conf.set("hive.io.file.readcolumn.names", "intCol");
        this.conf.set("columns", "intCol");
        this.conf.set("columns.types", "int");
        Path testPath = this.writeDirect("RowGroupFilterTakeEffect", fileSchema, new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer consumer) {
                for (int i = 0; i < 100; ++i) {
                    consumer.startMessage();
                    consumer.startField("int", 0);
                    consumer.addInteger(i);
                    consumer.endField("int", 0);
                    consumer.endMessage();
                }
            }
        });
        GenericUDFOPGreaterThan udf = new GenericUDFOPGreaterThan();
        ArrayList children = Lists.newArrayList();
        ExprNodeColumnDesc columnDesc = new ExprNodeColumnDesc(Integer.class, "intCol", "T", false);
        ExprNodeConstantDesc constantDesc = new ExprNodeConstantDesc((Object)50);
        children.add(columnDesc);
        children.add(constantDesc);
        ExprNodeGenericFuncDesc genericFuncDesc = new ExprNodeGenericFuncDesc((ObjectInspector)inspector, (GenericUDF)udf, (List)children);
        String searchArgumentStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)genericFuncDesc);
        this.conf.set("hive.io.filter.expr.serialized", searchArgumentStr);
        ParquetRecordReaderWrapper recordReader = (ParquetRecordReaderWrapper)new MapredParquetInputFormat().getRecordReader((InputSplit)new FileSplit(testPath, 0L, TestParquetRowGroupFilter.fileLength(testPath), (String[])null), this.conf, null);
        Assert.assertEquals((String)"row group is not filtered correctly", (long)1L, (long)recordReader.getFiltedBlocks().size());
        constantDesc = new ExprNodeConstantDesc((Object)100);
        children.set(1, constantDesc);
        genericFuncDesc = new ExprNodeGenericFuncDesc((ObjectInspector)inspector, (GenericUDF)udf, (List)children);
        searchArgumentStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)genericFuncDesc);
        this.conf.set("hive.io.filter.expr.serialized", searchArgumentStr);
        recordReader = (ParquetRecordReaderWrapper)new MapredParquetInputFormat().getRecordReader((InputSplit)new FileSplit(testPath, 0L, TestParquetRowGroupFilter.fileLength(testPath), (String[])null), this.conf, null);
        Assert.assertEquals((String)"row group is not filtered correctly", (long)0L, (long)recordReader.getFiltedBlocks().size());
    }

    private ArrayWritableObjectInspector getObjectInspector(String columnNames, String columnTypes) {
        List<TypeInfo> columnTypeList = this.createHiveTypeInfoFrom(columnTypes);
        List<String> columnNameList = this.createHiveColumnsFrom(columnNames);
        StructTypeInfo rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnNameList, columnTypeList);
        return new ArrayWritableObjectInspector(rowTypeInfo);
    }

    private List<String> createHiveColumnsFrom(String columnNamesStr) {
        List<Object> columnNames = columnNamesStr.length() == 0 ? new ArrayList() : Arrays.asList(columnNamesStr.split(","));
        return columnNames;
    }

    private List<TypeInfo> createHiveTypeInfoFrom(String columnsTypeStr) {
        ArrayList<TypeInfo> columnTypes = columnsTypeStr.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnsTypeStr);
        return columnTypes;
    }
}

