/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr.zookeeper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryOneTime;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricsReporting;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLock;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLockManager;
import org.apache.hadoop.hive.ql.util.ZooKeeperHiveHelper;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZookeeperLockManager {
    private HiveConf conf;
    private TestingServer server;
    private CuratorFramework client;
    private HiveLockObject hiveLock;
    private ZooKeeperHiveLock zLock;
    private HiveLockObject.HiveLockObjectData lockObjData;
    private static final String PARENT = "hive";
    private static final String TABLE = "t1";
    private static final String PARENT_LOCK_PATH = "/hive/t1";
    private static final String TABLE_LOCK_PATH = "/hive/t1/00001";

    @Before
    public void setup() {
        this.conf = new HiveConf();
        this.lockObjData = new HiveLockObject.HiveLockObjectData("1", "10", "SHARED", "show tables");
        this.hiveLock = new HiveLockObject(TABLE, this.lockObjData);
        this.zLock = new ZooKeeperHiveLock(TABLE_LOCK_PATH, this.hiveLock, HiveLockMode.SHARED);
        while (this.server == null) {
            try {
                this.server = new TestingServer();
                CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
                this.client = builder.connectString(this.server.getConnectString()).retryPolicy((RetryPolicy)new RetryOneTime(1)).build();
                this.client.start();
            }
            catch (Exception e) {
                System.err.println("Getting bind exception - retrying to allocate server");
                this.server = null;
            }
        }
    }

    @After
    public void teardown() throws Exception {
        this.client.close();
        this.server.close();
        this.server = null;
    }

    @Test
    public void testDeleteNoChildren() throws Exception {
        this.client.create().creatingParentsIfNeeded().forPath(TABLE_LOCK_PATH, this.lockObjData.toString().getBytes());
        byte[] data = (byte[])this.client.getData().forPath(TABLE_LOCK_PATH);
        Assert.assertArrayEquals((byte[])this.lockObjData.toString().getBytes(), (byte[])data);
        ZooKeeperHiveLockManager.unlockPrimitive((HiveLock)this.zLock, (String)PARENT, (CuratorFramework)this.client);
        try {
            data = (byte[])this.client.getData().forPath(TABLE_LOCK_PATH);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)(e instanceof KeeperException.NoNodeException), (Object)true);
        }
        try {
            data = (byte[])this.client.getData().forPath(PARENT_LOCK_PATH);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)(e instanceof KeeperException.NoNodeException), (Object)true);
        }
    }

    @Test
    public void testGetQuorumServers() {
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM, "node1");
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT, "9999");
        Assert.assertEquals((Object)"node1:9999", (Object)ZooKeeperHiveHelper.getQuorumServers((HiveConf)this.conf));
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM, "node1,node2,node3");
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT, "9999");
        Assert.assertEquals((Object)"node1:9999,node2:9999,node3:9999", (Object)ZooKeeperHiveHelper.getQuorumServers((HiveConf)this.conf));
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM, "node1:5666,node2,node3");
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT, "9999");
        Assert.assertEquals((Object)"node1:5666,node2:9999,node3:9999", (Object)ZooKeeperHiveHelper.getQuorumServers((HiveConf)this.conf));
    }

    @Test
    public void testMetrics() throws Exception {
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM, "localhost");
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT, String.valueOf(this.server.getPort()));
        File workDir = new File(System.getProperty("test.tmp.dir"));
        File jsonReportFile = new File(workDir, "json_reportingzk1");
        jsonReportFile.delete();
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED, true);
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        this.conf.setVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER, MetricsReporting.JSON_FILE.name() + "," + MetricsReporting.JMX.name());
        this.conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_LOCATION, jsonReportFile.toString());
        this.conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, "100ms");
        MetricsFactory.init((HiveConf)this.conf);
        HiveLockManagerCtx ctx = new HiveLockManagerCtx(this.conf);
        ZooKeeperHiveLockManager zMgr = new ZooKeeperHiveLockManager();
        zMgr.setContext(ctx);
        ZooKeeperHiveLock curLock = zMgr.lock(this.hiveLock, HiveLockMode.SHARED, false);
        Thread.sleep(2000L);
        byte[] jsonData = Files.readAllBytes(Paths.get(jsonReportFile.getAbsolutePath(), new String[0]));
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(jsonData);
        JsonNode countersNode = rootNode.path("counters");
        JsonNode zkLockNode = countersNode.path("zookeeper_hive_sharedlocks");
        JsonNode zkLockCountNode = zkLockNode.path("count");
        Assert.assertTrue((zkLockCountNode.asInt() == 1 ? 1 : 0) != 0);
        zMgr.unlock((HiveLock)curLock);
        Thread.sleep(2000L);
        jsonData = Files.readAllBytes(Paths.get(jsonReportFile.getAbsolutePath(), new String[0]));
        objectMapper = new ObjectMapper();
        rootNode = objectMapper.readTree(jsonData);
        countersNode = rootNode.path("counters");
        zkLockNode = countersNode.path("zookeeper_hive_sharedlocks");
        zkLockCountNode = zkLockNode.path("count");
        Assert.assertTrue((zkLockCountNode.asInt() == 0 ? 1 : 0) != 0);
        zMgr.close();
    }
}

