/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.sql.Date;
import java.util.HashMap;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestSemanticAnalyzer {
    @Test
    public void testNormalizeColSpec() throws Exception {
        this.checkNormalization("date", "2010-01-01", "2010-01-01", Date.valueOf("2010-01-01"));
        this.checkNormalization("date", "2010-1-01", "2010-01-01", Date.valueOf("2010-01-01"));
        this.checkNormalization("date", "2010-1-1", "2010-01-01", Date.valueOf("2010-01-01"));
        this.checkNormalization("string", "2010-1-1", "2010-1-1", "2010-1-1");
        try {
            this.checkNormalization("date", "foo", "", "foo");
            Assert.fail((String)"should throw");
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        try {
            this.checkNormalization("date", "2010-01-01", "2010-01-01", "2010-01-01");
            Assert.fail((String)"should throw");
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    public void checkNormalization(String colType, String originalColSpec, String result, Object colValue) throws SemanticException {
        String colName = "col";
        HashMap<String, String> partSpec = new HashMap<String, String>();
        partSpec.put("col", originalColSpec);
        BaseSemanticAnalyzer.normalizeColSpec(partSpec, (String)"col", (String)colType, (String)originalColSpec, (Object)colValue);
        Assert.assertEquals((Object)result, partSpec.get("col"));
        if (colValue instanceof Date) {
            DateWritable dw = new DateWritable((Date)colValue);
            BaseSemanticAnalyzer.normalizeColSpec(partSpec, (String)"col", (String)colType, (String)originalColSpec, (Object)dw);
            Assert.assertEquals((Object)result, partSpec.get("col"));
        }
    }
}

