/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEncode;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;

public class TestGenericUDFEncode
extends TestCase {
    public void testEncode() throws UnsupportedEncodingException, HiveException {
        String[] charsetNames;
        for (String charsetName : charsetNames = new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16"}) {
            this.verifyEncode("A sample string", charsetName);
        }
    }

    public void verifyEncode(String string, String charsetName) throws UnsupportedEncodingException, HiveException {
        GenericUDFEncode udf = new GenericUDFEncode();
        byte[] expected = string.getBytes(charsetName);
        JavaStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaStringObjectInspector charsetOI = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArguments = new ObjectInspector[]{valueOI, charsetOI};
        udf.initialize(initArguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)string);
        GenericUDF.DeferredJavaObject charsetObj = new GenericUDF.DeferredJavaObject((Object)charsetName);
        GenericUDF.DeferredObject[] arguments = new GenericUDF.DeferredObject[]{valueObj, charsetObj};
        BytesWritable outputWritable = (BytesWritable)udf.evaluate(arguments);
        byte[] output = outputWritable.getBytes();
        TestGenericUDFEncode.assertTrue((String)("Encoding failed for CharSet: " + charsetName), (expected.length == outputWritable.getLength() ? 1 : 0) != 0);
        for (int i = 0; i < expected.length; ++i) {
            TestGenericUDFEncode.assertEquals((String)("Encoding failed for CharSet: " + charsetName), (byte)expected[i], (byte)output[i]);
        }
    }
}

