/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

public class TestGenericUDFFromUtcTimestamp
extends TestCase {
    public static void runAndVerify(GenericUDF udf, Object arg1, Object arg2, Object expected) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(arg1), new GenericUDF.DeferredJavaObject(arg2)};
        Object result = udf.evaluate(args);
        if (expected == null) {
            TestGenericUDFFromUtcTimestamp.assertNull((Object)result);
        } else {
            TestGenericUDFFromUtcTimestamp.assertEquals((String)expected.toString(), (String)result.toString());
        }
    }

    public void testFromUtcTimestamp() throws Exception {
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        GenericUDFFromUtcTimestamp udf = new GenericUDFFromUtcTimestamp();
        ObjectInspector[] args2 = new ObjectInspector[]{valueOI, valueOI};
        udf.initialize(args2);
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 17:00:00"), new Text("Europe/London"), Timestamp.valueOf("2015-03-28 17:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 18:00:00"), new Text("Europe/London"), Timestamp.valueOf("2015-03-28 18:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 19:00:00"), new Text("Europe/London"), Timestamp.valueOf("2015-03-28 19:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 18:00:00.123456789"), new Text("Europe/London"), Timestamp.valueOf("2015-03-28 18:00:00.123456789"));
    }

    public void testToUtcTimestamp() throws Exception {
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        GenericUDFToUtcTimestamp udf = new GenericUDFToUtcTimestamp();
        ObjectInspector[] args2 = new ObjectInspector[]{valueOI, valueOI};
        udf.initialize(args2);
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 17:00:00"), new Text("Europe/London"), Timestamp.valueOf("2015-03-28 17:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 18:00:00"), new Text("Europe/London"), Timestamp.valueOf("2015-03-28 18:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 19:00:00"), new Text("Europe/London"), Timestamp.valueOf("2015-03-28 19:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 18:00:00.123456789"), new Text("Europe/London"), Timestamp.valueOf("2015-03-28 18:00:00.123456789"));
    }
}

