/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class FuncRoundWithNumDigitsDecimalToDecimal
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private int decimalPlaces;

    public FuncRoundWithNumDigitsDecimalToDecimal(int colNum, int scalarValue, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        this.decimalPlaces = scalarValue;
        this.outputType = "decimal";
    }

    public FuncRoundWithNumDigitsDecimalToDecimal() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.cols[this.colNum];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        int n = batch.size;
        HiveDecimalWritable[] vector = inputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.isRepeating) {
            outputIsNull[0] = inputIsNull[0];
            this.round(0, vector[0], this.decimalPlaces, outputColVector);
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = false;
                    this.round(i, vector[i], this.decimalPlaces, outputColVector);
                }
            } else {
                Arrays.fill(outputIsNull, 0, n, false);
                for (int i = 0; i != n; ++i) {
                    this.round(i, vector[i], this.decimalPlaces, outputColVector);
                }
            }
            outputColVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    this.round(i, vector[i], this.decimalPlaces, outputColVector);
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    this.round(i, vector[i], this.decimalPlaces, outputColVector);
                }
            }
            outputColVector.isRepeating = false;
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return this.outputType;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DECIMAL, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }

    protected void round(int i, HiveDecimalWritable input, int decimalPlaces, DecimalColumnVector outputColVector) {
        DecimalUtil.round(i, input, decimalPlaces, outputColVector);
    }
}

