/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastValueStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMap;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastLongHashMap
extends VectorMapJoinFastLongHashTable
implements VectorMapJoinLongHashMap {
    public static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastLongHashMap.class);
    protected VectorMapJoinFastValueStore valueStore;

    @Override
    public VectorMapJoinHashMapResult createHashMapResult() {
        return new VectorMapJoinFastValueStore.HashMapResult();
    }

    @Override
    public void assignSlot(int slot, long key, boolean isNewKey, BytesWritable currentValue) {
        byte[] valueBytes = currentValue.getBytes();
        int valueLength = currentValue.getLength();
        int pairIndex = 2 * slot;
        if (isNewKey) {
            this.slotPairs[pairIndex] = this.valueStore.addFirst(valueBytes, 0, valueLength);
            this.slotPairs[pairIndex + 1] = key;
        } else {
            this.slotPairs[pairIndex] = this.valueStore.addMore(this.slotPairs[pairIndex], valueBytes, 0, valueLength);
        }
    }

    @Override
    public JoinUtil.JoinResult lookup(long key, VectorMapJoinHashMapResult hashMapResult) {
        JoinUtil.JoinResult joinResult;
        VectorMapJoinFastValueStore.HashMapResult optimizedHashMapResult = (VectorMapJoinFastValueStore.HashMapResult)hashMapResult;
        optimizedHashMapResult.forget();
        long hashCode = HashCodeUtil.calculateLongHashCode(key);
        long valueRef = this.findReadSlot(key, hashCode);
        if (valueRef == -1L) {
            joinResult = JoinUtil.JoinResult.NOMATCH;
        } else {
            optimizedHashMapResult.set(this.valueStore, valueRef);
            joinResult = JoinUtil.JoinResult.MATCH;
        }
        optimizedHashMapResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinFastLongHashMap(boolean minMaxEnabled, boolean isOuterJoin, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, int initialCapacity, float loadFactor, int writeBuffersSize) {
        super(minMaxEnabled, isOuterJoin, hashTableKeyType, initialCapacity, loadFactor, writeBuffersSize);
        this.valueStore = new VectorMapJoinFastValueStore(writeBuffersSize);
    }
}

