/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsUtils {
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();
    private static final Logger LOG = LoggerFactory.getLogger(HdfsUtils.class);
    private static String HDFS_ID_PATH_PREFIX = "/.reserved/.inodes/";

    public static Long getFileId(FileSystem fileSystem, Path path, boolean allowSynthetic) throws IOException {
        String pathStr = path.toUri().getPath();
        if (fileSystem instanceof DistributedFileSystem) {
            return SHIMS.getFileId(fileSystem, pathStr);
        }
        if (!allowSynthetic) {
            LOG.warn("Cannot get unique file ID from " + fileSystem.getClass().getSimpleName() + "; returning null");
            return null;
        }
        int nameHash = pathStr.hashCode();
        FileStatus fs = fileSystem.getFileStatus(path);
        long fileSize = fs.getLen();
        long modTime = fs.getModificationTime();
        int fileSizeHash = (int)(fileSize ^ fileSize >>> 32);
        int modTimeHash = (int)(modTime ^ modTime >>> 32);
        int combinedHash = modTimeHash ^ fileSizeHash;
        long id = ((long)nameHash & 0xFFFFFFFFL) << 32 | (long)combinedHash & 0xFFFFFFFFL;
        LOG.warn("Cannot get unique file ID from " + fileSystem.getClass().getSimpleName() + "; using " + id + " (" + pathStr + "," + nameHash + "," + fileSize + ")");
        return id;
    }

    public static Path getFileIdPath(FileSystem fileSystem, Path path, long fileId) {
        return fileSystem instanceof DistributedFileSystem ? new Path(HDFS_ID_PATH_PREFIX + fileId) : path;
    }
}

